/*************************************************************************
 *
 *  $RCSfile: imapmbox.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPMBOX_HXX
#define CHAOS_IMAPMBOX_HXX

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif

#ifndef CHAOS_IMAPFLDR_HXX
#include <imapfldr.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

class INetIMAPListResponseMailbox;

namespace chaos {

class CntIMAPAcnt;
class CntIMAPMboxNode;

//============================================================================
class CntIMAPMbox: public CntIMAPFldr
{
	/** The number of messages only present locally but no longer present on
		the server.
	 */
	sal_uInt32 m_nLMesgCount;

	/** The number of messages present on the server and about which nothing
		is known locally (UNKNOWN_S_MESG_COUNT if not yet determined).
	 */
	sal_uInt32 m_nSMesgCount;

	/** The number of messages that are present both locally and on the
		server.
	 */
	sal_uInt32 m_nLSMesgCount;

	/** The number of messages that are locally deleted into the trash can,
		but which are still present on the server.
	 */
	sal_uInt32 m_nLSDMesgCount;

	bool m_bDeleted;
	bool m_bInheritedKeepBodiesFlag;

	CntIMAPMbox & getRootMbox();

	void setInferiors(bool bOn);

	void setSelect(CntNodeJob & rJob, bool bOn);

	void setReadMarkedFlags(CntNodeJob & rJob, bool bReadFlag,
							bool bMarkedFlag);

public:
	TYPEINFO();

	CntIMAPMbox(CntIMAPMboxNode & rMboxNode);

	virtual ~CntIMAPMbox();

	CntIMAPMboxNode const & getNode() const;

	CntIMAPMboxNode & getNode();

	CntIMAPFldr & getParentFldr();

	CntIMAPAcnt & getAcnt();

	bool initialize(CntNodeJob & rJob, bool bCreate = false,
					INetIMAPListResponseMailbox const * pData = 0,
					bool bSubscribed = false, bool bFlagNew = false,
					bool * pSubscribedChanged = 0);

	bool isDeleted() const { return m_bDeleted; }

	void setDeleted(bool bTheDeleted) { m_bDeleted = bTheDeleted; }

	bool getInferiors() const;

	bool getSelect() const;

	bool hasDeterminedHierarchySeparator(sal_Char & rHierarchySeparator);

	void setHierarchySeparator(CntNodeJob & rJob, bool bRootMboxFlagInferiors,
							   bool bRootMboxFlagSelect,
							   sal_Char cHierarchySeparator);

	void storeProperty(CntNodeJob & rJob, SfxPoolItem const & rItem);

	bool hasKeepBodiesFlag() const { return !m_bInheritedKeepBodiesFlag; }

	sal_uInt32 getLMesgCount() const { return m_nLMesgCount; }

	sal_uInt32 getLSMesgCount() const { return m_nLSMesgCount; }

	sal_uInt32 getLSDMesgCount() const { return m_nLSDMesgCount; }

	virtual CntStorageNode * getDirNode(CntNodeJob & rJob);

	static CntStorageNode * getDirNode(String const & rMboxURL);

	virtual void changeMboxCounts(CntNodeJob & rJob,
								  CountChange eMboxCountChange,
								  CountChange eSubscribedMboxCountChange);

	sal_uInt32 setServerMesgCount(CntNodeJob & rJob,
								  sal_uInt32 nServerMesgCount);

	void setMesgCounts(CntNodeJob & rJob, sal_uInt32 nTheLMesgCount,
					   sal_uInt32 nTheSMesgCount, sal_uInt32 nTheLSMesgCount,
					   sal_uInt32 nTheLSDMesgCount, sal_uInt32 nReadMesgCount,
					   sal_uInt32 nMarkedMesgCount);

	void changeMesgCounts(CntNodeJob & rJob, CountChange eLMesgCountChange,
						  CountChange eSMesgCountChange,
						  CountChange eLSMesgCountChange,
						  CountChange eLSDMesgCountChange,
						  CountChange eReadMesgCountChange,
						  CountChange eMarkedMesgCountChange);

	void renameStorage(CntNodeJob & rJob, String const & rNewMboxURL);
		// once storages are no longer deleted across a rename, this method
		// can go---and also the special code in initialize()...

	void clearRenamed(bool bClearThis);
		// once storages are no longer deleted across a rename, this method
		// can go---and also the special code in initialize()...

	static bool isSubMbox(ByteString const & rParentLiteralFullName,
						  sal_Char cParentHierarchyDelimiter,
						  ByteString const & rChildLiteralFullName);
};

}

#endif // CHAOS_IMAPMBOX_HXX

