/*************************************************************************
 *
 *  $RCSfile: imapmsgt.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_EXPORT_HXX
#include <export.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif
#ifndef _CHAOS_STRMITEM_HXX
#include <strmitem.hxx>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPMSGT_HXX
#include <imapmsgt.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntIMAPMesgOpenTask
//
//============================================================================

void CntIMAPMesgOpenTask::removeMesgDataCacheStream()
{
	if (m_bHasMesgDataCacheStream)
	{
		CntStorageNode * pCacheNode = getJob().GetCacheNode();
		if (pCacheNode)
		{
			pCacheNode->remove(m_rMesgNode.getDataStreamID());
			m_bHasMesgDataCacheStream = false;
		}
	}
}

//============================================================================
IMPL_LINK(CntIMAPMesgOpenTask, streamCallback,
		  INetIMAPFetchResponseBodySection const *, pSection)
{
	DBG_ASSERT(pSection,
			   "CntIMAPMesgOpenTask::streamCallback(): Null section");

	vos::ORef< ThreadTask > xThis(this);
	SvStream * pMesgDataCacheStream = 0;
	if (wakeUp())
	{
		if (!m_bHasMesgDataCacheStream
			&& ((pSection->getSectionText()
				         == INetIMAPBodySectionDescriptor::SECTION_TEXT_NO
			         && !pSection->getSectionNumberSequence().getCount()
			         && !pSection->isPartial())
				|| pSection->getSectionText()
				       == INetIMAPBodySectionDescriptor::RFC822))
		{
			CntStorageNode * pCacheNode = getJob().GetCacheNode();
			if (pCacheNode)
			{
				String aDataStreamID(m_rMesgNode.getDataStreamID());
				pMesgDataCacheStream
					= pCacheNode->openStream(aDataStreamID,
											 STREAM_STD_WRITE | STREAM_TRUNC);
				if (pMesgDataCacheStream)
				{
					m_bHasMesgDataCacheStream = true;
					pCacheNode->attrib(aDataStreamID, 0,
									   CNTDIRENTRY_ATTRIB_HIDDEN);
				}
			}
		}
		sleep();
	}
	return reinterpret_cast< long >(pMesgDataCacheStream);
}

//============================================================================
// virtual
void CntIMAPMesgOpenTask::beingCanceled()
{
	removeMesgDataCacheStream();
	super::beingCanceled();
}

//============================================================================
// virtual
bool CntIMAPMesgOpenTask::initialize()
{
	if (m_rMesgNode.getBody(getJob()))
	{
		if ( m_rMesgNode.isDeleted() )
			cancel();
		else
			done();
		return false;
	}

	for (;;)
		if (CntIMAPSelectTask::initialize())
			return true;
		else
			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
				case ERROR_RESPONSE_IGNORE:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return false;
			}
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMesgOpenTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_FETCH:
		{
			pushStatusInformation(CntResId(RID_TRANSFERRING_MESSAGE),
								  CntIMAPStatusInformation::TAG_NONE, true);

			String aMboxURL;
			sal_uInt32 nUIDValidity;
			CntIMAPURL::decomposeMesgURL(OWN_URL(&m_rMesgNode), aMboxURL,
										 nUIDValidity, m_nMesgUID);

			if (nUIDValidity && nUIDValidity != getUIDValidity())
			{
				done();
				return EXEC_DONE;
			}

			bool bIMAP4Rev1 = (getAcnt().getClient()->getCapabilities()
							           & INetIMAPClient::CAPABILITY_IMAP4REV1)
				                  != 0;

			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->add(m_nMesgUID);

			INetIMAPArgumentBodySectionList * pSections;
			if (bIMAP4Rev1)
			{
				INetIMAPArgumentBodySection * pSection
					= getAcnt().getClient()->createArgumentBodySection();
				pSection->setPeek();
				pSections
					= getAcnt().getClient()->createArgumentBodySectionList();
				pSections->append(pSection);
			}
			else
				pSections = 0;

			m_bFetchedData = false;

			++m_nState;
			ErrCode nError
				= clientCommandFetch(true, *pSet,
									 bIMAP4Rev1 ?
									     INetIMAPClient::FetchAttributes(0) :
									     INetIMAPClient::FETCH_RFC822_PEEK,
									 pSections, 0,
									 LINK(this, CntIMAPMesgOpenTask,
										  streamCallback));
			delete pSet;
			delete pSections;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_FETCH:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						popStatusInformation();

						removeMesgDataCacheStream();

						// At least the 'Netscape IMAP4rev1 Service 3.6' sends
						// only a tagged OK response when asked to fetch a
						// message that is not available:
						if (m_bFetchedData)
							done();
						else if (handleError(ERRCODE_CHAOS_MESSAGE_NOT_FOUND)
								     != ERROR_RESPONSE_CANCELED)
							cancel();
						return EXEC_DONE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_FETCH:
				{
					INetIMAPFetchResponse const & rFetchResponse
						= *static_cast< INetIMAPFetchResponse const * >(
							   pResponse);

					if (rFetchResponse.getPresentParts()
						    & INetIMAPFetchResponse::PART_UID
						&& rFetchResponse.getUID() == m_nMesgUID)
					{
						m_bFetchedData = true;
						m_rMesgNode.initialize(getJob(), true,
											   &rFetchResponse, 0);

						INetIMAPFetchResponseBodySectionList const & rSections
							= rFetchResponse.getBodySections();
						for (ULONG i = 0; i < rSections.getCount(); ++i)
						{
							INetIMAPFetchResponseBodySection const & rSection
								= rSections.get(i);

							if ((rSection.getSectionText()
							 == INetIMAPBodySectionDescriptor::SECTION_TEXT_NO
								     && !rSection.getSectionNumberSequence().
								                      getCount()
								     && !rSection.isPartial())
								|| rSection.getSectionText()
								     == INetIMAPBodySectionDescriptor::RFC822)
							{
								INetCoreNewsMessage const * pMessage
									= rSection.getData();
								if (pMessage)
								{
									CntStorageNode * pCacheNode
										= getJob().GetCacheNode();
									if (pCacheNode)
									{
										String aBodyStreamID(
											       m_rMesgNode.
												       getBodyStreamID());
										SvStream * pMesgBodyCacheStream
											= pCacheNode->
											      openStream(
													  aBodyStreamID,
													  STREAM_STD_WRITE);
										if (pMesgBodyCacheStream)
										{
											*pMesgBodyCacheStream
												<< CNT_MESSAGEBODY_NEWS_DATA;
											pMesgBodyCacheStream->
												WriteByteString(
													m_rMesgNode.
													    getDataStreamID(),
													RTL_TEXTENCODING_UTF8);
											*pMesgBodyCacheStream
												<< *pMessage;
											delete pMesgBodyCacheStream;

											CntMessageBodyItem
												aMesgBody(WID_MESSAGEBODY,
														  aBodyStreamID);
											aMesgBody.Get(pCacheNode,
														  getAcnt().
														      getINetMailer(),
														  true);

											// Force the following Put() to
											// broadcast an
											// SfxItemChangedHint:
											if (m_rMesgNode.
												        GetItemState(
															WID_MESSAGEBODY,
															false)
												    == SFX_ITEM_DISABLED)
												m_rMesgNode.
													ClearItem(
														WID_MESSAGEBODY);

											m_rMesgNode.Put(aMesgBody);
											m_rMesgNode.
												setBodyProperties(getJob());

											removeMesgDataCacheStream();

											if (ITEMSET_VALUE(
												        &m_rMesgNode,
														CntMsgStoreModeItem,
														WID_MESSAGE_STOREMODE)
											   == CNT_MESSAGE_STOREMODE_LOCAL)
												pCacheNode->
													attrib(
														aBodyStreamID, 0,
												   CNTDIRENTRY_ATTRIB_HIDDEN);
											else
												pCacheNode->
													remove(aBodyStreamID);
										}
									}
								}
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_START_OFFLINE:
			cancel();
			return EXEC_DONE;

		default:
			return CntIMAPSelectTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
CntIMAPMesgOpenTask::CntIMAPMesgOpenTask(CntNodeJob & rJob,
										 CntIMAPMesgNode & rTheMesgNode):
	CntIMAPSelectTask(rJob, rTheMesgNode.getParentMbox()),
	m_rMesgNode(rTheMesgNode),
	m_bHasMesgDataCacheStream(false)
{}

//============================================================================
//
//  CntIMAPMesgExportTask
//
//============================================================================

// virtual
void CntIMAPMesgExportTask::notification(SfxBroadcaster & rBroadcaster,
										 SfxHint const & rHint)
{
	if (&rBroadcaster == &m_xOpenJob)
	{
		if (CntStatusHint * pStatusHint = PTR_CAST(CntStatusHint, &rHint))
			if (pStatusHint->GetStatus() == CNT_STATUS_DONE
				|| pStatusHint->GetStatus() == CNT_STATUS_ERROR
				   && pStatusHint->GetError() == ERRCODE_ABORT)
			{
				EndListening(*m_xOpenJob);
				m_xOpenJob = 0;
				reschedule();
			}
	}
	else
		super::notification(rBroadcaster, rHint);
}

//============================================================================
// virtual
void CntIMAPMesgExportTask::beingCanceled()
{
	if (m_xOpenJob.Is())
		EndListening(*m_xOpenJob);
	super::beingCanceled();
}

//============================================================================
// virtual
void CntIMAPMesgExportTask::end()
{
	delete m_pExport;
	if (m_pStream)
		static_cast< CntExpStreamItem const * >(getJob().GetRequest())->
			releaseStream();
	super::end();
}

//============================================================================
// virtual
bool CntIMAPMesgExportTask::executeTimeSlice(bool bFirst)
{
	CntExpStreamItem const & rRequest
		= *static_cast< CntExpStreamItem const * >(getJob().GetRequest());

	if (bFirst && !rRequest.hasStream())
	{
		cancel();
		return false;
	}

	if (!m_pStream)
	{
		m_pStream = rRequest.tryToAcquireStream();
		if (!m_pStream)
			return true;

		m_pExport = new CntExport(*m_pStream);

		String aFileName;
		if (m_pStream->IsA() == ID_FILESTREAM)
			aFileName
				= static_cast< SvFileStream * >(m_pStream)->GetFileName();
		String aStatusText;
		if (aFileName.Len() != 0)
		{
			aStatusText = CntResId(RID_STATUS_EXPORT_TO);
			aStatusText.SearchAndReplaceAscii("%1", aFileName);
		}
		else
			aStatusText = CntResId(RID_STATUS_EXPORT);
		pushStatusInformation(aStatusText);

		if (rRequest.doForceBodies() && !m_rMesgNode.getBody(getJob()))
		{
			m_xOpenJob = new CntNodeJob(&getJob(), &m_rMesgNode, &m_rMesgNode,
										CntOpenModeItem(WID_OPEN,
														CNT_OPEN_MESSAGE));
			new CntIMAPMesgOpenTask(*m_xOpenJob, m_rMesgNode);
			StartListening(*m_xOpenJob);
			getAcnt().getNode().ExecuteJob(m_xOpenJob);
			return false;
		}
	}

	ErrCode nError = getAcnt().exportMesg(getJob(), *m_pExport, m_rMesgNode);

	if (nError == ERRCODE_NONE)
		done();
	else
	{
		getJob().SetError(nError);
		cancel();
	}

	return false;
}

//============================================================================
CntIMAPMesgExportTask::CntIMAPMesgExportTask(CntNodeJob & rJob,
											 CntIMAPMesgNode & rTheMesgNode):
	CntIMAPOfflineTask(rJob, rTheMesgNode.getParentMbox().getAcnt().getNode(),
					   rTheMesgNode.getParentMbox().getAcnt()),
	m_rMesgNode(rTheMesgNode),
	m_pStream(0),
	m_pExport(0)
{}

//============================================================================
//
//  CntIMAPMesgDeleteTask
//
//============================================================================

// virtual
bool CntIMAPMesgDeleteTask::initialize()
{
	if (!ITEM_VALUE(CntBoolItem, *getJob().GetRequest()))
	{
		if (!m_rMesgNode.isDeleted())
		{
			CntNodeRef
			 xMboxDirNode(m_rMesgNode.getParentMbox().getDirNode(getJob()));
			if (!xMboxDirNode.Is())
			{
				cancel();
				return false;
			}

			sal_uInt32 nMesgDirAttribs;
			String aMboxURL;
			sal_uInt32 nUIDValidity;
			sal_uInt32 nMesgUID;
			CntIMAPURL::decomposeMesgURL(OWN_URL(&m_rMesgNode), aMboxURL,
										 nUIDValidity, nMesgUID);
			if (static_cast< CntStorageNode * >(&xMboxDirNode)->
				    attrib(CntIMAPMesgNode::createMesgDirID(nUIDValidity,
															nMesgUID),
						   0, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE,
						   nMesgDirAttribs))
			{
				cancel();
				return false;
			}

			m_rMesgNode.setDeleted(true);

			bool bServer = (nMesgDirAttribs
							        & CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER)
				               != 0;
			m_rMesgNode.getParentMbox().
			 changeMesgCounts(getJob(),
							  bServer ?
							   CntIMAPFldr::COUNT_STAY :
							   CntIMAPFldr::COUNT_DEC,
							  CntIMAPFldr::COUNT_STAY,
							  bServer ?
							   CntIMAPFldr::COUNT_DEC :
							   CntIMAPFldr::COUNT_STAY,
							  bServer ?
							   CntIMAPFldr::COUNT_INC :
							   CntIMAPFldr::COUNT_STAY,
							  nMesgDirAttribs
							    & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ ?
							   CntIMAPFldr::COUNT_DEC :
							   CntIMAPFldr::COUNT_STAY,
							  nMesgDirAttribs
							    & CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED ?
							   CntIMAPFldr::COUNT_DEC :
							   CntIMAPFldr::COUNT_STAY);

			getJob().Result(&m_rMesgNode, CNT_ACTION_DELETED);
		}

		done();
		return false;
	}

	m_bExpunged = false;

	for (;;)
		if (CntIMAPSelectTask::initialize())
			return true;
		else
			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
				case ERROR_RESPONSE_IGNORE:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return false;
			}
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMesgDeleteTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_STORE:
		{
			String aMboxURL;
			sal_uInt32 nUIDValidity;
			sal_uInt32 nMesgUID;
			CntIMAPURL::decomposeMesgURL(OWN_URL(&m_rMesgNode), aMboxURL,
										 nUIDValidity, nMesgUID);

			if (nUIDValidity && nUIDValidity != getUIDValidity())
			{
				m_nState = STATE_START_OFFLINE;
				return EXEC_CONTINUE;
			}

			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->add(nMesgUID);

			++m_nState;
			ErrCode nError
				= clientCommandStore(true, *pSet,
									 INetIMAPClient::STORE_ADD_FLAGS_SILENT,
									 INET_IMAP_FLAG_DELETED, 0);
			delete pSet;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_STORE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_SEND_EXPUNGE;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_SEND_EXPUNGE:
			++m_nState;
			return handleCommandFailure(clientCommandExpunge());

		case STATE_RECV_EXPUNGE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						m_bExpunged = true;

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_START_OFFLINE;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_START_OFFLINE:
		{
			CntNodeRef
			 xMboxDirNode(m_rMesgNode.getParentMbox().getDirNode(getJob()));
			if (xMboxDirNode.Is())
			{
				String aMboxURL;
				sal_uInt32 nUIDValidity;
				sal_uInt32 nMesgUID;
				CntIMAPURL::decomposeMesgURL(OWN_URL(&m_rMesgNode), aMboxURL,
											 nUIDValidity, nMesgUID);
				String
					aMesgDirID(CntIMAPMesgNode::createMesgDirID(nUIDValidity,
																nMesgUID));

				sal_uInt32 nMesgDirAttribs = 0;
				static_cast< CntStorageNode * >(&xMboxDirNode)->
					attrib(aMesgDirID, 0, 0, nMesgDirAttribs);
				static_cast< CntStorageNode * >(&xMboxDirNode)->
					remove(aMesgDirID);

				CntStorageNode * pCacheNode = getJob().GetCacheNode(false);
				if (pCacheNode)
					pCacheNode->remove(m_rMesgNode.getBodyStreamID());

				bool bServer = (nMesgDirAttribs
								        & CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER)
					               != 0;
				bool bDeleted = m_rMesgNode.isDeleted();

				m_rMesgNode.setDeleted(false);

				// EXP: expunge successful
				// SRV: CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER bit set
				// DEL: CNTDIRENTRY_ATTRIB_MARKEDFORDELTE bit set
				// r: CNTDIRENTRY_ATTRIB_IMAP_MESG_READ bit set
				// m: CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED bit set
				// L: local-only non-deleted mesg count
				// S: server-only non-deleted mesg count
				// LS: local-and-server non-deleted mesg count
				// LSD: local-and-server deleted mesg count
				// R: read mesg count
				// M: marked mesg count
				//
				// EXP SRV DEL |  L   S  LS  LSD
				// ------------+----------------
				//  -   -   -  | DEC  -   -   -
				//  -   -   x  |  -   -   -   -
				//  -   x   -  |  -  INC DEC  -
				//  -   x   x  |  -  INC  -  DEC
				//  x   -   -  | DEC  -   -   -
				//  x   -   x  |  -   -   -   -
				//  x   x   -  |  -   -  DEC  -
				//  x   x   x  |  -   -   -  DEC
				//
				// DEL  r   m  |  R   M
				// ------------+--------
				//  -   -   -  |  -   -
				//  -   -   x  |  -  DEC
				//  -   x   -  | DEC  -
				//  -   x   x  | DEC DEC
				//  x   -   -  |  -   -
				//  x   -   x  |  -   -
				//  x   x   -  |  -   -
				//  x   x   x  |  -   -
				m_rMesgNode.getParentMbox().
				 changeMesgCounts(getJob(),
								  !bServer && !bDeleted ?
								   CntIMAPFldr::COUNT_DEC :
								   CntIMAPFldr::COUNT_STAY,
								  !m_bExpunged && bServer ?
								   CntIMAPFldr::COUNT_INC :
								   CntIMAPFldr::COUNT_STAY,
								  bServer && !bDeleted ?
								   CntIMAPFldr::COUNT_DEC :
								   CntIMAPFldr::COUNT_STAY,
								  bServer && bDeleted ?
								   CntIMAPFldr::COUNT_DEC :
								   CntIMAPFldr::COUNT_STAY,
								  !bDeleted
								  && nMesgDirAttribs
								      & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ ?
								   CntIMAPFldr::COUNT_DEC :
								   CntIMAPFldr::COUNT_STAY,
								  !bDeleted
								  && nMesgDirAttribs
								      & CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED ?
								   CntIMAPFldr::COUNT_DEC :
								   CntIMAPFldr::COUNT_STAY);
			}

			return EXEC_BASE;
		}

		default:
			return CntIMAPSelectTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
CntIMAPMesgDeleteTask::CntIMAPMesgDeleteTask(CntNodeJob & rJob,
											 CntIMAPMesgNode & rTheMesgNode):
	CntIMAPSelectTask(rJob, rTheMesgNode.getParentMbox()),
	m_rMesgNode(rTheMesgNode)
{}

//============================================================================
//
//  CntIMAPMesgUnDeleteTask
//
//============================================================================

// virtual
bool CntIMAPMesgUnDeleteTask::executeTimeSlice(bool)
{
	if (!m_rMesgNode.isDeleted())
	{
		done();
		return false;
	}

	CntStorageNode * pMboxDirNode = getJob().GetDirectoryNode();
	if (!pMboxDirNode)
	{
		cancel();
		return false;
	}

	String aMboxURL;
	sal_uInt32 nUIDValidity;
	sal_uInt32 nMesgUID;
	CntIMAPURL::decomposeMesgURL(OWN_URL(&m_rMesgNode), aMboxURL,
								 nUIDValidity, nMesgUID);

	sal_uInt32 nMesgDirAttribs;
	if (pMboxDirNode->
		 attrib(CntIMAPMesgNode::createMesgDirID(nUIDValidity, nMesgUID),
				CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0, nMesgDirAttribs))
	{
		cancel();
		return false;
	}

	m_rMesgNode.setDeleted(false);

	bool bServer = (nMesgDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER)
		               != 0;
	m_rMesgNode.getParentMbox().
	 changeMesgCounts(getJob(),
					  bServer ?
					   CntIMAPFldr::COUNT_STAY : CntIMAPFldr::COUNT_INC,
					  CntIMAPFldr::COUNT_STAY,
					  bServer ?
					   CntIMAPFldr::COUNT_INC : CntIMAPFldr::COUNT_STAY,
					  bServer ?
					   CntIMAPFldr::COUNT_DEC : CntIMAPFldr::COUNT_STAY,
					  nMesgDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ ?
					   CntIMAPFldr::COUNT_INC : CntIMAPFldr::COUNT_STAY,
					  nMesgDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED ?
					   CntIMAPFldr::COUNT_INC : CntIMAPFldr::COUNT_STAY);

	getJob().Result(&m_rMesgNode);

	done();
	return false;
}

//============================================================================
CntIMAPMesgUnDeleteTask::CntIMAPMesgUnDeleteTask(CntNodeJob & rJob,
												 CntIMAPMesgNode &
												  rTheMesgNode):
	CntIMAPOfflineTask(rJob, rTheMesgNode.getParentMbox().getAcnt().getNode(),
					   rTheMesgNode.getParentMbox().getAcnt()),
	m_rMesgNode(rTheMesgNode)
{}

//============================================================================
//
//  CntIMAPMesgFlagTask
//
//============================================================================

// virtual
bool CntIMAPMesgFlagTask::initialize()
{
	SfxPoolItem const * pFlagged;
	if (m_rMesgNode.GetItemState(getJob().GetRequest()->Which(), false,
								 &pFlagged)
		    == SFX_ITEM_SET
		&& (ITEM_VALUE(CntBoolItem, *pFlagged) != false)
		       == (ITEM_VALUE(CntBoolItem, *getJob().GetRequest()) != false))
	{
		done();
		return false;
	}

	for (;;)
		if (CntIMAPSelectTask::initialize())
			return true;
		else
			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
				case ERROR_RESPONSE_IGNORE:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return false;
			}
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMesgFlagTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_STORE:
		{
			String aMboxURL;
			sal_uInt32 nUIDValidity;
			sal_uInt32 nMesgUID;
			CntIMAPURL::decomposeMesgURL(OWN_URL(&m_rMesgNode), aMboxURL,
										 nUIDValidity, nMesgUID);

			if (nUIDValidity != 0 && nUIDValidity != getUIDValidity())
			{
				m_rMesgNode.storeProperty(getJob(), *getJob().GetRequest());

				done();
				return EXEC_DONE;
			}

			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->add(nMesgUID);

			++m_nState;
			ErrCode nError
				= clientCommandStore(
					  true, *pSet,
					  ITEM_VALUE(CntBoolItem, *getJob().GetRequest()) ?
					      INetIMAPClient::STORE_ADD_FLAGS_SILENT :
					      INetIMAPClient::STORE_REMOVE_FLAGS_SILENT,
					  getJob().GetRequest()->Which() == WID_IS_READ ?
					      INET_IMAP_FLAG_SEEN : INET_IMAP_FLAG_FLAGGED,
					  0);
			delete pSet;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_STORE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						m_rMesgNode.initialize(getJob(), true, 0, 0);
						m_rMesgNode.storeProperty(getJob(),
												  *getJob().GetRequest());

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						done();
						return EXEC_DONE;
					}
					break;
				}
			}
			break;

		case STATE_START_OFFLINE:
			cancel();
			return EXEC_DONE;

		default:
			return CntIMAPSelectTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
CntIMAPMesgFlagTask::CntIMAPMesgFlagTask(CntNodeJob & rJob,
										 CntIMAPMesgNode & rTheMesgNode):
	CntIMAPSelectTask(rJob, rTheMesgNode.getParentMbox()),
	m_rMesgNode(rTheMesgNode)
{}

