/*************************************************************************
 *
 *  $RCSfile: imapmsgt.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPMSGT_HXX
#define CHAOS_IMAPMSGT_HXX

#ifndef CHAOS_IMAPTASK_HXX
#include <imaptask.hxx>
#endif

namespace chaos {

class CntExport;

//============================================================================
class CntIMAPMesgOpenTask: public CntIMAPSelectTask
{
	typedef CntIMAPSelectTask super;

	enum { STATE_SEND_FETCH = STATE_START_ONLINE, STATE_RECV_FETCH };

	CntIMAPMesgNode & m_rMesgNode;
	sal_uInt32 m_nMesgUID;
	bool m_bHasMesgDataCacheStream;
	bool m_bFetchedData;

	void removeMesgDataCacheStream();

	DECL_LINK(streamCallback, INetIMAPFetchResponseBodySection const *);

	virtual void beingCanceled();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMesgOpenTask(CntNodeJob & rJob, CntIMAPMesgNode & rTheMesgNode);
};

//============================================================================
class CntIMAPMesgExportTask: public CntIMAPOfflineTask
{
	typedef CntIMAPOfflineTask super;

	CntNodeJobRef m_xOpenJob;
	CntIMAPMesgNode & m_rMesgNode;
	SvStream * m_pStream;
	CntExport * m_pExport;

	virtual bool executeTimeSlice(bool bFirst);

	virtual void notification(SfxBroadcaster & rBroadcaster,
							  SfxHint const & rHint);

	virtual void beingCanceled();

	virtual void end();

public:
	CntIMAPMesgExportTask(CntNodeJob & rJob, CntIMAPMesgNode & rTheMesgNode);
};

//============================================================================
class CntIMAPMesgDeleteTask: public CntIMAPSelectTask
{
	typedef CntIMAPSelectTask super;

	enum { STATE_SEND_STORE = STATE_START_ONLINE, STATE_RECV_STORE,
		   STATE_SEND_EXPUNGE, STATE_RECV_EXPUNGE };

	CntIMAPMesgNode & m_rMesgNode;
	bool m_bExpunged;

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMesgDeleteTask(CntNodeJob & rJob, CntIMAPMesgNode & rTheMesgNode);
};

//============================================================================
class CntIMAPMesgUnDeleteTask: public CntIMAPOfflineTask
{
	typedef CntIMAPOfflineTask super;

	CntIMAPMesgNode & m_rMesgNode;

	virtual bool executeTimeSlice(bool);

public:
	CntIMAPMesgUnDeleteTask(CntNodeJob & rJob,
							CntIMAPMesgNode & rTheMesgNode);
};

//============================================================================
class CntIMAPMesgFlagTask: public CntIMAPSelectTask
{
	typedef CntIMAPSelectTask super;

	enum { STATE_SEND_STORE = STATE_START_ONLINE, STATE_RECV_STORE };

	CntIMAPMesgNode & m_rMesgNode;

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMesgFlagTask(CntNodeJob & rJob, CntIMAPMesgNode & rTheMesgNode);
};

}

#endif // CHAOS_IMAPMSGT_HXX

