/*************************************************************************
 *
 *  $RCSfile: imapstor.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPSTOR_HXX
#define CHAOS_IMAPSTOR_HXX

//============================================================================
//
//  Account
//
//============================================================================

/** The ID of the account set in the account directory.
 */
#define CNT_IMAP_ACNT_SET_ID "ACNT"

/** Flags for the account set in the account directory.
 */
#define CNTDIRENTRY_ATTRIB_IMAP_ACNT_MBOXS CNTDIRENTRY_ATTRIB_USER1
#define CNTDIRENTRY_ATTRIB_IMAP_ACNT_SSCRBD_MBOXS CNTDIRENTRY_ATTRIB_USER2
#define CNTDIRENTRY_ATTRIB_IMAP_ACNT_AUTO_CHECKED CNTDIRENTRY_ATTRIB_USER7

//============================================================================
//
//  Mailboxes
//
//============================================================================

/** Flags for mailbox sets in their parent directories.
 */
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX CNTDIRENTRY_ATTRIB_USER4
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD CNTDIRENTRY_ATTRIB_MARKED
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_MBOXS CNTDIRENTRY_ATTRIB_USER1
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD_MBOXS CNTDIRENTRY_ATTRIB_USER2
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS CNTDIRENTRY_ATTRIB_USER3
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW CNTDIRENTRY_ATTRIB_USER5
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED CNTDIRENTRY_ATTRIB_USER6
#define CNTDIRENTRY_ATTRIB_IMAP_MBOX_AUTO_CHECKED CNTDIRENTRY_ATTRIB_USER7

/** WIDs for the account node set, the account directory set, mailbox node
	sets, and mailbox directory sets.
 */
#define WID_IMAP_MBOX_COUNT WID_FOLDER_COUNT
#define WID_IMAP_SSCRBD_MBOX_COUNT WID_SUBSCRNEWSGROUPCOUNT

/** WIDs for mailbox node sets and mailbox directory sets.
 */
#define WID_IMAP_MESG_COUNT WID_TOTALCONTENTCOUNT
#define WID_IMAP_READ_MESG_COUNT WID_SEENCONTENTCOUNT
#define WID_IMAP_MARKED_MESG_COUNT WID_MARKED_DOCUMENT_COUNT

/** WIDs for mailbox directory sets (Local, Server, and Deleted).
 */
#define WID_IMAP_L_MESG_COUNT WID_FACTORY_HELP_ID
#define WID_IMAP_S_MESG_COUNT WID_NEWSGROUPCOUNT
#define WID_IMAP_LS_MESG_COUNT WID_ARTICLECOUNT
#define WID_IMAP_LSD_MESG_COUNT WID_DOCUMENT_SIZE

//============================================================================
//
//  Messages
//
//============================================================================

/** The UID validity separator for message sets in their parent directories.
 */
#define CNT_IMAP_MESG_SET_ID_UIDVALIDITY_SEPARATOR '.'

/** The suffix for message raw data stream IDs in the account directory.
 */
#define CNT_IMAP_MESG_DATA_STREAM_ID_SUFFIX ".data"

/** The suffix for message body stream IDs in the account directory.
 */
#define CNT_IMAP_MESG_BODY_STREAM_ID_SUFFIX ".body"

/** Flags for message sets in their parent directories.
 */
#define CNTDIRENTRY_ATTRIB_IMAP_MESG_READ CNTDIRENTRY_ATTRIB_USER1
#define CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED CNTDIRENTRY_ATTRIB_MARKED
#define CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER CNTDIRENTRY_ATTRIB_USER2

#endif // CHAOS_IMAPSTOR_HXX

