/*************************************************************************
 *
 *  $RCSfile: cntrnmgr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTRNMGR_HXX
#define _CNTRNMGR_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif
#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif

class SfxCancelManager;
class SimpleResMgr;
class Link;
struct ExchangeParams;

namespace inet {
	class INetWrapper;
}

namespace com {	namespace sun {	namespace star { namespace uno {
	template < class T > class Reference;
} } } }

namespace com {	namespace sun {	namespace star { namespace lang {
	class XMultiServiceFactory;
} }	} }

namespace chaos {

class CntIniManager;
class CntJobDispatcher;
class CntJobRescheduler;
class CntUpdateInitTimer;

struct CntErrorHandler;
struct CntFileNameEntry;
struct CntPasswordEntry;
struct CntUpdateEntry;

struct CntSystemData_Impl;

DECLARE_LIST( CntUpdateList,       CntUpdateEntry* )
DECLARE_LIST( CntPasswordList,     CntPasswordEntry* )
DECLARE_LIST( CntFileEntryList,    CntFileNameEntry* )
DECLARE_LIST( CntSchedulerList,    CntJobRescheduler* )
DECLARE_LIST( CntErrorHandlerList, CntErrorHandler* )
DECLARE_LIST( CntViewTypesList,    String* )

#define CNT_UPDATEREQUEST_REMOVE   	( (ULONG)-1 )
#define CNT_UPDATEREQUEST_REMOVEALL ( (ULONG)-2 )

//=========================================================================

#define CNT_RNM()  CntRootNodeMgr::Get()
#define CNT_DATA() CntRootNodeMgr::GetSystemData()

class CntRootNodeMgr : public CntNode
{
	friend class chaos::CntUpdateInitTimer;

private:
	static CntSystemData_Impl*	_pSysData;
	static CntRootNodeMgr*		_pTheRNM;

	CntConnMode					_eConnMode;
	String						_aCacheDir;
	String						_aConfigDir;
	CntNodeRef					_xStorage;
	CntUpdateList  				_aUpdateList;
	CntUpdateInitTimer*			_pInitTimer;
	CntFileEntryList			_aFileEntryList;
	CntPasswordList				_aPasswordList;
	CntSchedulerList			_aSchedulerList;
	CntViewTypesList			_aViewTypesList;
	CntViewList					_aViewList;
	CntExplorerList				_aExplorerList;
	CntErrorHandlerList*		_pErrorHandlerList;
	CntJobDispatcher*			_pDispatcher;
	BOOL						_bKeepPassword : 1;
	BOOL						_bLazyInitDone : 1;

	void 						RestoreProperties_Impl();
	BOOL 						RemoveChildRequests_Impl
												( const String& rParentURL );
	void 						SaveUpdateRequesterList_Impl();
	void 						SaveFileEntryList_Impl();
	void 						SaveViewList_Impl();
	void 						SaveExplorerList_Impl();
	void 						SaveTransActionList_Impl();
	void 						SetConnMode_Impl( CntConnMode eConnMode );
	BOOL						UpdateAllowed_Impl( CntUpdateEntry* pEntry );

	BOOL     					GetLoginInfo_Impl( const String& rTargetURL,
												   const String& rServer,
												   const String& rRealm,
									   			   String& rUser,
									   			   String& rPassword,
												   String& rAccount,
									   			   const CntNodeJob* pJob,
									   			   const String& rStoredPw,
												   const String& rStoredAc,
                                                   bool bErrorHandler );
	CntErrorHandler* 			GetErrorHandler_Impl(
										const CntInterface* pClient ) const;
	ErrCode						PropagateError_Impl(
												ErrCode       nError,
												CntNodeJob*   pJob,
												const String* pErrorStr,
												void*         pData );

	static CntSystemData_Impl*	GetOrCreateSystemData();

                    			CntRootNodeMgr( const CntRootNodeMgr& ); // n.i.
    CntRootNodeMgr&				operator=( const CntRootNodeMgr& ); // n.i.

protected:
								CntRootNodeMgr();
	virtual 					~CntRootNodeMgr();

public:
								TYPEINFO();
								CNT_NODE_SUBCLASS_DECL();

    // Lazy Initialization
	static void					LazyInitialize();
	BOOL						LazyInitDone() const { return _bLazyInitDone; }

	// Deinitialize system
	void						Deinitialize();

	// Get the CHAOS Rootnode Manager
	static CntRootNodeMgr* 		Get() { return _pTheRNM; }
	// -> Get, create if not exists
	static CntRootNodeMgr* 		GetOrCreate();

	// Get CHAOS system data pointer
	static CntSystemData_Impl*	GetSystemData() { return _pSysData; }

	// Registration of node factories ( in cntreg.cxx )
	static void 				RegisterFactories();

	// Is CHAOS system available?
	static BOOL					IsCHAOS();

	virtual void				Flush();
	virtual void				Inserted( CntNode *pNewNode,
										  CntNodeJob* pJob,
										  BOOL bBroadcast = TRUE );

	// Automatic update:
	// 	nInterval = 0 : removes AUTO-update request / leaves manually update
	// 	nInterval = -1 : completely removes update request
	//  nInterval = -2 : completly removes update request / inclusive children
	//  nInterval (seconds) sets automatic update for the node
	void						RequestAutoUpdate( CntAnchor* pAnchor,
											   	   ULONG 	  nInterval );
	void 						SyncAutoUpdate( CntAnchor* pAnchor,
									 			const String& rOldURL );
	BOOL						ResetUpdateResults( CntAnchor* pAnchor,
													BOOL bRecursive );

	// SfxItemSet interface
    virtual const SfxPoolItem*  Put( const SfxPoolItem& rProp, USHORT nWhich );
    		const SfxPoolItem*  Put( const SfxPoolItem& rProp )
		                                { return Put( rProp, rProp.Which() ); }

	// SfxListener-Interface
	virtual void				Notify( SfxBroadcaster& rBC,
										const SfxHint& rHint );

	// Get the URL of directory for placing cache nodes
	const String&				GetCacheDirectory();

	// Get the URL of directory for placing user data nodes
	const String&				GetUserDataDirectory();

	// Get the URL of directory for placing trash
	const String&				GetTrashDirectory();

	// Get/Set the URL for the default out tray
	const String&				GetOutTrayURL( BOOL bCheck = TRUE );
	void						SetOutTrayURL( const String& rURL );

	// INI Manager
	static CntIniManager*		GetIniManager();

	// Cancel Manager
	static SfxCancelManager*	GetCancelManager();
	static void					SetCancelManager( SfxCancelManager* pCancelMgr );
	static SfxCancelManager*	GetOwnCancelManager();

	// Resource Manager
	static SimpleResMgr*		GetResManager();

	// INetWrapper
	BOOL 						getINetWrapper(
									NAMESPACE_INET( INetWrapper )*&rpWrapper );

	// Error handling
	BOOL						RegisterErrorHandler(
										const CntInterface* pClient,
	                                    const Link& rLink );
	BOOL						DeregisterErrorHandler(
										const CntInterface* pClient );
	const Link*					QueryErrorHandler(
										const CntInterface* pClient ) const;
	USHORT 						HandleError( ErrCode       nError,
											 CntNodeJob*   pJob,
											 const String* pErrorStr = NULL,
											 void*         pData = NULL,
											 bool          bCancelJob = true );

	// Creation of new root node.
	CntNode*					createNew( const CntItemListItem& rItem );

	// Construction of special (view) nodes.
	CntNode*					QueryViewNode( const String& rURL,
	                                           BOOL bCreate = TRUE );
	BOOL						IsViewNode	 ( const String& rURL,
	                                           BOOL bRoot = TRUE );
	const CntViewTypesList*		GetViewTypesList() const
								{ return &_aViewTypesList; }

	// Access to root views.
	BOOL						AddView	  ( CntNode* pRootViewNode );
	BOOL						RemoveView( CntNode* pRootViewNode );
	BOOL						RemoveView( const String& rRootViewURL );
	const CntViewList*			GetViewList() const	{ return &_aViewList; }

	// Access to Explorer directories.
    const CntExplorerList* 		GetExplorers() const { return &_aExplorerList; }
    void		  	 	   		AddExplorer   ( const String& rDirURL );
    void		  	 	   		RemoveExplorer( const String& rDirURL );

	// Access to login information.
	BOOL 						GetLoginInfo( const String& rTargetURL,
								   			  String& rUser,
								   			  String& rPassword );
	BOOL 						GetLoginInfo( const String& rServer,
											  const String& rRealm,
								   			  String& rUser,
								   			  String& rPassword );
	BOOL 						RemoveLoginInfo( const String& rTargetURL );

	// Transcations
	BOOL						AddLoggedJob( CntNodeJob* pJob );

	// File name conversion ( short<->long )
	BOOL						AddFileEntry( const String& rLongName,
											  const String& rShortName );
	BOOL						RemoveFileEntry( const String& rLongName );
	BOOL						GetFileEntry( String& rLongName,
											  String& rShortName );

	// Job rescheduler list
	void						AddJobScheduler
											( CntJobRescheduler* pScheduler )
								{ _aSchedulerList.Insert( pScheduler ); }
	void						RemoveJobScheduler
											( CntJobRescheduler* pScheduler )
								{ _aSchedulerList.Remove( pScheduler ); }

	// root storage
	CntNode*					GetStorage() const { return _xStorage; }

	// Job dispatcher
	virtual CntJobDispatcher*	getJobDispatcher() const;

    static void                 setSendFormats( USHORT nFormats );

	// UNO service factory stuff...
	static com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >
	getProcessServiceManager();
	static void	setProcessServiceManager(
			const com::sun::star::uno::Reference<
					com::sun::star::lang::XMultiServiceFactory >& rFactory );
};

}

#endif /* !_CNTRNMGR_HXX */
