/*************************************************************************
 *
 *  $RCSfile: cntrules.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:18:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTRULES_HXX
#define _CNTRULES_HXX

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _CHAOS_CNTRLDEF_HXX
#include <cntrldef.hxx>
#endif

class IntlWrapper;
namespace com { namespace sun { namespace star {
	namespace ucb { struct RuleTerm; }
	namespace uno { template< typename T > class Sequence; }
} } }

namespace chaos {

class CntNodeRule;
class CntNodeRuleSet;

//============================================================================
class CntNodeRuleTerm
{
	enum SearchResult { SEARCH_CONTAINS_NOT, SEARCH_CONTAINS,
						SEARCH_MATCHES };

	String m_aStringOperand;
	Date m_aDateOperand;
	sal_Int32 m_nNumericOperand;
	CntNodeRuleOperator m_eOperator;
	CntOperandType m_eOperandType;
	USHORT m_nPropertyWID;
	bool m_bCaseSensitive;
	bool m_bRegexp;

	inline StringCompare compare(String const & rArgument,
                                 IntlWrapper const & rIntlWrapper) const;

	inline SearchResult search(String const & rArgument,
                               IntlWrapper const & rIntlWrapper) const;

	bool matchString(String const & rArgument,
                     IntlWrapper const & rIntlWrapper) const;

	bool matchDate(Date const & rArgument) const;

	bool matchBool(bool bArgument) const;

	bool matchNumeric(sal_Int32 nArgument) const;

	bool matchDateNumeric(Date const & rArgument, Date const * pReferenceDate)
		const;

public:
	/// CNT_NODE_RULE_OPERANDTYPE_STRING constructor.
	CntNodeRuleTerm(CntNodeRule * pRule, USHORT nThePropertyWID,
					CntNodeRuleOperator eTheOperator,
					String const & rTheStringOperand, bool bTheCaseSensitive,
					bool bTheRegexp = false);

	/// CNT_NODE_RULE_OPERANDTYPE_DATE constructor.
	CntNodeRuleTerm(CntNodeRule * pRule, USHORT nThePropertyWID,
					CntNodeRuleOperator eTheOperator,
					Date const & rTheDateOperand);

	/// CNT_NODE_RULE_OPERANDTYPE_BOOL constructor.
	CntNodeRuleTerm(CntNodeRule * pRule, USHORT nThePropertyWID,
					CntNodeRuleOperator eTheOperator);

	/// CNT_NODE_RULE_OPERANDTYPE_NUMERIC constructor.
	CntNodeRuleTerm(CntNodeRule * pRule, USHORT nThePropertyWID,
					CntNodeRuleOperator eTheOperator,
					sal_Int32 nTheNumericOperand);

    bool operator ==(CntNodeRuleTerm const & rTerm) const;

    bool operator !=(CntNodeRuleTerm const & rTerm) const
	{ return !(*this == rTerm); }

	USHORT GetPropertySID() const { return m_nPropertyWID; }

	CntNodeRuleOperator GetOperator() const { return m_eOperator; }

	CntOperandType GetOperandType() const { return m_eOperandType; }

	String const & GetStringOperand() const { return m_aStringOperand; }

	bool IsCaseSensitive() const { return m_bCaseSensitive; }

	bool IsRegularExpression() const { return m_bRegexp; }

	Date const & GetDateOperand() const { return m_aDateOperand; }

	sal_Int32 GetNumericOperand() const { return m_nNumericOperand; }

	bool matches(SfxPoolItem const & rArgument,
                 IntlWrapper const & rIntlWrapper,
				 Date const * pReferenceDate) const;

	void store(SvStream & rStream) const;

	static CntNodeRuleTerm * load(SvStream & rStream);

	static CntNodeRuleTerm * translate(com::sun::star::ucb::RuleTerm const &
									       rTerm,
									   CntNodeRule * pRule);
};

//============================================================================
class CntNodeRule
{
	List m_aTerms;
	String m_aActionParameter;
	CntNodeAction m_eAction;

	void clearTerms();

	void copyTerms(CntNodeRule const & rRule);

public:
	CntNodeRule(CntNodeRuleSet * pSet, CntNodeAction eTheAction):
		m_eAction(eTheAction) {}

	CntNodeRule(CntNodeRuleSet * pSet, CntNodeAction eTheAction,
				String const & rTheActionParameter):
		m_eAction(eTheAction), m_aActionParameter(rTheActionParameter) {}

	inline CntNodeRule(CntNodeRule const & rRule);

	~CntNodeRule() { clearTerms(); }

    inline CntNodeRule & operator =(CntNodeRule const & rRule);

    bool operator ==(CntNodeRule const & rRule) const;

    bool operator !=(CntNodeRule const & rRule) const
	{ return !(*this == rRule); }

	sal_uInt32 TermCount() const { return m_aTerms.Count(); }

	CntNodeRuleTerm const * GetTerm(sal_uInt32 nIndex) const
	{ return static_cast< CntNodeRuleTerm * >(m_aTerms.GetObject(nIndex)); }

	void InsertTerm(CntNodeRuleTerm * pTerm)
	{ m_aTerms.Insert(pTerm, LIST_APPEND); }

	CntNodeAction GetAction() const { return m_eAction; }

	String const & GetParameter() const { return m_aActionParameter; }

	CntNodeAction queryAction(SfxItemSet const & rItems,
                              IntlWrapper const & rInternationl,
							  Date const * pReferenceDate) const;

	void store(SvStream & rStream) const;

	void load(SvStream & rStream);

	bool
	getTerms(
		com::sun::star::uno::Sequence< com::sun::star::ucb::RuleTerm > &
		    rTerms) const;

	bool
	addTerms(com::sun::star::uno::Sequence< com::sun::star::ucb::RuleTerm >
			         const &
			     rTerms);
};

inline CntNodeRule::CntNodeRule(CntNodeRule const & rRule):
	m_eAction(rRule.m_eAction),
	m_aActionParameter(rRule.m_aActionParameter)
{
	copyTerms(rRule);
}

inline CntNodeRule & CntNodeRule::operator =(CntNodeRule const & rRule)
{
	if (&rRule != this)
	{
		clearTerms();
		copyTerms(rRule);
		m_eAction = rRule.m_eAction;
		m_aActionParameter = rRule.m_aActionParameter;
	}
	return *this;
}

//============================================================================
class CntNodeActionRec
{
	String m_aParameter;
	CntNodeAction m_eAction;

public:
	CntNodeActionRec(CntNodeAction eTheAction): m_eAction(eTheAction) {}

	CntNodeActionRec(String const & rTheParameter, CntNodeAction eTheAction):
		m_eAction(eTheAction), m_aParameter(rTheParameter) {}

    inline bool operator ==(CntNodeActionRec const & rRec) const;

	bool operator !=(CntNodeActionRec const & rRec) const
	{ return !(*this == rRec); }

	CntNodeAction GetAction() const { return m_eAction; }

	String const & GetParameter() const { return m_aParameter; }
};

inline bool CntNodeActionRec::operator ==(CntNodeActionRec const & rRec) const
{
	return m_eAction == rRec.m_eAction && m_aParameter == rRec.m_aParameter;
}

//============================================================================
class CntNodeActionSet
{
	List m_aRecs;

	CntNodeActionSet(CntNodeActionSet const &); // not implemented

    void operator =(CntNodeActionSet const &); // not implemented

public:
	CntNodeActionSet() {};

	~CntNodeActionSet();

	sal_uInt32 Count() const { return m_aRecs.Count(); }

	CntNodeActionRec * Get(sal_uInt32 nIndex) const
	{ return static_cast< CntNodeActionRec * >(m_aRecs.GetObject(nIndex)); }

	void Insert(CntNodeActionRec * pRec, bool bClone);
};

//============================================================================
class CntNodeRuleSet
{
	List m_aRules;
	bool m_bHandleFolder;

	void clearRules();

	void copyRules(CntNodeRuleSet const & rSet);

public:
	CntNodeRuleSet(): m_bHandleFolder(false) {}

	CntNodeRuleSet(CntNodeRuleSet const & rSet):
		m_bHandleFolder(rSet.m_bHandleFolder) { copyRules(rSet); }

	~CntNodeRuleSet() { clearRules(); }

    inline CntNodeRuleSet & operator =(CntNodeRuleSet const & rSet);

    bool operator ==(CntNodeRuleSet const & rSet) const;

    bool operator !=(CntNodeRuleSet const & rSet) const
	{ return !(*this == rSet); }

	sal_uInt32 RuleCount() const { return m_aRules.Count(); }

	CntNodeRule const * GetRule(sal_uInt32 nIndex) const
	{ return static_cast< CntNodeRule * >(m_aRules.GetObject(nIndex)); }

	void InsertRule(CntNodeRule * pRule)
	{ m_aRules.Insert(pRule, LIST_APPEND); }

	bool GetHandleFolder() const { return m_bHandleFolder; }

	void SetHandleFolder(bool bTheHandleFolder)
	{ m_bHandleFolder = bTheHandleFolder; }

	CntNodeAction GetDefaultAction(bool & rNeitherNor) const;

	void execute(SfxItemSet const & rItems, CntNodeActionSet & rActions,
                 IntlWrapper const & rIntlWrapper,
				 Date const * pReferenceDate) const;

	void store(SvStream & rStream) const;

	void load(SvStream & rStream);
};

inline CntNodeRuleSet & CntNodeRuleSet::operator =(CntNodeRuleSet const &
												       rSet)
{
	if (&rSet != this)
	{
		clearRules();
		copyRules(rSet);
		m_bHandleFolder = rSet.m_bHandleFolder;
	}
	return *this;
}

//============================================================================
class CntRuleSetItem: public SfxPoolItem
{
	CntNodeRuleSet m_aSet;

public:
	TYPEINFO();

	CntRuleSetItem(USHORT nWhich = 0): SfxPoolItem(nWhich) {}

    virtual int operator ==(SfxPoolItem const & rItem) const;

	virtual SfxItemPresentation GetPresentation(SfxItemPresentation,
												SfxMapUnit, SfxMapUnit,
												String & rText,
                                                IntlWrapper const * = 0)
		const;

	virtual	BOOL QueryValue(com::sun::star::uno::Any& rVal, BYTE = 0) const;

	virtual	BOOL PutValue(com::sun::star::uno::Any const & rVal, BYTE = 0);

    virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const;

	virtual SvStream & Store(SvStream & rStream, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new CntRuleSetItem(*this); }

	CntNodeRuleSet const & GetRuleSet() const { return m_aSet; }

	void SetRuleSet(CntNodeRuleSet const & rTheSet) { m_aSet = rTheSet; }
};

}

#endif // _CNTRULES_HXX

