/*************************************************************************
 *
 *  $RCSfile: cntsditm.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:18:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTSDITM_HXX
#define _CNTSDITM_HXX

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

class Date;
class IntlWrapper;
namespace com { namespace sun { namespace star { namespace ucb {
	struct SearchInfo;
} } } }

namespace chaos {

class CntNodeRuleSet;

//============================================================================
enum CntSearchMatchMode
{
	CNT_SEARCH_MATCH_UNKNOWN,
	CNT_SEARCH_MATCH_NO,
	CNT_SEARCH_MATCH_YES
};

//============================================================================
class CntSearchData
{
public:
	enum RecursionType
	{
		RECURS_NONE,
		RECURS_ONE_LEVEL,
		RECURS_DEEP
	};

	enum StringRelType
	{
		STRING_EQUAL,
		STRING_NOT_EQUAL,
		STRING_CONTAINS,
		STRING_NOT_CONTAINS,
		STRING_LESS_EQUAL,
		STRING_GREATER_EQUAL
	};

	enum DateRelType
	{
		DATE_EQUAL,
		DATE_NOT_EQUAL,
		DATE_LESS_EQUAL,
		DATE_GREATER_EQUAL
	};

private:
	CntNodeRuleSet * m_pCriteria;
	RecursionType m_eRecursion;
	bool m_bIncludeBase;
	bool m_bRespectFolderViewRestrictions;
	bool m_bRespectDocViewRestrictions;
	bool m_bFollowIndirections;

public:
	inline CntSearchData(CntNodeRuleSet * pTheCriteria = 0,
						 RecursionType eTheRecursion = RECURS_NONE,
						 bool bTheIncludeBase = false,
						 bool bTheRespectFolderViewRestrictions = false,
						 bool bTheRespectDocViewRestrictions = false,
						 bool bTheFollowIndirections = false);

	inline CntSearchData(CntSearchData const & rData, bool bTheIncludeBase,
						 bool bStopRecursion = false);
		// if rData is the search data for some hirarchy level, this ctor
		// creates the right search data for the next 'deeper' hirarchy level

	inline CntSearchData * createSameLevel() const;

	inline CntSearchData * createNextLevel(bool bStopRecursion) const;

	bool DoSearchBase() const { return m_bIncludeBase; }

	bool DoSearchFirstLevel() const
	{ return m_eRecursion >= RECURS_ONE_LEVEL; }

	bool IsRecursive() const { return m_eRecursion == RECURS_DEEP; }

	bool DoObeyFolderViewRestrictions() const
	{ return m_bRespectFolderViewRestrictions; }

	bool DoObeyDocViewRestrictions() const
	{ return m_bRespectDocViewRestrictions; }

	bool DoFollowIndirections() const { return m_bFollowIndirections; }

	bool Matches(SfxItemSet const & aItems,
                 IntlWrapper const & rIntlWrapper) const;
		// return true if the item set matches the rules

	CntSearchMatchMode MatchesIncomplete(SfxItemSet const & aItems,
                                         IntlWrapper const & rIntlWrapper)
		const;
		// like Matches(), but items not set are considedered not (yet) known
		// (never returns CNT_SEARCH_MATCH_NO_DATA)

	bool HasSingleStringConstraint(USHORT nWhich,
								   StringRelType * pRelation = 0,
								   String * pString = 0,
								   bool * pCaseSensitive = 0,
								   bool * pRegexp = 0) const;

	bool HasSingleDateConstraint(USHORT nWhich, DateRelType * pRelation = 0,
								 Date * pDate = 0) const;

	void BaseAlreadyMatched() { m_bIncludeBase = false; }

	inline bool operator ==(CntSearchData const & rData) const;

	bool queryValue(com::sun::star::ucb::SearchInfo & rInfo) const;

	bool putValue(com::sun::star::ucb::SearchInfo const & rInfo);
};

inline CntSearchData::CntSearchData(CntNodeRuleSet * pTheCriteria,
									RecursionType eTheRecursion,
									bool bTheIncludeBase,
									bool bTheRespectFolderViewRestrictions,
									bool bTheRespectDocViewRestrictions,
									bool bTheFollowIndirections):
	m_pCriteria(pTheCriteria),
	m_eRecursion(eTheRecursion),
	m_bIncludeBase(bTheIncludeBase),
	m_bRespectFolderViewRestrictions(bTheRespectFolderViewRestrictions),
	m_bRespectDocViewRestrictions(bTheRespectDocViewRestrictions),
	m_bFollowIndirections(bTheFollowIndirections)
{}

inline CntSearchData::CntSearchData(CntSearchData const & rData,
									bool bTheIncludeBase,
									bool bStopRecursion):
	m_pCriteria(rData.m_pCriteria),
	m_eRecursion(bStopRecursion || rData.m_eRecursion == RECURS_ONE_LEVEL ?
				     RECURS_NONE : rData.m_eRecursion),
	m_bIncludeBase(bTheIncludeBase),
	m_bRespectFolderViewRestrictions(rData.m_bRespectFolderViewRestrictions),
	m_bRespectDocViewRestrictions(rData.m_bRespectDocViewRestrictions),
	m_bFollowIndirections(rData.m_bFollowIndirections)
{}

inline CntSearchData * CntSearchData::createSameLevel() const
{
	return new CntSearchData(m_pCriteria, m_eRecursion, true,
							 m_bRespectFolderViewRestrictions,
							 m_bRespectDocViewRestrictions,
							 m_bFollowIndirections);
}

inline CntSearchData * CntSearchData::createNextLevel(bool bStopRecursion)
	const
{
	return new CntSearchData(m_pCriteria,
							 bStopRecursion
							 || m_eRecursion == RECURS_ONE_LEVEL ?
							     RECURS_NONE : m_eRecursion,
							 false, m_bRespectFolderViewRestrictions,
							 m_bRespectDocViewRestrictions,
							 m_bFollowIndirections);
}

inline bool CntSearchData::operator ==(CntSearchData const & rData) const
{
	return m_pCriteria == rData.m_pCriteria
	       && m_eRecursion == rData.m_eRecursion
	       && m_bIncludeBase == rData.m_bIncludeBase
	       && m_bRespectFolderViewRestrictions
		          == rData.m_bRespectFolderViewRestrictions
	       && m_bRespectDocViewRestrictions
		          == rData.m_bRespectDocViewRestrictions
		   && m_bFollowIndirections == rData.m_bFollowIndirections;
}

//============================================================================
class CntSearchDataItem: public SfxPoolItem
{
	CntSearchData m_aData;

public:
	TYPEINFO();

	CntSearchDataItem(USHORT nWhich = 0): SfxPoolItem(nWhich) {}

	CntSearchDataItem(USHORT nWhich, CntSearchData const & rTheData):
		SfxPoolItem(nWhich), m_aData(rTheData) {}

	virtual ~CntSearchDataItem() {}

	virtual int operator ==(SfxPoolItem const & rItem) const;

	virtual	BOOL QueryValue(com::sun::star::uno::Any & rVal, BYTE = 0) const;

	virtual	BOOL PutValue(com::sun::star::uno::Any const & rVal, BYTE = 0);

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new CntSearchDataItem(*this); }

	CntSearchData const & GetValue() const { return m_aData; }
};

}

#endif // _CNTSDITM_HXX

