/*************************************************************************
 *
 *  $RCSfile: inimgr.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:18:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_INIMGR_HXX
#define _CHAOS_INIMGR_HXX

#ifndef _SFXBRDCST_HXX
#include <svtools/brdcst.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

class IntlWrapper;

namespace chaos {

class CntIniManager_Impl;

//============================================================================
enum CntSettingKey
{
	CNT_KEY_ADDRESS_EMAIL, // GetAddressToken(ADDRESS_EMAIL)
	CNT_KEY_INET_DNS, // SFX_KEY_INET_DNS
	CNT_KEY_INET_FTPPROXYNAME, // SFX_KEY_INET_FTPPROXYNAME
	CNT_KEY_INET_FTPPROXYPORT, // SFX_KEY_INET_FTPPROXYPORT
	CNT_KEY_INET_HTTPPROXYNAME, // SFX_KEY_INET_HTTPPROXYNAME
	CNT_KEY_INET_HTTPPROXYPORT, // SFX_KEY_INET_HTTPPROXYPORT
	CNT_KEY_INET_MAILPASSWORD, // SFX_KEY_INET_MAILPASSWORD
	CNT_KEY_INET_MAILTEXTFORMAT, // SFX_KEY_INET_MAILTEXTFORMAT
	CNT_KEY_INET_MAILUSERNAME, // SFX_KEY_INET_MAILUSERNAME
	CNT_KEY_INET_NNTPSERVER, // SFX_KEY_INET_NNTPSERVER
	CNT_KEY_INET_NOPROXY, // SFX_KEY_INET_NOPROXY
	CNT_KEY_INET_POPSERVER, // SFX_KEY_INET_POPSERVER
	CNT_KEY_INET_PROXYTYPE, // SFX_KEY_INET_PROXYTYPE
	CNT_KEY_INET_SECURITYPROXYNAME, // SFX_KEY_INET_SECURITYPROXYNAME
	CNT_KEY_INET_SECURITYPROXYPORT, // SFX_KEY_INET_SECURITYPROXYPORT
	CNT_KEY_INET_SOCKSPROXYNAME, // SFX_KEY_INET_SOCKSPROXYNAME
	CNT_KEY_INET_SOCKSPROXYPORT, // SFX_KEY_INET_SOCKSPROXYPORT
	CNT_KEY_INET_SMTPSERVER, // SFX_KEY_INET_SMTPSERVER
	CNT_KEY_INET_SSL, // SFX_GROUP_INET, "SSL"
	CNT_KEY_STORAGE_DIR, // SFX_KEY_STORAGE_DIR
	CNT_KEY_USER_FIRSTNAME, // SFX_KEY_TRASH_USER_FIRSTNAME
	CNT_KEY_USER_NAME, // SFX_KEY_TRASH_USER_NAME
	CNT_KEY_USER_LANGUAGE
};

//============================================================================
class CntIniManager: public SfxBroadcaster
{
	vos::ORef< CntIniManager_Impl > m_xImpl;

public:
	CntIniManager();

	virtual ~CntIniManager();

	String getEntry(CntSettingKey eKey) const;

	void startSettingsChangeListener();

	void stopSettingsChangeListener();

    IntlWrapper const & getIntlWrapper() const;
};

}

#endif // _CHAOS_INIMGR_HXX

