/*************************************************************************
 *
 *  $RCSfile: provider.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kso $ $Date: 2001/04/27 08:04:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PROVIDER_HXX
#define _PROVIDER_HXX

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPROPERTYSETREGISTRY_HPP_
#include <com/sun/star/ucb/XPropertySetRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

class Contents_Impl;

namespace chaos {

class ChaosContent;
class CntAnchor;

//=========================================================================

#define APP_VENDOR_TYPE_PREFIX "application/" INET_VENDOR_SCHEME_PREFIX
#define CHAOS_TYPE_PREFIX 	   ".chaos/"

//=========================================================================

class ChaosContentProvider :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::lang::XServiceInfo,
				public com::sun::star::lang::XEventListener,
				public com::sun::star::ucb::XContentProvider
{
public:
	ChaosContentProvider( const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& rXSMgr );
	virtual ~ChaosContentProvider();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

    // XServiceInfo
	XSERVICEINFO_DECL()

	// XEventListener
    virtual void SAL_CALL disposing( const com::sun::star::lang::EventObject& Source )
		throw( com::sun::star::uno::RuntimeException );

	// XContentProvider
	virtual com::sun::star::uno::Reference<	com::sun::star::ucb::XContent > SAL_CALL queryContent( const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Identifier )
		throw( com::sun::star::ucb::IllegalIdentifierException, com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL compareContentIds( const com::sun::star::uno::Reference<	com::sun::star::ucb::XContentIdentifier >& Id1,	const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Id2 )
		throw( com::sun::star::uno::RuntimeException );

	// Non-Interface methods
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentProviderManager > getBroker();
	com::sun::star::uno::Reference< com::sun::star::ucb::XPropertySetRegistry > getPropertySetRegistry();
	com::sun::star::uno::Reference< com::sun::star::ucb::XContent >	queryContent( ChaosContent* pParent, CntAnchor* pAnchor )
		throw( com::sun::star::ucb::IllegalIdentifierException, com::sun::star::uno::RuntimeException );
	void addContent	  ( ChaosContent* pContent );
	void removeContent( ChaosContent* pContent );
	void removeContent( const rtl::OUString& rURL );
	vos::OMutex& getMutex() { return m_aMutex; }

private:
	com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL queryContent_Impl( const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Identifier, ChaosContent* pParent, CntAnchor* pAnchor )
		throw( com::sun::star::ucb::IllegalIdentifierException, com::sun::star::uno::RuntimeException );

	// Members
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentProviderManager > m_xBroker;
	com::sun::star::uno::Reference< com::sun::star::ucb::XPropertySetRegistry > m_xPropsReg;
	Contents_Impl* m_pContents;
	vos::OMutex    m_aMutex;
};

}

#endif /* !_PROVIDER_HXX */
