/*************************************************************************
 *
 *  $RCSfile: strmitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_STRMITEM_HXX
#define _CHAOS_STRMITEM_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif

class SvStream;

namespace chaos {

//============================================================================
class CntGuardedStream: public SvRefBase
{
	friend class CntStreamItem;

	SvStream * m_pStream;
	BOOL m_bPublic;
	NAMESPACE_VOS(OMutex) m_aMutex;

private:
	virtual ~CntGuardedStream();

	inline SvStream * tryToAcquireStream()
	{ return m_bPublic || m_aMutex.tryToAcquire() ? m_pStream : 0; }

	inline void releaseStream();

public:
	CntGuardedStream(SvStream * pTheStream, BOOL bThePublic):
		m_pStream(pTheStream), m_bPublic(bThePublic) {}

	BOOL hasStream() const { return CAST_TO_BOOL(m_pStream); }
};

inline void CntGuardedStream::releaseStream()
{
	if (!m_bPublic)
		m_aMutex.release();
}

//============================================================================
SV_DECL_IMPL_REF(CntGuardedStream);

//============================================================================
class CntStreamItem: public SfxPoolItem
{
	MUTABLE CntGuardedStreamRef m_xGuard;
	MUTABLE SvStream * m_pAcquiredStream;

protected:
	void setStream(SvStream * pStream);

public:
	TYPEINFO();

	CntStreamItem(USHORT nWhich = 0, SvStream * pStream = 0);

	CntStreamItem(USHORT nWhich, const CntGuardedStreamRef & rTheGuard);

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any & rVal,
						  BYTE nMemberId = 0);

	virtual	BOOL QueryValue(com::sun::star::uno::Any & rVal,
							BYTE nMemberId = 0) const;

	virtual SfxPoolItem * Create(SvStream &, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	BOOL hasStream() const { return m_xGuard->hasStream(); }

	inline SvStream * tryToAcquireStream() const;

	inline void releaseStream() const;
};

inline SvStream * CntStreamItem::tryToAcquireStream() const
{
	if (!m_pAcquiredStream)
		MUTATE(CntStreamItem, m_pAcquiredStream)
		 = MUTATE(CntStreamItem, m_xGuard)->tryToAcquireStream();
	return m_pAcquiredStream;
}

inline void CntStreamItem::releaseStream() const
{
	if (m_pAcquiredStream)
	{
		MUTATE(CntStreamItem, m_pAcquiredStream) = 0;
		MUTATE(CntStreamItem, m_xGuard)->releaseStream();
	}
}

//============================================================================
class CntInStreamItem: public CntStreamItem
{
public:
	TYPEINFO();

	CntInStreamItem(USHORT nWhich = 0, SvStream * pStream = 0):
		CntStreamItem(nWhich, pStream) {}

	CntInStreamItem(USHORT nWhich, const CntGuardedStreamRef & rGuard):
		CntStreamItem(nWhich, rGuard) {}

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any & rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Create(SvStream &, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;
};

//============================================================================
class CntPostStreamItem: public CntInStreamItem
{
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > m_xSink;

public:
	TYPEINFO();

	CntPostStreamItem(USHORT nWhich = 0, SvStream * pStream = 0):
		CntInStreamItem(nWhich, pStream) {}

	CntPostStreamItem(USHORT nWhich, SvStream * pStream,
					  const com::sun::star::uno::Reference<
					  	com::sun::star::uno::XInterface > & rTheSink):
		CntInStreamItem(nWhich, pStream), m_xSink(rTheSink) {}

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any & rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Create(SvStream &, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	getDataSink() const { return m_xSink; }
};

//============================================================================
class CntOutStreamItem: public CntStreamItem
{
public:
	TYPEINFO();

	CntOutStreamItem(USHORT nWhich = 0, SvStream * pStream = 0):
		CntStreamItem(nWhich, pStream) {}

	CntOutStreamItem(USHORT nWhich, const CntGuardedStreamRef & rGuard):
		CntStreamItem(nWhich, rGuard) {}

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any & rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Create(SvStream &, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;
};

//============================================================================
class CntExpStreamItem: public CntOutStreamItem
{
	BOOL m_bForceBodies;

public:
	TYPEINFO();

	CntExpStreamItem(USHORT nWhich = 0, SvStream * pStream = 0,
					 BOOL bTheForceBodies = FALSE):
		CntOutStreamItem(nWhich, pStream), m_bForceBodies(bTheForceBodies) {}

	CntExpStreamItem(USHORT nWhich, const CntGuardedStreamRef & rGuard,
					 BOOL bTheForceBodies = FALSE):
		CntOutStreamItem(nWhich, rGuard), m_bForceBodies(bTheForceBodies) {}

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any & rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Create(SvStream &, USHORT) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	BOOL doForceBodies() const { return m_bForceBodies; }
};

}

#endif // _CHAOS_STRMITEM_HXX

