/*************************************************************************
 *
 *  $RCSfile: taskbase.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/20 10:24:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

#ifndef CHAOS_TASKBASE_HXX
#define CHAOS_TASKBASE_HXX

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _SFXCANCEL_HXX
#include <svtools/cancel.hxx>
#endif
#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _VOS_CONDITN_HXX
#include <vos/conditn.hxx>
#endif
#ifndef _VOS_THREAD_HXX
#include <vos/thread.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_
#include <vos/refernce.hxx>
#endif

namespace com { namespace sun { namespace star {
	namespace task { class XInteractionRequest;	}
	namespace ucb
	{
		class XContent;
		class XContentIdentifier;
		class XContentIdentifierFactory;
		class XCommandEnvironment;
	}
	namespace uno {	class Any; }
} } }

namespace rtl { class OUString; }

class SfxBroadcaster;
class SfxHint;
class SfxPoolItem;

namespace chaos {

class ChaosContent;
struct CntErrorData;

//============================================================================
enum ContentTaskStatus
{
    ContentTaskStatus_CREATED = 0,
    ContentTaskStatus_RUNNING = 1,
    ContentTaskStatus_DONE 	  = 2,
    ContentTaskStatus_ABORTED = 3
};

//============================================================================
class ContentTaskStatusListener
{
public:
    virtual void contentTaskStatusChange( const ContentTaskStatus& rOld,
										  const ContentTaskStatus& rNew ) = 0;
};

//=========================================================================
class ContentTask : public vos::OReference
{
public:
    virtual void start() = 0;
    virtual void execute()
		throw( com::sun::star::uno::Exception ) = 0;
    virtual void abort() = 0;
    virtual const ContentTaskStatus& getStatus() const = 0;
    virtual com::sun::star::uno::Reference<
		com::sun::star::ucb::XCommandEnvironment > getEnvironment() const = 0;
};

//============================================================================
class ChaosTaskBase : public SfxListener
{
	enum { PROGRESS_NONE = 0x10000, PROGRESS_TEXT };
	enum TaskCallbackReason { NONE = 0, FINISHED, EXCEPTION, INTERACTION };

	com::sun::star::uno::Reference<
		com::sun::star::ucb::XCommandEnvironment >  	 m_xEnv;
	com::sun::star::uno::Reference<
		com::sun::star::ucb::XContentIdentifierFactory > m_xIDFactory;
	com::sun::star::uno::Reference<
		com::sun::star::task::XInteractionRequest > 	 m_xInteractionRequest;
	vos::OCondition             m_aFinished;
	vos::OCondition             m_aInteracted;
	ContentTaskStatus 			m_eState;
	ChaosContent*               m_pOwner;
	ContentTask*   				m_pTask;
	ContentTaskStatusListener*	m_pListener;
	SfxCancellable*             m_pCancellable;
	TaskCallbackReason			m_eCallbackReason;
	com::sun::star::uno::Any    m_aException;
	sal_uInt32					m_nProgressState;
    oslThreadIdentifier         m_nMainThreadId;
	sal_Bool					m_bStarted;
	sal_Bool					m_bExecSync;

private:
	DECL_LINK( ErrorHandler, const CntErrorData* );

	void initIDFactory();
	void waitForCompletion();
    void finalCleanup();

public:
	ChaosTaskBase( ChaosContent* pOwner,
				   ContentTask* pTask,
			       const com::sun::star::uno::Reference<
				   			com::sun::star::ucb::XCommandEnvironment >& xEnv,
				   ContentTaskStatusListener* pListener  );
	virtual ~ChaosTaskBase();

	sal_Bool isSynchronous() const { return m_bExecSync; }
	sal_Bool queryRun() const { return !m_bStarted; }
	com::sun::star::uno::Any run( const rtl::OUString& rName,
								  sal_Int32 nHandle,
								  const com::sun::star::uno::Any& rValue,
                                  sal_Bool bSynchronous )
        throw ( com::sun::star::uno::Exception );
	com::sun::star::uno::Any run( const SfxPoolItem& rItem,
                                  sal_Bool bSynchronous )
        throw ( com::sun::star::uno::Exception );
    void abort() { if ( m_pCancellable ) m_pCancellable->Cancel(); }

    const ContentTaskStatus& getStatus() const { return m_eState; }
	sal_Bool setStatus( const ContentTaskStatus& rNewState );

    com::sun::star::uno::Reference<	com::sun::star::ucb::XCommandEnvironment >
	getEnvironment() const { return m_xEnv; }
	ContentTask* getContentTask() const { return m_pTask; }
	ChaosContent* getOwner() const { return m_pOwner; }
	com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
	getContent() const;
	SfxCancellable* getCancellable() const { return m_pCancellable; }

	void notifyContentEvent( sal_Int32 nAction,
							 const com::sun::star::uno::Reference<
							 	com::sun::star::ucb::XContent >& rContent,
							 const com::sun::star::uno::Reference<
							 	com::sun::star::ucb::XContentIdentifier >& rId );

	// SfxListener
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

}  // namespace chaos

#endif // CHAOS_TASKBASE_HXX

