/*************************************************************************
 *
 *  $RCSfile: thrditem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _THRDITEM_HXX
#define _THRDITEM_HXX

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

namespace chaos {

class CntThreadingInfo;

SvStream& operator>>( SvStream &rStream, CntThreadingInfo &rInfo );
SvStream& operator<<( SvStream &rStream, const CntThreadingInfo &rInfo );

// -----------------------------------------------------------------------

enum CntThreadingType

/**	[Description]

	Describes the way to interpret a single <CntThreadingInfo>.
*/

{
	CNT_THREADING_BY_PROPVALUE,  	// e.g. by subject
	CNT_THREADING_BY_PARENTCHAIN,	// e.g. from references to msg-id
	CNT_THREADING_BY_PARENTPATH,	// e.g. news-groups
	CNT_TREEADING_END
};

// -----------------------------------------------------------------------

class CntThreadingInfo

/**	[Description]

	Contains a single threading criteria normally collected in
	<CntThreadingInfoItem>'s.
*/

{
friend SvStream& operator>>( SvStream &rStream, CntThreadingInfo &rInfo );
friend SvStream& operator<<( SvStream &rStream, const CntThreadingInfo &rInfo );

	USHORT						_nIsEnabledWID;
    USHORT                      _nParentWID;
	USHORT						_nChildWID;
	USHORT						_nTitleWID;
	CntThreadingType			_eType;
	char						_cDelimiter;

public:
								CntThreadingInfo()
								:	_nIsEnabledWID(0),
									_nParentWID(0),
									_nChildWID(0),
									_nTitleWID(0),
									_eType(CNT_TREEADING_END),
									_cDelimiter(0)
								{}
								CntThreadingInfo( CntThreadingType eType,
												  USHORT nIsEnabledWID,
												  USHORT nParentWID,
												  USHORT nChildWID = 0,
												  char cDelimiter = 0,
												  USHORT nTitleWID = 0 )
								:	_nIsEnabledWID(nIsEnabledWID),
									_nParentWID(nParentWID),
									_nChildWID(nChildWID ? nChildWID : nParentWID),
									_nTitleWID(nTitleWID ? nTitleWID : _nChildWID),
									_eType(eType),
									_cDelimiter(cDelimiter)
								{}

	BOOL						operator==( const CntThreadingInfo &rOther ) const;
	BOOL						operator!=( const CntThreadingInfo &rOther ) const
								{ return !operator==(rOther); }

	CntThreadingType			GetType() const { return _eType; }
	USHORT              		GetIsEnabledWID() const { return _nIsEnabledWID; }
	USHORT              		GetParentWID() const { return _nParentWID; }
	USHORT              		GetChildWID() const { return _nChildWID; }
	USHORT              		GetTitleWID() const { return _nTitleWID; }
	char                		GetDelimiter() const { return _cDelimiter; }
};

// -----------------------------------------------------------------------

SV_DECL_OBJARR( CntThreadingInfoArr, CntThreadingInfo, 1, 3 )

// -----------------------------------------------------------------------

class CntThreadingItem: public SfxPoolItem

/**	[Description]

	Collects <CntThreadingInfo>'s to a complete desctiption how to
	thread the contents of a container.
*/

{
	CntThreadingInfoArr			_aInfos;

public:
							 	TYPEINFO();
								CntThreadingItem( USHORT nWhich = 0 );
								CntThreadingItem( USHORT nWhich, SvStream & );
								CntThreadingItem( const CntThreadingItem& );
								~CntThreadingItem();

	virtual int 			 	operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*     	Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	 	Create(SvStream &, USHORT nItemVersion) const;
	virtual SvStream&		 	Store(SvStream &, USHORT nItemVersion ) const;

	USHORT						Count() const { return _aInfos.Count(); }
	const CntThreadingInfo& 	operator[]( USHORT n ) const { return _aInfos[n]; }

	void						Append( const CntThreadingInfo &rInfo )
								{ _aInfos.Insert( rInfo, _aInfos.Count() ); }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

}

#endif

