/*************************************************************************
 *
 *  $RCSfile: xdatacnt.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kso $ $Date: 2001/05/30 09:30:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _XDATACNT_HXX
#define _XDATACNT_HXX

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XDATACONTAINER_HPP_
#include <com/sun/star/ucb/XDataContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_
#include <com/sun/star/container/XNamed.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

class CntUnoDataContainer_Impl;

namespace chaos {

//=========================================================================

#define XDATACONTAINER_SERVICE_NAME	"com.sun.star.ucb.DataContainer"

//=========================================================================

class CntUnoDataContainer :
				public cppu::OWeakObject,
				public com::sun::star::lang::XServiceInfo,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::ucb::XDataContainer,
                public com::sun::star::io::XActiveDataSink,
                public com::sun::star::container::XNamed
{
private:
	CntUnoDataContainer_Impl* m_pImp;

	// forbidden and not implemented.
	CntUnoDataContainer( const CntUnoDataContainer& );
	// forbidden and not implemented.
    CntUnoDataContainer& operator=( const CntUnoDataContainer& );

public:
	CntUnoDataContainer(
		const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rXSMgr );
	virtual ~CntUnoDataContainer();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

    // XServiceInfo
	XSERVICEINFO_DECL()

	// XDataContainer methods.
	virtual rtl::OUString SAL_CALL
	getContentType()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	setContentType( const rtl::OUString& aType )
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL
	getData()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	setData( const com::sun::star::uno::Sequence< sal_Int8 >& aData )
		throw( com::sun::star::uno::RuntimeException );
    virtual rtl::OUString SAL_CALL
	getDataURL() throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	setDataURL( const rtl::OUString& aURL )
		throw( com::sun::star::uno::RuntimeException );

	// XIndexContainer methods. ( XDataContainer is derived from it. )
    virtual void SAL_CALL
	insertByIndex( sal_Int32 Index, const com::sun::star::uno::Any& Element )
		throw( com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::lang::IndexOutOfBoundsException,
			   com::sun::star::lang::WrappedTargetException,
			   com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removeByIndex( sal_Int32 Index )
		throw( com::sun::star::lang::IndexOutOfBoundsException,
			   com::sun::star::lang::WrappedTargetException,
			   com::sun::star::uno::RuntimeException );

	// XIndexReplace methods. ( XIndexContainer is derived from it. )
	virtual void SAL_CALL
	replaceByIndex( sal_Int32 Index, const com::sun::star::uno::Any& Element )
		throw( com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::lang::IndexOutOfBoundsException,
			   com::sun::star::lang::WrappedTargetException,
			   com::sun::star::uno::RuntimeException );

	// XIndexAccess methods. ( XIndexReplace is derived from it. )
    virtual sal_Int32 SAL_CALL
	getCount()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::uno::Any SAL_CALL
	getByIndex( sal_Int32 Index )
		throw( com::sun::star::lang::IndexOutOfBoundsException,
			   com::sun::star::lang::WrappedTargetException,
			   com::sun::star::uno::RuntimeException );

	// XElementAccess methods. ( XIndexAccess is derived from it. )
    virtual com::sun::star::uno::Type SAL_CALL
	getElementType()
		throw( com::sun::star::uno::RuntimeException );
    virtual sal_Bool SAL_CALL hasElements()
		throw( com::sun::star::uno::RuntimeException );

	// XActiveDataSink
    virtual void SAL_CALL
	setInputStream( const com::sun::star::uno::Reference<
						com::sun::star::io::XInputStream >& aStream )
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::uno::Reference<
		com::sun::star::io::XInputStream > SAL_CALL
	getInputStream()
		throw( com::sun::star::uno::RuntimeException );

    // XNamed
    virtual rtl::OUString SAL_CALL
    getName()
        throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
    setName( const rtl::OUString& aName )
        throw( com::sun::star::uno::RuntimeException );
};

}

#endif /* !_XDATACNT_HXX */
