/*************************************************************************
 *
 *  $RCSfile: cntvwitm.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _TOOLS_COLOR_HXX
#include <tools/color.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _ADRPARSE_HXX //autogen
#include <svtools/adrparse.hxx>
#endif

#include <cntvwitm.hxx>

#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif

using namespace chaos;

#define GLOBALOVERFLOW

#define MSGITEM_COUNT 5
#define FLDITEM_COUNT 3

#define ITEMID_CNT_MSG_VIEWMODE 	0
#define ITEMID_CNT_FOLDER_VIEWMODE 	0
#define ITEMID_CNT_VIEW_DESCRIPTION 0
#define ITEMID_CNT_OPEN_MODE 		0

TYPEINIT1_AUTOFACTORY(CntMsgViewModeItem, CntEnumItem);
TYPEINIT1_AUTOFACTORY(CntSentMsgViewModeItem, CntEnumItem);
TYPEINIT1_AUTOFACTORY(CntFolderViewModeItem, CntEnumItem);
TYPEINIT1_AUTOFACTORY(CntViewDescriptionItem, SfxPoolItem);
TYPEINIT1_AUTOFACTORY(CntNameItem, CntUnencodedStringItem);
TYPEINIT1_AUTOFACTORY(CntPriorityItem, CntEnumItem);
TYPEINIT1_AUTOFACTORY(CntValueAddedModeItem, CntEnumItem);

// -------------------------------------------------------------------------

CntMsgViewModeItem::CntMsgViewModeItem( USHORT nWhich, CntMsgViewMode eMode)
	: CntEnumItem( nWhich, eMode )
{
}

SfxPoolItem* CntMsgViewModeItem::Clone( SfxItemPool* ) const
{
	return new CntMsgViewModeItem( *this );
}

SfxPoolItem* CntMsgViewModeItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntMsgViewModeItem( Which(), (CntMsgViewMode)eStyle );
}

SvStream& CntMsgViewModeItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

SfxItemPresentation CntMsgViewModeItem::GetPresentation( SfxItemPresentation,
							SfxMapUnit,
							SfxMapUnit,
							XubString &rText,
                            const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

String CntMsgViewModeItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos < MSGITEM_COUNT, "enum overflow!" );
	return String( CntResId( RID_CNTMSGVIEWMODE_START + nPos ) );
}

USHORT CntMsgViewModeItem::GetValueCount() const
{
	return MSGITEM_COUNT;
}

// virtual
BOOL CntMsgViewModeItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		   BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntMsgViewModeItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntMsgViewModeItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	 BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

// --------------------------------------------------------------------------

CntFolderViewModeItem::CntFolderViewModeItem( USHORT nWhich, CntFolderViewMode eMode)
	: CntEnumItem( nWhich, eMode )
{
}

SfxPoolItem* CntFolderViewModeItem::Clone( SfxItemPool* ) const
{
	return new CntFolderViewModeItem( *this );
}

SfxPoolItem* CntFolderViewModeItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntFolderViewModeItem( Which(), (CntFolderViewMode)eStyle );
}

SvStream& CntFolderViewModeItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

SfxItemPresentation CntFolderViewModeItem::GetPresentation( SfxItemPresentation,
	SfxMapUnit,
	SfxMapUnit,
	XubString &rText,
    const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

String CntFolderViewModeItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos < FLDITEM_COUNT, "enum overflow!" );
	return String( CntResId( RID_CNTFLDVIEWMODE_START + nPos ) );
}

USHORT CntFolderViewModeItem::GetValueCount() const
{
	return FLDITEM_COUNT;
}

// virtual
BOOL CntFolderViewModeItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		   	  BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntFolderViewModeItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntFolderViewModeItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	 	BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

// --------------------------------------------------------------------------

CntViewDescriptionItem::CntViewDescriptionItem(
	USHORT nWhich,
	const String& rIconLocation )
	:   SfxPoolItem( nWhich ),
		_aIsLocator(TRUE),
		_aInterface(FALSE),
		_aUseType( FALSE ),
		_aIconLocator( rIconLocation )
{}

CntViewDescriptionItem::CntViewDescriptionItem( const CntViewDescriptionItem& rItm)
	: SfxPoolItem( rItm ),
	  _aIsLocator( rItm._aIsLocator ),
	  _aInterface( rItm._aInterface ),
	  _aUseType( rItm._aUseType ),
	  _aIconLocator( rItm._aIconLocator )
{}

SfxPoolItem* CntViewDescriptionItem::Clone( SfxItemPool* pPool ) const
{
	return new CntViewDescriptionItem( *this );
}

CntViewDescriptionItem& CntViewDescriptionItem::operator=(const CntViewDescriptionItem& rItem)
{
	_aIsLocator = rItem._aIsLocator;
	_aInterface = rItem._aInterface;
	_aUseType = rItem._aUseType;
	_aIconLocator = rItem._aIconLocator;

	return *this;
}

int CntViewDescriptionItem::operator==( const SfxPoolItem& rItem ) const
{
	const CntViewDescriptionItem& rItm = (const CntViewDescriptionItem&)rItem;

	if ( ( _aIsLocator == rItm._aIsLocator ) &&
		 ( _aInterface == rItm._aInterface ) &&
		 ( _aUseType == rItm._aUseType ) &&
		 ( _aIconLocator == rItm._aIconLocator ) )
	{
		return TRUE;
	}

	return FALSE;
}

CntViewDescriptionItem::CntViewDescriptionItem()
{
	_aIsLocator = FALSE;
	_aInterface = FALSE;
	_aUseType = FALSE;
}

// virtual
USHORT CntViewDescriptionItem::GetVersion(USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

SfxPoolItem* CntViewDescriptionItem::Create( SvStream& rStream,
											 USHORT nVersion ) const
{
	BOOL bIsLocator = FALSE;
	BOOL bInterface = FALSE;
	BOOL bUseType = FALSE;

	rStream >> bIsLocator;
	rStream >> bInterface;
	rStream >> bUseType;

	if ( bIsLocator )
	{
		String aLocation;
		readUnicodeString(rStream, aLocation, nVersion >= 1);
		return new CntViewDescriptionItem( Which(), aLocation );
	}

	return new CntViewDescriptionItem( Which(), bInterface, bUseType );
}

SvStream& CntViewDescriptionItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (BOOL) _aIsLocator;
	rStream << (BOOL) _aInterface;
	rStream << (BOOL) _aUseType;

	if ( _aIsLocator )
		writeUnicodeString(rStream, _aIconLocator);

	return rStream;
}


//============================================================================
//
//  class CntOpenModeItem
//
//============================================================================

//============================================================================
TYPEINIT1_AUTOFACTORY(CntOpenModeItem, CntWIDSetItem);

//============================================================================
// virtual
BOOL CntOpenModeItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  BYTE nMemberId ) const
{
	sal_Int16 nValue = GetValue();
	rVal <<= nValue;
	return TRUE;
}

//============================================================================
// virtual
BOOL CntOpenModeItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		SetValue( CntOpenMode( nValue ) );
		return TRUE;
	}

	DBG_ERROR( "CntOpenModeItem::PutValue - Wrong type!" );
	return FALSE;
}

//============================================================================
// virtual
SfxPoolItem * CntOpenModeItem::Create(SvStream & rStream, USHORT nItemVersion)
	const
{
	CntWIDSetItem * pWIDSetItem
	 = SAL_STATIC_CAST(CntWIDSetItem *,
					   CntWIDSetItem::Create(rStream, nItemVersion));
	USHORT eTheMode = CNT_OPEN_ALL;
	rStream >> eTheMode;
	if (eTheMode >= CNT_OPEN_MODE_COUNT)
		eTheMode = CNT_OPEN_ALL;
	CntOpenModeItem * pOpenModeItem
	 = new CntOpenModeItem(*pWIDSetItem, CntOpenMode(eTheMode));
	delete pWIDSetItem;
	return pOpenModeItem;
}

//============================================================================
// virtual
SvStream & CntOpenModeItem::Store(SvStream& rStream, USHORT nItemVersion)
	const
{
	CntWIDSetItem::Store(rStream, nItemVersion);
	rStream << USHORT(m_eMode);
	return rStream;
}

//============================================================================
// virtual
SfxPoolItem * CntOpenModeItem::Clone(SfxItemPool *) const
{
	return new CntOpenModeItem(*this);
}

// -------------------------------------------------------------------------

CntSentMsgViewModeItem::CntSentMsgViewModeItem( USHORT nWhich, CntSentMsgViewMode eMode)
	: CntEnumItem( nWhich, eMode )
{
}

SfxPoolItem* CntSentMsgViewModeItem::Clone( SfxItemPool* ) const
{
	return new CntSentMsgViewModeItem( *this );
}

SfxPoolItem* CntSentMsgViewModeItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntSentMsgViewModeItem( Which(), (CntSentMsgViewMode)eStyle );
}

SvStream& CntSentMsgViewModeItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

SfxItemPresentation CntSentMsgViewModeItem::GetPresentation( SfxItemPresentation,
							SfxMapUnit,
							SfxMapUnit,
							XubString &rText,
                            const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

String CntSentMsgViewModeItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos < CNT_SENT_VIEW_END, "enum overflow!" );
	return String( CntResId( RID_CNTSENTMSGVIEWMODE_START + nPos ) );
}

USHORT CntSentMsgViewModeItem::GetValueCount() const
{
	return CNT_SENT_VIEW_END;
}

// virtual
BOOL CntSentMsgViewModeItem::PutValue( const com::sun::star::uno::Any& rVal,
						   			   BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntSentMsgViewModeItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntSentMsgViewModeItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  		 BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

// -------------------------------------------------------------------------

SfxPoolItem* CntNameItem::Clone( SfxItemPool* pPool ) const
{
	return new CntNameItem( *this );
}

int CntNameItem::operator==( const SfxPoolItem& rItm ) const
{
	return CntUnencodedStringItem::operator==( rItm );
}

int CntNameItem::Compare( const SfxPoolItem& rItm ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rItm ), "unequal type" );

	switch ( GetRealName().CompareIgnoreCaseToAscii( ((const CntNameItem&)rItm).GetRealName() ) )
	{
		case COMPARE_EQUAL   : return  0;
		case COMPARE_LESS    : return -1;
		case COMPARE_GREATER : return  1;
	}
	return 0;
}

const String& CntNameItem::GetRealName() const
{
	if ( !aRealName.Len() )
	{
		const String& rValue = CntUnencodedStringItem::GetValue();
		if ( rValue.Len() )
		{
			SvAddressParser aParser( rValue );
			CntNameItem* pVarThis = CONST_CAST( CntNameItem*, this );
			if( aParser.Count() )
				pVarThis->aRealName = aParser.GetRealName( 0 );
			else
				pVarThis->aRealName = rValue;
		}
	}
	return aRealName;
}

SfxItemPresentation CntNameItem::GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * ) const
{
	rText = GetRealName();
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

// virtual
USHORT CntNameItem::GetVersion(USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

// virtual
SfxPoolItem * CntNameItem::Create(SvStream & rStream, USHORT nVersion) const
{
	String aName;
	readUnicodeString(rStream, aName, nVersion >= 1);
	return new CntNameItem(Which(), aName);
}

// virtual
SvStream& CntNameItem::Store(SvStream & rStream, USHORT) const
{
	writeUnicodeString(rStream, GetValue());
	return rStream;
}

// -------------------------------------------------------------------------

CntPriorityItem::CntPriorityItem( USHORT nWhich, CntPriority eMode )
	: CntEnumItem( nWhich, eMode )
{
}

CntPriorityItem::CntPriorityItem( USHORT nWhich, const String& rValue )
	: CntEnumItem( nWhich, CNT_PRIO_NORMAL )
{
	// Parse Value to get Enum
	USHORT nValue = rValue.ToInt32();
	if ( ( nValue > 0 ) && ( nValue <= CNT_PRIO_LOWEST ) )
		SetEnumValue( nValue );
}

SfxPoolItem* CntPriorityItem::Clone( SfxItemPool* ) const
{
	return new CntPriorityItem( *this );
}

SfxPoolItem* CntPriorityItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntPriorityItem( Which(), (CntPriority)eStyle );
}

SvStream& CntPriorityItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

String CntPriorityItem::GetValueText() const
{
	String aValue;

	GetPresentation( SFX_ITEM_PRESENTATION_COMPLETE,
					 SFX_MAPUNIT_APPFONT, SFX_MAPUNIT_APPFONT,
					 aValue );
	return aValue;
}

SfxItemPresentation CntPriorityItem::GetPresentation( SfxItemPresentation,
							SfxMapUnit,
							SfxMapUnit,
							XubString &rText,
                            const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_NAMELESS;
}

String CntPriorityItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos > 0, "enum underflow!" );
	DBG_ASSERT( nPos <= CNT_PRIO_LOWEST, "enum overflow!" );

	if ( ( nPos == 0 ) || ( nPos > CNT_PRIO_LOWEST ) )
		nPos = CNT_PRIO_NORMAL;

	return String( CntResId( RID_CNT_PRIORITY_START + nPos - 1) );
}

USHORT CntPriorityItem::GetValueCount() const
{
	return CNT_PRIO_LOWEST - 1;
}

int CntPriorityItem::Compare( const SfxPoolItem& rWith ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rWith ), "unequal type" );

	// da X.Compare( Y ) am String einem Compare( Y, X ) entspricht,
	// vergleichen wir hier Y mit X
	if( ((const CntPriorityItem&)rWith).GetValue() == GetValue() )
		return 0;
	if( ((const CntPriorityItem&)rWith).GetValue() < GetValue() )
		return -1;
	return 1;
}

// virtual
BOOL CntPriorityItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntPriorityItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntPriorityItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

// --------------------------------------------------------------------------

CntValueAddedModeItem::CntValueAddedModeItem(
									USHORT nWhich, CntValueAddedMode eMode)
: CntEnumItem( nWhich, eMode )
{
}

SfxPoolItem* CntValueAddedModeItem::Clone( SfxItemPool* ) const
{
	return new CntValueAddedModeItem( *this );
}

SfxPoolItem* CntValueAddedModeItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntValueAddedModeItem( Which(), (CntValueAddedMode)eStyle );
}

SvStream& CntValueAddedModeItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

SfxItemPresentation CntValueAddedModeItem::GetPresentation( SfxItemPresentation,
	SfxMapUnit,
	SfxMapUnit,
	XubString &rText,
    const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

String CntValueAddedModeItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos < VALUE_ADDED_MODE_COUNT, "enum overflow!" );
	return String( CntResId( RID_CNTVALUEADDEDMODE_START + nPos ) );
}

USHORT CntValueAddedModeItem::GetValueCount() const
{
	return VALUE_ADDED_MODE_COUNT;
}

// virtual
BOOL CntValueAddedModeItem::PutValue( const com::sun::star::uno::Any& rVal,
						   			  BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntValueAddedModeItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntValueAddedModeItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  		BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

//============================================================================
//
//  CntUpdateItem
//
//============================================================================

TYPEINIT1(CntUpdateItem, SfxVoidItem);

//============================================================================
// virtual
SfxPoolItem * CntUpdateItem::Clone(SfxItemPool *) const
{
	return new CntUpdateItem(*this);
}

