/*************************************************************************
 *
 *  $RCSfile: dsizitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#include "dsizitem.hxx"

using namespace chaos;

// class CntDocItemsSizeItem ---------------------------------------------

TYPEINIT1_AUTOFACTORY(CntDocItemsSizeItem, SfxPoolItem);

// -----------------------------------------------------------------------

int CntDocItemsSizeItem::operator==( const SfxPoolItem& rItem ) const
{
	DBG_ASSERT( SfxPoolItem::operator==(rItem), "unequal types" );
	const CntDocItemsSizeItem& rSizItem = (const CntDocItemsSizeItem&)rItem;

    return ( ( rSizItem.GetFolderSize() == mnFolderSize ) &&
			 ( rSizItem.GetHeaderSize() == mnHeaderSize ) &&
			 ( rSizItem.GetPartSize() == mnPartSize ) &&
			 ( rSizItem.GetBodySize() == mnBodySize ) );
}

// -----------------------------------------------------------------------

SfxPoolItem* CntDocItemsSizeItem::Clone( SfxItemPool* ) const
{
	return new CntDocItemsSizeItem( *this );
}

// -----------------------------------------------------------------------

SfxPoolItem* CntDocItemsSizeItem::Create( SvStream& rStrm, USHORT ) const
{
	ULONG nFSiz, nHSiz, nPSiz, nBSiz;
	rStrm >> nFSiz >> nHSiz >> nPSiz >> nBSiz;

	CntDocItemsSizeItem* pItem = new CntDocItemsSizeItem( Which() );
	pItem->SetFolderSize( nFSiz );
	pItem->SetHeaderSize( nHSiz );
	pItem->SetPartSize( nPSiz );
	pItem->SetBodySize( nBSiz );

	return pItem;
}

// -----------------------------------------------------------------------

SvStream& CntDocItemsSizeItem::Store( SvStream& rStrm, USHORT ) const
{
	rStrm << mnFolderSize;
	rStrm << mnHeaderSize;
	rStrm << mnPartSize;
	rStrm << mnBodySize;
	return rStrm;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntDocItemsSizeItem::PutValue( const com::sun::star::uno::Any& rVal,
						   			BYTE nMemberId )
{
	com::sun::star::uno::Sequence< sal_Int32 > aValue;
	if ( rVal >>= aValue )
	{
		if ( aValue.getLength() >= 4 )
		{
			const sal_Int32* pValues = aValue.getConstArray();

			mnFolderSize = pValues[ 0 ];
			mnHeaderSize = pValues[ 1 ];
			mnPartSize	 = pValues[ 2 ];
			mnBodySize	 = pValues[ 3 ];
			return TRUE;
		}
	}

	DBG_ERROR( "CntDocItemsSizeItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntDocItemsSizeItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	  BYTE nMemberId ) const
{
	com::sun::star::uno::Sequence< sal_Int32 > aValue( 4 );
	sal_Int32* pValues = aValue.getArray();

	pValues[ 0 ] = mnFolderSize;
	pValues[ 1 ] = mnHeaderSize;
	pValues[ 2 ] = mnPartSize;
	pValues[ 3 ] = mnBodySize;

	rVal <<= aValue;
	return TRUE;
}


