/*************************************************************************
 *
 *  $RCSfile: ulstitem.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _ULSTITEM_CXX "$Revision: 1.3 $"

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif

#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif

#ifndef _STDARG_H
#include <stdarg.h>
#endif

using namespace chaos;

//-------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntUShortListItem, SfxPoolItem);

//=========================================================================

CntUShortListItem::CntUShortListItem( USHORT nWhich )
:	SfxPoolItem(nWhich)
{
}

//-------------------------------------------------------------------------

CntUShortListItem::CntUShortListItem (
	USHORT nWhich, USHORT_ARG nUShort1, ...)
	: SfxPoolItem (nWhich)
{
	va_list pArgs;
	va_start (pArgs, nUShort1);

	USHORT nIns = nUShort1;
	while (nIns)
	{
		Append (nIns);
		nIns = va_arg (pArgs, USHORT_ARG);
	}
}

//-------------------------------------------------------------------------

CntUShortListItem::CntUShortListItem( USHORT nWhich, SvStream &rStream )
	: SfxPoolItem( nWhich )
{
	USHORT nCount = 0;
	rStream >> nCount;
	for ( USHORT n = 0; n < nCount; ++n )
	{
		USHORT nUShort;
		rStream >> nUShort;
		Append( nUShort );
	}
}

//-------------------------------------------------------------------------

CntUShortListItem::CntUShortListItem( const CntUShortListItem &rOrig )
	: SfxPoolItem( rOrig )
{
	for ( USHORT n = 0; n < rOrig.Count(); ++n )
		Append( rOrig[n] );
}

//-------------------------------------------------------------------------

CntUShortListItem::~CntUShortListItem()
{
}

//-------------------------------------------------------------------------

int CntUShortListItem::operator==( const SfxPoolItem &rItem ) const
{
	const CntUShortListItem& rOther = (const CntUShortListItem&) rItem;
	if ( Count() != rOther.Count() )
		return FALSE;

	for ( USHORT n = 0; n < Count(); ++n )
		if ( operator[](n) != rOther[n] )
			return FALSE;

	return TRUE;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntUShortListItem::Create (
	SvStream &rStream, USHORT nItemVersion) const
{
	return new CntUShortListItem( Which(), rStream );
}

//-------------------------------------------------------------------------

SvStream& CntUShortListItem::Store (
	SvStream &rStream, USHORT nItemVersion) const
{
	rStream << Count();
	for ( USHORT n = 0; n < Count(); ++n )
		rStream << _aUShorts[ n ];
	return rStream;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntUShortListItem::Clone( SfxItemPool *pPool ) const
{
	return new CntUShortListItem( *this );
}

//-------------------------------------------------------------------------

BOOL CntUShortListItem::Contains( USHORT n ) const
{
	USHORT nCount = _aUShorts.Count();
	for( USHORT nCur = 0; nCur < nCount; nCur++ )
	{
		if( _aUShorts[nCur] == n )
			return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntUShortListItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		  BYTE nMemberId )
{
	com::sun::star::uno::Sequence< rtl::OUString > aValue;
	if ( rVal >>= aValue )
	{
		const CntItemMap* pItemMap = CntItemPool::GetItemMap();
		if ( !pItemMap )
			return FALSE;

		// Destroy old array.
		while ( _aUShorts.Count() )
			_aUShorts.Remove( 0 );

		const rtl::OUString* pValues = aValue.getConstArray();

		// Assemble new array.
		sal_uInt32 nCount = aValue.getLength();
		for ( sal_uInt32 n = 0; n < nCount; ++n )
		{
			const rtl::OUString& rCurr = pValues[ n ];
			const CntItemMapEntry* pEntry =	pItemMap->Prop2Which( rCurr );
			if ( pEntry )
				Append( pEntry->nWhich );
		}

		return TRUE;
	}

	DBG_ERROR( "CntUShortListItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntUShortListItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	    BYTE nMemberId ) const
{
	sal_uInt32 nCount = _aUShorts.Count();

	const CntItemMap* pItemMap = CntItemPool::GetItemMap();
	if ( !pItemMap && nCount )
		return FALSE;

	com::sun::star::uno::Sequence< rtl::OUString > aProps( nCount );
	rtl::OUString* pProps = aProps.getArray();
	sal_uInt32 nArrPos = 0;

	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const CntItemMapEntry* pEntry =	pItemMap->Which2Prop( _aUShorts[ n ] );
		if ( pEntry )
		{
			pProps[ nArrPos ] = rtl::OUString::createFromAscii(pEntry->pName);

			++nArrPos;
		}
	}

	aProps.realloc( nArrPos );

	rVal <<= aProps;
	return TRUE;
}

//=========================================================================
//
// CntViewColumnsListItem implementation
//
//=========================================================================

TYPEINIT1_AUTOFACTORY( CntViewColumnsListItem, CntUShortListItem );

//----------------------------------------------------------------------------

CntViewColumnsListItem::CntViewColumnsListItem (
	USHORT nWhich, USHORT_ARG nUShort1, ...)
	: CntUShortListItem (nWhich)
{
	va_list pArgs;
	va_start (pArgs, nUShort1);

	USHORT nIns = nUShort1;
	while (nIns)
	{
		Append (nIns);
		nIns = va_arg (pArgs, USHORT_ARG);
	}
}

//----------------------------------------------------------------------------
// virtual
CntViewColumnsListItem::~CntViewColumnsListItem()
{
}

//-------------------------------------------------------------------------
// virtual
SfxPoolItem* CntViewColumnsListItem::Create (
							SvStream &rStream, USHORT nItemVersion) const
{
	return new CntViewColumnsListItem( Which(), rStream );
}

//----------------------------------------------------------------------------
// virtual
SfxPoolItem* CntViewColumnsListItem::Clone( SfxItemPool* pPool ) const
{
	return new CntViewColumnsListItem( *this );
}

//----------------------------------------------------------------------------
// virtual
BOOL CntViewColumnsListItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		       BYTE nMemberId )
{
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntViewColumnsListItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	         BYTE nMemberId ) const
{
	return FALSE;
}

//=========================================================================
//
// CntIdentifierListItem implementation
//
//=========================================================================

TYPEINIT1_AUTOFACTORY( CntIdentifierListItem, CntUShortListItem );

//----------------------------------------------------------------------------

CntIdentifierListItem::CntIdentifierListItem(
								USHORT nWhich, USHORT_ARG nUShort1, ... )
: CntUShortListItem( nWhich )
{
	va_list pArgs;
	va_start( pArgs, nUShort1 );

	USHORT nIns = nUShort1;
	while( nIns )
	{
		Append( nIns );
		nIns = va_arg( pArgs, USHORT_ARG );
	}
}

//----------------------------------------------------------------------------
// virtual
CntIdentifierListItem::~CntIdentifierListItem()
{
}

//-------------------------------------------------------------------------
// virtual
SfxPoolItem* CntIdentifierListItem::Create(
							SvStream &rStream, USHORT nItemVersion ) const
{
	return new CntIdentifierListItem( Which(), rStream );
}

//----------------------------------------------------------------------------
// virtual
SfxPoolItem* CntIdentifierListItem::Clone( SfxItemPool* pPool ) const
{
	return new CntIdentifierListItem( *this );
}

//----------------------------------------------------------------------------
// virtual
BOOL CntIdentifierListItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		  	  BYTE nMemberId )
{
	com::sun::star::uno::Sequence< sal_Int16 > aValue;
	if ( rVal >>= aValue )
	{
		const CntItemMap* pItemMap = CntItemPool::GetItemMap();
		if ( !pItemMap )
			return FALSE;

		// Destroy old array.
		while ( Count() )
			Remove( 0 );

		const sal_Int16* pValues = aValue.getConstArray();

		// Assemble new array.
		sal_uInt32 nCount = aValue.getLength();
		for ( sal_uInt32 n = 0; n < nCount; ++n )
			Append( pValues[ n ] );

		return TRUE;
	}

	DBG_ERROR( "CntIdentifierListItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntIdentifierListItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	    	BYTE nMemberId ) const
{
	sal_uInt32 nCount = Count();
	com::sun::star::uno::Sequence< sal_Int16 > aSeq( nCount );
	sal_Int16* pArray = aSeq.getArray();

	for ( sal_uInt32 n = 0; n < nCount; ++n )
		pArray[ n ] = operator[]( n );

	rVal <<= aSeq;
	return TRUE;
}

