/*************************************************************************
 *
 *  $RCSfile: widsitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _CNTWIDS_HRC //autogen
#include <svtools/cntwids.hrc>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif
#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif
#ifndef _CHAOS_WIDSITEM_HXX
#include <widsitem.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntWIDSetItem
//
//============================================================================

#if defined DBG_UTIL
BOOL CntWIDSetItem::checkRanges() const
{
	if (m_xRanges.Is())
	{
		if (m_xRanges->Count() % 2)
			return FALSE;
		for (USHORT i = 0; i < m_xRanges->Count(); i += 2)
			if (USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)))
				 < WID_CHAOS_START
				|| USHORT(REINTERPRET_CAST(ULONG,
										   m_xRanges->GetObject(i + 1)))
				    > WID_CHAOS_END
				|| USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)))
				    > USHORT(REINTERPRET_CAST(ULONG,
											  m_xRanges->GetObject(i + 1)))
				|| i
				   && USHORT(REINTERPRET_CAST(ULONG,
											  m_xRanges->GetObject(i - 1)))
				       >= USHORT(REINTERPRET_CAST(ULONG,
												  m_xRanges->GetObject(i)))
				           - 1)
				return FALSE;
	}
	return TRUE;
}
#endif // DBG_UTIL

//============================================================================
void CntWIDSetItem::addRange_Impl(USHORT nLowerBound, USHORT nUpperBound)
{
	ULONG i = 0;
	for (;; i += 2)
		if (i >= m_xRanges->Count())
		{
			m_xRanges->Insert(REINTERPRET_CAST(void *, nLowerBound),
							  LIST_APPEND);
			m_xRanges->Insert(REINTERPRET_CAST(void *, nUpperBound),
							  LIST_APPEND);
			return;
		}
		else if (nLowerBound
				  < USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)))
				     - 1)
		{
			if (nUpperBound
				 < USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)))
				    - 1)
			{
				m_xRanges->Insert(REINTERPRET_CAST(void *, nLowerBound), i);
				m_xRanges->Insert(REINTERPRET_CAST(void *, nUpperBound),
								  i + 1);
				return;
			}
			else
			{
				m_xRanges->Replace(REINTERPRET_CAST(void *, nLowerBound), i);
				break;
			}
		}
		else if (nLowerBound
				  <= USHORT(REINTERPRET_CAST(ULONG,
											 m_xRanges->GetObject(i + 1)))
				      + 1)
		{
			if (nLowerBound
				 < USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i))))
				m_xRanges->Replace(REINTERPRET_CAST(void *, nLowerBound), i);
			break;
		}
	for (;;)
	{
		if (nUpperBound
			 <= USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i + 1))))
			break;
		else if (i + 2 >= m_xRanges->Count()
				 || nUpperBound
				     < USHORT(REINTERPRET_CAST(ULONG,
											   m_xRanges->GetObject(i + 2)))
				        - 1)
		{
			m_xRanges->Replace(REINTERPRET_CAST(void *, nUpperBound), i + 1);
			break;
		}
		m_xRanges->Remove(i + 1);
		m_xRanges->Remove(i + 1);
	}
}

//============================================================================
TYPEINIT1_AUTOFACTORY(CntWIDSetItem, SfxPoolItem);

//============================================================================
CntWIDSetItem::CntWIDSetItem(USHORT nWhich, const USHORT * pRanges):
	SfxPoolItem(nWhich),
	m_xRanges(new CntWIDRangesList)
{
	if (pRanges)
		while (*pRanges)
			m_xRanges->Insert(REINTERPRET_CAST(void *, *pRanges++),
							  LIST_APPEND);
	DBG_ASSERT(checkRanges(),
			   "CntWIDSetItem constructed with illegal ranges");
}

//============================================================================
// virtual
int CntWIDSetItem::operator ==(const SfxPoolItem & rItem) const
{
	const CntWIDSetItem * pWIDSetItem = PTR_CAST(CntWIDSetItem, &rItem);
	if (!pWIDSetItem)
		return FALSE;
	if (&m_xRanges == &pWIDSetItem->m_xRanges)
		return TRUE;
	if (&m_xRanges)
		if (&pWIDSetItem->m_xRanges)
		{
			if (m_xRanges->Count() != pWIDSetItem->m_xRanges->Count())
				return FALSE;
			for (ULONG i = 0; i < m_xRanges->Count(); ++i)
				if (USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)))
					 != USHORT(REINTERPRET_CAST(ULONG,
												pWIDSetItem->
												 m_xRanges->GetObject(i))))
					return FALSE;
			return TRUE;
		}
		else
			return m_xRanges->Count() == 2
			       && USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(0)))
			           == WID_CHAOS_START
			       && USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(1)))
			           == WID_CHAOS_END;
	else
		return pWIDSetItem->m_xRanges->Count() == 2
		       && USHORT(REINTERPRET_CAST(ULONG,
										  pWIDSetItem->
										   m_xRanges->GetObject(0)))
		           == WID_CHAOS_START
		       && USHORT(REINTERPRET_CAST(ULONG,
										  pWIDSetItem->
										   m_xRanges->GetObject(1)))
		           == WID_CHAOS_END;
}

//============================================================================
// virtual
SfxPoolItem * CntWIDSetItem::Create(SvStream & rStream, USHORT) const
{
	CntWIDSetItem * pWIDSetItem = new CntWIDSetItem(Which());
	USHORT nCount = 0;
	rStream >> nCount;
	if (nCount)
	{
		BOOL bValid = !(nCount % 2);
		if (bValid)
		{
			CntWIDRangesList * pRanges = new CntWIDRangesList;
			for (USHORT i = 0; i < nCount; i += 2)
			{
				USHORT nLowerBound = 0;
				USHORT nUpperBound = 0;
				rStream >> nLowerBound >> nUpperBound;
				bValid
				 = bValid && nLowerBound >= WID_CHAOS_START
				   && nUpperBound <= WID_CHAOS_END
				   && nLowerBound <= nUpperBound
				   && (!i
					   || USHORT(REINTERPRET_CAST(ULONG,
												  pRanges->GetObject(i - 1)))
					       < nLowerBound - 1);
				if (bValid)
				{
					pRanges->Insert(REINTERPRET_CAST(void *, nLowerBound),
									LIST_APPEND);
					pRanges->Insert(REINTERPRET_CAST(void *, nUpperBound),
									LIST_APPEND);
				}
			}
			if (bValid)
				pWIDSetItem->m_xRanges = pRanges;
			else
				delete pRanges;
		}
	}
	return pWIDSetItem;
}

//============================================================================
// virtual
SvStream & CntWIDSetItem::Store(SvStream & rStream, USHORT) const
{
	if (m_xRanges.Is())
	{
		USHORT nCount = USHORT(m_xRanges->Count());
		rStream << nCount;
		for (USHORT i = 0; i < nCount; ++i)
			rStream
			 << USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)));
	}
	else
		rStream << USHORT(2) << USHORT(WID_CHAOS_START)
				<< USHORT(WID_CHAOS_END);
	return rStream;
}

//============================================================================
// virtual
SfxPoolItem * CntWIDSetItem::Clone(SfxItemPool *) const
{
	return new CntWIDSetItem(*this);
}

//============================================================================
// virtual
BOOL CntWIDSetItem::QueryValue(com::sun::star::uno::Any& rVal, BYTE) const
{
	const CntItemMap * pMap = CntItemPool::GetItemMap();
	if (!pMap)
		return FALSE;
	if (m_xRanges.Is())
	{
		sal_uInt32 nMaxCount = 0;
		{ // wrap i for old compilers...
			for (ULONG i = 0; i < m_xRanges->Count(); i += 2)
				nMaxCount
				 += USHORT(REINTERPRET_CAST(ULONG,
											m_xRanges->GetObject(i + 1)))
				     + 1
				     - USHORT(REINTERPRET_CAST(ULONG,
											   m_xRanges->GetObject(i)));
		}
		com::sun::star::uno::Sequence< rtl::OUString > aValue(nMaxCount);
		rtl::OUString * pPropNames = aValue.getArray();
		sal_uInt32 nRealCount = 0;
		for (ULONG i = 0; i < m_xRanges->Count(); i += 2)
			for (USHORT nWID
				  = USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(i)));
				 nWID
				  <= USHORT(REINTERPRET_CAST(ULONG,
											 m_xRanges->GetObject(i + 1)));
				 ++nWID)
			{
				const CntItemMapEntry * pEntry = pMap->Which2Prop(nWID);
				if (pEntry)
					pPropNames[nRealCount++]
						= rtl::OUString::createFromAscii(pEntry->pName);
			}

		aValue.realloc(nRealCount);
		rVal <<= aValue;
	}
	else
	{
		sal_uInt32 nMaxCount = WID_CHAOS_END + 1 - WID_CHAOS_START;
		com::sun::star::uno::Sequence< rtl::OUString > aValue(nMaxCount);
		rtl::OUString * pPropNames = aValue.getArray();
		sal_uInt32 nRealCount = 0;
		for (USHORT nWID = WID_CHAOS_START; nWID <= WID_CHAOS_END; ++nWID)
		{
			const CntItemMapEntry * pEntry = pMap->Which2Prop(nWID);
			if (pEntry)
				pPropNames[nRealCount++]
					= rtl::OUString::createFromAscii(pEntry->pName);
		}

		aValue.realloc(nRealCount);
		rVal <<= aValue;
	}
	return TRUE;
}

//============================================================================
// virtual
BOOL CntWIDSetItem::PutValue(const com::sun::star::uno::Any& rVal, BYTE)
{
	com::sun::star::uno::Sequence< rtl::OUString > aValue;
	if ( rVal >>= aValue )
	{
		const CntItemMap * pMap = CntItemPool::GetItemMap();
		if (!pMap)
			return FALSE;

		const rtl::OUString* pValues = aValue.getConstArray();

		m_xRanges = new CntWIDRangesList;
		for (sal_uInt32 i = 0; i < aValue.getLength(); ++i)
		{
			const CntItemMapEntry * pEntry = pMap->Prop2Which(pValues[i]);
			if (pEntry)
				addElement(pEntry->nWhich);
		}

		return TRUE;
	}

	DBG_ERROR( "CntWIDSetItem::PutValue - Wrong type!" );
	return FALSE;
}

//============================================================================
void CntWIDSetItem::addRanges(const USHORT * pRanges)
{
	if (pRanges && m_xRanges.Is())
	{
		modifyRanges();
		for (; *pRanges; pRanges += 2)
			addRange_Impl(pRanges[0], pRanges[1]);
	}
}

//============================================================================
void CntWIDSetItem::addElements(const USHORT * pElements)
{
	if (pElements && m_xRanges.Is())
	{
		modifyRanges();
		for (; *pElements; ++pElements)
			addRange_Impl(*pElements, *pElements);
	}
}

//============================================================================
void CntWIDSetItem::addElements(ULONG nCount, const USHORT * pElements)
{
	if (m_xRanges.Is())
	{
		modifyRanges();
		for (; nCount--; ++pElements)
			addRange_Impl(*pElements, *pElements);
	}
}

//============================================================================
BOOL CntWIDSetItem::isFullRanges() const
{
	return !m_xRanges.Is()
	       || m_xRanges->Count() == 2
	           && USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(0)))
	               <= WID_CHAOS_START
	           && USHORT(REINTERPRET_CAST(ULONG, m_xRanges->GetObject(1)))
	               >= WID_CHAOS_END;
}

//============================================================================
BOOL CntWIDSetItem::contains(USHORT nWID) const
{
	if (m_xRanges.Is())
	{
		ULONG nEnd = m_xRanges->Count();
		if (!nEnd)
			return FALSE;
		ULONG nStart = 0;
		ULONG nMiddle = 2 * (nEnd / 4);
		for (;;)
			if (nWID
				 < USHORT(REINTERPRET_CAST(ULONG,
										   m_xRanges->GetObject(nMiddle))))
				if (nMiddle == nStart)
					return FALSE;
				else
				{
					nEnd = nMiddle;
					nMiddle = nStart + 2 * ((nEnd - nStart) / 4);
				}
			else if (nWID
					  > USHORT(REINTERPRET_CAST(ULONG,
												m_xRanges->GetObject(nMiddle
																	  + 1))))
				if (nMiddle + 2 == nEnd)
					return FALSE;
				else
				{
					nStart = nMiddle;
					nMiddle = nStart + 2 * ((nEnd - nStart) / 4);
				}
			else
				return TRUE;
	}
	else
		return TRUE;
}

//============================================================================
//
//  CntWIDSetItemIterator
//
//============================================================================

CntWIDSetItemIterator::CntWIDSetItemIterator(CntWIDSetItem & rTheItem):
	m_rItem(rTheItem),
	m_nIndex(0),
	m_nWID(rTheItem.m_xRanges.Is() ?
		    rTheItem.m_xRanges->Count() ?
		     USHORT(REINTERPRET_CAST(ULONG,
									 rTheItem.m_xRanges->GetObject(0))) :
		     0 :
		    WID_CHAOS_START)
{}

//============================================================================
USHORT CntWIDSetItemIterator::getNext()
{
	if (m_rItem.m_xRanges.Is())
	{
		if (m_nIndex >= m_rItem.m_xRanges->Count())
			return 0;
		if (m_nWID
			 <= USHORT(REINTERPRET_CAST(ULONG,
										m_rItem.m_xRanges->GetObject(m_nIndex
																	  + 1))))
			return m_nWID++;
		m_nIndex += 2;
		if (m_nIndex >= m_rItem.m_xRanges->Count())
			return 0;
		m_nWID
		 = USHORT(REINTERPRET_CAST(ULONG,
								   m_rItem.m_xRanges->GetObject(m_nIndex)));
		return m_nWID++;
	}
	else if (m_nWID <= WID_CHAOS_END)
		return m_nWID++;
	else
		return 0;
}

