/*************************************************************************
 *
 *  $RCSfile: cnftpfld.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif

#ifndef _CNTNFTP_HXX
#include <cntnftp.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

#ifndef CHAOS_CNFTPFLD_HXX
#include <cnftpfld.hxx>
#endif

using namespace chaos;

SV_IMPL_REF(CntStoreItemSet);

//============================================================================
//
//  CntFTPFolderImp
//
//============================================================================

void CntFTPFolderImp::findChild(String const & rName, bool bDoc,
								ULONG & rIndex, bool & rFound) const
{
	ULONG nStart = 0;
	ULONG nEnd = m_aChildren.Count();
	for (;;)
		if (nStart == nEnd)
		{
			rIndex = nStart;
			rFound = false;
			return;
		}
		else
		{
			ULONG nMid = nStart + (nEnd - nStart) / 2;
			CntFTPFolderChildEntry & rChild = *m_aChildren.GetObject(nMid);
			StringCompare eCompare = rName.CompareTo(rChild.getName());
			if (eCompare == COMPARE_EQUAL)
				if (bDoc < rChild.isDoc())
					eCompare = COMPARE_LESS;
				else if (bDoc > rChild.isDoc())
					eCompare = COMPARE_GREATER;
			switch (eCompare)
			{
				case COMPARE_EQUAL:
					rIndex = nMid;
					rFound = true;
					return;

				case COMPARE_LESS:
					nEnd = nMid;
					break;

				case COMPARE_GREATER:
					nStart = nMid + 1;
					break;
			}
		}
}

//============================================================================
CntFTPFolderImp::~CntFTPFolderImp()
{
	CntFTPFolderChildEntry * pChildEntry;
	while (pChildEntry = m_aChildren.Remove())
		delete pChildEntry;
}

//============================================================================
void CntFTPFolderImp::storeChildren(CntStorageNode & rFolderDirNode)
{
	if (!m_bStored)
	{
		String aFolderDirID(RTL_CONSTASCII_USTRINGPARAM(
			                    CNT_FTP_FOLDER_ENTRY_PREFIX));
		aFolderDirID += CntFTPImp::GetName(&m_rNode);
		CntStoreItemSetRef
			xFolderDirSet(static_cast< CntStorageNode * >(rFolderDirNode.
														      GetParent())->
						      openItemSet(
								  CntFTPImp::GetFolderDirectoryEntryRanges(),
								  aFolderDirID, STREAM_STD_WRITE));
		if (xFolderDirSet.Is())
		{
			SfxPoolItem const * pItem;
			if (m_rNode.GetItemState(WID_TOTALCONTENTCOUNT, true, &pItem)
				    == SFX_ITEM_SET)
			{
				xFolderDirSet->Put(m_rNode.Get(WID_FOLDER_COUNT));
				xFolderDirSet->Put(*pItem);
				xFolderDirSet = 0;
				static_cast< CntStorageNode * >(rFolderDirNode.GetParent())->
					attrib(aFolderDirID, 0,
						   CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST);
			}
			else
			{
				xFolderDirSet->ClearItem(WID_FOLDER_COUNT);
				xFolderDirSet->ClearItem(WID_TOTALCONTENTCOUNT);
				xFolderDirSet = 0;
				static_cast< CntStorageNode * >(rFolderDirNode.GetParent())->
					attrib(aFolderDirID, CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST,
						   0);
			}
		}
		String aFolderURL(OWN_URL(&m_rNode));
		CntFTPFolderChildEntry * pChildEntry;
		while (pChildEntry = m_aChildren.Remove())
		{
			String aChildURL(aFolderURL);
			aChildURL += CntFTPURL::encodeFSegment(pChildEntry->getName());
			if (!pChildEntry->isDoc())
				aChildURL += '/';
			CntNodeRef xChildNode(m_rNode.Query(aChildURL, false));
			if (pChildEntry->isDoc())
			{
				String aDocDirID(RTL_CONSTASCII_USTRINGPARAM(
					                 CNT_FTP_DOC_ENTRY_PREFIX));
				aDocDirID += pChildEntry->getName();
				CntStoreItemSetRef
					xDocDirSet(
						rFolderDirNode.
						    openItemSet(
								CntFTPImp::GetDocDirectoryEntryRanges(),
								aDocDirID, STREAM_STD_WRITE));
				if (xChildNode.Is() && xDocDirSet.Is())
				{
					SfxPoolItem const * pItem;
					if (xChildNode->GetItemState(WID_DATE_CREATED, false,
												 &pItem)
						    == SFX_ITEM_SET)
						xDocDirSet->Put(*pItem);
					else
						xDocDirSet->ClearItem(WID_DATE_CREATED);
					if (xChildNode->GetItemState(WID_DOCUMENT_SIZE, false,
												 &pItem)
						    == SFX_ITEM_SET)
						xDocDirSet->Put(*pItem);
					else
						xDocDirSet->ClearItem(WID_DOCUMENT_SIZE);
				}
			}
			else
			{
				String aSubFolderDirID(RTL_CONSTASCII_USTRINGPARAM(
					                       CNT_FTP_FOLDER_ENTRY_PREFIX));
				aSubFolderDirID += pChildEntry->getName();
				CntStoreItemSetRef
					xSubFolderDirSet(
						rFolderDirNode.
						    openItemSet(
								CntFTPImp::GetDocDirectoryEntryRanges(),
								aSubFolderDirID, STREAM_STD_WRITE));
				if (xChildNode.Is())
				{
					SfxPoolItem const * pItem;
					bool bCompleteList
						= xChildNode->GetItemState(WID_TOTALCONTENTCOUNT,
												   true, &pItem)
						      == SFX_ITEM_SET;
					if (xSubFolderDirSet.Is())
					{
						if (bCompleteList)
							xSubFolderDirSet->Put(*pItem);
						else
							xSubFolderDirSet->
							 ClearItem(WID_TOTALCONTENTCOUNT);
						if (xChildNode->GetItemState(WID_DATE_CREATED, true,
													 &pItem))
							xSubFolderDirSet->Put(*pItem);
						else
							xSubFolderDirSet->ClearItem(WID_DATE_CREATED);
						if (xChildNode->GetItemState(WID_FOLDER_COUNT, true,
													 &pItem))
							xSubFolderDirSet->Put(*pItem);
						else
							xSubFolderDirSet->ClearItem(WID_FOLDER_COUNT);
						xSubFolderDirSet = 0;
					}
					if (bCompleteList)
						rFolderDirNode.
						 attrib(aSubFolderDirID, 0,
								CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST);
					else
						rFolderDirNode.
						 attrib(aSubFolderDirID,
								CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST, 0);
				}
			}
			delete pChildEntry;
		}
		m_bStored = true;
	}
}

//============================================================================
void CntFTPFolderImp::addChild(String const & rName, bool bDoc)
{
	ULONG nIndex;
	bool bFound;
	findChild(rName, bDoc, nIndex, bFound);
	if (!bFound)
		m_aChildren.Insert(new CntFTPFolderChildEntry(rName, bDoc), nIndex);
}

//============================================================================
void CntFTPFolderImp::removeChild(String const & rName, bool bDoc)
{
	ULONG nIndex;
	bool bFound;
	findChild(rName, bDoc, nIndex, bFound);
	if (bFound)
		delete m_aChildren.Remove(nIndex);
}

//============================================================================
void CntFTPFolderImp::renameChild(String const & rOldName,
								  String const & rNewName, bool bDoc)
{
	ULONG nIndex;
	bool bFound;
	findChild(rOldName, bDoc, nIndex, bFound);
	if (bFound)
		m_aChildren.GetObject(nIndex)->setName(rNewName);
}

//============================================================================
bool CntFTPFolderImp::hasChild(String const & rName, bool bDoc) const
{
	ULONG nIndex;
	bool bFound;
	findChild(rName, bDoc, nIndex, bFound);
	return bFound;
}

//============================================================================
//
//  CntFTPOpenFolderTask
//
//============================================================================

void CntFTPOpenFolderTask::removeDocFromCache()
{
	m_xChildNode->ClearItem(WID_DOCUMENT_BODY);
	if (m_xFolderDirNode.Is())
	{
		CntStoreItemSetRef
			xDocDirSet(static_cast< CntStorageNode * >(&m_xFolderDirNode)->
					       openItemSet(
							   CntFTPImp::GetDocDirectoryEntryRanges(),
							   m_aChildID,
							   STREAM_STD_READWRITE | STREAM_NOCREATE));
		if (xDocDirSet.Is())
		{
			xDocDirSet->ClearItem(WID_FTP_RETR_DOCUMENT_SIZE);
			xDocDirSet->ClearItem(WID_FTP_RETR_DATE_CREATED);
			String aDocCacheName( ITEMSET_VALUE(xDocDirSet, CntStringItem,
												WID_FTP_CACHENAME));
			if (aDocCacheName.Len() > 0)
			{
				if (!m_pCacheNode)
					m_pCacheNode = getJob().GetCacheNode(false);
				if (m_pCacheNode)
				{
					String aRefcountID(
						       RTL_CONSTASCII_USTRINGPARAM(
								   CNT_FTP_DOC_REFCOUNT_CACHE_ENTRY_PREFIX));
					aRefcountID += aDocCacheName;
					CntStoreItemSetRef
						xRefcountCacheSet(
							m_pCacheNode->
							    openItemSet(
								   CntFTPImp::GetDocRefcountCacheEntryRanges(),
									aRefcountID,
									STREAM_STD_READWRITE | STREAM_NOCREATE));
					if (xRefcountCacheSet.Is())
					{
						UINT32 nRefcount = ITEMSET_VALUE(xRefcountCacheSet,
														 CntUInt32Item,
														 WID_FTP_CACHEREFS);
						if (nRefcount > 0)
						{
							xRefcountCacheSet->
								Put(CntUInt32Item(WID_FTP_CACHEREFS,
												  nRefcount - 1));
							return;
						}
						xRefcountCacheSet = 0;
					}
					m_pCacheNode->remove(aRefcountID);
					String aContentsID(
						       RTL_CONSTASCII_USTRINGPARAM(
								   CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
					aContentsID += aDocCacheName;
					m_pCacheNode->remove(aContentsID);
				}
			}
		}
	}
}

//============================================================================
bool CntFTPOpenFolderTask::downloadDocIntoCache()
{
	if (!m_pCacheNode)
		m_pCacheNode = getJob().GetCacheNode();
	if (m_pCacheNode)
	{
		if (!m_xFolderDirNode)
		{
			getImp().forceDirectoryStorage();
			m_xFolderDirNode = CntFTPImp::GetDirectory(xTargetNode);
			if (m_xFolderDirNode.Is())
				static_cast< CntFTPFolderNode * >(&xTargetNode)->
					getImp().storeChildren(*static_cast< CntStorageNode * >(
						                       &m_xFolderDirNode));
		}
		if (m_xFolderDirNode.Is())
		{
			CntStoreItemSetRef
				xDocDirSet(static_cast< CntStorageNode * >(
					               &m_xFolderDirNode)->
						       openItemSet(
								   CntFTPImp::GetDocDirectoryEntryRanges(),
								   m_aChildID, STREAM_STD_READWRITE));
			if (xDocDirSet.Is())
			{
				m_aDocCacheName = ITEMSET_VALUE(xDocDirSet, CntStringItem,
												WID_FTP_CACHENAME);
				if (m_aDocCacheName.Len() == 0)
					m_aDocCacheName
						= getImp().FindUnusedCacheName(&getJob(),
													   m_pCacheNode);
				else
				{
					String aContentsCacheID(
						       RTL_CONSTASCII_USTRINGPARAM(
								   CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
					aContentsCacheID += m_aDocCacheName;
					SvStream * pContentsStream
						= m_pCacheNode->openStream(aContentsCacheID,
												   STREAM_STD_READ);
					bool bContentsPresent = pContentsStream != 0;
					delete pContentsStream;
					if (bContentsPresent)
					{
						UINT32 nContentsCacheAttribs = 0;
						m_pCacheNode->attrib(aContentsCacheID, 0, 0,
											 nContentsCacheAttribs);
						if (nContentsCacheAttribs
							    & CNTDIRENTRY_ATTRIB_FTP_PARTIAL)
							m_pCacheNode->remove(aContentsCacheID);
						else if (nContentsCacheAttribs
								     & CNTDIRENTRY_ATTRIB_FTP_PERSISTENT)
							m_aDocCacheName.Erase();
					}
				}
				if (m_aDocCacheName.Len() > 0)
				{
					m_xChildNode->ClearItem(WID_DOCUMENT_BODY);
					SfxPoolItem const * pItem;
					if (m_xChildNode->GetItemState(WID_DOCUMENT_SIZE, false,
												   &pItem)
						    == SFX_ITEM_SET)
						xDocDirSet->
							Put(CntUInt32Item(WID_FTP_RETR_DOCUMENT_SIZE,
											  ITEM_VALUE(CntUInt32Item,
														 *pItem)));
					else
						xDocDirSet->ClearItem(WID_FTP_RETR_DOCUMENT_SIZE);
					xDocDirSet->
						Put(SfxDateTimeItem(
							    WID_FTP_RETR_DATE_CREATED,
								static_cast< SfxDateTimeItem const * >(
									    &m_xChildNode->
										     Get(WID_DATE_CREATED))->
								    GetDateTime()));
					xDocDirSet->Put(CntStringItem(WID_FTP_CACHENAME,
												  m_aDocCacheName));
					xDocDirSet = 0;
					String aContentsCacheID(
						       RTL_CONSTASCII_USTRINGPARAM(
								   CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
					aContentsCacheID += m_aDocCacheName;
					SvStream * pContentsStream
						= m_pCacheNode->openStream(aContentsCacheID,
												   STREAM_STD_WRITE
												       | STREAM_TRUNC);
					String aRefcountCacheID(
						       RTL_CONSTASCII_USTRINGPARAM(
								   CNT_FTP_DOC_REFCOUNT_CACHE_ENTRY_PREFIX));
					aRefcountCacheID += m_aDocCacheName;
					if (pContentsStream)
					{
						CntStoreItemSetRef
							xRefcountCacheSet(
								m_pCacheNode->
								    openItemSet(
								  CntFTPImp::GetDocRefcountCacheEntryRanges(),
										m_aDocCacheName));
						if (xRefcountCacheSet.Is())
						{
							xRefcountCacheSet->
								Put(CntUInt32Item(WID_FTP_CACHEREFS, 0));
							xRefcountCacheSet = 0;
						}
						m_xDocLockBytes
							= new SvAsyncLockBytes(pContentsStream, true);
						if (m_nState == STATE_CWD_LINK)
							m_nState = STATE_TYPE_I;
						else
						{
							m_nState = STATE_CWD_BACK;
							m_nCWDBackNextState = STATE_TYPE_I;
						}
						handleCallback(0, 0);
						return true;
					}
					else
					{
						m_pCacheNode->remove(aContentsCacheID);
						m_pCacheNode->remove(aRefcountCacheID);
					}
				}
			}
		}
	}
	return false;
}

//============================================================================
void CntFTPOpenFolderTask::resetDocDownload()
{
	if (m_nState == STATE_RETR_DONE)
	{
		String aContentsCacheID(
			       RTL_CONSTASCII_USTRINGPARAM(
					   CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
		aContentsCacheID += m_aDocCacheName;
		m_pCacheNode->attrib(aContentsCacheID, 0,
							 CNTDIRENTRY_ATTRIB_FTP_PARTIAL);
	}
}

//============================================================================
// virtual
bool CntFTPOpenFolderTask::initialize()
{
	SfxPoolItem const & rRequest = *getJob().GetRequest();
	m_nWhich = rRequest.Which();

	CntSearchData const * pSearchData;
	if (m_nWhich == WID_SEARCH)
	{
		pSearchData = &ITEM_VALUE(CntSearchDataItem, rRequest);
		if (!pSearchData->DoSearchFirstLevel())
		{
			done();
			return false;
		}
	}

	if (m_nWhich == WID_OPEN)
		switch (ITEM_VALUE(CntOpenModeItem, rRequest))
		{
			case CNT_OPEN_ALL:
				m_bResultFolders = true;
				m_bResultDocs = true;
				break;

			case CNT_OPEN_FOLDERS:
				m_bResultFolders = true;
				m_bResultDocs = false;
				break;

			case CNT_OPEN_MESSAGES:
				m_bResultFolders = false;
				m_bResultDocs = true;
				break;

			default:
				done();
				return false;
		}
	else
	{
		m_bResultFolders = true;
		m_bResultDocs = true;
	}

	m_eResultDocsMode
		= m_bResultDocs
		  && (m_nWhich != WID_SEARCH
			      || pSearchData->DoObeyDocViewRestrictions()) ?
	          CntMsgViewMode(ITEMSET_VALUE(getJob().GetClient(),
										   CntMsgViewModeItem,
										   WID_MESSAGEVIEW_MODE)) :
			  CNT_VIEW_ALL_ARTICLES;

	m_bCompleteList = false;
	if (xTargetNode.Is())
	{
		CntNodeRef
			xParentDirNode(CntFTPImp::GetDirectory(xTargetNode->GetParent()));
		if (xParentDirNode.Is())
		{
			String aFolderDirID(RTL_CONSTASCII_USTRINGPARAM(
				                    CNT_FTP_FOLDER_ENTRY_PREFIX));
			aFolderDirID += CntFTPImp::GetName(xTargetNode);
			UINT32 nFolderDirAttribs = 0;
			static_cast< CntStorageNode * >(&xParentDirNode)->
				attrib(aFolderDirID, 0, 0, nFolderDirAttribs);
			m_bCompleteList = (nFolderDirAttribs
							           & CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST)
				                  != 0;
		}
	}

	bConnModeDetermined = true;
	if ((m_nWhich == WID_OPEN || m_nWhich == WID_SEARCH) && m_bCompleteList
		&& !getImp().getUpdateOnOpenMode(getJob()))
		eConnMode = CNT_CONN_MODE_OFFLINE;
	else
		for (;;)
		{
			eConnMode = getImp().GetConnMode();
			if (eConnMode == CNT_CONN_MODE_ONLINE
				|| (m_nWhich == WID_OPEN || m_nWhich == WID_SEARCH)
				   && m_bCompleteList)
				break;
			if (!error(ERRCODE_CHAOS_OFFLINE))
				return false;
		}

	if (eConnMode == CNT_CONN_MODE_OFFLINE)
	{
		m_xFolderDirNode = CntFTPImp::GetDirectory(xTargetNode);
		m_xFolderUserNode = CntFTPImp::GetUserData(xTargetNode);
		m_aFolderURL = OWN_URL(xTargetNode);
		m_pFolderDirIterator = new CntStorageIterator;
	}

	return true;
}

//============================================================================
// virtual
void CntFTPOpenFolderTask::handleCallback(sal_Int32 nReplyCode,
										  sal_Char const * pReplyText)
{
	for (;;)
		switch (m_nState)
		{
			case STATE_LIST:
				m_nState = STATE_LIST_DONE;
				if (!connectionGetNameList(aName, m_aChildNames)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
				return;

			case STATE_LIST_DONE:
				if (nReplyCode / 100 == 2)
					reschedule();
				else if (nReplyCode / 100 != 1
						 && error(nReplyCode, pReplyText))
					errorRestart();
				return;

			case STATE_CWD_BACK:
				m_nState = STATE_CWD_BACK_DONE;
				if (!connectionSetCurDir(getFullPath())
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
				return;

			case STATE_CWD_BACK_DONE:
				if (nReplyCode / 100 == 2)
				{
					m_nState = m_nCWDBackNextState;
					break;
				}
				else if (error(nReplyCode, pReplyText))
					errorRestart();
				return;

			case STATE_CWD_LINK:
				m_nState = STATE_CWD_LINK_DONE;
				if (!connectionSetCurDir(m_aChildName)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
				return;

			case STATE_CWD_LINK_DONE:
				m_bChildDoc = nReplyCode / 100 != 2;
				reschedule();
				return;

			case STATE_TYPE_I:
			    if (getImp().getConnection()->getDataType()
					    == inet::INetFTPConnection::DATA_TYPE_IMAGE)
					m_nState = STATE_RETR;
				else
				{
					m_nState = STATE_TYPE_I_DONE;
					if (!connectionSetTypeImage()
						&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						errorRestart();
					return;
				}
				break;

			case STATE_TYPE_I_DONE:
				if (nReplyCode / 100 == 2)
				{
					m_nState = STATE_RETR;
					break;
				}
				else if (error(nReplyCode, pReplyText))
					errorRestart();
				return;

			case STATE_RETR:
				m_nState = STATE_RETR_DONE;
				if (!connectionRetrieve(m_aChildName, m_xDocLockBytes, 0)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
				return;

			case STATE_RETR_DONE:
				if (nReplyCode / 100 == 2)
				{
					m_eChildProcessMode = CHILD_DOWNLOADED;
					reschedule();
				}
				else if (nReplyCode / 100 != 1)
				{
					resetDocDownload();
					if (error(nReplyCode, pReplyText))
						errorRestart();
				}
				return;
		}
}

//============================================================================
// virtual
void CntFTPOpenFolderTask::handleReschedule()
{
	startTimeSlice();

	switch (eConnMode)
	{
		case CNT_CONN_MODE_ONLINE:
			// Initialize iteration over received name list, part one:
			if (m_nState == STATE_LIST_DONE)
			{
				m_xFolderDirNode = CntFTPImp::GetDirectory(xTargetNode);
				m_xFolderUserNode = CntFTPImp::GetUserData(xTargetNode);

				if (m_xFolderDirNode.Is())
					static_cast< CntFTPFolderNode * >(&xTargetNode)->
						getImp().
						    storeChildren(*static_cast< CntStorageNode * >(
								               &m_xFolderDirNode));

				switch (m_nWhich)
				{
					case WID_SYNCHRONIZE:
						if (m_xFolderDirNode.Is())
						{
							m_pFolderDirIterator = new CntStorageIterator;
							m_nState = STATE_OLD_LIST_STORAGE;
						}
						else
						{
							m_nChildIndex = 0;
							m_nState = STATE_OLD_LIST_NODE;
						}
						break;

					default:
						m_nState = STATE_ITER_INIT;
						break;
				}
			}

			// Collect children present in directory storage into
			// WID_SYNCHRONIZE's lists of children no longer present:
			if (m_nState == STATE_OLD_LIST_STORAGE)
			{
				if (m_xFolderDirNode.Is())
					for (;;)
					{
						String aChildDirID(static_cast< CntStorageNode * >(
							                       &m_xFolderDirNode)->
										       iter(*m_pFolderDirIterator));
						if (aChildDirID.Len() == 0)
							break;

						String aChildName;
						bool bChildDoc;
						if (CntFTPImp::ParseID(aChildDirID, aChildName,
											   bChildDoc))
							if (bChildDoc)
								m_pOldDocs
									= new ChildItem(aChildName, m_pOldDocs);
							else
								m_pOldFolders = new ChildItem(aChildName,
															  m_pOldFolders);

						if (checkTimeSliceExhausted())
						{
							reschedule();
							return;
						}
					}

				delete m_pFolderDirIterator;
				m_pFolderDirIterator = 0;
				m_nState = STATE_ITER_INIT;
			}

			// Collect children present in implementation into
			// WID_SYNCHRONIZE's lists of children no longer present:
			if (m_nState == STATE_OLD_LIST_NODE)
			{
				for (; m_nChildIndex< static_cast< CntFTPFolderNode * >(
					           &xTargetNode)->
						   getImp().getChildCount();
					 ++m_nChildIndex)
				{
					CntFTPFolderChildEntry const & rChildEntry
						= static_cast< CntFTPFolderNode * >(&xTargetNode)->
						      getImp().getChild(m_nChildIndex);
					if (rChildEntry.isDoc())
						m_pOldDocs = new ChildItem(rChildEntry.getName(),
												   m_pOldDocs);
					else
						m_pOldFolders = new ChildItem(rChildEntry.getName(),
													  m_pOldFolders);

					if (checkTimeSliceExhausted())
					{
						reschedule();
						return;
					}
				}

				m_nState = STATE_ITER_INIT;
			}

			// Initialize iteration over received name list, part two:
			if (m_nState == STATE_ITER_INIT)
			{
				m_bResetFolderCounts
					= m_nWhich == WID_SYNCHRONIZE
					  || xTargetNode->GetItemState(WID_TOTALCONTENTCOUNT)
					         != SFX_ITEM_SET;
				if (m_bResetFolderCounts)
					CntFTPImp::updateFolderCountsInit(*xTargetNode);
				m_aFolderURL = OWN_URL(xTargetNode);
				m_eChildProcessMode = CHILD_RESOLVE_LINK;
				m_nState = STATE_CWD_LINK;
			}

			// Iterate over received name list:
			while (m_aChildNames.Count())
			{
				inet::INetFTPDirentry const & rChildEntry
					= *static_cast< inet::INetFTPDirentry * >(
						   m_aChildNames.GetObject(0));

				switch (m_eChildProcessMode)
				{
					case CHILD_RESOLVE_LINK:
					{
						m_aChildName = rChildEntry.m_aName;
						if (m_aChildName.Len() == 0 || m_aChildName == '.'
							|| m_aChildName.EqualsAscii(".."))
							break;

						m_eChildProcessMode = CHILD_LINK_RESOLVED;

						if (rChildEntry.m_nMode
							& INETCOREFTP_FILEMODE_ISLINK)
						{
							xub_StrLen nPos = m_aChildName.SearchAscii("->");
							if (nPos != STRING_NOTFOUND)
							{
								m_aChildName.Erase(nPos);
								m_aChildName.EraseTrailingChars();
							}
							m_bChildLink = true;
							if (m_nState != STATE_CWD_LINK)
							{
								m_nState = STATE_CWD_BACK;
								m_nCWDBackNextState = STATE_CWD_LINK;
							}
							handleCallback(0, 0);
							return;
						}
						else
						{
							m_bChildDoc = !(rChildEntry.m_nMode
											    & INETCOREFTP_FILEMODE_ISDIR);
							m_bChildLink = false;
						}
					}
					case CHILD_LINK_RESOLVED:
					{
						// Remove child from WID_SYNCHRONIZE's lists of
						// children no longer present:
						for (ChildItem ** pOldList
								 = m_bChildDoc ? &m_pOldDocs : &m_pOldFolders;
							 *pOldList; pOldList = &(*pOldList)->m_pNext)
							if ((*pOldList)->m_aName == m_aChildName)
							{
								ChildItem * pItem = *pOldList;
								*pOldList = pItem->m_pNext;
								delete pItem;
								break;
							}

						// Get child's ID for storage access:
						m_aChildID
							= m_bChildDoc ?
							      String::CreateFromAscii(
									  RTL_CONSTASCII_STRINGPARAM(
										  CNT_FTP_DOC_ENTRY_PREFIX)) :
							      String::CreateFromAscii(
									  RTL_CONSTASCII_STRINGPARAM(
										  CNT_FTP_FOLDER_ENTRY_PREFIX));
						m_aChildID += m_aChildName;

						// Check if child was previously known or is logically
						// deleted:
						bool bNewChild;
						if (m_xFolderDirNode.Is())
						{
							UINT32 nChildDirAttribs = 0;
							if (!static_cast< CntStorageNode * >(
								         &m_xFolderDirNode)->
								     attrib(m_aChildID, 0, 0,
											nChildDirAttribs))
							{
								if (nChildDirAttribs
									    & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE)
									break;
								bNewChild = false;
							}
							else
								bNewChild = true;
						}
						else
							bNewChild
								= !static_cast< CntFTPFolderNode * >(
									       &xTargetNode)->
								       getImp().hasChild(m_aChildName,
														 m_bChildDoc);

						String aChildURL;
						CntNodeRef xChildNode;
						bool bDocRead;
						bool bDocMarked;

						// For a document, get its read/marked state:
						if (m_bChildDoc)
						{
							aChildURL = m_aFolderURL;
							aChildURL
								+= CntFTPURL::encodeFSegment(m_aChildName);
							m_xChildNode
								= xTargetNode->Query(aChildURL, false);
							if (m_xChildNode.Is())
							{
								bDocRead = ITEMSET_VALUE(m_xChildNode,
														 CntBoolItem,
														 WID_IS_READ)
									           != false;
								bDocMarked = ITEMSET_VALUE(m_xChildNode,
														   CntBoolItem,
														   WID_IS_MARKED)
									             != false;
							}
							else
							{
								UINT32 nDocUserAttribs = 0;
								if (m_xFolderUserNode.Is())
									static_cast< CntStorageNode * >(
										    &m_xFolderUserNode)->
										attrib(m_aChildID, 0, 0,
											   nDocUserAttribs);
								bDocRead
									= (nDocUserAttribs
									           & CNTDIRENTRY_ATTRIB_FTP_READ)
									      != 0;
								bDocMarked
									= (nDocUserAttribs
									           & CNTDIRENTRY_ATTRIB_MARKED)
									      != 0;
							}
						}

						// Update the data about the child:
						if (m_xFolderDirNode.Is())
						{
							CntStoreItemSetRef
								xChildDirSet(
									static_cast< CntStorageNode * >(
										    &m_xFolderDirNode)->
									    openItemSet(
											m_bChildDoc ?
									 CntFTPImp::GetDocDirectoryEntryRanges() :
								   CntFTPImp::GetFolderDirectoryEntryRanges(),
											m_aChildID, STREAM_STD_WRITE));
							if (xChildDirSet.Is())
							{
								if (rChildEntry.m_aDate.GetDate())
									xChildDirSet->Put(
										SfxDateTimeItem(
											WID_DATE_CREATED,
											rChildEntry.m_aDate));

								if (m_bChildDoc
									&& rChildEntry.m_nSize != ULONG(-1))
									xChildDirSet->
										Put(CntUInt32Item(WID_DOCUMENT_SIZE,
														  rChildEntry.
														      m_nSize));
								xChildDirSet = 0;
							}

							UINT32 nChildDirClearAttribs = 0;
							UINT32 nChildDirSetAttribs = 0;

							if (!(rChildEntry.m_nMode
								      & INETCOREFTP_FILEMODE_WRITE))
								nChildDirSetAttribs
									|= CNTDIRENTRY_ATTRIB_FTP_READONLY;
							else
								nChildDirClearAttribs
									|= CNTDIRENTRY_ATTRIB_FTP_READONLY;
							if (m_bChildLink)
								nChildDirSetAttribs
									|= CNTDIRENTRY_ATTRIB_FTP_LINK;
							else
								nChildDirClearAttribs
									|= CNTDIRENTRY_ATTRIB_FTP_LINK;

							static_cast< CntStorageNode * >(
								    &m_xFolderDirNode)->
								attrib(m_aChildID, nChildDirClearAttribs,
									   nChildDirSetAttribs);
						}
						else
							static_cast< CntFTPFolderNode * >(&xTargetNode)->
								getImp().addChild(m_aChildName, m_bChildDoc);

						// If the child is new or the counts have been reset,
						// increment the counts:
						if (bNewChild || m_bResetFolderCounts)
							if (m_bChildDoc)
								CntFTPImp::updateFolderCountsAddDoc(
									*xTargetNode, bDocRead, bDocMarked);
							else
								CntFTPImp::updateFolderCountsAddFolder(
									*xTargetNode);

						// Check if child is compatible with view mode:
						bool bResult;
						if (m_bChildDoc)
							if (m_bResultDocs)
								switch (m_eResultDocsMode)
								{
									case CNT_VIEW_ALL_ARTICLES:
										bResult = true;
										break;

									case CNT_VIEW_UNREAD_ARTICLES:
										bResult = !bDocRead;
										break;

									case CNT_VIEW_READ_ARTICLES:
										bResult = bDocRead;
										break;

									case CNT_VIEW_MARKED_ARTICLES:
										bResult = bDocMarked;
										break;

									case CNT_VIEW_MARKED_AND_UNREAD_ARTICLES:
										bResult = bDocMarked || !bDocRead;
										break;
								}
							else
								bResult = false;
						else
							bResult = m_bResultFolders;
						if (!bResult)
							break;

						// Get child node:
						if (!m_xChildNode)
						{
							if (aChildURL.Len() == 0)
							{
								aChildURL = m_aFolderURL;
								aChildURL += CntFTPURL::encodeFSegment(
									             m_aChildName);
								if (!m_bChildDoc)
									aChildURL += '/';
							}
							m_xChildNode = xTargetNode->Query(aChildURL);
						}

						if (m_xChildNode.Is())
						{
							// Fill child node with previously known data:
							if (m_bChildDoc)
								getImp().
									GetDocNodeData(PTR_CAST(CntFTPDocNode,
															&m_xChildNode));
							else
								getImp().
									GetFolderNodeData(PTR_CAST(
										                  CntFTPFolderNode,
														  &m_xChildNode));

							// Update child node data:
							if (rChildEntry.m_aDate.GetDate())
								m_xChildNode->
									Put(SfxDateTimeItem(WID_DATE_CREATED,
														rChildEntry.m_aDate));

#if 0 // no WID_FLAG_READONLY
							m_xChildNode->
								Put(CntBoolItem(
									    WID_FLAG_READONLY,
										!(rChildEntry.m_nMode
										      & INETCOREFTP_FILEMODE_WRITE)));
#endif // no WID_FLAG_READONLY
							m_xChildNode->
								Put(CntUInt32Item(WID_FSYS_FLAGS,
												  m_bChildLink ?
												      CNT_FLAG_LINK : 0));
							if (m_bChildDoc
								&& rChildEntry.m_nSize != ULONG(-1))
								m_xChildNode->
									Put(CntUInt32Item(WID_DOCUMENT_SIZE,
													  rChildEntry.m_nSize));

							// Result child node:
							if (m_nWhich == WID_OPEN
								|| !m_xChildNode->IsInserted())
								getJob().Result(m_xChildNode);
							if (m_nWhich == WID_SEARCH)
								getJob().ResultSearchMatch(m_xChildNode);

							// Check if document's contents are to be
							// downloaded into, or removed from cache:
							if (m_bChildDoc
								&& (m_nWhich == WID_UPDATE && bNewChild
									|| m_nWhich == WID_SYNCHRONIZE))
								if (getImp().KeepDocPersistent(m_xChildNode))
								{
									if (downloadDocIntoCache())
										return;
								}
								else if (m_nWhich == WID_SYNCHRONIZE)
									removeDocFromCache();
						}

						break;
					}

					case CHILD_DOWNLOADED:
					{
						m_xDocLockBytes = 0;
						String
							aContentsCacheID(
								RTL_CONSTASCII_USTRINGPARAM(
									CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
						aContentsCacheID += m_aDocCacheName;
						m_pCacheNode->
							attrib(aContentsCacheID, 0,
								   CNTDIRENTRY_ATTRIB_FTP_PERSISTENT);
						break;
					}
				}

				m_eChildProcessMode = CHILD_RESOLVE_LINK;
				m_xChildNode = 0;
				m_xDocLockBytes = 0;

				delete static_cast< inet::INetFTPDirentry * >(
					       m_aChildNames.Remove(ULONG(0)));

				if (checkTimeSliceExhausted())
				{
					reschedule();
					return;
				}
			}

			// Process WID_SYNCHRONIZE's list of child folders no longer
			// present:
			while (m_pOldFolders)
			{
				String aChildFolderID;
				if (m_xFolderDirNode.Is() || m_xFolderUserNode.Is())
				{
					aChildFolderID.
						AssignAscii(RTL_CONSTASCII_STRINGPARAM(
							            CNT_FTP_FOLDER_ENTRY_PREFIX));
					aChildFolderID += m_pOldFolders->m_aName;
				}

				if (m_xFolderDirNode.Is())
					static_cast< CntStorageNode * >(&m_xFolderDirNode)->
						remove(aChildFolderID);
				else
					static_cast< CntFTPFolderNode * >(&xTargetNode)->
						getImp().removeChild(m_pOldFolders->m_aName, false);

				if (m_xFolderUserNode.Is())
					static_cast< CntStorageNode * >(&m_xFolderDirNode)->
						remove(aChildFolderID);

				String aChildFolderURL(m_aFolderURL);
				aChildFolderURL
					+= CntFTPURL::encodeFSegment(m_pOldFolders->m_aName);
				aChildFolderURL += '/';
				CntNodeRef
					xChildFolderNode(xTargetNode->Query(aChildFolderURL,
														false));
				if (xChildFolderNode.Is())
					getJob().Result(xChildFolderNode, CNT_ACTION_DELETED);

				ChildItem * pNext = m_pOldFolders->m_pNext;
				delete m_pOldFolders;
				m_pOldFolders = pNext;

				if (checkTimeSliceExhausted())
				{
					reschedule();
					return;
				}
			}

			// Process WID_SYNCHRONIZE's list of documents no longer present:
			while (m_pOldDocs)
			{
				String aDocID;
				if (m_xFolderDirNode.Is() || m_xFolderUserNode.Is())
				{
					aDocID.AssignAscii(RTL_CONSTASCII_STRINGPARAM(
						                   CNT_FTP_DOC_ENTRY_PREFIX));
					aDocID += m_pOldDocs->m_aName;
				}

				if (m_xFolderDirNode.Is())
					static_cast< CntStorageNode * >(&m_xFolderDirNode)->
						remove(aDocID);
				else
					static_cast< CntFTPFolderNode * >(&xTargetNode)->
						getImp().removeChild(m_pOldDocs->m_aName, true);

				if (m_xFolderUserNode.Is())
				{
					static_cast< CntStorageNode * >(&m_xFolderDirNode)->
						attrib(aDocID,
							   CNTDIRENTRY_ATTRIB_CREATE
							       | CNTDIRENTRY_ATTRIB_MARKED,
							   0);
					static_cast< CntStorageNode * >(&m_xFolderDirNode)->
						remove(aDocID);
				}

				String aDocURL(m_aFolderURL);
				aDocURL += CntFTPURL::encodeFSegment(m_pOldDocs->m_aName);
				CntNodeRef xDocNode(xTargetNode->Query(aDocURL, false));
				if (xDocNode.Is())
					getJob().Result(xDocNode, CNT_ACTION_DELETED);

				ChildItem * pNext = m_pOldDocs->m_pNext;
				delete m_pOldDocs;
				m_pOldDocs = pNext;

				if (checkTimeSliceExhausted())
				{
					reschedule();
					return;
				}
			}

			if (xTargetNode != getJob().GetSubject())
				m_bCompleteList = false;
			if (!m_bCompleteList)
			{
				CntNodeRef
					xParentDirNode(CntFTPImp::GetDirectory(xTargetNode->
														       GetParent()));
				if (xParentDirNode.Is())
				{
					String aFolderDirID(RTL_CONSTASCII_USTRINGPARAM(
						                    CNT_FTP_FOLDER_ENTRY_PREFIX));
					aFolderDirID += CntFTPImp::GetName(xTargetNode);
					if (xTargetNode != getJob().GetSubject())
					{
						UINT32 nFolderDirAttribs = 0;
						static_cast< CntStorageNode * >(&xParentDirNode)->
							attrib(aFolderDirID, 0, 0, nFolderDirAttribs);
						m_bCompleteList
							= (nFolderDirAttribs
							           & CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST)
							      != 0;
					}
					if (!m_bCompleteList)
						static_cast< CntStorageNode * >(&xParentDirNode)->
							attrib(aFolderDirID, 0,
								   CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST);
				}
			}

			CntFTPImp::updateFolderCountsStore(*xTargetNode);

			break;

		case CNT_CONN_MODE_OFFLINE:
			if (m_xFolderDirNode.Is())
				for (;;)
				{
					String aChildID(static_cast< CntStorageNode * >(
						                    &m_xFolderDirNode)->
									    iter(*m_pFolderDirIterator));
					if (aChildID.Len() == 0)
						break;

					String aChildName;
					bool bChildDoc;
					if (CntFTPImp::ParseID(aChildID, aChildName, bChildDoc)
						&& (bChildDoc ? m_bResultDocs : m_bResultFolders))
					{
						String aChildURL;
						CntNodeRef xChildNode;

						bool bResult = true;
						if (bChildDoc)
							if (m_bResultDocs)
							{
								bool bDocRead;
								bool bDocMarked;
								if (m_eResultDocsMode
									    != CNT_VIEW_ALL_ARTICLES)
								{
									UINT32 nDocUserAttribs;
									if (m_xFolderUserNode.Is()
										&& !static_cast< CntStorageNode * >(
											        &m_xFolderUserNode)->
										        attrib(aChildID, 0, 0,
													   nDocUserAttribs))
									{
										bDocRead
											= (nDocUserAttribs
											    & CNTDIRENTRY_ATTRIB_FTP_READ)
											      != 0;
										bDocMarked
											= (nDocUserAttribs
											      & CNTDIRENTRY_ATTRIB_MARKED)
											      != 0;
									}
									else
									{
										aChildURL = m_aFolderURL;
										aChildURL
											+= CntFTPURL::encodeFSegment(
												   aChildName);
										xChildNode
											= xTargetNode->Query(aChildURL,
																 false);
										if (xChildNode.Is())
										{
											bDocRead
												= ITEMSET_VALUE(xChildNode,
																CntBoolItem,
																WID_IS_READ)
												      != false;
											bDocMarked
												= ITEMSET_VALUE(xChildNode,
																CntBoolItem,
																WID_IS_MARKED)
												      != false;
										}
										else
										{
											bDocRead = false;
											bDocMarked = false;
										}
									}
								}
								switch (m_eResultDocsMode)
								{
									case CNT_VIEW_ALL_ARTICLES:
										bResult = true;
										break;

									case CNT_VIEW_UNREAD_ARTICLES:
										bResult = !bDocRead;
										break;

									case CNT_VIEW_READ_ARTICLES:
										bResult = bDocRead;
										break;

									case CNT_VIEW_MARKED_ARTICLES:
										bResult = bDocMarked;
										break;

									case CNT_VIEW_MARKED_AND_UNREAD_ARTICLES:
										bResult = bDocMarked || !bDocRead;
										break;
								}
							}
							else
								bResult = false;
						else
							bResult = m_bResultFolders;

						if (bResult)
						{
							if (!xChildNode.Is())
							{
								if (aChildURL.Len() == 0)
								{
									aChildURL = m_aFolderURL;
									aChildURL += CntFTPURL::encodeFSegment(
										             aChildName);
									if (!bChildDoc)
										aChildURL += '/';
								}
								xChildNode = xTargetNode->Query(aChildURL);
							}
							if (xChildNode.Is())
							{
								if (bChildDoc)
									getImp().
										GetDocNodeData(PTR_CAST(CntFTPDocNode,
																&xChildNode));
								else
									getImp().GetFolderNodeData(
										         PTR_CAST(CntFTPFolderNode,
														  &xChildNode));
								if (m_nWhich == WID_OPEN
									|| !xChildNode->IsInserted())
									getJob().Result(xChildNode);
								if (m_nWhich == WID_SEARCH)
									getJob().ResultSearchMatch(xChildNode);
							}
						}
					}

					if (checkTimeSliceExhausted())
					{
						reschedule();
						return;
					}
				}

			break;
	}

	done();
}

//============================================================================
// virtual
void CntFTPOpenFolderTask::handleCancel()
{
	resetDocDownload();
	if (xTargetNode.Is())
		CntFTPImp::updateFolderCountsStore(*xTargetNode);
}

//============================================================================
// virtual
CntFTPOpenFolderTask::~CntFTPOpenFolderTask()
{
	delete m_pFolderDirIterator;

	while (inet::INetFTPDirentry * pChildEntry
		       = static_cast< inet::INetFTPDirentry * >(m_aChildNames.
														    Remove()))
		delete pChildEntry;

	for (ChildItem * pFolderItem = m_pOldFolders; pFolderItem;)
	{
		ChildItem * pNext = pFolderItem->m_pNext;
		delete pFolderItem;
		pFolderItem = pNext;
	}
	for (ChildItem * pDocItem = m_pOldDocs; pDocItem;)
	{
		ChildItem * pNext = pDocItem->m_pNext;
		delete pDocItem;
		pDocItem = pNext;
	}
}

//============================================================================
//
//  CntFTPMakeFolderTask
//
//============================================================================

// virtual
bool CntFTPMakeFolderTask::initialize()
{
	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}
	return true;
}

//============================================================================
// virtual
void CntFTPMakeFolderTask::handleCallback(sal_Int32 nReplyCode,
										  sal_Char const * pReplyText)
{
	switch (m_nState)
	{
		case STATE_MKD:
			m_nState = STATE_MKD_DONE;
			if (!connectionMakeDir(aName)
				&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
				errorRestart();
			break;

		case STATE_MKD_DONE:
			if (nReplyCode / 100 == 2)
			{
				CntNodeRef xChildFolderNode
					= getImp().GetFTPBoxNode().Query(aNodeURL);
				if (xChildFolderNode.Is())
				{
					CntNode & rParentFolderNode
						= *xChildFolderNode->GetParent();
					CntNodeRef xParentDirNode
						= CntFTPImp::GetDirectory(&rParentFolderNode);
					if (xParentDirNode.Is())
					{
						String aChildFolderDirID(
							       RTL_CONSTASCII_USTRINGPARAM(
									   CNT_FTP_FOLDER_ENTRY_PREFIX));
						aChildFolderDirID += aName;
						static_cast< CntStorageNode * >(&xParentDirNode)->
							remove(aChildFolderDirID);
						CntStoreItemSetRef
							xChildFolderDirSet(
								static_cast< CntStorageNode * >(
									    &xParentDirNode)->
								    openItemSet(
								   CntFTPImp::GetFolderDirectoryEntryRanges(),
										aChildFolderDirID, STREAM_STD_WRITE));
						xChildFolderDirSet = 0;
						static_cast< CntFTPFolderNode * >(
							    &rParentFolderNode)->
							getImp().storeChildren(
								         *static_cast< CntStorageNode * >(
											  &xParentDirNode));
					}
					else
						static_cast< CntFTPFolderNode * >(
							    &rParentFolderNode)->
							getImp().addChild(aName, false);
					getImp().GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
														&xChildFolderNode));
					getJob().Result(xChildFolderNode);
					CntFTPImp::updateFolderCountsAddFolder(rParentFolderNode,
														   true);
					done();
				}
				else
					cancel();
			}
			else if (error(nReplyCode, pReplyText))
				errorRestart();
			break;
	}
}

//============================================================================
//
//  CntFTPRenameFolderTask
//
//============================================================================

// virtual
bool CntFTPRenameFolderTask::initialize()
{
	String aTitle(ITEMSET_VALUE(getJob().GetSubject(), CntStringItem,
								WID_TITLE));
	if (aTitle.Len() == 0 || aTitle == ITEM_VALUE(CntStringItem,
												  *getJob().GetRequest()))
	{
		done();
		return false;
	}
	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}
	return true;
}

//============================================================================
// virtual
void CntFTPRenameFolderTask::handleCallback(sal_Int32 nReplyCode,
											sal_Char const * pReplyText)
{
	switch (m_nState)
	{
		case STATE_RNFR:
			m_nState = STATE_RNTO;
			if (!connectionRenameFrom(aName)
				&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
				errorRestart();
			break;

		case STATE_RNTO:
			if (nReplyCode / 100 == 3)
			{
				m_nState = STATE_RNTO_DONE;
				if (!connectionRenameTo(ITEM_VALUE(CntStringItem,
												   *getJob().GetRequest()))
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
			}
			else if (error(nReplyCode, pReplyText))
				errorRestart();
			break;

		case STATE_RNTO_DONE:
			if (nReplyCode / 100 == 2)
				reschedule();
			else if (error(nReplyCode, pReplyText))
				errorRestart();
			break;
	}
}

//============================================================================
// virtual
void CntFTPRenameFolderTask::handleReschedule()
{
	CntNode & rOldSubFolderNode = *getJob().GetSubject();
	String aOldSubFolderName(CntFTPImp::GetName(&rOldSubFolderNode));
	String
		aNewSubFolderName(ITEM_VALUE(CntStringItem, *getJob().GetRequest()));
	CntNode & rParentFolderNode = *rOldSubFolderNode.GetParent();
	CntNodeRef xParentDirNode(CntFTPImp::GetDirectory(&rParentFolderNode));
	CntNodeRef xParentUserNode(CntFTPImp::GetUserData(&rParentFolderNode));
	String aOldSubFolderID;
	String aNewSubFolderID;
	if (xParentDirNode.Is() || xParentUserNode.Is())
	{
		aOldSubFolderID.AssignAscii(RTL_CONSTASCII_STRINGPARAM(
			                            CNT_FTP_FOLDER_ENTRY_PREFIX));
		aOldSubFolderID += aOldSubFolderName;
		aNewSubFolderID.AssignAscii(RTL_CONSTASCII_STRINGPARAM(
			                            CNT_FTP_FOLDER_ENTRY_PREFIX));
		aNewSubFolderID += aNewSubFolderName;
	}
	if (xParentDirNode.Is())
	{
		static_cast< CntFTPFolderNode * >(&rParentFolderNode)->
			getImp().storeChildren(*static_cast< CntStorageNode * >(
				                        &xParentDirNode));
		static_cast< CntStorageNode * >(&xParentDirNode)->
			rename(aOldSubFolderID, aNewSubFolderID);
		static_cast< CntStorageNode * >(&xParentDirNode)->
			attrib(aNewSubFolderID, CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST, 0);
	}
	else
		static_cast< CntFTPFolderNode * >(&rParentFolderNode)->
			getImp().renameChild(aOldSubFolderName, aNewSubFolderName, false);
	if (xParentUserNode.Is())
		static_cast< CntStorageNode * >(&xParentUserNode)->
			rename(aOldSubFolderID, aNewSubFolderID);
	String aNewSubFolderURL(OWN_URL(&rParentFolderNode));
	aNewSubFolderURL += CntFTPURL::encodeFSegment(aNewSubFolderName);
	aNewSubFolderURL += '/';
	CntNodeRef xNewSubFolderNode(rParentFolderNode.Query(aNewSubFolderURL));
	if (xNewSubFolderNode.Is())
	{
		getImp().GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
											&xNewSubFolderNode));
		getJob().Result(&xNewSubFolderNode, CNT_ACTION_EXCHANGED);
		done();
	}
	else
		cancel();
}

//============================================================================
//
//  CntFTPDeleteFolderTask
//
//============================================================================

void CntFTPDeleteFolderTask::trash()
{
	if (&xTargetNode == getJob().GetSubject())
	{
		getImp().forceDirectoryStorage();
		CntNode * pParent = xTargetNode->GetParent();
		CntNodeRef xDirectory(CntFTPImp::GetDirectory(pParent));
		if (xDirectory.Is())
		{
			static_cast< CntFTPFolderNode * >(pParent)->
				getImp().storeChildren(*static_cast< CntStorageNode * >(
					                        &xDirectory));
			String
				aID(RTL_CONSTASCII_USTRINGPARAM(CNT_FTP_FOLDER_ENTRY_PREFIX));
			aID += CntFTPImp::GetName(&xTargetNode);
			UINT32 nAttribs = 0;
			static_cast< CntStorageNode * >(&xDirectory)->
				attrib(aID, 0, 0, nAttribs);
			if (!(nAttribs & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE))
			{
				xTargetNode->Broadcast(CntFTPDeleteFolderHint());
				static_cast< CntStorageNode * >(&xDirectory)->
					attrib(aID, 0, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE);
				CntNodeRef xUserData(CntFTPImp::GetUserData(pParent));
				if (xUserData.Is())
					static_cast< CntStorageNode * >(&xUserData)->
						attrib(aID, 0, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE);
				CntFTPImp::updateFolderCountsRemoveFolder(*pParent, true);
				getJob().GetSubject()->CntNode::ExecuteJob(&getJob());
				return;
			}
		}
	}
	else
	{
		String aViewURL;
		if (CntAnchor * pAnchor = PTR_CAST(CntAnchor, getJob().GetClient()))
			aViewURL = pAnchor->GetRootViewURL(true);
		if (aViewURL.Len() == 0)
			aViewURL = OWN_URL(xTargetNode);
		else
			aViewURL = CntAnchor::ToViewURL(aViewURL, OWN_URL(xTargetNode));
		CntAnchorRef xTargetAnchor(new CntAnchor(0, aViewURL));
		xTargetAnchor->Put(*getJob().GetRequest());
	}
	cancel();
}

//============================================================================
// virtual
bool CntFTPDeleteFolderTask::initialize()
{
	if (xTargetNode.Is() && !ITEM_VALUE(CntBoolItem, *getJob().GetRequest()))
	{
		trash();
		return false;
	}
	else
	{
		bConnModeDetermined = true;
		for (;;)
		{
			eConnMode = getImp().GetConnMode();
			if (eConnMode == CNT_CONN_MODE_ONLINE)
				break;
			if (!error(ERRCODE_CHAOS_OFFLINE))
				return false;
		}
		return true;
	}
}

//============================================================================
// virtual
void CntFTPDeleteFolderTask::handleCallback(sal_Int32 nReplyCode,
											sal_Char const * pReplyText)
{
	switch (m_nState)
	{
		case STATE_RMD:
			if (ITEM_VALUE(CntBoolItem, *getJob().GetRequest()))
			{
				m_bDELE = false;
				m_nState = STATE_RMD_DONE;
				if (!connectionRemoveDir(aName)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
			}
			else
				trash();
			break;

		case STATE_RMD_DONE:
			if (nReplyCode / 100 == 2)
			{
				xTargetNode->Broadcast(CntFTPDeleteFolderHint());
				CntNode * pParent = xTargetNode->GetParent();

				String aID(RTL_CONSTASCII_USTRINGPARAM(
					           CNT_FTP_FOLDER_ENTRY_PREFIX));
				aID += aName;

				CntNodeRef xDirectory(CntFTPImp::GetDirectory(pParent));
				bool bWasLogicallyRemoved = false;
				if (xDirectory.Is())
				{
					static_cast< CntFTPFolderNode * >(pParent)->
						getImp().
						    storeChildren(*static_cast< CntStorageNode * >(
								               &xDirectory));
					UINT32 nSubFolderDirAttribs = 0;
					static_cast< CntStorageNode * >(&xDirectory)->
						attrib(aID, 0, 0, nSubFolderDirAttribs);
					bWasLogicallyRemoved
						= (nSubFolderDirAttribs
						           & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE)
						      != 0;
					static_cast< CntStorageNode * >(&xDirectory)->remove(aID);
				}
				else
					static_cast< CntFTPFolderNode * >(pParent)->
						getImp().removeChild(aName, false);

				CntNodeRef xUserData = CntFTPImp::GetUserData(pParent);
				if (xUserData.Is())
					static_cast< CntStorageNode * >(&xUserData)->remove(aID);
				if (!bWasLogicallyRemoved)
					CntFTPImp::updateFolderCountsRemoveFolder(*pParent, true);
				getJob().GetSubject()->CntNode::ExecuteJob(&getJob());
			}
			else if (!m_bDELE && nReplyCode / 10 == 55
					 && ITEMSET_VALUE(xTargetNode, CntUInt32Item,
									  WID_FSYS_FLAGS)
					        & CNT_FLAG_LINK)
			{
				// Some FTPDs return 550 when trying to RMD a symlink to a
				// directory, but DELE is successful:
				m_bDELE = true;
				if (!connectionRemove(aName)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
			}
			else if (error(nReplyCode, pReplyText))
				errorRestart();
			break;
	}
}

//============================================================================
//
//  CntFTPUndeleteFolderTask
//
//============================================================================

// virtual
bool CntFTPUndeleteFolderTask::initialize()
{
	CntNode * pSubject = getJob().GetSubject();
	CntNode * pParent = pSubject->GetParent();
	CntNodeRef xDirectory(CntFTPImp::GetDirectory(pParent));
	if (xDirectory.Is())
	{
		String aID(RTL_CONSTASCII_USTRINGPARAM(CNT_FTP_FOLDER_ENTRY_PREFIX));
		aID += CntFTPImp::GetName(pSubject);
		UINT32 nSubFolderDirAttribs = 0;
		static_cast< CntStorageNode * >(&xDirectory)->
			attrib(aID, 0, 0, nSubFolderDirAttribs);
		if (nSubFolderDirAttribs & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE)
		{
			static_cast< CntStorageNode * >(&xDirectory)->
				attrib(aID, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0);
			CntNodeRef xUserData(CntFTPImp::GetUserData(pParent));
			if (xUserData.Is())
				static_cast< CntStorageNode * >(&xUserData)->
					attrib(aID, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0);
			getImp().GetFolderNodeData(PTR_CAST(CntFTPFolderNode, pSubject));
			CntFTPImp::updateFolderCountsAddFolder(*pParent, true);
			getImp().GetFolderNodeData(PTR_CAST(CntFTPFolderNode, pSubject));
			getJob().Result(pSubject);
			for (CntFTPRedirectionPointer const * p
					 = getImp().GetRedirectionPointers(OWN_URL(pParent));
				 p; p = p->GetNext())
			{
				CntNodeRef xRedNode(CntRootNodeMgr::Get()->
									    Query(p->GetPointerURL()));
				if (xRedNode.Is())
					xRedNode->Broadcast(CntNodeHint(pSubject,
													CNT_ACTION_INSERTED,
													&getJob()));
			}
			done();
			return false;
		}
	}
	cancel();
	return false;
}

//============================================================================
//
//  CntFTPFlagFolderTask
//
//============================================================================

// virtual
bool CntFTPFlagFolderTask::initialize()
{
	bool bProxy = xTargetNode.Is() && getImp().IsProxyFolder(&xTargetNode);
	if (xTargetNode.Is() && !getImp().IsProxyFolder(&xTargetNode))
	{
		getImp().FlagFolder(&xTargetNode, getJob().GetRequest());
		done();
		return false;
	}
	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}
	return true;
}

//============================================================================
// virtual
void CntFTPFlagFolderTask::handleCallback(sal_Int32, sal_Char const *)
{
	getImp().FlagFolder(&xTargetNode, getJob().GetRequest());
	done();
}

