/*************************************************************************
 *
 *  $RCSfile: cntnftp.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif

#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef _CNTNFTP_HXX
#include <cntnftp.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef CHAOS_SLSTITEM_HXX
#include <slstitem.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef CHAOS_TFRMITEM_HXX
#include <tfrmitem.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif

#ifndef CHAOS_CNFTPDOC_HXX
#include <cnftpdoc.hxx>
#endif
#ifndef CHAOS_CNFTPFLD_HXX
#include <cnftpfld.hxx>
#endif

using namespace chaos;

//============================================================================
static const USHORT aCntFTPBoxRanges[]
	= { WID_TITLE, WID_TITLE,
		WID_DEFAULT, WID_UPDATE,
		WID_DUMMY_PROPFOLDERVIEW1, WID_MESSAGEVIEW_MODE,
		WID_SORTING, WID_SORTING,
		WID_FILTERED, WID_RULES,
		WID_TOTALCONTENTCOUNT, WID_SEENCONTENTCOUNT,
		WID_BOXALL_START, WID_SERVERPORT,
		WID_SERVERBASE, WID_SERVERBASE,
		WID_MESSAGE_STOREMODE, WID_MESSAGE_STOREMODE,
		WID_SERVER_RANGES, WID_REOPEN,
		WID_MSG_COLUMN_WIDTHS, WID_FTP_SERVERSYSTEM,
			// i.e., WID_MSG_COLUMN_WIDTHS, WID_SEND_PUBLIC_PROT_ID
		WID_CLEAN_CACHE, WID_SEARCH,
		WID_TRANSFER, WID_TRANSFER,
		WID_VIEWDATA, WID_VIEWDATA,
		WID_FOLDER_COUNT, WID_FOLDER_COUNT,
		WID_TARGET_FRAMES, WID_TARGET_FRAMES,
		WID_VIEW_START, WID_VIEW_END,
		WID_FLAG_UPDATE_ON_OPEN, WID_FLAG_UPDATE_ON_OPEN,
		WID_VIEW2_START, WID_VIEW2_END,
		WID_FOLDER_START2, WID_FOLDER_END2,
		WID_FLD_FONT, WID_FTP_ACCOUNT, 0 };

//============================================================================
static const USHORT aCntFTPFolderRanges[]
	= { WID_FTP_TARGET_FOLDER, WID_FTP_TARGET_FOLDER,
			// i.e., WID_REPLY_TO, WID_REPLY_TO
		WID_TITLE, WID_TITLE,
		WID_ALL_START, WID_DATE_CREATED,
		WID_VIEW_DESCRIPTION, WID_UPDATE,
		WID_DUMMY_PROPFOLDERVIEW1, WID_MESSAGEVIEW_MODE,
		WID_SORTING, WID_SORTING,
		WID_FILTERED, WID_FOLDER_END,
		WID_MESSAGE_STOREMODE, WID_MESSAGE_STOREMODE,
		WID_PROPERTYLIST, WID_PROPERTYLIST,
		WID_SEARCH, WID_SEARCH,
		WID_TRANSFER, WID_TRANSFER,
		WID_FSYS_FLAGS, WID_VIEWDATA,
		WID_MARKED_DOCUMENT_COUNT, WID_FOLDER_COUNT,
		WID_TARGET_FRAMES, WID_TARGET_FRAMES,
		WID_VIEW_START, WID_VIEW_END,
		WID_REAL_NAME, WID_REAL_NAME,
		WID_SET_AS_DEFAULT, WID_VIEW2_END,
		WID_FOLDER_START2, WID_FOLDER_END2,
		WID_VIEW3_START, WID_VIEW3_END, 0 };

//============================================================================
static const USHORT aCntFTPDocRanges[]
	= { WID_TITLE, WID_TITLE,
		WID_OPEN, WID_DATE_CREATED,
		WID_VIEW_DESCRIPTION, WID_SYNCHRONIZE,
		WID_INSERT, WID_INSERT,
		WID_MESSAGE_STOREMODE, WID_MESSAGE_STOREMODE,
		WID_PROPERTYLIST, WID_PROPERTYLIST,
		WID_SEARCH, WID_SEARCH,
		WID_DOCUMENT_BODY, WID_DOCUMENT_SIZE,
		WID_FSYS_FLAGS, WID_FSYS_FLAGS,
		WID_REAL_NAME, WID_REAL_NAME, 0 };

//============================================================================
//
//  class CntFTPDeleteFolderHint
//
//============================================================================

TYPEINIT1(CntFTPDeleteFolderHint, SfxHint)

//============================================================================
//
//  class CntFTPRedirectNode
//
//============================================================================

TYPEINIT1(CntFTPRedirectNode, CntNode)

//============================================================================
CNT_NODE_SUBCLASS_IMPL(CntFTPRedirectNode)
{}

//============================================================================
void CntFTPRedirectNode::SetTarget(CntNode * pFolder)
{
	CntFTPBoxNode * pBox;
	bool bBoxDetermined = false;

	if (m_aURL.Len() != 0)
	{
		pBox = PTR_CAST(CntFTPBoxNode, GetRootNode());
		bBoxDetermined = true;
		if (pBox)
		{
			pBox->m_pImp->RemoveRedirection(OWN_URL(this), m_aURL);
			CntNode * pNode = pBox->Query(m_aURL, false);
			if (pNode)
				EndListening(*pNode);
		}
	}

	if (pFolder)
	{
		m_aURL = OWN_URL(pFolder);
		if (!bBoxDetermined)
			pBox = PTR_CAST(CntFTPBoxNode, GetRootNode());
		if (pBox)
		{
			pBox->m_pImp->AddRedirection(OWN_URL(this), m_aURL);
			StartListening(*pFolder);
		}
	}
	else
		m_aURL.Erase();
}

//============================================================================
void CntFTPRedirectNode::GetTarget(CntNodeRef & rFolder)
{
	if (m_aURL.Len() != 0)
		if (CntFTPBoxNode * pBox = PTR_CAST(CntFTPBoxNode, GetRootNode()))
		{
			rFolder = pBox->Query(m_aURL);
			pBox->m_pImp->GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
													 &rFolder));
			return;
		}
	rFolder.Clear();
}

//============================================================================
// virtual
void CntFTPRedirectNode::Notify(SfxBroadcaster & rBroadcaster,
								const SfxHint & rHint)
{
	if (rHint.ISA(SfxItemChangedHint))
	{
		if (m_aURL.Len() != 0)
			if (CntFTPBoxNode * pBox = PTR_CAST(CntFTPBoxNode, GetRootNode()))
			{
				CntNode * pNode = pBox->Query(m_aURL, false);
				if (&rBroadcaster == pNode)
				{
					const SfxPoolItem & rItem
						= static_cast< const SfxItemChangedHint * >(&rHint)->
						      GetNewItem();
					switch (rItem.Which())
					{
						case WID_TOTALCONTENTCOUNT:
						case WID_SEENCONTENTCOUNT:
						case WID_IS_READ:
						case WID_IS_MARKED:
						case WID_FOLDER_COUNT:
						case WID_MESSAGE_STOREMODE:
							Put(rItem);
							break;
					}
					return;
				}
			}
	}
	else if (rHint.ISA(CntFTPDeleteFolderHint))
	{
		if (m_aURL.Len() != 0)
			if (CntFTPBoxNode * pBox = PTR_CAST(CntFTPBoxNode, GetRootNode()))
			{
				CntNode * pNode = pBox->Query(m_aURL, false);
				if (&rBroadcaster == pNode)
				{
					SetTarget(0);
					pBox->m_pImp->CopyFolderData(0, this);
					return;
				}
			}
	}
	CntNode::Notify(rBroadcaster, rHint);
}

//============================================================================
//
//  class CntFTPBoxNode
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntFTPBoxNode, CntFTPRedirectNode)

//============================================================================
CNT_NODE_SUBCLASS_IMPL(CntFTPBoxNode)
{
	CntRootNodeMgr::InsertFactory(new CntNodeFactory(
		                                  String::CreateFromAscii(
											  RTL_CONSTASCII_STRINGPARAM(
												  "ftp://*")),
										  '/', TYPE(CntFTPBoxNode),
										  CONTENT_TYPE_X_CNT_FTPBOX,
										  CNT_CREATION_FLAG_PROPERTIES
										  	| CNT_CREATION_FLAG_KIND_FOLDER,
										  HID_CHAOS_NEW_FTP_BOX));
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM("/*/")),
									 '/', TYPE(CntFTPFolderNode),
									 CONTENT_TYPE_X_CNT_FTPFOLDER,
									 CNT_CREATION_FLAG_TITLE
									 	| CNT_CREATION_FLAG_KIND_FOLDER,
									 HID_CHAOS_NEW_FTP_FLD));
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM("/*")),
									 String(), TYPE(CntFTPDocNode),
									 CONTENT_TYPE_X_CNT_FTPFILE,
									 CNT_CREATION_FLAG_HIDDEN
									 	| CNT_CREATION_FLAG_INSERT_WITH_STREAM
									 	| CNT_CREATION_FLAG_TITLE
										| CNT_CREATION_FLAG_KIND_DOCUMENT));
}

//============================================================================
CntFTPBoxNode::CntFTPBoxNode(): CntFTPRedirectNode(aCntFTPBoxRanges)
{
	CntDefaults * pClassDefs = GetDefaults();
	if (!pClassDefs)
	{
		pClassDefs = new CntDefaults(*this, aCntFTPBoxRanges);

		pClassDefs->Put(CntContentTypeItem(WID_CONTENT_TYPE,
										   CONTENT_TYPE_X_CNT_FTPBOX));

		pClassDefs->Put(CntBoolItem(WID_FLAG_IS_FOLDER, true));
		pClassDefs->Put(CntBoolItem(WID_FLAG_HAS_FOLDER, true));
		pClassDefs->Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, true));

		CntViewColumnsListItem aColumnOrder(WID_VIEW_COLS_BEAMER,
											WID_TITLE, DEF_WIDTH_TITLE_FSYS,
											WID_DOCUMENT_SIZE,
											    DEF_WIDTH_DOCUMENT_SIZE,
											WID_IS_MARKED,
											    DEF_WIDTH_IS_MARKED,
											WID_IS_READ, DEF_WIDTH_IS_READ,
											WID_DATE_CREATED,
											    DEF_WIDTH_DATE_CREATED, 0);
		pClassDefs->Put(aColumnOrder);
		pClassDefs->Put(aColumnOrder, WID_VIEW_COLS_FILEDLG);
		pClassDefs->Put(aColumnOrder, WID_VIEW_COLS_FLDWIN);

		CntSortingItem aSortOrder(WID_SORTING);
		aSortOrder.Append(CntSortingInfo(WID_TITLE, true));
		aSortOrder.Append(CntSortingInfo(WID_DATE_CREATED, true));
		aSortOrder.Append(CntSortingInfo(WID_DOCUMENT_SIZE, true));
		pClassDefs->Put(aSortOrder);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_BEAMER);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_FILEDLG);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_FLDWIN_DETAILS);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_FLDWIN_ICON);

		CntStringListItem aHeaderConfig(WID_HEADER_CONFIG);
		aHeaderConfig.
			SetString(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
				                                  "t\nNonRFC-Title\001b\n"
												      "From:\nDate:\n"
												      "NonRFC-Size\n"
												      "Comments:\nKeywords:\n"
												      "NonRFC-UserFields")));
		pClassDefs->Put(aHeaderConfig);

		pClassDefs->Put(CntIdentifierListItem(WID_PROPERTYLIST,
										      CNT_TABPAGE_GENERAL,
										      CNT_TABPAGE_FTP_SERVER,
										      CNT_TABPAGE_RULES,
										      CNT_TABPAGE_VIEW_PROPERTIES,
										      CNT_TABPAGE_DESCRIPTION,
										      CNT_TABPAGE_BACKGROUND,
										      CNT_TABPAGE_FONT, 0));

		pClassDefs->
			Put(CntTargetFrameItem(WID_TARGET_FRAMES,
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM("_beamer")),
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM("_top")),
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM(
										   "_blank"))));

		pClassDefs->Put(CntUShortListItem(WID_RENAME, WID_TITLE, 0));

		pClassDefs->Put(CntStringItem(WID_SERVERNAME, String()));
		pClassDefs->Put(CntUInt16Item(WID_FTP_SERVERSYSTEM,
									  CntFTPImp::SYSTEM_UNKNOWN));

		pClassDefs->Put(CntMsgStoreModeItem(WID_MESSAGE_STOREMODE));
	}
	CntInterface::SetParent(pClassDefs);

	m_pImp = new CntFTPImp(*this);
}

//============================================================================
// virtual
CntFTPBoxNode::~CntFTPBoxNode()
{
	delete m_pImp;
}

//============================================================================
// virtual
const SfxPoolItem * CntFTPBoxNode::ExecuteJob(CntNodeJob * pJob)
{
	if (pJob->GetRequestData())
		return
			static_cast< chaos::ThreadTask * >(pJob->GetRequestData())->run();

	m_pImp->initialize(*pJob);
	if (pJob->GetSubject() == this)
		switch (pJob->GetRequest()->Which())
		{
			case WID_SERVERNAME:
				if (m_pImp->changeUserHost(*pJob, 0,
										   &ITEM_VALUE(CntStringItem,
													   *pJob->GetRequest())))
					return 0;
				break;

			case WID_USERNAME:
				if (m_pImp->changeUserHost(*pJob,
										   &ITEM_VALUE(CntStringItem,
													   *pJob->GetRequest()),
										   0))
					return 0;
				break;

			case WID_SERVERBASE:
				m_pImp->changeBase(*pJob,
								   ITEM_VALUE(CntStringItem,
											  *pJob->GetRequest()));
				pJob->Done();
				return 0;

			case WID_PUTDATA:
			{
				const CntItemListItem & rList
					= *static_cast< const CntItemListItem * >(
						   pJob->GetRequest());

				bool bUserPresent = false;
				String aUser;
				bool bHostPresent = false;
				String aHost;
				USHORT nBaseIndex = USHORT(-1);
				for (USHORT i = 0; i < rList.Count(); ++i)
				{
					const SfxPoolItem & rItem = rList[i];
					switch (rItem.Which())
					{
						case WID_USERNAME:
							bUserPresent = true;
							aUser = ITEM_VALUE(CntStringItem, rItem);
							break;

						case WID_SERVERNAME:
							bHostPresent = true;
							aHost = ITEM_VALUE(CntStringItem, rItem);
							break;

						case WID_SERVERBASE:
							nBaseIndex = i;
							break;
					}
				}

				if ((bUserPresent || bHostPresent)
					&& m_pImp->changeUserHost(*pJob,
											  bUserPresent ? &aUser : 0,
											  bHostPresent ? &aHost : 0))
					return 0;

				if (nBaseIndex != USHORT(-1))
				{
					m_pImp->changeBase(*pJob,
									   ITEM_VALUE(CntStringItem,
												  rList[nBaseIndex]));
					const_cast< CntItemListItem & >(rList).Remove(nBaseIndex);
						// HACK to remove the item from the request's list
				}

				break;
			}

			case WID_OPEN:
			case WID_UPDATE:
			case WID_SYNCHRONIZE:
			case WID_SEARCH:
				return (new CntFTPOpenFolderTask(*pJob, *m_pImp))->run();

			case WID_IS_READ:
			case WID_IS_MARKED:
				return (new CntFTPFlagFolderTask(*pJob, *m_pImp))->run();

			case WID_TRANSFER:
				return (new CntFTPTransferDocTask(*pJob, *m_pImp))->run();

			case WID_CLEAN_CACHE:
				return (new CntFTPCleanCacheTask(*pJob, *m_pImp))->run();

			case WID_MESSAGE_STOREMODE:
			{
				CntNodeRef xBoxRedirectNode;
				GetTarget(xBoxRedirectNode);
				if (xBoxRedirectNode.Is())
					xBoxRedirectNode->Put(*pJob->GetRequest());
				break;
			}

			case WID_CONNECTION_MODE:
				return (new CntFTPCloseConnectionTask(*pJob, *m_pImp))->run();

			case WID_CREATE_NEW:
			{
				static sal_Int32 nCount = 0;
				String aUrl(OWN_URL(pJob->GetSubject()));
				aUrl += sal_Unicode('[');
				aUrl += String::CreateFromInt32(nCount++);
				aUrl += sal_Unicode(']');
				CntItemListItem const * pList
					= static_cast< CntItemListItem const * >(
						  pJob->GetRequest());
				const_cast< CntItemListItem * >(pList)->
					Append(new CntStringItem(WID_OWN_URL, aUrl));
				break;
			}
		}
	else if (pJob->GetSubject()->ISA(CntFTPFolderNode))
		switch (pJob->GetRequest()->Which())
		{
			case WID_GETDATA:
				m_pImp->GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
												   pJob->GetSubject()));
				pJob->GetSubject()->CntNode::ExecuteJob(pJob);
				return 0;

			case WID_PUTDATA:
			{
				const CntItemListItem & rList
					= *static_cast< const CntItemListItem * >(
						   pJob->GetRequest());
				for (USHORT i = 0; i < rList.Count();)
				{
					const SfxPoolItem & rItem = rList[i];
					if (rItem.Which() == WID_TITLE)
					{
						pJob->GetClient()->Put(rItem);
						const_cast< CntItemListItem & >(rList).Remove(i);
							// HACK to remove the item from the request's list
					}
					else
						++i;
				}
				break;
			}

			case WID_OPEN:
			case WID_UPDATE:
			case WID_SYNCHRONIZE:
			case WID_SEARCH:
				return (new CntFTPOpenFolderTask(*pJob, *m_pImp))->run();

			case WID_INSERT:
				return (new CntFTPMakeFolderTask(*pJob, *m_pImp))->run();

			case WID_TITLE:
			{
				String aUrl(OWN_URL(pJob->GetSubject()));
				if (aUrl.Len() > 0
					&& aUrl.GetChar(aUrl.Len() - 1) == sal_Unicode(']'))
				{
					aUrl.Erase(aUrl.SearchBackward(sal_Unicode('[')));
					aUrl += CntFTPURL::encodeFSegment(
						        ITEM_VALUE(CntStringItem,
										   *pJob->GetRequest()));
					aUrl += '/';
					pJob->
						GetSubject()->CntNode::Put(CntStringItem(WID_OWN_URL,
																 aUrl),
												   WID_OWN_URL);
				}
				else
					return
						(new CntFTPRenameFolderTask(*pJob, *m_pImp))->run();
				break;
			}

			case WID_DELETE:
				return (new CntFTPDeleteFolderTask(*pJob, *m_pImp))->run();

			case WID_UNDELETE:
				return (new CntFTPUndeleteFolderTask(*pJob, *m_pImp))->run();

			case WID_IS_READ:
			case WID_IS_MARKED:
				return (new CntFTPFlagFolderTask(*pJob, *m_pImp))->run();

			case WID_TRANSFER:
				return (new CntFTPTransferDocTask(*pJob, *m_pImp))->run();

			case WID_CREATE_NEW:
			{
				static sal_Int32 nCount = 0;
				String aUrl(OWN_URL(pJob->GetSubject()));
				aUrl += sal_Unicode('[');
				aUrl += String::CreateFromInt32(nCount++);
				aUrl += sal_Unicode(']');
				CntItemListItem const * pList
					= static_cast< CntItemListItem const * >(
						pJob->GetRequest());
				const_cast< CntItemListItem * >(pList)->
					Append(new CntStringItem(WID_OWN_URL, aUrl));
				break;
			}
		}
	else if (pJob->GetSubject()->ISA(CntFTPDocNode))
		switch (pJob->GetRequest()->Which())
		{
			case WID_GETDATA:
				m_pImp->GetDocNodeData(PTR_CAST(CntFTPDocNode,
												pJob->GetSubject()));
				pJob->GetSubject()->CntNode::ExecuteJob(pJob);
				return 0;

			case WID_PUTDATA:
			{
				const CntItemListItem & rList
					= *static_cast< const CntItemListItem * >(
						   pJob->GetRequest());
				for (USHORT i = 0; i < rList.Count();)
				{
					const SfxPoolItem & rItem = rList[i];
					if (rItem.Which() == WID_TITLE)
					{
						pJob->GetClient()->Put(rItem);
						const_cast< CntItemListItem & >(rList).Remove(i);
							// HACK to remove the item from the request's list
					}
					else
						++i;
				}
				break;
			}

			case WID_OPEN:
			case WID_UPDATE:
			case WID_SYNCHRONIZE:
				return (new CntFTPRetrieveDocTask(*pJob, *m_pImp))->run();

			case WID_INSERT:
				return (new CntFTPStoreDocTask(*pJob, *m_pImp))->run();

			case WID_TITLE:
			{
				String aUrl(OWN_URL(pJob->GetSubject()));
				if (aUrl.Len() > 0
					&& aUrl.GetChar(aUrl.Len() - 1) == sal_Unicode(']'))
				{
					aUrl.Erase(aUrl.SearchBackward(sal_Unicode('[')));
					aUrl += CntFTPURL::encodeFSegment(
						        ITEM_VALUE(CntStringItem,
										   *pJob->GetRequest()));
					pJob->
						GetSubject()->CntNode::Put(CntStringItem(WID_OWN_URL,
																 aUrl),
												   WID_OWN_URL);
				}
				else
					return (new CntFTPRenameDocTask(*pJob, *m_pImp))->run();
				break;
			}

			case WID_DELETE:
				return (new CntFTPDeleteDocTask(*pJob, *m_pImp))->run();

			case WID_UNDELETE:
				return (new CntFTPUndeleteDocTask(*pJob, *m_pImp))->run();

			case WID_IS_READ:
			case WID_IS_MARKED:
				m_pImp->FlagDoc(pJob->GetSubject(), pJob->GetRequest());
				pJob->Done();
				return 0;

			case WID_MESSAGE_STOREMODE:
				m_pImp->SetDocNodePersistence(pJob);
				return 0;
		}
	return CntNode::ExecuteJob(pJob);
}

//============================================================================
// virtual
BOOL CntFTPBoxNode::JobFinished(CntNodeJob * pJob)
{
	bool bFinished = CntFTPRedirectNode::JobFinished(pJob) != false;

#if 0
	bool bQueuedJobs = false;
	CntNodeJobQueue * pQueue = GetJobQueue();
	if (pQueue && pQueue->Count())
	{
		CntNodeJobList * pList = pQueue->GetObject(0);
		if (pList && pList->Count())
			bQueuedJobs = true;
	}
	if (!IsDead() && !bQueuedJobs
		&& (pJob->GetRequest()->Which() != WID_CONNECTION_MODE
			|| ITEM_VALUE(CntConnModeItem, pJob->GetRequest())
			       != CNT_CONN_MODE_OFFLINE))
		InsertJob(new CntNodeJob(0, this, this,
								 CntConnModeItem(WID_CONNECTION_MODE,
												 CNT_CONN_MODE_OFFLINE)));
#endif

	return bFinished;
}

//============================================================================
// virtual
void CntFTPBoxNode::SetConnMode(CntConnMode eMode)
{
	CntConnMode eOldMode = m_pImp->GetConnMode();
	m_pImp->SetConnMode(eMode);
	if (eOldMode == CNT_CONN_MODE_ONLINE && eMode != CNT_CONN_MODE_ONLINE)
		InsertJob(new CntNodeJob(0, this, this,
								 CntConnModeItem(WID_CONNECTION_MODE,
												 CNT_CONN_MODE_OFFLINE)));
}

//============================================================================
//
//  class CntFTPFolderNode
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntFTPFolderNode, CntFTPRedirectNode)

//============================================================================
CNT_NODE_SUBCLASS_IMPL(CntFTPFolderNode)
{
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM("/*/")),
									 '/', TYPE(CntFTPFolderNode),
									 CONTENT_TYPE_X_CNT_FTPFOLDER,
									 CNT_CREATION_FLAG_TITLE
									 	| CNT_CREATION_FLAG_KIND_FOLDER,
									 HID_CHAOS_NEW_FTP_BOX));
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM("/*")),
									 String(), TYPE(CntFTPDocNode),
									 CONTENT_TYPE_X_CNT_FTPFILE,
									 CNT_CREATION_FLAG_HIDDEN
									 	| CNT_CREATION_FLAG_INSERT_WITH_STREAM
									 	| CNT_CREATION_FLAG_TITLE
										| CNT_CREATION_FLAG_KIND_DOCUMENT));
}

//============================================================================
CntFTPFolderNode::CntFTPFolderNode():
	CntFTPRedirectNode(aCntFTPFolderRanges),
	m_pImp(0)
{
	CntDefaults * pClassDefs = GetDefaults();
	if (!pClassDefs)
	{
		pClassDefs = new CntDefaults(*this, aCntFTPFolderRanges);

		pClassDefs->Put(CntContentTypeItem(WID_CONTENT_TYPE,
										   CONTENT_TYPE_X_CNT_FTPFOLDER));

		pClassDefs->Put(CntBoolItem(WID_FLAG_IS_FOLDER, true));
		pClassDefs->Put(CntBoolItem(WID_FLAG_HAS_FOLDER, true));
		pClassDefs->Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, true));

		CntViewColumnsListItem aColumnOrder(WID_VIEW_COLS_BEAMER,
											WID_TITLE, DEF_WIDTH_TITLE_FSYS,
											WID_DOCUMENT_SIZE,
											    DEF_WIDTH_DOCUMENT_SIZE,
											WID_IS_MARKED,
											    DEF_WIDTH_IS_MARKED,
											WID_IS_READ, DEF_WIDTH_IS_READ,
											WID_DATE_CREATED,
											    DEF_WIDTH_DATE_CREATED, 0);
		pClassDefs->Put(aColumnOrder);
		pClassDefs->Put(aColumnOrder, WID_VIEW_COLS_FILEDLG);
		pClassDefs->Put(aColumnOrder, WID_VIEW_COLS_FLDWIN);

		CntSortingItem aSortOrder(WID_SORTING);
		aSortOrder.Append(CntSortingInfo(WID_TITLE, true));
		aSortOrder.Append(CntSortingInfo(WID_DATE_CREATED, true));
		aSortOrder.Append(CntSortingInfo(WID_DOCUMENT_SIZE, true));
		pClassDefs->Put(aSortOrder);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_BEAMER);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_FILEDLG);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_FLDWIN_DETAILS);
		pClassDefs->Put(aSortOrder, WID_VIEW_SORT_FLDWIN_ICON);

		CntStringListItem aHeaderConfig(WID_HEADER_CONFIG);
		aHeaderConfig.
			SetString(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
				                                  "t\nNonRFC-Title\001b\n"
												      "From:\nDate:\n"
												      "NonRFC-Size\n"
												      "Comments:\n"
												      "Keywords:\n"
												      "NonRFC-UserFields")));
		pClassDefs->Put(aHeaderConfig);

		pClassDefs->Put(CntIdentifierListItem(WID_PROPERTYLIST,
										      CNT_TABPAGE_GENERAL,
										      CNT_TABPAGE_RULES,
										      CNT_TABPAGE_VIEW_PROPERTIES,
										      CNT_TABPAGE_DESCRIPTION,
										      CNT_TABPAGE_CONTENT_PROPERTIES,
										      CNT_TABPAGE_BACKGROUND,
										      CNT_TABPAGE_FONT,
										      0));

		pClassDefs->
			Put(CntTargetFrameItem(WID_TARGET_FRAMES,
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM("_beamer")),
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM("_top")),
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM(
										   "_blank"))));

		pClassDefs->Put(CntUShortListItem(WID_RENAME, WID_TITLE, 0));
	}
	CntInterface::SetParent(pClassDefs);

	m_pImp = new CntFTPFolderImp(*this);
}

//============================================================================
// virtual
CntFTPFolderNode::~CntFTPFolderNode()
{
	delete m_pImp;
}

//============================================================================
// virtual
const SfxPoolItem * CntFTPFolderNode::InsertJob(CntNodeJob * pJob)
{
	switch (pJob->GetRequest()->Which())
	{
		case WID_GETDATA:
		case WID_PUTDATA:
		case WID_OPEN:
		case WID_UPDATE:
		case WID_SYNCHRONIZE:
		case WID_SEARCH:
		case WID_INSERT:
		case WID_TITLE:
		case WID_DELETE:
		case WID_UNDELETE:
		case WID_IS_READ:
		case WID_IS_MARKED:
		case WID_TRANSFER:
		case WID_CREATE_NEW:
			return GetRootNode()->InsertJob(pJob);

		default:
			return CntNode::InsertJob(pJob);
	}
}

//============================================================================
//
//  class CntFTPDocNode
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntFTPDocNode, CntDocumentNode);

//============================================================================
CNT_NODE_SUBCLASS_IMPL(CntFTPDocNode)
{}

//============================================================================
CntFTPDocNode::CntFTPDocNode():
	CntDocumentNode(aCntFTPDocRanges),
	m_bInitialized(false)
{
	CntDefaults * pClassDefs = GetDefaults();
	if (!pClassDefs)
	{
		pClassDefs = new CntDefaults(*this, aCntFTPDocRanges,
									 CntDocumentNode::GetDefaults());

		pClassDefs->Put(CntContentTypeItem(WID_CONTENT_TYPE,
									       CONTENT_TYPE_X_CNT_FTPFILE));

		pClassDefs->Put(CntUShortListItem(WID_RENAME, WID_TITLE, 0));
		pClassDefs->DisableItem(WID_DOCUMENT_SIZE);
	}
	CntInterface::SetParent(pClassDefs);
}

//============================================================================
// virtual
const SfxPoolItem * CntFTPDocNode::InsertJob(CntNodeJob * pJob)
{
	switch (pJob->GetRequest()->Which())
	{
		case WID_GETDATA:
		case WID_PUTDATA:
		case WID_OPEN:
		case WID_UPDATE:
		case WID_SYNCHRONIZE:
		case WID_INSERT:
		case WID_TITLE:
		case WID_DELETE:
		case WID_UNDELETE:
		case WID_IS_READ:
		case WID_IS_MARKED:
		case WID_MESSAGE_STOREMODE:
			return GetRootNode()->InsertJob(pJob);

		default:
			return CntNode::InsertJob(pJob);
	}
}

