/*************************************************************************
 *
 *  $RCSfile: coutnntp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:42:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _COUTNNTP_CXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _DATEITEM_HXX
#include <svtools/dateitem.hxx>
#endif

#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif

#ifndef _CNTOUTIMP_HXX
#include <coutimp.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif
#ifndef _CHAOS_MBXFORMT_HXX
#include <mbxformt.hxx>
#endif

using namespace chaos;

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

#ifndef ERRCODE_CHAOS_LOGIN_FAILURE
#define ERRCODE_CHAOS_LOGIN_FAILURE ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE
#endif

/*========================================================================
 *
 * CntOutNNTP... internals.
 *
 *======================================================================*/
#define SERVICE_READY          (INETCORENNTP_REPLY_SERVICE_READY)
#define TRANSFER_WAIT          (INETCORENNTP_REPLY_TRANSFER_WAIT)

#define AUTHINFO_REQUIRED      (INETCORENNTP_REPLY_AUTHINFO_REQUIRED)
#define MORE_AUTHINFO_REQUIRED (INETCORENNTP_REPLY_MORE_AUTHINFO_REQUIRED)
#define AUTHINFO_ACCEPTED      (INETCORENNTP_REPLY_AUTHINFO_ACCEPTED)
#define AUTHINFO_REJECTED      (INETCORENNTP_REPLY_AUTHINFO_REJECTED)

#define PERMISSION_DENIED      (INETCORENNTP_REPLY_PERMISSION_DENIED)

/*========================================================================
 *
 * CntOutNNTP_Impl.
 *
 *======================================================================*/
class CntOutNNTP_Impl
{
public:
	/** initAuthentication.
	*/
	static void initAuthentication (
		const CntNodeRef       &rxNode,
		const CntRecipientInfo &rRcptInfo);

	/** clearAuthentication.
	*/
	static void clearAuthentication (
		const CntNodeRef &rxNode);

	/** formatProtocolError.
	*/
	static void formatProtocolError (ByteString &rReplyText);
};

/*
 * initAuthentication.
 */
void CntOutNNTP_Impl::initAuthentication (
	const CntNodeRef       &rxNode,
	const CntRecipientInfo &rRcptInfo)
{
	if (rxNode.Is())
	{
		// Check initialization.
		const SfxPoolItem *pItem = NULL;
		rxNode->GetItemState (WID_SERVERNAME, FALSE, &pItem);
		if (pItem == NULL)
		{
			// Prepare Account and Server.
			rxNode->Put (CntStringItem (
				WID_ACCOUNT, rRcptInfo.GetNewsRecipient()));
			rxNode->Put (CntStringItem (
				WID_SERVERNAME, rRcptInfo.GetServer()));

			// Prepare Username and Password.
			rxNode->Put (CntStringItem (
				WID_USERNAME, rRcptInfo.GetUsername()));
			rxNode->Put (CntStringItem (
				WID_PASSWORD, rRcptInfo.GetPassword()));
		}
	}
}

/*
 * clearAuthentication.
 */
void CntOutNNTP_Impl::clearAuthentication (const CntNodeRef &rxNode)
{
	if (rxNode.Is())
	{
		rxNode->ClearItem (WID_ACCOUNT);
		rxNode->ClearItem (WID_SERVERNAME);

		rxNode->ClearItem (WID_USERNAME);
		rxNode->ClearItem (WID_PASSWORD);
	}
}

/*
 * formatProtocolError.
 * (Format ReplyText as ProtocolError string).
 */
void CntOutNNTP_Impl::formatProtocolError (ByteString &rReplyText)
{
	xub_StrLen nPos = rReplyText.Len();
	if (nPos > 0)
	{
		if (rReplyText.GetChar (nPos - 1) == '\n')
			rReplyText.Erase (nPos - 1);

		while ((nPos = rReplyText.Search ('\n')) != STRING_NOTFOUND)
			rReplyText.Erase (0, nPos + 1);
	}
}

/*========================================================================
 *
 * CntOutNNTPJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutNNTPJob_Impl.
 */
CntOutNNTPJob_Impl::CntOutNNTPJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pMailer      (NULL),
	  m_pMessage     (NULL),
	  m_pRcptInfo    (NULL),
	  m_nHintId      (0),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutNNTPJob_Impl.
 */
CntOutNNTPJob_Impl::~CntOutNNTPJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutNNTPJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutNNTPJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Check request.
	const SfxPoolItem *pReq = pJob->GetRequest();
	DBG_ASSERT (pReq, "CntOutNNTPJob_Impl::Execute(): no Request");
	if (pReq == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Obtain RecipientInfo.
		m_pRcptInfo = ITEM_VALUE (CntRecipientInfoItem, *pReq);
		DBG_ASSERT(
			m_pRcptInfo, "CntOutNNTPJob_Impl::Execute(): no Recipient");
		if (m_pRcptInfo == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check State.
		USHORT eState = m_pRcptInfo->GetState();
		if (!((eState == CNTOUT_ISTATE_WRITTEN) ||
			  (eState == CNTOUT_ISTATE_ERROR  )    ))
		{
			// Nothing to do.
			pJob->Done();
			return NULL;
		}

		// Check SendTries.
		USHORT nSendTries = m_pRcptInfo->GetSendTries();
		if (!(nSendTries < COUTIMP_SENDTRIES_LIMIT))
		{
			// Mark undeliverable.
			m_pRcptInfo->SetState (CNTOUT_ISTATE_FATALERROR);

			// Done.
			pJob->Done();
			return NULL;
		}

		// Obtain subject.
		CntNodeRef xSubject (pJob->GetSubject());
		DBG_ASSERT(
			xSubject.Is(), "CntOutNNTPJob_Impl::Execute(): no Subject");
		if (!xSubject.Is())
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain message body.
		const CntMessageBodyItem &rBody =
			(const CntMessageBodyItem&)(xSubject->Get(WID_MESSAGEBODY));
		m_pMessage = rBody.Get();
		DBG_ASSERT(
			m_pMessage, "CntOutNNTPJob_Impl::Execute(): no Message");
		if (m_pMessage == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain mailer.
		m_pMailer = GetParent()->GetMailer();
		DBG_ASSERT(
			m_pMailer, "CntOutNNTPJob_Impl::Execute(): no Mailer");
		if (m_pMailer == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Initialize protocol error.
		m_pRcptInfo->SetProtocolError (0);
		m_pRcptInfo->SetProtocolErrorStr (String());

		// Next state.
		m_eState = STATE_CLOSED;
		if (m_pMailer->NewsIsOpen())
		{
			// Close connection.
			if (!m_pMailer->NewsCloseConnection (ExecuteCallback, this))
			{
				// Failure. Abort connection.
				m_pMailer->NewsAbortConnection();

				// Try again.
				m_eState = STATE_NONE;
				GetRootNode()->RescheduleJob (pJob);
			}

			// Wait for next callback.
			return NULL;
		}
	}

	// Jump into state machine.
	ExecuteHandler (m_pMailer, SERVICE_READY, NULL);
	return NULL;
}

/*
 * ExecuteCallback.
 */
sal_Bool CntOutNNTPJob_Impl::ExecuteCallback (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{
	// Check context.
	CntOutNNTPJob_Impl *pThis = (CntOutNNTPJob_Impl *)pData;
	DBG_ASSERT(
		pThis, "CntOutNNTPJob_Impl::ExecuteCallback(): no pThis");
	if (pThis == NULL)
		return sal_False;

	// Handle callback reason.
	pThis->AddRef();
	pThis->ExecuteHandler (pMailer, nReplyCode, pReplyText);
	pThis->ReleaseRef();

	// Wait for next callback.
	return sal_True;
}

/*
 * ExecuteHandler.
 */
void CntOutNNTPJob_Impl::ExecuteHandler (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText)
{
	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutNNTPJob_Impl::ExecuteHandler(): no Job");
	if (pJob == NULL)
		return;

	// Jump into state machine.
	while (1)
	{
		switch (m_eState)
		{
			case STATE_CLOSED:
				if (nReplyCode/100 == 2)
				{
					// Connection closed. Obtain Host and Port.
					String aHost;
					USHORT nPort;

					String aEndpoint (m_pRcptInfo->GetServer());
					CntMBXFormat::decomposeDomainAndPort (
						aEndpoint, aHost, nPort);

					// Notify caller (ShowStatusText).
					String aStatusText (CntResId (
						RID_PROT_CONNECTING_TO_SERVER));
					aStatusText.SearchAndReplace (S2U ("$(ARG1)"), aEndpoint);

					m_nHintId = 1;
					Broadcast (CntStatusBarHint (aStatusText));

					// Establish new connection.
					m_eState = STATE_OPEN;
					if (!m_pMailer->NewsOpenConnection (
						aHost, nPort, ExecuteCallback, this))
					{
						// Failure.
						if (m_nHintId)
						{
							// Remove StatusText.
							m_nHintId = 0;
							Broadcast (CntStatusBarHint (String()));
						}

						// Set recipient info.
						m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);

						m_pRcptInfo->SetProtocolError (
							INETCORENNTP_REPLY_CONNECT_ERROR);

						if (aHost.Len() == 0)
							m_pRcptInfo->SetProtocolErrorStr (CntResId (
								RID_PROT_ERROR_NO_SERVER_NAME));
						else
							m_pRcptInfo->SetProtocolErrorStr (CntResId (
								RID_PROT_ERROR_CONNECT_ERROR));

						// Notify caller.
						if (!pJob->SetError (ERRCODE_CHAOS_CONNECT_FAILURE))
						{
							// Try again.
							m_eState = STATE_NONE;
							GetRootNode()->RescheduleJob (pJob);
						}
					}

					// Wait for next callback.
					return;
				}
				else
				{
					// Failure. Abort connection.
					m_pMailer->NewsAbortConnection();

					// Try again.
					m_eState = STATE_NONE;
					GetRootNode()->RescheduleJob (pJob);
				}
				break;

			case STATE_OPEN:
				if (nReplyCode/100 == 2)
				{
					// Connection opened. Check PostingAllowed.
					if (m_pMailer->NewsIsPostingAllowed())
					{
						// Setup recipient header fields.
						m_pMessage->SetTo (
							m_pRcptInfo->GetToRecipient());
						m_pMessage->SetCC (
							m_pRcptInfo->GetCcRecipient());
						m_pMessage->SetBCC (
							m_pRcptInfo->GetBccRecipient());
						m_pMessage->SetNewsgroups (
							m_pRcptInfo->GetNewsRecipient());

						// Reset CreationDate and MessageID.
						m_pMessage->SetDate (String());
						m_pMessage->SetMessageID (String());

						// Increment SendTries.
						USHORT nSendTries = m_pRcptInfo->GetSendTries();
						m_pRcptInfo->SetSendTries (nSendTries + 1);

						// Post article.
						m_eState = STATE_SEND;

						m_pMailer->NewsSetTransferCallback (
							ExecuteCallback, this);

						if (!m_pMailer->NewsPostArticle (
							*m_pMessage, ExecuteCallback, this))
						{
							// Set recipient info.
							m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);

							/*
							 * @@@ NEED BETTER ERROR DESCRIPTION @@@.
							 */
							m_pRcptInfo->SetProtocolError (0);
							m_pRcptInfo->SetProtocolErrorStr (CntResId (
								RID_CNTOUT_MAILSTATE_NOT_SENT));

							// Notify caller.
							if (!pJob->SetError (ERRCODE_IO_UNKNOWN))
							{
								// Try again.
								m_eState = STATE_NONE;
								GetRootNode()->RescheduleJob (pJob);
							}
						}

						// Wait for next callback.
						return;
					}
					else
					{
						// Posting not allowed.
						m_pRcptInfo->SetState (CNTOUT_ISTATE_FATALERROR);

						m_pRcptInfo->SetProtocolError (SERVICE_READY);
						m_pRcptInfo->SetProtocolErrorStr (CntResId (
							RID_PROT_ERROR_NO_POSTING_ALLOWED));

						// Done.
						m_eState = STATE_DONE;
					}
				}
				else if ((nReplyCode == PERMISSION_DENIED) ||
						 (nReplyCode == AUTHINFO_REQUIRED)    )
				{
					// Failure.
					if (m_nHintId)
					{
						// Remove StatusText.
						m_nHintId = 0;
						Broadcast (CntStatusBarHint (String()));
					}

					// Authenticate.
					CntOutNNTP_Impl::clearAuthentication (pJob->GetSubject());
					m_eState = STATE_AUTH;
				}
				else
				{
					// Failure.
					SetProtocolError (nReplyCode, pReplyText);
					m_eState = STATE_DONE;
				}
				break;

			case STATE_SEND:
				if (nReplyCode/100 == 2)
				{
					// Clear transfer callback.
					m_pMailer->NewsSetTransferCallback (NULL, NULL);

					// Setup StatusText.
					String aStatusText (CntResId (
						RID_PROT_SENDING_MESSAGE));
					aStatusText.SearchAndReplace (
						S2U("$(ARG1)"), UniString());
					aStatusText.SearchAndReplace (
						S2U("$(ARG2)"),
						UniString::CreateFromInt32 (
							m_pMailer->NewsGetTransferCount()));

					// Notify caller (ShowStatusText).
					m_nHintId = 1;
					Broadcast (CntStatusBarHint (aStatusText));

					// Save new MessageID and CreationDate.
					DateTime aDateTime (Date(0), Time(0));
					if (m_pMessage->ParseDateField (
						m_pMessage->GetDate(), aDateTime, aDateTime))
					{
						CntNode *pSubject = pJob->GetSubject();
						aDateTime.ConvertToLocalTime();

						pSubject->Put (SfxDateTimeItem (
							WID_DATE_CREATED, aDateTime));
						pSubject->Put (CntStringItem (
							WID_MESSAGE_ID, m_pMessage->GetMessageID()));
					}

					// Mark message sent.
					m_pRcptInfo->SetState (CNTOUT_ISTATE_SENT);

					m_pRcptInfo->SetProtocolError (nReplyCode);
					if (pReplyText)
					{
						ByteString aReplyText (pReplyText);
						CntOutNNTP_Impl::formatProtocolError (aReplyText);
						m_pRcptInfo->SetProtocolErrorStr (
							UniString (aReplyText, RTL_TEXTENCODING_UTF8));
					}

					// Close connection.
					m_eState = STATE_DONE;
					if (m_pMailer->NewsCloseConnection (
						ExecuteCallback, this))
					{
						// Wait for next callback.
						return;
					}
				}
				else if (nReplyCode == TRANSFER_WAIT)
				{
					// Setup StatusText.
					String aStatusText (CntResId (
						RID_PROT_SENDING_MESSAGE));
					aStatusText.SearchAndReplace (
						S2U("$(ARG1)"), UniString());
					aStatusText.SearchAndReplace (
						S2U("$(ARG2)"),
						UniString::CreateFromInt32 (
							m_pMailer->NewsGetTransferCount()));

					// Notify caller (ShowStatusText).
					m_nHintId = 1;
					Broadcast (CntStatusBarHint (aStatusText));

					// Wait for next callback.
					return;
				}
				else if ((nReplyCode == PERMISSION_DENIED) ||
						 (nReplyCode == AUTHINFO_REQUIRED)    )
				{
					// Failure.
					if (m_nHintId)
					{
						// Remove StatusText.
						m_nHintId = 0;
						Broadcast (CntStatusBarHint (String()));
					}

					// Clear transfer callback.
					m_pMailer->NewsSetTransferCallback (NULL, NULL);

					// Decrement SendTries.
					USHORT nSendTries = m_pRcptInfo->GetSendTries();
					m_pRcptInfo->SetSendTries (nSendTries - 1);

					// Authenicate.
					CntOutNNTP_Impl::clearAuthentication (pJob->GetSubject());
					m_eState = STATE_AUTH;
				}
				else
				{
					// Failure.
					SetProtocolError (nReplyCode, pReplyText);
					m_eState = STATE_DONE;
				}
				break;

			case STATE_AUTH:
				if (nReplyCode/100 == 2)
				{
					// Resume previous state.
					m_eState = STATE_OPEN;

					// Try again.
					GetRootNode()->RescheduleJob (pJob);
					return;
				}
				else if (nReplyCode == AUTHINFO_REQUIRED)
				{
					// Obtain Subject.
					CntNodeRef xSubject (pJob->GetSubject());

					// Initialize authentication.
					CntOutNNTP_Impl::initAuthentication (
						xSubject, *m_pRcptInfo);
					const String &rUsername = ITEMSET_VALUE_STRING(
						xSubject, WID_USERNAME);

					// Notify caller.
					UniString aReplyText (pReplyText, RTL_TEXTENCODING_UTF8);
					if (!rUsername.Len() && pJob->SetError (
						ERRCODE_CHAOS_LOGIN_FAILURE, &aReplyText, xSubject))
					{
						// Failure.
						m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);

						m_pRcptInfo->SetProtocolError (nReplyCode);
						if (pReplyText)
						{
							ByteString aReplyText (pReplyText);
							CntOutNNTP_Impl::formatProtocolError (aReplyText);
							m_pRcptInfo->SetProtocolErrorStr (
								UniString (aReplyText, RTL_TEXTENCODING_UTF8));
						}
					}
					else
					{
						// Send Username and Password.
						m_eState = STATE_USER;
						GetRootNode()->RescheduleJob (pJob);
					}

					// Wait for next callback.
					return;
				}
				else if (nReplyCode == MORE_AUTHINFO_REQUIRED)
				{
					// Missing Password.
					CntNodeRef xSubject (pJob->GetSubject());

					String aUserOld (ITEMSET_VALUE_STRING(
						xSubject, WID_USERNAME));

					// Notify caller.
					UniString aReplyText (pReplyText, RTL_TEXTENCODING_UTF8);
					if (pJob->SetError (
						ERRCODE_CHAOS_LOGIN_FAILURE, &aReplyText, xSubject))
					{
						// Failure.
						m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);

						m_pRcptInfo->SetProtocolError (nReplyCode);
						if (pReplyText)
						{
							ByteString aReplyText (pReplyText);
							CntOutNNTP_Impl::formatProtocolError (aReplyText);
							m_pRcptInfo->SetProtocolErrorStr (
								UniString (aReplyText, RTL_TEXTENCODING_UTF8));
						}
					}
					else
					{
						// Check for changed Username.
						String aUserNew (ITEMSET_VALUE_STRING(
							xSubject, WID_USERNAME));
						if (!(aUserNew == aUserOld))
						{
							// Send Username and Password.
							m_eState = STATE_USER;
						}
						else
						{
							// Send Password.
							m_eState = STATE_PASS;
						}
						GetRootNode()->RescheduleJob (pJob);
					}

					// Wait for next callback.
					return;
				}
				else if ((nReplyCode == AUTHINFO_REJECTED) ||
						 (nReplyCode == PERMISSION_DENIED)    )
				{
					// Obtain Subject.
					CntNodeRef xSubject (pJob->GetSubject());

					// Clear any previous authentication.
					CNT_RNM()->RemoveLoginInfo (OWN_URL (xSubject));
					CntOutNNTP_Impl::clearAuthentication (xSubject);

					// Authenticate.
					nReplyCode = AUTHINFO_REQUIRED;
				}
				else
				{
					// Failure.
					SetProtocolError (nReplyCode, pReplyText);
					m_eState = STATE_DONE;
				}
				break;

			case STATE_USER:
				if (pMailer->NewsIsOpen())
				{
					// Obtain Username and Password.
					CntNodeRef xSubject (pJob->GetSubject());

					const String &rUsername =
						ITEMSET_VALUE_STRING (xSubject, WID_USERNAME);
					const String &rPassword =
						ITEMSET_VALUE_STRING (xSubject, WID_PASSWORD);

					// Authenticate.
					m_eState = STATE_AUTH;
					if (pMailer->NewsAuthenticate (
						rUsername, rPassword, ExecuteCallback, this))
					{
						// Ok, wait for next callback.
						return;
					}

					// Authinfo required (missing username).
					nReplyCode = AUTHINFO_REQUIRED;
				}
				else
				{
					// Try again.
					m_eState = STATE_CLOSED;
					GetRootNode()->RescheduleJob (pJob);
					return;
				}
				break;

			case STATE_PASS:
				if (pMailer->NewsIsOpen())
				{
					// Obtain Password.
					CntNodeRef xSubject (pJob->GetSubject());

					const String &rPassword =
						ITEMSET_VALUE_STRING(xSubject, WID_PASSWORD);

					// Authenticate.
					m_eState = STATE_AUTH;
					if (pMailer->NewsAuthenticatePassword (
						rPassword, ExecuteCallback, this))
					{
						// Ok, wait for next callback.
						return;
					}

					// More Authinfo required (missing password).
					nReplyCode = MORE_AUTHINFO_REQUIRED;
				}
				else
				{
					// Try again.
					m_eState = STATE_CLOSED;
					GetRootNode()->RescheduleJob (pJob);
					return;
				}
				break;

			case STATE_DONE:
				if (nReplyCode/100 == 2)
				{
					// Done.
					m_eState = STATE_NONE;
					pJob->Done();
				}
				else
				{
					// Failure.
					m_eState = STATE_NONE;
					pJob->Cancel();
				}
				break;

			default: // STATE_NONE.
				return;
		}
	}
}

/*
 * SetProtocolError.
 */
void CntOutNNTPJob_Impl::SetProtocolError (
	sal_Int32 nReplyCode, const sal_Char *pReplyText)
{
	m_pRcptInfo->SetProtocolError (nReplyCode);
	switch (nReplyCode)
	{
		case INETCORENNTP_REPLY_NETWORK_ERROR:
			// Recoverable.
			m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);
			m_pRcptInfo->SetProtocolErrorStr (CntResId (
				RID_PROT_ERROR_NETWORK_ERROR));
			break;

		case INETCORENNTP_REPLY_RESOLVER_ERROR:
			// Recoverable.
			m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);
			m_pRcptInfo->SetProtocolErrorStr (CntResId (
				RID_PROT_ERROR_NAMERESOLVE_ERROR));
			break;

		case INETCORENNTP_REPLY_CONNECT_ERROR:
			// Recoverable.
			m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);
			m_pRcptInfo->SetProtocolErrorStr (CntResId (
				RID_PROT_ERROR_CONNECT_ERROR));
			break;

		default:
			if (nReplyCode/100 == 4)
			{
				// Recoverable (4xx).
				m_pRcptInfo->SetState (CNTOUT_ISTATE_ERROR);
			}
			else
			{
				// Unrecoverable (5xx).
				m_pRcptInfo->SetState (CNTOUT_ISTATE_FATALERROR);
			}
			if (pReplyText)
			{
				ByteString aReplyText (pReplyText);
				CntOutNNTP_Impl::formatProtocolError (aReplyText);
				m_pRcptInfo->SetProtocolErrorStr (
					UniString (aReplyText, RTL_TEXTENCODING_UTF8));
			}
			break;
	}
}

/*
 * Notify.
 */
void CntOutNNTPJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == GetJob()))
	{
		if (pJob->IsCancelled() || pJob->IsDone())
		{
			// Finished.
			EndListening (*pJob);
			if (m_nHintId)
			{
				// Remove StatusText.
				Broadcast (CntStatusBarHint (String()));
				m_nHintId = 0;
			}

			// Cleanup.
			CntOutNNTP_Impl::clearAuthentication (pJob->GetSubject());
			if (m_pMailer)
				m_pMailer->NewsAbortConnection();
		}
	}
	CntOutJob_Impl::Notify (rBC, rHint);
}

