/*************************************************************************
 *
 *  $RCSfile: stgview.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif
#ifndef _SVTREEBOX_HXX
#include <svtools/svtreebx.hxx>
#endif
#ifndef _SVT_FILEDLG_HXX
#include <svtools/filedlg.hxx>
#endif
#ifndef _SFXITEMITER_HXX
#include <svtools/itemiter.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _DATETIMEITEM_HXX //autogen
#include <svtools/dateitem.hxx>
#endif
#ifndef _DTRITEM_HXX //autogen
#include <svtools/dtritem.hxx>
#endif
#ifndef _RNGITEM_HXX
#include <svtools/rngitem.hxx>
#endif
#ifndef _SFXSLSTITM_HXX //autogen
#include <svtools/slstitm.hxx>
#endif
#ifndef _CSTITEM_HXX //autogen
#include <svtools/cstitem.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif

#ifndef _STGVIEW_HRC
#include "stgview.hrc"
#endif

#ifndef _CNTSTG_HXX
#include "..\..\source\inc\cntstg.hxx"
#endif
#ifndef _CNTSTORE_HXX
#include "..\..\source\inc\cntstore.hxx"
#endif
#ifndef _CASTMACS_HXX
#include "..\..\source\inc\castmacs.hxx"
#endif
#ifndef _CHAOS_STORITEM_HXX
#include "..\..\source\inc\storitem.hxx"
#endif
#ifndef _CNTSYS_HXX
#include "..\..\source\inc\cntsys.hxx"
#endif
#ifndef _ILSTITEM_HXX
#include "..\..\source\inc\ilstitem.hxx"
#endif
#ifndef _CNTRANGE_HXX
#include "..\..\source\inc\cntrange.hxx"
#endif
#ifndef _SORTITEM_HXX
#include "..\..\source\inc\sortitem.hxx"
#endif
#ifndef _CSTRITEM_HXX
#include "..\..\source\inc\cstritem.hxx"
#endif
#ifndef _OUTITEMS_HXX
#include "..\..\source\inc\outitems.hxx"
#endif
#ifndef _RCPNITEM_HXX
#include "..\..\source\inc\rcpnitem.hxx"
#endif
#ifndef _CHAOS_SILITEM_HXX
#include "..\..\source\inc\silitem.hxx"
#endif
#ifndef _ULSTITEM_HXX
#include "..\..\source\inc\ulstitem.hxx"
#endif
#ifndef _CNTXREF_HXX
#include "..\..\source\inc\cntxref.hxx"
#endif
#ifndef _DHDRITEM_HXX
#include "..\..\source\inc\dhdritem.hxx"
#endif
#ifndef _CHAOS_IMAPMITM_HXX
#include "..\..\source\inc\imapmitm.hxx"
#endif

#if defined TF_UCB
using namespace chaos;
#endif // TF_UCB

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF( CntStoreItemSet );
#endif

#define TYPE_STORAGEFILE	1
#define TYPE_DIRECTORY		2
#define TYPE_DIRENTRY		3
#define TYPE_STREAM			4
#define TYPE_ITEMSET		5
#define TYPE_ITEMLIST		6
#define TYPE_ITEM			7

/*========================================================================
 *
 * StgListBoxEntry.
 *
 *=======================================================================*/

class StgListBoxEntry : public SvLBoxEntry
{
	friend class StgTreeListBox;
	friend class StgViewerWin;

private:
	String		m_aURL;
	CntStorage* m_pStore;
	USHORT 		m_nTypeInfo;

    StgListBoxEntry* GetParent() { return (StgListBoxEntry*)GetUserData(); }

public:
    StgListBoxEntry();
    virtual ~StgListBoxEntry();
};

/*========================================================================
 *
 * StgTreeListBox.
 *
 *=======================================================================*/

class StgTreeListBox : public SvTreeListBox
{
private:
	Bitmap		 m_aItem;
	Bitmap  	 m_aStream;
	Bitmap  	 m_aDirEntry;
	Bitmap  	 m_aOpen;
	Bitmap  	 m_aClosed;
	Bitmap  	 m_aOpenStg;
	Bitmap  	 m_aClosedStg;
	Bitmap  	 m_aOpenItemSet;
	Bitmap  	 m_aClosedItemSet;
	Bitmap  	 m_aOpenItemList;
	Bitmap  	 m_aClosedItemList;
	SfxItemPool* m_pPool;

    virtual SvLBoxEntry* CreateEntry() const;
    virtual void         RequestingChilds( SvLBoxEntry* pParent );

public:
	StgTreeListBox( Window* pParent, WinBits nWinStyle = 0 );
	virtual ~StgTreeListBox();

    StgListBoxEntry* InsertEntry( const String& rName,
                                  USHORT nTypeInfo,
                                  StgListBoxEntry* pParent = NULL );
};

/*========================================================================
 *
 * StgViewerWin.
 *
 *=======================================================================*/

class StgViewerWin : public WorkWindow
{
	StgTreeListBox  	 m_aTree;
    const International& m_rInternational;

public:    StgViewerWin( Window *pParent, WinBits nWinStyle );
    ~StgViewerWin();

    virtual void Resize();

	void FillTree( const String& rStorageName );
	void FillTree( CntStorage* pStore, StgListBoxEntry* pParent );
	void FillTree( SfxItemSet *pItemSet, StgListBoxEntry* pParent );
	void FillTree( const SfxPoolItem *pItem, StgListBoxEntry* pParent );
};

/*========================================================================
 *
 * StgListBoxEntry implementation.
 *
 *=======================================================================*/

//-------------------------------------------------------------------------
StgListBoxEntry::StgListBoxEntry()
: m_pStore( NULL ),
  m_nTypeInfo( 0 )
{
}

//-------------------------------------------------------------------------
StgListBoxEntry::~StgListBoxEntry()
{
	delete m_pStore;
}

/*========================================================================
 *
 * StgTreeListBox implementation.
 *
 *=======================================================================*/

//-------------------------------------------------------------------------
StgTreeListBox::StgTreeListBox( Window* pParent, WinBits nWinStyle )
: SvTreeListBox( pParent, nWinStyle ),
  m_aItem( ResId( BMP_ITEM ) ),
  m_aStream( ResId( BMP_STREAM ) ),
  m_aDirEntry( ResId( BMP_DIRENTRY ) ),
  m_aOpen( ResId( BMP_OPEN ) ),
  m_aClosed( ResId( BMP_CLOSED ) ),
  m_aOpenStg( ResId( BMP_OPENSTG ) ),
  m_aClosedStg( ResId( BMP_CLOSEDSTG ) ),
  m_aOpenItemSet( ResId( BMP_OPENITEMSET ) ),
  m_aClosedItemSet( ResId( BMP_CLOSEDITEMSET ) ),
  m_aOpenItemList( ResId( BMP_OPENITEMLIST ) ),
  m_aClosedItemList( ResId( BMP_CLOSEDITEMLIST ) ),
  m_pPool( CntSystem::GetItemPool() )
{
}

//-------------------------------------------------------------------------
// virtual
StgTreeListBox::~StgTreeListBox()
{
	CntSystem::ReleaseItemPool();
}

//-------------------------------------------------------------------------
// virtual
SvLBoxEntry* StgTreeListBox::CreateEntry() const
{
	return new StgListBoxEntry();
}

//-------------------------------------------------------------------------
// virtual
void StgTreeListBox::RequestingChilds( SvLBoxEntry* pParent )
{
    StgListBoxEntry* p = (StgListBoxEntry*)pParent;
	if ( !p->HasChilds() )
	{
       	StgViewerWin* pViewer = (StgViewerWin*)Window::GetParent();

	    if ( p->m_nTypeInfo == TYPE_ITEMSET )
		{
        	CntStoreItemSetRef xItemSet(
					p->GetParent()->m_pStore->openItemSet(
							p->m_aURL, *m_pPool, STREAM_STD_READ, NULL ) );
        	if ( xItemSet.Is() )
				pViewer->FillTree( xItemSet, p );
		}
	}
}

//-------------------------------------------------------------------------
StgListBoxEntry* StgTreeListBox::InsertEntry( const String& rName,
                                        	  USHORT nTypeInfo,
                                        	  StgListBoxEntry* pParent )
{
    StgListBoxEntry* p;
    switch( nTypeInfo )
    {
        case TYPE_STORAGEFILE:
			p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
					rName, m_aOpen, m_aClosed, pParent );
            break;

        case TYPE_DIRECTORY:
             p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
			 		rName, m_aOpenStg, m_aClosedStg, pParent );
            break;

        case TYPE_DIRENTRY:
             p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
			 		rName, m_aDirEntry, m_aDirEntry, pParent );
            break;
        case TYPE_STREAM:
             p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
			 		rName, m_aStream, m_aStream, pParent );
            break;
        case TYPE_ITEMSET:
             p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
					rName, m_aOpenItemSet, m_aClosedItemSet, pParent, TRUE );
            break;
        case TYPE_ITEMLIST:
             p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
					rName, m_aOpenItemList, m_aClosedItemList, pParent );
            break;
        case TYPE_ITEM:
             p = (StgListBoxEntry*)SvTreeListBox::InsertEntry(
			 		rName, m_aItem, m_aItem, pParent );
            break;

        default:
            return NULL;
    }

    p->SetUserData( pParent );
    p->m_nTypeInfo = nTypeInfo;
    return p;
}

/*========================================================================
 *
 * StgViewerWin implementation.
 *
 *=======================================================================*/

//-------------------------------------------------------------------------
StgViewerWin::StgViewerWin( Window *pParent, WinBits nWinStyle )
: WorkWindow( pParent, nWinStyle ),
  m_aTree( this, WB_HSCROLL ),
  m_rInternational( Application::GetAppInternational() )
{
    Font aTreeFont( m_aTree.GetFont() );
    aTreeFont.SetName( String( RTL_CONSTASCII_USTRINGPARAM("Courier") ) );
    aTreeFont.SetFamily( FAMILY_MODERN );
    aTreeFont.SetPitch( PITCH_FIXED );
    aTreeFont.SetSize( Size( 0, 12 ) );

    m_aTree.SetFont( aTreeFont );
    m_aTree.SetIndent( 20 );
    m_aTree.SetPosPixel( Point( 0, 0 ) );

    m_aTree.Show();
}

//-------------------------------------------------------------------------
StgViewerWin::~StgViewerWin()
{
}

//-------------------------------------------------------------------------
void StgViewerWin::Resize()
{
    m_aTree.SetSizePixel( GetOutputSizePixel() );
}

//-------------------------------------------------------------------------
void StgViewerWin::FillTree( const String& rStorageName )
{
    StgListBoxEntry* pEntry =
				m_aTree.InsertEntry( rStorageName, TYPE_STORAGEFILE );

	pEntry->m_aURL =
		DirEntry( rStorageName, FSYS_STYLE_HOST ).GetFull( FSYS_STYLE_URL );

	pEntry->m_pStore = new CntRootStorage();
	pEntry->m_pStore->initialize( NULL, pEntry->m_aURL  );

	FillTree( pEntry->m_pStore, pEntry );
}

//-------------------------------------------------------------------------
void StgViewerWin::FillTree( CntStorage* pStore, StgListBoxEntry* pParent )
{
    ULONG nChildren = 0;

	CntStorageIterator aIter( 0, 0 );
	String aStr( pStore->iter( aIter ) );
    while( aStr.Len() ) {
        StgListBoxEntry* p = NULL;
		String aStr1( aStr );
        UINT32 nAttrib = (*aIter).m_nAttrib;

		// Obtain entry flags.
        if ( nAttrib & ~( CNTSTORE_ATTRIB_ISDIR | CNTDIRENTRY_ATTRIB_CREATE ) )
		{
            aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(" ["));
            if( nAttrib & CNTDIRENTRY_ATTRIB_HIDDEN )
                aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("Hidden,"));
            if( nAttrib & CNTDIRENTRY_ATTRIB_MARKED )
                aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("Marked,"));
            if( nAttrib & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE )
                aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					                 "MarkedForDelete,"));
			int nUser = 1;
			UINT32 nBit = CNTDIRENTRY_ATTRIB_USER1;
			while ( nBit < CNTSTORE_ATTRIB_ISLINK )
			{
				if ( nAttrib & nBit )
				{
					aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("USER"));
					aStr += String::CreateFromInt32(nUser);
					aStr += ',';
				}
				++nUser;
				nBit <<= 1;
			}
			if ( aStr.GetChar(aStr.Len() - 1) == '[' )
				aStr.Erase(aStr.Len() - 1 );
			else
            	aStr.SetChar(aStr.Len() - 1, ']');
        }

		// directory.
        if ( nAttrib & CNTSTORE_ATTRIB_ISDIR )
		{
            p = m_aTree.InsertEntry( aStr, TYPE_DIRECTORY, pParent );

            p->m_aURL = pParent->m_aURL;

			if ( pParent->m_nTypeInfo == TYPE_STORAGEFILE )
				p->m_aURL.AppendAscii(RTL_CONSTASCII_STRINGPARAM("#/"));

            p->m_aURL += aStr1;
            p->m_aURL += '/';

			p->m_pStore = new CntStorage();
			p->m_pStore->initialize( pStore, p->m_aURL  );

            FillTree( p->m_pStore, p );
        }
        else
		{
	        if ( nAttrib & CNTDIRENTRY_ATTRIB_CREATE )
			{
                p = m_aTree.InsertEntry( aStr, TYPE_DIRENTRY, pParent );
			}
#if 0
// ??? wie stream von itemset unterscheiden ???
//            else if ( !pIndexEntry->GetFirstBlock() )
//			  {
//                p = m_aTree.InsertEntry( aStr, TYPE_STREAM, pParent );
//			  }
#endif
            else
			{
                p = m_aTree.InsertEntry( aStr, TYPE_ITEMSET, pParent );
			}

            p->m_aURL = aStr1;
        }

        nChildren++;

        aStr = pStore->iter( aIter );
    }

//    if ( nChildren && ( pParent->m_nTypeInfo == TYPE_STORAGEFILE ) )
//        m_aTree.Expand( pParent );
}

//-------------------------------------------------------------------------
void StgViewerWin::FillTree( SfxItemSet *pItemSet, StgListBoxEntry* pParent )
{
    SfxItemIter aIter( *pItemSet );
    const SfxPoolItem *pItem  = aIter.FirstItem();
    while ( pItem )
	{
        FillTree( pItem, pParent );
        pItem  = aIter.NextItem();
    }
}

//-------------------------------------------------------------------------
void StgViewerWin::FillTree( const SfxPoolItem *pItem, StgListBoxEntry* pParent )
{
    StgListBoxEntry* p;
    USHORT nWhich = pItem->Which();
    String aStr(String::CreateFromInt32(nWhich));

    aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(": "));

    if ( pItem->ISA( CntItemListItem ) )
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(CntItemListItem)"));

        p = m_aTree.InsertEntry( aStr, TYPE_ITEMLIST, pParent );

        for( USHORT n = 0; n < ( (CntItemListItem*)pItem )->Count(); n++ )
            FillTree( &( *(CntItemListItem*)pItem )[ n ], p );

        return;
    }

    if ( pItem->ISA( CntUnencodedStringItem ) )
	{
        ((aStr += '\"') += ((const CntUnencodedStringItem*)pItem)->GetValue()) += '\"';
		if ( pItem->ISA(CntStringItem) && ((const CntStringItem*)pItem)->IsEncrypted() )
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(" (auto garbled)"));
	}
    else if ( pItem->ISA( CntEnumItem ) )
	{
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(enum)"));
		aStr += String::CreateFromInt32(((const CntEnumItem*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( CntByteItem ) )
	{
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(BYTE)"));
		aStr += String::CreateFromInt32(((const CntByteItem*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( SfxInt16Item ) )
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(INT16)"));
		aStr += String::CreateFromInt32(((const SfxInt16Item*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( CntUInt16Item ) )
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(UINT16)"));
		aStr += String::CreateFromInt32(((const CntUInt16Item*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( CntInt32Item ) )
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(INT32)"));
		aStr += String::CreateFromInt32(((const CntInt32Item*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( CntUInt32Item ) )
	{
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(UINT32)"));
		aStr += String::CreateFromInt64(((const CntUInt32Item*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( CntBoolItem ) )
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("(BOOL)"));
		aStr += String::CreateFromInt32(((const CntBoolItem*)pItem)->
										    GetValue());
	}
    else if ( pItem->ISA( SfxDateTimeItem ) )
	{
        DateTime aDateTime = ((const SfxDateTimeItem*)pItem)->GetDateTime();
        aStr += m_rInternational.GetDate( aDateTime );
        aStr += ' ';
        aStr += m_rInternational.GetTime( aDateTime );
    }
    else if ( pItem->ISA( SfxRangeItem ) )
	{
        aStr += String::CreateFromInt32(((const SfxRangeItem*)pItem)->From());
        aStr += '-';
        aStr += String::CreateFromInt32(((const SfxRangeItem*)pItem)->To());
    }
    else if ( pItem->ISA( SfxUShortRangesItem ) )
	{
        const USHORT *pRanges = ((const SfxUShortRangesItem*)pItem)->GetRanges();
        while( *pRanges ) {
            aStr += String::CreateFromInt32(*(pRanges++));
            aStr += '-';
            aStr += String::CreateFromInt32(*(pRanges++));
            aStr += ' ';
        }
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("[USHORT]"));
    }
    else if ( pItem->ISA( CntRangesItem ) )
	{
        USHORT nCount = ((const CntRangesItem*)pItem)->Count();
        for( USHORT n = 0; n < nCount; n++ ) {
            ULONG nFrom, nTo;
            ((const CntRangesItem*)pItem)->GetRange(n,nFrom,nTo);
            aStr += String::CreateFromInt64(nFrom);
            aStr += '-';
            aStr += String::CreateFromInt64(nTo);
            aStr += ' ';
        }
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("[ULONG]"));
    }
    else if ( pItem->ISA( CntCrossReferenceItem ) )
	{
		aStr += ((const CntCrossReferenceItem*)pItem)->GetGroup();
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(": "));
		aStr
			+= String::CreateFromInt64(((const CntCrossReferenceItem*)pItem)->
									       GetIndex());
    }
    else if ( pItem->ISA( CntSortingItem ) )
	{
        USHORT nCount = ((const CntSortingItem*)pItem)->Count();
        for( USHORT n = 0; n < nCount; n++ ) {
            const CntSortingInfo &rInfo = (*(const CntSortingItem*)pItem)[n];
            aStr += String::CreateFromInt32(rInfo.GetSortingWID());
            aStr += '(';
            aStr += String::CreateFromInt32(rInfo.GetAscending());
            aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(") "));
        }
    }
    else if ( pItem->ISA( CntUShortListItem ) )
	{
        USHORT nCount = ((const CntUShortListItem*)pItem)->Count();
        for( USHORT n = 0; n < nCount; n++ ) {
			aStr += String::CreateFromInt32(
				        (*(const CntUShortListItem*)pItem)[n]);
			aStr += ' ';
        }
    }
    else if ( pItem->ISA( CntSendInfoListItem ) )
		aStr.
			AppendAscii(RTL_CONSTASCII_STRINGPARAM("CntSendInfoListItem..."));
    else if ( pItem->ISA( SfxStringListItem ) )
	{
		List* pList = ((SfxStringListItem*)pItem)->GetList();
		ULONG nCount = pList->Count();
		for ( ULONG i = 0; i < nCount; ++i )
		{
            aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\""));
			aStr += *(String*)pList->GetObject( i );
            aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\" "));
        }
    }
	else if (pItem->ISA(CntIMAPMboxDataItem))
	{
		const CntIMAPMboxDataItem & rMboxData
		 = *INSECURE_DYNAMIC_CAST(const CntIMAPMboxDataItem *, pItem);
		if (rMboxData.hasData())
		{
			int nItems = 0;
			if (rMboxData.getFlagInferiors())
			{
				aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("inf"));
				++nItems;
			}
			if (rMboxData.getFlagSelect())
			{
				if (nItems++)
					aStr += ',';
				aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("sel"));
			}
			if (nItems)
				aStr += ',';
			UINT8 nSep = rMboxData.getHierarchySeparator();
			if (!nSep)
				aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("NIL"));
			else if (nSep >= ' ' && nSep != '"' && nSep <= '~')
			{
				aStr += '"';
				aStr += sal_Unicode(nSep);
				aStr += '"';
			}
			else
			{
				aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("%d"));
				aStr += String::CreateFromInt32(nSep);
			}
		}
		if (rMboxData.getUIDValidity())
		{
			if (rMboxData.hasData())
				aStr += ';';
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("UIDval="));
			aStr += String::CreateFromInt64(rMboxData.getUIDValidity());
		}
		else if (!rMboxData.hasData())
			aStr += '-';
	}
	else if (pItem->ISA(CntRecipientListItem))
	{
		const CntRecipientListItem& rRcpList =
			(CntRecipientListItem&) *pItem;
		for (int i=0; i<rRcpList.Count(); i++)
		{
			aStr += String::CreateFromInt32(i);
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(": \""));
			aStr += rRcpList[i]->GetToRecipient();
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\"[TO] \""));
			aStr += rRcpList[i]->GetCcRecipient();
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\"[CC] \""));
			aStr += rRcpList[i]->GetBccRecipient();
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\"[BCC] \""));
			aStr += rRcpList[i]->GetNewsRecipient();
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\"[NEWS] \""));
			aStr += rRcpList[i]->GetServer();
			aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\"[SERVER]"));
		}
	}
    else if ( pItem->ISA(SfxDateTimeRangeItem) )
	{
        DateTime aDateTime = ((const SfxDateTimeRangeItem*)pItem)->GetStartDateTime();
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("Start: "));
		aStr += m_rInternational.GetDate( aDateTime );
        aStr += ' ';
        aStr += m_rInternational.GetTime( aDateTime );

		aDateTime = ((const SfxDateTimeRangeItem*)pItem)->GetEndDateTime();
		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("   End: "));
		aStr += m_rInternational.GetDate( aDateTime );
        aStr += ' ';
        aStr += m_rInternational.GetTime( aDateTime );
    }
    else if (pItem->ISA(CntDocHeaderItem))
	{
		CntDocHeader *pHead = ((const CntDocHeaderItem *)pItem)->GetValue();
		if (pHead)
		{
			ULONG i, n = pHead->GetHeaderCount();
			for (i = 0; i < n; i++)
			{
				aStr += '|';
				aStr += pHead->GetHeaderName(i);
				aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(": "));
				aStr += pHead->GetHeaderValue(i);
				aStr += '|';
			}
		}
    }
    else if (pItem->ISA(SfxCrawlStatusItem))
	{
		String aText;
		const SfxCrawlStatusItem* pCStat = (const SfxCrawlStatusItem*)pItem;
		pCStat->GetPresentation( SFX_ITEM_PRESENTATION_NAMELESS, SFX_MAPUNIT_APPFONT,
			SFX_MAPUNIT_APPFONT, aText );
		aStr += aText;
	}

    p = m_aTree.InsertEntry( aStr, TYPE_ITEM, pParent );
}

/*========================================================================
 *
 * MyApp.
 *
 *=======================================================================*/

class MyApp : public Application
{
private:
    StgViewerWin*  m_pMain;

    DECL_LINK( FileMenu, Menu* );

public:
	virtual void Main();

    void OpenStorage( const String& rStorage );
};

MyApp aMyApp;

//-------------------------------------------------------------------------
// virtual
void MyApp::Main()
{
	String aPfx(RTL_CONSTASCII_USTRINGPARAM("stg"));
	aPfx += String::CreateFromInt32(SUPD);

	ResMgr* pMgr = ResMgr::CreateResMgr(CREATEVERSIONRESMGR_NAME(stg));
	Resource::SetResManager( pMgr );

	StgViewerWin aAppWin( NULL, WB_APP | WB_STDWORK );

    MenuBar aMBMain( ResId( MENU_MAIN ) );

  	aMBMain.GetPopupMenu( MENU_FILE )->PushSelectHdl(
											LINK( this, MyApp, FileMenu ) );

    m_pMain = &aAppWin;

    SetAppMenu( &aMBMain );

	aAppWin.SetText( String( ResId( TEXT_TITLEBAR ) ) );

    aAppWin.Show();

    // Check for command line params
    for ( int n = 0; n < GetCommandLineParamCount(); ++n )
	{
        String aPara = GetCommandLineParam( n );
        OpenStorage( aPara );
    }

	Execute();
}

//-------------------------------------------------------------------------
IMPL_LINK( MyApp, FileMenu, Menu *, pMenu )
{
    switch ( pMenu->GetCurItemId() )
    {
        case MENU_OPEN:
		{
            FileDialog aOpen( m_pMain, WB_OPEN | WB_SVLOOK | WB_STDMODAL );

            aOpen.
				AddFilter(ResId(TEXT_FILTER1),
						  String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
							                          "*.*")));
            aOpen.
				AddFilter(ResId(TEXT_FILTER2),
						  String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
							                          "*.scc")));
            aOpen.
				AddFilter(ResId(TEXT_FILTER3),
						  String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
							                          "*.scs")));
            aOpen.SetCurFilter(ResId(TEXT_FILTER3));

            if( aOpen.Execute() )
				OpenStorage( aOpen.GetPath() );

			break;
        }

        case MENU_EXIT:
            Quit();
            break;
    }

    return TRUE;
}

//-------------------------------------------------------------------------
void MyApp::OpenStorage( const String& rPath )
{
    GetpApp()->EnterWait();
	m_pMain->FillTree( rPath );
    GetpApp()->LeaveWait();
}

