/*************************************************************************
 *
 *  $RCSfile: adminprovider.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: jb $ $Date: 2001/04/03 16:33:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "adminprovider.hxx"
#include "apiaccessobj.hxx"

#ifndef CONFIGMGR_API_ADMINPROVIDERIMPL_HXX_
#include "adminproviderimpl.hxx"
#endif
#ifndef CONFIGMGR_API_USERIMPL_HXX_
#include "userimpl.hxx"
#endif
#ifndef CONFIGMGR_API_GROUPIMPL_HXX_
#include "groupimpl.hxx"
#endif
#ifndef CONFIGMGR_BOOTSTRAP_HXX_
#include "bootstrap.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef __SGI_STL_ALGORITHM
#include <algorithm>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#define THISREF() static_cast< ::cppu::OWeakObject* >(this)

namespace configmgr
{
	namespace css  = ::com::sun::star;
	namespace uno  = css::uno;
	namespace lang = css::lang;
	namespace beans = css::beans;
	using ::rtl::OUString;
	using ::vos::ORef;
	using namespace osl;

	namespace 
	{
		typedef uno::Reference< uno::XInterface > (OAdminProviderImpl::*CreatorFunc)(const uno::Sequence< uno::Any >& aArguments);
		struct AdminServiceCreationInfo
		{
			ServiceInfo const* info;
			CreatorFunc create;
		};

//-------- Implementation object information ----------------------------------
		AsciiServiceName const aRemoteProviderServices[] = 
		{
			"com.sun.star.configuration.UserAdministrationProvider",
			"com.sun.star.configuration.AdministrationProvider",
			0
		};

		ServiceInfo const aRemoteProviderInfo = 
		{
			"com.sun.star.comp.configuration.RemoteAdministrationProvider",
			aRemoteProviderServices
		};

//-------- Created service information ----------------------------------

		static sal_Int32 getCreateUserAdminServiceDataCount()
		{
			return 4;
		};

		static const AdminServiceCreationInfo* getCreateUserAdminServiceData()
		{
			static AdminServiceCreationInfo const createServiceData[] = 
			{
				{ &configapi::aCreateReadAccessSI, &OAdminProviderImpl::createReadAccess },
				{ &configapi::aCreateUpdateAccessSI, &OAdminProviderImpl::createUpdateAccess },
				{ &aUserAccessSI, &OAdminProviderImpl::createUserAccess },				
				{ &aGroupAccessSI, &OAdminProviderImpl::createGroupAccess },				
			};
			OSL_ENSURE(sizeof(createServiceData)/sizeof(createServiceData[0]) == getCreateUserAdminServiceDataCount(),
				"getCreateServiceData : inconsistent data !");
			return createServiceData;
		}
	}
	
	static AdminServiceCreationInfo const* findUserAdminCreationInfo( const OUString& aServiceSpecifier )
	{
		for (int i= 0; i<getCreateUserAdminServiceDataCount(); ++i)
		{
			AdminServiceCreationInfo const& rCreationInfo = getCreateUserAdminServiceData()[i];

			ServiceInfo const* pInfo = rCreationInfo.info;
			if (!pInfo)
				continue;

			if (AsciiServiceName pImplName = pInfo->implementationName)
			{
				if (0 == aServiceSpecifier.compareToAscii(pImplName))
					return &rCreationInfo;
			}
				
			if (AsciiServiceName const* pNames = pInfo->serviceNames)
			{
				while(*pNames)
				{
					if (0 == aServiceSpecifier.compareToAscii(*pNames))
						return &rCreationInfo;

					++pNames;
				}
			}
		}
		// not found
		return 0;
	}

//-----------------------------------------------------------------------
	const ServiceInfo* getRemoteAdminProviderServices()
	{
		return &aRemoteProviderInfo;
	}

	//-----------------------------------------------------------------------------
	// provider instantiation
	uno::Reference< uno::XInterface > SAL_CALL instantiateRemoteAdminProvider( uno::Reference< lang::XMultiServiceFactory > const& rServiceManager, ConnectionSettings const& _aSettings )
	{
		::rtl::OUString const sService(RTL_CONSTASCII_USTRINGPARAM("adminconfiguration"));

		ConnectionSettings aSettings(_aSettings);
		aSettings.setAdminSession(sService);
		
		OAdminProvider* pNewProvider = new OAdminProvider(rServiceManager);

		uno::Reference< lang::XMultiServiceFactory > aRet( pNewProvider );

		pNewProvider->connect(aSettings);

		return  aRet;		
	}

	//-----------------------------------------------------------------------------
	OAdminProvider::OAdminProvider(const uno::Reference< lang::XMultiServiceFactory >& _xServiceFactory)
				   :OProvider(_xServiceFactory,&aRemoteProviderInfo)
				   ,m_pImpl(NULL)			
	{
	}

	//-----------------------------------------------------------------------------
	OAdminProvider::~OAdminProvider()
	{
		delete m_pImpl;		
	}

	//-----------------------------------------------------------------------------
	void OAdminProvider::connect(const ConnectionSettings& _rSettings) throw(uno::Exception)
	{
		OSL_ENSURE( m_pImpl == NULL, "Error: Administration Provider already is connected");

		std::auto_ptr<OAdminProviderImpl> pNewImpl( new OAdminProviderImpl(this, m_xServiceFactory) );

		implConnect(*pNewImpl, _rSettings);

		m_pImpl = pNewImpl.release();		
	}

	//-----------------------------------------------------------------------------
	void SAL_CALL OAdminProvider::disposing()
	{		
		if (m_pImpl)
			m_pImpl->dispose();				

		OProvider::disposing();						
	}		
	
	//-----------------------------------------------------------------------------
	uno::Reference< uno::XInterface > SAL_CALL OAdminProvider::createInstance( const OUString& aServiceSpecifier ) 
		throw(uno::Exception, uno::RuntimeException)
	{
		
		CFG_TRACE_INFO("going to create a read access instance for %s", "missing unicode conversion");
		if (AdminServiceCreationInfo const* pInfo = findUserAdminCreationInfo(aServiceSpecifier))
		{
			// it's a known service name - try to create without args
			if (CreatorFunc create = pInfo->create)
			{
				uno::Sequence< uno::Any > aArguments;
				return (m_pImpl->*create)(
					aArguments);
			}
		}
		return uno::Reference< uno::XInterface >();		
	}

	//-----------------------------------------------------------------------------
	uno::Reference< uno::XInterface > SAL_CALL 
		OAdminProvider::createInstanceWithArguments( const ::rtl::OUString& aServiceSpecifier, const uno::Sequence< uno::Any >& aArguments ) 
			throw(uno::Exception, uno::RuntimeException)
	{		
		if (AdminServiceCreationInfo const* pInfo = findUserAdminCreationInfo(aServiceSpecifier))
		{
			// it's a known service name - try to create without args
			if (CreatorFunc create = pInfo->create)
			{
				return (m_pImpl->*create)(aArguments);
			}
		}
		return uno::Reference< uno::XInterface >();		
	}

	//-----------------------------------------------------------------------------
	uno::Sequence< OUString > SAL_CALL OAdminProvider::getAvailableServiceNames(  ) 
		throw(uno::RuntimeException)
	{	
		sal_Int32 nCount = 0;
		{
			for (int i= 0; i<getCreateUserAdminServiceDataCount(); ++i)
				nCount += countServices(getCreateUserAdminServiceData()[i].info);
		}

		uno::Sequence< OUString > aNames(nCount);

		if (nCount > 0)
		{
			sal_Int32 n = 0;
			for (int i= 0; i<getCreateUserAdminServiceDataCount(); ++i)
			{
				ServiceInfo const* pInfo = getCreateUserAdminServiceData()[i].info;
				AsciiServiceName const* pNames = pInfo ? pInfo->serviceNames : 0;

				if (pNames)
				{
					while(*pNames)
					{
						aNames[n] = OUString::createFromAscii(*pNames);
						++n;
						++pNames;
					}
				}
			}
		}
		return aNames;
	}

	// OPropertyArrayUsageHelper
	// -------------------------------------------------------------------------
	::cppu::IPropertyArrayHelper* OAdminProvider::createArrayHelper( ) const
	{
		uno::Sequence< beans::Property > aProps;
		describeProperties(aProps);
		return new ::cppu::OPropertyArrayHelper(aProps);
	}
	// -------------------------------------------------------------------------
	::cppu::IPropertyArrayHelper & OAdminProvider::getInfoHelper()
	{
		return *const_cast<OAdminProvider*>(this)->getArrayHelper();
	}
} // namespace configmgr


