/*************************************************************************
 *
 *  $RCSfile: confname.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jb $ $Date: 2001/06/20 20:22:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_CONFNAME_HXX_
#define CONFIGMGR_CONFNAME_HXX_

#include "apitypes.hxx"

#include <functional>
#include <iterator>

namespace configmgr
{

// Exceptions removed !! now most members are nothrow

	//------------------------------------------------------------------------------------------------------------------
	class ConfigurationName
	{
	public:
		static const ::sal_Unicode delimiter; // = '/'
		static OUString stringDelimiter();
		static OUString rootname();
		static ConfigurationName root();

	public:
		struct Absolute {};
		ConfigurationName();
		ConfigurationName(OUString const& sFullName) throw();
		ConfigurationName(OUString const& sFullName, Absolute) throw();
		ConfigurationName(ConfigurationName const& sBaseName, OUString const& sRelativeName) throw();
		ConfigurationName(ConfigurationName const& sBaseName, ConfigurationName const& sRelativeName) throw();

		sal_Int32 depth() const;

		bool isEmpty() const;
		OUString localName()	const;
		OUString fullName()	const;

		bool isRelative() const;
		OUString moduleName() const;

		bool isNestedIn(ConfigurationName const& aBaseName) const;
		ConfigurationName relativeTo(ConfigurationName const& aBaseName) const throw();

		ConfigurationName getParentName() const;

		ConfigurationName composeWith(OUString const& sRelativeName) const throw()
		{ return ConfigurationName(*this,sRelativeName); }

		ConfigurationName composeWith(ConfigurationName const& aRelativeName) const throw()
		{ return ConfigurationName(*this,aRelativeName); }

		ConfigurationName operator+(OUString const& sRelativeName) const throw()
		{ return composeWith(sRelativeName); }

		ConfigurationName operator+(ConfigurationName const& aRelativeName) const throw()
		{ return composeWith(aRelativeName); }

		friend bool operator==(ConfigurationName const& lhs, ConfigurationName const& rhs) throw();
		friend bool operator!=(ConfigurationName const& lhs, ConfigurationName const& rhs) throw() { return !(lhs == rhs); }
		
		///@deprecated
		// for backward conpatibility with first vesion
		bool empty() const { return isEmpty(); }
	public:
		class Iterator;
		// Warning: ConfigurationName(x.begin(),x.end()) loses 'absolute' attribute
		ConfigurationName(Iterator const& first, Iterator const& last); 
		Iterator begin() const throw();
		Iterator end() const throw();
		
	private:
		OUString	m_sPath;
		sal_Int32	m_nNamePos;

		ConfigurationName(OUString const& sFullName, sal_Int32 nPos) throw();

		static sal_Int32 validate(OUString& sName, bool bMaybeAbsolute) throw();

		void init(OUString const& aPath) throw();
		void init(ConfigurationName const& aBasePath, OUString const& aRelPath) throw();
		void init_concat(OUString const& aBasePath, OUString const& aRelPath, sal_Int32 nRelPos) throw();
	};

	struct OUStringPointerDerefHelper { 
		OUString const s; 
		explicit OUStringPointerDerefHelper(OUString const& s_) : s(s_) {}
		OUString const* operator->() const { return &s; }
	};

	class ConfigurationName :: Iterator
	{
		OUString aPath; 
		sal_Int32 nPos, nEnd;

		friend class ConfigurationName;
		Iterator(OUString const& aPath_, bool atEnd);
	public:
		OUString const operator*() const;
		OUStringPointerDerefHelper operator->() const { return OUStringPointerDerefHelper(**this); }

		Iterator& operator++();
		Iterator operator++(int) { Iterator ret(*this); ++*this; return ret; }

		Iterator& operator--();
		Iterator operator--(int) { Iterator ret(*this); --*this; return ret; }

		friend bool operator==(Iterator const& lhs, Iterator const& rhs);
		friend bool operator!=(Iterator const& lhs, Iterator const& rhs) { return !(lhs == rhs); }
	};

	inline ConfigurationName::Iterator ConfigurationName::begin() const throw()
	{
		return Iterator(m_sPath, false);
	}
	inline ConfigurationName::Iterator ConfigurationName::end() const throw()
	{
		return Iterator(m_sPath, true);
	}

	//------------------------------------------------------------------------------------------------------------------
	//------------------------------------------------------------------------------------------------------------------
	/** comparing two <type>ConfigurationNames</type> in an stl-usable manner.
		A <type>ConfigurationNames</type> x is considered to be less than y, if the corresponding
		node in the configuration tree is located on the left of the one for y. Which means that in the
		deepest common ancestor of x an y, if it's children are sorted by name, the child leading to
		x is located left of the one leading to y.<BR>
		If of the two nodes described by the names, one is an ancestor of the other, the shorter name is
		considered beeing less than the longer one.
		The names beeing compared should be absolute, or at least they should be relative to the same node.
		Else the comparisation won't make any sense.
	*/
	struct ConfNameCompare : public ::std::binary_function< ConfigurationName, ConfigurationName, bool >
	{
		bool operator() (const ConfigurationName& x, const ConfigurationName& y) const
		{
			ConfigurationName::Iterator aLoopX = x.begin();
			ConfigurationName::Iterator aStopX = x.end();
			ConfigurationName::Iterator aLoopY = y.begin();
			ConfigurationName::Iterator aStopY = y.end();

			::rtl::OUString sCheckX, sCheckY;
			while ((aLoopX != aStopX) && (aLoopY != aStopY))
			{
				sCheckX = *aLoopX;
				sCheckY = *aLoopY;
				if (sCheckX < sCheckY)
					return sal_True;	// x is located left of y
				else if (sCheckX > sCheckY)
					return sal_False;	// x is located right of y

				++aLoopX; ++aLoopY;
			}
			if (aLoopX != aStopX)
				// the loop ended because aLoopY reached it's end
				// -> the y-node is an ancestor of the x-node
				// -> y is less than x
				return sal_False;
			if (aLoopY != aStopY)
				// the other way round : x is less than y
				return sal_True;

			// x and y are identical
			return sal_False;
		}
	};

} // namespace config

#endif // CONFIGMGR_CONFNAME_HXX_


