/*************************************************************************
 *
 *  $RCSfile: server_version.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: jb $ $Date: 2001/07/16 07:55:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _CONFIGMGR_SERVER_VERSION_HXX_
#define _CONFIGMGR_SERVER_VERSION_HXX_

//..........................................................................
namespace configmgr
{
//..........................................................................

#define _WRONG_ERROR_RESPONSE_PARAM_DATA_TYPE_
	// the current server supplies the error messages with type "0"

#define _SERVER_KNOWS_DATA_TYPE_LONG_
	// the current server uses the param data type "long" instead of "int" in some cases

#define _STRIP_ABSOLUTE_PATH_SLASH_
	// currently, server requires pathes in requests not to start with a slash, despite being absolute

//#define _SIMULATE_COMPONENT_DOTS_ 
#define _SIMULATE_TEMPLATE_COMPONENT_DOTS_ 
	// the api (and all layers above the session) are working with node paths like
	// com.sun.star.Office.Common, which means here is a component called "Office" located under com.sun.star which
	// has a sub node "Common". So the server-side node path would be com.sun.star/Office/Common

#define _ENCODE_USER_NAMES_
	// currently, user names are used in xml tags, that's why they need to be encoded

#define _ENCODE_ELEMENT_NAMES_
	// currently, element names are used in xml tags, that's why they need to be encoded

#define REQUEST_TEMPLATE_DETECTION "org.openoffice.Templates"
	// currently, requests for templates have a path starting with pseudo-module "org.openoffice.Templates"

//#define CFGSERVER_TEMPLATE_LOCATION "org.openoffice.Templates"
#define CFGSERVER_TEMPLATE_LOCATION "Template"
	// currently, requests for templates need a path starting with pseudo-module "templates"

#if defined (CFGSERVER_TEMPLATE_LOCATION) || defined (_SIMULATE_TEMPLATE_COMPONENT_DOTS_)
#ifndef REQUEST_TEMPLATE_DETECTION
#error "Cannot detect template when translating node pathes in openNode"
#endif
#endif
// must be able to detect a template request - also forces _REMOTE_PATH_TRANSLATION_

#if defined(_SIMULATE_COMPONENT_DOTS_) || defined (_ENCODE_ELEMENT_NAMES_) || defined (REQUEST_TEMPLATE_DETECTION) || defined (_STRIP_ABSOLUTE_PATH_SLASH_) 
#define _REMOTE_PATH_TRANSLATION_
#endif

#define _NO_ADDNODE_REDUNDANCE_
	// in addNode operations, the server does not have the same redundance as in updateNode : in an update operation,
	// the root of the to-be-updated tree occurs in the node path argument as well as in the node tree. In add
	// operations, this name has to occur only in the node path.

#define _SIMULATE_USERPROFILE_SETNODE_
	// when logged on as admin in a remote session, the UserProfile node should be a set node

#define _NOTIFICATION_SUPPORT_
	// receiving notifications from the remote server

// #define _USE_COMPRESSION
	// used to define that compression for binary cached files

//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SERVER_VERSION_HXX_


