/*************************************************************************
 *
 *  $RCSfile: treecache.hxx,v $
 *
 *  $Revision: 1.38 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 11:52:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_TREECACHE_HXX_
#define _CONFIGMGR_TREECACHE_HXX_

#ifndef CONFIGMGR_TREEPROVIDER_HXX
#include "treeprovider.hxx"
#endif
#ifndef CONFIGMGR_DEFAULTPROVIDER_HXX
#include "defaultprovider.hxx"
#endif

#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif
#ifndef _CONFIGMGR_XMLTREEBUILDER_HXX
#include "xmltreebuilder.hxx"
#endif
#ifndef CONFIGMGR_API_EVENTS_HXX_
#include "confevents.hxx"
#endif
#ifndef CONFIGMGR_MISC_OPTIONS_HXX_
#include "options.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif


#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetException.hpp>
#endif


#ifndef _VOS_TIMER_HXX_
#include <vos/timer.hxx>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef INCLUDED_MAP
#include <map>
#define INCLUDED_MAP
#endif
#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

namespace com
{
	namespace sun
	{
		namespace star
		{
			namespace script
			{
				class XTypeConverter;
			}
		}
	}
}

namespace configmgr
{
	class OTreeAccessor;
	class IConfigSession;

	namespace uno	= ::com::sun::star::uno;
	namespace xmlsax	= ::com::sun::star::xml::sax;
	namespace script	= ::com::sun::star::script;

	class OUpdateCallback;
	class IConfigSession;
	struct StatusInfo;
	class OTreeAccessor;
	class OTreeDisposeScheduler;
	class OCacheWriteScheduler;

	class TreeManager;
	//==========================================================================
	//= OUpdateCallback
	//==========================================================================
	class OUpdateCallback : public IDataRequestCallback
	{
        typedef configuration::AbsolutePath     AbsolutePath;
        typedef configuration::Path::Component  Name;

		oslInterlockedCount		m_refCount;
		//	XMLDataReader		m_aDataReader;
		TreeManager*			m_pCacheManager;
		TreeChangeList			m_aChanges;
		::vos::ORef< XMLTreeChangeListBuilder >
								m_xBuilder;
		::vos::OCondition		m_aDoneCond;

		StatusInfo				m_aServerStatus;	/// the status as returned from the server, @seealso <method>done</method>
		sal_Int32				m_nConnError;		/// the error as returned from the session, @seealso <method>failed</method>

	public:
		StatusInfo		getStatus() const { return m_aServerStatus; }
		sal_Int32		getConnError() const { return m_nConnError; }

	protected:
		~OUpdateCallback() { }

	public:
		OUpdateCallback(const AbsolutePath& _rRootPath, const vos::ORef<OOptions>& rOptions, TreeManager&);
		OUpdateCallback(const AbsolutePath& _rRootPath, const vos::ORef<OOptions>& rOptions);

		// IInterface
		virtual void SAL_CALL acquire(  ) throw () {osl_incrementInterlockedCount( &m_refCount );}
		virtual void SAL_CALL release(  ) throw () 
		{
			if (! osl_decrementInterlockedCount( &m_refCount ))
				delete this;
		}

		/** wait until the request is not (no matter if successfull or not)
			@param		_pTimeout	time out for the wait operation. If NULL, a default will be used.
			@return		sal_True, if successfull
			@seealso	getStatus
			@seealso	getConnError
		*/
		sal_Bool waitForUpdate(TimeValue* _pTimeout = NULL);

		// IRequestCallback
		virtual		void failed(sal_Int32 _nErrorCode);
		virtual		void done(const StatusInfo& _rStatus);

		// IDataRequestCallback
		virtual	uno::Reference< xmlsax::XDocumentHandler > getDataReader();
	};

	//==========================================================================
	//= TreeInfo / TreeData
	//==========================================================================
	struct TreeInfo;
	class Tree;

	class TreeOnDemand
	{
		std::auto_ptr<Tree>		m_pTree;
		void makeTree();
	public:
		osl::Mutex		mutex;

		TreeOnDemand();
		~TreeOnDemand();

		Tree& tree() { if (!m_pTree.get()) makeTree(); return *m_pTree; }
	};

	//==========================================================================
	//= TreeManager
	//==========================================================================
	class TreeManager	:public ITreeManager
                        ,public IDefaultableTreeManager
                        ,public IDefaultProvider
						,public ITemplateProvider
						,private INotifyListener
                        ,private ConfigChangeBroadcaster
	{
		typedef ::std::map< ::vos::ORef<OOptions>, TreeInfo*, ltOptions > TreeList;
		
		osl::Mutex				m_aTreeListMutex;
		osl::Mutex				m_aUpdateMutex;
		
		oslInterlockedCount		m_refCount;		
		TreeList				m_aTreeList; // Map
		TreeOnDemand			m_aTemplates;
		
		OTreeAccessor*			m_pLock;
		OTreeDisposeScheduler*	m_pDisposer;
		OCacheWriteScheduler *m_pCacheWriter;
		IConfigSession*			m_pSession;  // read/write or send/recieve Nodes
				
		::vos::ORef<OOptions>		m_xDefaultOptions;
		::vos::ORef< OUpdateCallback > m_xDataReqCb;			

		bool                    m_bLazyWritePossible; // true if lasy writing possible
		bool                    m_bDisposeMode;       // true, if we are in disposing
		friend class OTreeDisposeScheduler;
		friend class OCacheWriteScheduler;
		// friend class OInvalidateThread;
		
	protected:
		// ref counted, that's why no public dtor
		~TreeManager();

		// Interface for OInvalidateThread
		IConfigSession* getSession() {return m_pSession;}

	public:
		/** ctor
			@param		_pSession			the session to work on			
		*/
		TreeManager(IConfigSession*	_pSession, const vos::ORef<OOptions>& _xOptions);

		// IInterface
		virtual void SAL_CALL acquire(  ) throw () {osl_incrementInterlockedCount( &m_refCount );}
		virtual void SAL_CALL release(  ) throw ();

		// disposing the cache before destroying		
		void dispose();
		
		// ITreeManager
		/** requests a node given by it's path. Basicly, this means
			that the node is fetch from the cache when it contains it else it ask the server
			system into it's cache.
			@param			_rSubtreePath	the path to the node in URI notation.
			@param			_nMinLevels		indicates how many tree levels under the node determined by <arg>_rSubtreePath</arg>
											should be loaded
		*/
		virtual ISubtree* requestSubtree(AbsolutePath const& _rSubtreePath, 
                                         const vos::ORef < OOptions >& _xOptions,
										 sal_Int16 _nMinLevels = ALL_LEVELS) CFG_UNO_THROW_ALL(  );

		virtual void updateTree(TreeChangeList& aChanges) CFG_UNO_THROW_ALL(  );

		virtual void notifyUpdate(TreeChangeList const& aChanges) CFG_UNO_THROW_RTE(  );

		virtual void releaseSubtree(AbsolutePath const& aSubtreePath, 
                                    const vos::ORef < OOptions >& _xOptions ) CFG_NOTHROW();

		virtual void disposeData(const vos::ORef < OOptions >& _xOptions) CFG_NOTHROW();

		virtual void fetchSubtree(AbsolutePath const& aSubtreePath, 
                                    const vos::ORef < OOptions >& _xOptions, 
                                    sal_Int16 nMinLevels = ALL_LEVELS) CFG_NOTHROW();

		// IDefaultableTreeManager
        virtual sal_Bool fetchDefaultData(AbsolutePath const& aSubtreePath, 
									        const vos::ORef < OOptions >& _xOptions,
									        sal_Int16 nMinLevels) CFG_UNO_THROW_ALL(  );

		// IDefaultProvider
        virtual std::auto_ptr<ISubtree> requestDefaultData(AbsolutePath const& aSubtreePath, 
										                    const vos::ORef < OOptions >& _xOptions,
										                    sal_Int16 nMinLevels) CFG_UNO_THROW_ALL(  );
		// ITemplateProvider
		virtual ::std::auto_ptr<INode> requestTemplateInstance(Name const& aName, Name const& aModule, 
										   const vos::ORef < OOptions >& _xOptions) CFG_UNO_THROW_ALL(  );		
		
		IConfigBroadcaster* getBroadcaster() { return this; }


		auto_ptr<ISubtree> loadNodeFromSession( IConfigSession *_pSession, AbsolutePath const& _aAbsoluteSubtreePath, 
												const vos::ORef < OOptions >& _xOptions,
												sal_Int16 _nMinLevels)  CFG_UNO_THROW_ALL(  );

    // implementation interfaces
		void sessionUpdate(vos::ORef< OOptions > const& _xOptions, const AbsolutePath &_aRootPath, SubtreeChange* _aPendingChange)
						CFG_UNO_THROW_ALL(  );
		
		void invalidateTreeAsync(const AbsolutePath &_aAbsoluteSubtreePath,
								 const vos::ORef<OOptions>& _rOptions) CFG_UNO_THROW_ALL(  );

		void refreshSubtree(const AbsolutePath &_aAbsoluteSubtreePath, 
                            const vos::ORef<OOptions>& _aOptions) CFG_UNO_THROW_ALL(  );
	protected:
		// ISyncronizedData
		virtual void acquireReadAccess() const;
		virtual void releaseReadAccess() const;
		virtual void acquireWriteAccess();
		virtual void releaseWriteAccess();		

	protected:
		/** load a subtree of a tree, insert it into the tree. The method will determine if getNode
			can be used or an openNode is neccessary.
			<BR>
			The method has to be called with an acquired read guard for the given tree
			<BR>
			The newly read node will be inserted into the given tree.
			<BR>
			The parameter _rClearBeforeWrite is neccessary as long as we cant nest a write guard into a read guard.
		*/
		ISubtree* implLoadSubtree(const AbsolutePath& _rSubtreePath,
							      const vos::ORef < OOptions >& _xOptions,
								  sal_Int16 _nMinLevels, 
								  TreeInfo& _rTreeInfo, 
								  OReadSynchronized& _rClearBeforeWrite, 									   
								  StatusInfo& _rStatus);		

		AbsolutePath ensureTemplate(Name const& _rName, Name const& _rModule) CFG_UNO_THROW_ALL(  );

		AbsolutePath completeTemplateLocation(const Name& _rLogicalTemplateName, const Name &_rModule);
		std::auto_ptr<ISubtree> loadRemoteTemplate( const AbsolutePath& _rNodePath, 
												      const vos::ORef < OOptions >& _xOptions,
												      StatusInfo& /* [out] */ _rStatus );		

		/** closing a list of given node ids,			
			@param			_rNodeIds		list of node ids
			@seealso		cancelNotify
		*/
		void	closeNodes(	const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rNodeIds, 
							const vos::ORef < OOptions >& _xOptions);

		void fireChanges(TreeChangeList const& aChangeTree, sal_Bool _bError);

	private:

		OTreeDisposeScheduler* createDisposer(vos::ORef<OOptions> const& _xOptions);

		/// lasy writing
		OCacheWriteScheduler* createCacheWriter(vos::ORef<OOptions> const& _xOptions);
		/// stop Lasy writing and flush data
		void disableAsync();					 

		// insert new tree if necessary
		TreeInfo* requestTreeInfo(vos::ORef<OOptions> const& _xOptions, bool bCreate);
		Tree& getTemplatesTree();

        // helper to implement force-writable support
        static void forceWritable(INode& _rNode);

		// disposing
		void disposeAll();
		void disposeOne(vos::ORef<OOptions> const& _xOptions, bool bFlushUpdates = true);		
		void disposeUser(vos::ORef<OOptions> const& _xUserOptions, bool bFlushUpdates = true);
		void implDisposeOne(std::auto_ptr<TreeInfo> pInfos, vos::ORef<OOptions> const& _xOptions, bool bFlushUpdates);

		// ConfigChangeBroadcaster
		virtual ConfigChangeBroadcastHelper* getBroadcastHelper(vos::ORef<OOptions> const& _xOptions, bool bCreate);

		// INotifyListener
		virtual void nodeUpdated(TreeChangeList& _rChanges);

	};

}


#endif // _CONFIGMGR_TREECACHE_HXX_

