/*************************************************************************
 *
 *  $RCSfile: envelopestream_impl.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dg $ $Date: 2001/02/08 11:26:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>

//..........................................................................
namespace configmgr
{
//..........................................................................

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::io;
using namespace ::vos;


//==========================================================================
//= OEnvelopeInputStream
//==========================================================================
template <class SESSIONINPUT, class CONNTYPE>
sal_Bool OEnvelopeInputStream<SESSIONINPUT, CONNTYPE>::doImplRead(::com::sun::star::uno::Sequence< sal_Int8 >& _rData, sal_Int32& _nBytes, sal_Bool _bWantAll) throw (NotConnectedException, IOException)
{
	if (m_bEof)
	{
		_nBytes = 0;
		m_bEof = sal_False;		// so the next read request is kind of a restart
		return sal_False;
	}

	sal_Bool bReadSomething = SESSIONINPUT::doImplRead(_rData, _nBytes, _bWantAll);
	if (!bReadSomething)
		return sal_False;	// eof on the socket

	const sal_Int8* pBuffer = _rData.getConstArray();
#ifdef CFG_ENABLE_TRACING
	const sal_Int8* pTrafficToTrace = pBuffer;
	sal_Int32 nTrafficLen = _nBytes;
	while (nTrafficLen > 0)
	{
		sal_Int32 nZeroPos;
		const sal_Int8* pZeroSearch = pTrafficToTrace;
		for (nZeroPos = 0; nZeroPos<nTrafficLen; ++nZeroPos, ++pZeroSearch)
			if (!*pZeroSearch)
				break;

		char pszFormat[20];
		sprintf(pszFormat, "%%.%is", pZeroSearch - pTrafficToTrace);
		CFG_TRACE_TO_DEVICE("inlog", pszFormat, pTrafficToTrace);

		if (nZeroPos < nTrafficLen)
		{
			CFG_TRACE_TO_DEVICE("inlog", "\n----------\n- %s: envelope closed\n----------\n", OConfigTracer::getTimeStamp().getStr());
		}

		nTrafficLen = nTrafficLen - (pZeroSearch - pTrafficToTrace) - 1;
		pTrafficToTrace = pZeroSearch + 1;
	}
#endif	
	for (register sal_Int32 i=0; i<_nBytes; ++i, ++pBuffer)
		if (!*pBuffer)
		{	// found the envelope separator
			sal_Int32 nNextEnvelopeBytes = _nBytes - i - 1;

			CFG_TRACE_INFO("envelope input stream: detected an envelope separator, simulating EOF");
			CFG_TRACE_INFO_NI("envelope input stream: saving %i bytes for the next envelope, returning %i bytes for the current one", nNextEnvelopeBytes, _nBytes - nNextEnvelopeBytes - 1);

			if (nNextEnvelopeBytes)
				pushBackPrependBytes(pBuffer + 1, nNextEnvelopeBytes);

			_nBytes -= nNextEnvelopeBytes;
			_nBytes -= 1;	// the '0' token

			if (_nBytes)
			{
				// still have some bytes in this envelope
				// the next round should propagate the EOF idicated by the separator sign
				m_bEof = sal_True;	// next round should behave as if EOF is reached
				return sal_True;	// this round has some bytes to return
			}
			else
			{
				// there were no bytes before the separator sign
				m_bEof = sal_False;	// next round should read as usual
				return sal_False;	// this round we have an EOF
			}
			// previously, we had an 'm_bEof = sal_True; return (0 != _nBytes);'.
			// in case _nBytes was 0, this lead to one EOF this round and one EOF at the beginning of
			// the next round, which caused the SAX-parser to exit (it does not allow to be run with an
			// input stream retruning 0  immediately, it throws an SAX-exception which caused the reader
			// thread to exit)
			// FS - 78170 - 08/27/00
		}

	return sal_True;
}

//==========================================================================
//= OEnvelopeOutputStream
//==========================================================================
//--------------------------------------------------------------------------
template <class SESSIONOUTPUT, class CONNTYPE>
void SAL_CALL OEnvelopeOutputStream<SESSIONOUTPUT, CONNTYPE>::closeOutput( ) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	::osl::Guard< OMutexWrapper > aGuard(m_aMutex);
	checkConnected();
	if (isConnected() && m_bWroteAnything)
	{
		// add the envelope seperator
		m_aBuffer[m_nLen] = 0;	// envelope sep
		Sequence < sal_Int8 > aData(m_aBuffer, m_nLen + 1);
		m_nLen = 0;				// reset the length		
		SESSIONOUTPUT::implWrite(aData);
		
		flush();		
		
#ifdef CFG_ENABLE_TRACING
		CFG_TRACE_TO_DEVICE("outlog", "\n----------\n- %s: envelope closed\n----------\n", OConfigTracer::getTimeStamp().getStr());
#endif
	}
}

//--------------------------------------------------------------------------
template <class SESSIONOUTPUT, class CONNTYPE>
sal_Int32 OEnvelopeOutputStream<SESSIONOUTPUT, CONNTYPE>::implWrite(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rData)
{
#ifdef CFG_ENABLE_TRACING
	char pszFormat[20];
	sprintf(pszFormat, "%%.%is", _rData.getLength());
	CFG_TRACE_TO_DEVICE("outlog", pszFormat, _rData.getConstArray());
#endif

	sal_Int32 nWriteLength = _rData.getLength();	
	m_bWroteAnything = true;

	if ((nWriteLength + m_nLen) < BUFFER_LEN)
	{	
		memcpy(m_aBuffer + m_nLen, _rData.getConstArray(), nWriteLength);
		m_nLen += nWriteLength;
	}
	else
	{		
		if (m_nLen)
		{
			Sequence < sal_Int8 > aData(m_aBuffer, nWriteLength + m_nLen);
			memcpy(aData.getArray() + m_nLen, _rData.getConstArray(), nWriteLength);
			m_nLen = 0;
			SESSIONOUTPUT::implWrite(aData);
		}
		else
			SESSIONOUTPUT::implWrite(_rData);
	}	
	return nWriteLength;	
}

//--------------------------------------------------------------------------
template <class SESSIONOUTPUT, class CONNTYPE>
Any SAL_CALL OEnvelopeOutputStream<SESSIONOUTPUT, CONNTYPE>::queryInterface( const Type& _rType ) throw(RuntimeException)
{
	Any aReturn = SESSIONOUTPUT::queryInterface(_rType);
	if (!aReturn.hasValue())
		aReturn = OEnvelopeOutputStream_Base::queryInterface(_rType);
	return aReturn;
}

//--------------------------------------------------------------------------
template <class SESSIONOUTPUT, class CONNTYPE>
void SAL_CALL OEnvelopeOutputStream<SESSIONOUTPUT, CONNTYPE>::cancel(  ) throw(RuntimeException)
{
	try
	{
		SESSIONOUTPUT::closeOutput();
	}
	catch(RuntimeException&)
	{
		throw;
	}
	catch(Exception&)
	{
	}
}

//..........................................................................
}	// namespace configmgr
//..........................................................................


