/*************************************************************************
 *
 *  $RCSfile: receivethread.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/21 12:22:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_RECEIVETHREAD_HXX_
#include "receivethread.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_RS_TYPES_HXX_
#include "rs_types.hxx"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_SAXPARSEEXCEPTION_HPP_
#include <com/sun/star/xml/sax/SAXParseException.hpp>
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif

#define PARSER_SERVICE	::rtl::OUString::createFromAscii("com.sun.star.xml.sax.Parser")

//..........................................................................
namespace configmgr
{
//..........................................................................

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::xml;
using namespace ::com::sun::star::lang;
using namespace ::vos;
using namespace ::osl;

//==========================================================================
//= OReceiveThread
//==========================================================================
//--------------------------------------------------------------------------
OReceiveThread::OReceiveThread(const Reference< XInputStream >& _rxInputStream, const Reference< sax::XParser >& _rxParser)
	:m_bTerminated(sal_False)
	,m_pTerminated(NULL)
{
	OSL_ENSURE(_rxInputStream.is() && _rxParser.is(), "OReceiveThread::OReceiveThread : invalid stream and/or parser !");
	if (_rxInputStream.is() && _rxParser.is())
	{
		m_xInputStream = _rxInputStream;
		m_xStreamParser = _rxParser;
	}
}

//--------------------------------------------------------------------------
void OReceiveThread::run()
{
	ClearableMutexGuard aStreamSafety(m_aMutex);
	if (m_xInputStream.is() && m_xStreamParser.is())
	{
		sal_Bool bFatalError = sal_False;
		while (schedule() && !bFatalError)	// no termination request and no fatal error
		{
			sax::InputSource aSourceDescription;
			aSourceDescription.aInputStream = m_xInputStream;

			// TODO : set an error handler on the parser (which should be the ORemoteSession, probably)

			try
			{
				aStreamSafety.clear();
				// parse one envelope
				m_xStreamParser->parseStream(aSourceDescription);
			}
			catch(sax::SAXParseException& e)
			{
				e;
				CFG_TRACE_ERROR("receiver thread: caught a SAXParseException, message: %s", OUSTRING2ASCII(e.Message)); 
				OSL_ENSURE(sal_False, "OReceiveThread::run : could not parse the xml stream got from the socket !");
				bFatalError = sal_True;
			}
			catch(sax::SAXException& e)
			{
				e;
				CFG_TRACE_ERROR("receiver thread: caught a SAXException, message: %s", OUSTRING2ASCII(e.Message)); 
				OSL_ENSURE(sal_False, "OReceiveThread::run : caught a generic SAXException !");
				bFatalError = sal_True;
			}
			catch(NotConnectedException& e)
			{
				e;
				CFG_TRACE_INFO("receive thread: caught a NotConnectedException (allowed)");
				// nothing to do : the only thing which can cause this exception (presumed that the stream
				// and the parser were constructed correctly, i.e. with a valid socket) is an closeInput on
				// the stream, which we can only do ourself (in our kill method). So this is no condition
				// for an assertion.
			}
			catch(IOException& e)
			{
				e;
				CFG_TRACE_ERROR("receive thread: caught a IO exception, message: %s", OUSTRING2ASCII(e.Message));	
				// not allowed : the socket stream object is not allowed to throw an IOException, which describes
				// the socket error occured, typiccally this means the connection was closed! 
				OSL_ENSURE(m_pTerminated, "OReceiveThread::run : catched an IOException !");
				bFatalError = sal_True;
			}
			catch(RuntimeException& e)
			{
				e;
				CFG_TRACE_ERROR("receiver thread: caught a RuntimeException (this is heavy), message: %s", OUSTRING2ASCII(e.Message)); 
				OSL_ENSURE(sal_False, "OReceiveThread::run : catched an generic RuntimeException !");
				bFatalError = sal_True;
			}
		}
	}

	{
		MutexGuard aStreamSafety(m_aMutex);
		if (m_xInputStream.is())
			// finished because of an exception or an end-of-file
			try { m_xInputStream->closeInput(); }
			catch(Exception&) { }
	}
}

//--------------------------------------------------------------------------
void OReceiveThread::onTerminated()
{
	MutexGuard aTerminationGuard(m_aTerminationMutex);
	m_bTerminated = sal_True;
	if (m_pTerminated)
		m_pTerminated->set();
}

//--------------------------------------------------------------------------
void OReceiveThread::terminateBlocking()
{
	OSL_ENSURE(getIdentifier() != getCurrentIdentifier(),
		"OReceiveThread::terminateBlocking : not to be called from within this thread itself !");
		// below we will wait for a flag (or a condition) to be set in onTerminated, and this method
		// can only be called from within this thread

	terminate();

	{
		MutexGuard aTerminationGuard(m_aTerminationMutex);
		if (m_bTerminated)
		{
			// onTerminated already has been called
			delete this;
			return;
		}

		m_pTerminated = new OCondition;
		m_pTerminated->reset();

	}

	m_pTerminated->wait();

	{
		MutexGuard aTerminationGuard(m_aTerminationMutex);
		delete m_pTerminated;
		m_pTerminated = NULL;
	}

	delete this;
}

//--------------------------------------------------------------------------
void OReceiveThread::terminate()
{
	OThread::terminate();
		// it's a coorperative terminate : just a flag is set, and schedule checks this flag

	{
		MutexGuard aStreamSafety(m_aMutex);

		if (m_xInputStream.is())
		{
			try { m_xInputStream->closeInput(); }
			catch(Exception&) { }
				// will cause the blocking read of the stream to throw an NotConnectedException, which
				// will cancel the parsing
		}
		m_xInputStream = NULL;
	}
}

//..........................................................................
}	// namespace configmgr
//..........................................................................


