/*************************************************************************
 *
 *  $RCSfile: receivethread.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_RECEIVETHREAD_HXX_
#define _CONFIGMGR_SESSION_RECEIVETHREAD_HXX_

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

//==========================================================================
// forwards
namespace vos
{
	class OConnectorSocket;
	class OCondition;
}

//..........................................................................
namespace configmgr
{
//..........................................................................

//==========================================================================
//= OReceiveThread
//==========================================================================
/** the thread which reads data from the config server and forwards it (translated)
	to a <type>ORemoteSession</type>.
*/
typedef ::vos::OThread OReceiveThread_Base;
class OReceiveThread : public OReceiveThread_Base
{
protected:
	::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStream >
							m_xInputStream;		/// input stream to read from
	::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XParser >
							m_xStreamParser;	/// the object parsing the input stream
	::osl::Mutex			m_aMutex;			/// stream access safety
	::osl::Mutex			m_aTerminationMutex;/// safety for the termination process
	::vos::OCondition*		m_pTerminated;		/// condition to be set on termination (in some cases)
	sal_Bool				m_bTerminated;		/// sal_True when onTerminated has been called

protected:
	/** dtor. protected, the thread object deletes itself in waitForTermination
	*/
	~OReceiveThread() { }

public:
	/** constructs the thread (but does not start it).
		@param		_rxInputStream	the stream to read from
		@param		_rxParser		the parser, has to support the com.sun.star.xml.sax.Parser service.
	*/
	OReceiveThread(const ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStream >& _rxInputStream, const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XParser >& _rxParser);

	/** terminate the thread, block until the termination, the DELETE the thread object !
	*/
	void terminateBlocking();

protected:
	virtual void SAL_CALL run();

	virtual void SAL_CALL onTerminated();

private:
	/// inherited by <type scope="vos">OThread</type>
	virtual void SAL_CALL terminate();

	virtual void SAL_CALL kill() { /* should never be called */ OReceiveThread_Base::kill(); }
};

//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SESSION_RECEIVETHREAD_HXX_


