/*************************************************************************
 *
 *  $RCSfile: loader.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:07:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_LOADER_HXX
#define CONFIGMGR_LOADER_HXX

#ifndef CONFIGMGR_TREEBUILDERCALLBACK_HXX
#include "treebuildercallback.hxx"
#endif
#ifndef CONFIGMGR_API_APITYPES_HXX_
#include "apitypes.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif
#ifndef CONFIGMGR_MISC_OPTIONS_HXX_
#include "options.hxx"
#endif
#ifndef CONFIGMGR_CONFIGPATH_HXX_
#include "configpath.hxx"
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

namespace configmgr
{
	class IConfigSession;

	class OTreeLoader : public vos::OReference
					  , private NotCopyable
	{	
        typedef configuration::AbsolutePath AbsolutePath;
        typedef configuration::Name         ModuleName;
	private:
		osl::Mutex					m_aMutex;
		vos::ORef< TreeBuilderCallback > m_xReader;		
		AbsolutePath			    m_aLoadedName;		
		IConfigSession*				m_pSession;
		vos::ORef< OOptions >		m_xOptions;
		sal_Int16					m_nLevels;
		bool						m_bStarted;
	
	public:			
		explicit OTreeLoader(IConfigSession* pSession, AbsolutePath const& aLoadedName, 
							 vos::ORef< OOptions > const& _xOptions, sal_Int16 nMinLevels); 

		/// starting a read for a node, blocking depends of the kind of session
		void start(INotifyListener*);
		
		/// blocking for a read
		std::auto_ptr<ISubtree>		waitToResponse() CFG_UNO_THROW_ALL();
		const AbsolutePath&	        getLoadedPath()     const {return m_aLoadedName;}
		ModuleName	                getComponentName()  const {return m_aLoadedName.getModuleName();}
        sal_Int16                   getLoadedLevels()   const {return m_nLevels;}
	};
////////////////////////////////////////////////////////////////////////////////	
} // namespace configmgr

#endif // CONFIGMGR_LOADER_HXX


