/*************************************************************************
 *
 *  $RCSfile: binarywritehandler.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:18:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "binarywritehandler.hxx"


#ifndef CONFIGMGR_BINARYWRITER_HXX
#include "binarywriter.hxx"
#endif
#ifndef _CONFIGMGR_TREE_VALUENODE_HXX
#include "valuenode.hxx"
#endif
#ifndef _CONFIGMGR_FILEHELPER_HXX_
#include "filehelper.hxx"
#endif
#ifndef _CONFIGMGR_OSLSTREAM_HXX_
#include "oslstream.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XDataOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif

// -----------------------------------------------------------------------------
#define ASCII(x) rtl::OUString::createFromAscii(x)
// -----------------------------------------------------------------------------

namespace configmgr
{
	using namespace rtl;
	using namespace std;
	using namespace com::sun::star::uno;
	using namespace comphelper;

	namespace css  = com::sun::star;
	namespace lang = css::lang;
	namespace io   = css::io;

// -----------------------------------------------------------------------------
// ------------ Markable is a helperclass to write a mark in a file ------------
// -----------------------------------------------------------------------------


	OMark::OMark()
			:m_pWriter(NULL)
	{}
	
	OMark::~OMark()
	{
		// OSL_ENSURE(m_pWriter == NULL, "Mark not stored, wrong handling");
	}
	
	
	void OMark::create(OBinaryBaseWriter* _pWriter)
	{
		m_pWriter = _pWriter;
		m_xMarkableStream = _pWriter->getMarkableStream();

		m_nPosition = m_xMarkableStream->createMark();
		sal_Int64 nPosition = 0;
		m_pWriter->write(nPosition);
	}
	
// -----------------------------------------------------------------------------
	void OMark::store(/*OBinaryBaseWriter* _pWriter*/)
	{
		// if OBinaryBaseWriter is a parameter, we could test if it is the right Pointer
		// OSL_ENSURE(m_pWriter == _pWriter, "ERROR, pointer is wrong.");

		if (m_pWriter != NULL)
		{
			sal_Int64 nPosition = m_xMarkableStream->offsetToMark(m_nPosition);
			m_xMarkableStream->jumpToMark(m_nPosition);
			m_pWriter->write(nPosition);
			m_xMarkableStream->jumpToFurthest();
			m_xMarkableStream->deleteMark(m_nPosition);
		}
		m_pWriter = NULL;						 // should prevent double call of store()
	}


// -----------------------------------------------------------------------------
void OBinaryWriteHandler::handle(ValueNode const& aValueNode)
{
	writeNodeType(m_aWriter, NodeType::value);
	writeValue(m_aWriter, aValueNode.getName(), aValueNode.getAttributes(), 
			   aValueNode.getValueType(), aValueNode.getValue(), aValueNode.getDefault());
}

// -----------------------------------------------------------------------------
void OBinaryWriteHandler::handle(ISubtree const& aSubtree)
{
	if (aSubtree.isSetNode())
	{
		writeNodeType(m_aWriter, NodeType::ntyp_set);
		writeSet(m_aWriter, aSubtree.getName(), aSubtree.getAttributes(),
                 aSubtree.getElementTemplateName(),
                 aSubtree.getElementTemplateModule());
	}
	else
	{

		writeNodeType(m_aWriter, NodeType::group);
		writeGroup(m_aWriter, aSubtree.getName(), aSubtree.getAttributes());
	}
	
	if (m_bWriteMark)
	{
		// Write Mark
		OMark aMark;
		aMark.create(&m_aWriter);
		
		// Write inner Subtrees
		aSubtree.forEachChild(*this);
		aMark.store();
		writeStop(m_aWriter);
	}
	else
	{
		// Write inner Subtrees
		aSubtree.forEachChild(*this);
		//? writeStop(m_aWriter);
	}
}

// -----------------------------------------------------------------------------
bool write(ISubtree const* _pSubtree, rtl::OUString const& _aFilename,
		   uno::Reference< lang::XMultiServiceFactory > const& _xServiceProvider)
    SAL_THROW( (uno::RuntimeException) )
{
	// BACK: returns an error, if fails.
	bool bRet = false;

	try 
	{
	    OBinaryBaseWriter aWriter(_aFilename, _xServiceProvider);

		aWriter.open();
		writeFileHeader(aWriter, CFG_BINARY_SUBTREE_MAGIC);

		OBinaryWriteHandler aHandler(aWriter, _xServiceProvider, true);
		aHandler.handle(*_pSubtree);

	    writeStop(aWriter);
	    aWriter.close();

		bRet = true;
	}
	catch (io::IOException& e)
	{
		rtl::OUString sMessage = e.Message;
		OSL_ENSURE(false, "IOException");
	}
	
	return bRet;
}

// -----------------------------------------------------------------------------
// ------------------------- OBinaryWriteChangeHandler -------------------------
// -----------------------------------------------------------------------------

void OBinaryWriteChangeHandler::handle(ValueChange const& aValueNode)
{
	writeNodeType(m_aWriter, NodeType::valuechange);
	Any aDummy;
	writeValue(m_aWriter,
			   aValueNode.getNodeName(),
			   aValueNode.getAttributes(), 
			   aValueNode.getNewValue().getValueType(),
			   aValueNode.getNewValue(),
			   aDummy);

}
// -----------------------------------------------------------------------------
void OBinaryWriteChangeHandler::handle(AddNode const& aAddNode)
{
	writeNodeType(m_aWriter, NodeType::addnode);

	INode* pNewNode = aAddNode.getAddedNode();
	if (!pNewNode)
	{
		pNewNode = aAddNode.getAddedNode_unsafe();
		OSL_ENSURE(pNewNode, "OBinaryWriteChangeHandler::handle : added an empty node ?");
		// CFG_TRACE_WARNING("binary writer: Writing 'AddNode' change that doesn't own its node");
	}

	if (pNewNode)
	{
		OBinaryWriteHandler aHandler(m_aWriter, m_xServiceProvider, true);
		aHandler.applyToNode(*pNewNode);
	}
}
// -----------------------------------------------------------------------------
void OBinaryWriteChangeHandler::handle(RemoveNode const& aRemoveNode)
{
	writeNodeType(m_aWriter, NodeType::removenode);
	// NAME HANDLING
	m_aWriter.write(aRemoveNode.getNodeName());
}
// -----------------------------------------------------------------------------
void OBinaryWriteChangeHandler::handle(SubtreeChange const& aSubtreeChange)
{
	if (aSubtreeChange.isSetNodeChange())
	{
		writeNodeType(m_aWriter, NodeType::ntyp_set);
		writeSet(m_aWriter,
				 aSubtreeChange.getNodeName(),
				 aSubtreeChange.getAttributes(),
                 aSubtreeChange.getElementTemplateName(),
                 aSubtreeChange.getElementTemplateModule());
	}
	else
	{

#ifdef DEBUG /* To set a break if required */
		if (aSubtreeChange.getNodeName().equals(ASCII("Localisation")))
			volatile int dummy = 0;
#endif

		writeNodeType(m_aWriter, NodeType::group);
		writeGroup(m_aWriter, aSubtreeChange.getNodeName(), aSubtreeChange.getAttributes());
	}
	
	if (m_bWriteMark)
	{
		// Write Mark
//!		OMarkable aMarkable(m_aWriter);

		// Write inner Subtrees
		aSubtreeChange.forEachChange(*this);
		writeStop(m_aWriter);
	}
	else
	{
		// Write inner Subtrees
		aSubtreeChange.forEachChange(*this);
		// writeStop(m_aWriter);
	}
}
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
bool write(SubtreeChange const* _pSubtreeChange, rtl::OUString const& _aFilename, 
		   uno::Reference< lang::XMultiServiceFactory > const& _xServiceProvider)
    SAL_THROW( (uno::RuntimeException) )
{
	// BACK: returns an error, if fails.
	bool bRet = false;

	try 
	{
	    OBinaryBaseWriter aWriter(_aFilename, _xServiceProvider);

		aWriter.open();
		writeFileHeader(aWriter, CFG_BINARY_SUBTREECHANGE_MAGIC);
		
		OBinaryWriteChangeHandler aHandler(aWriter, _xServiceProvider, true);
		aHandler.handle(*_pSubtreeChange);

	    writeStop(aWriter);
	    aWriter.close();

		bRet = true;
	}
	catch (io::IOException& e)
	{
		rtl::OUString sMessage = e.Message;
		OSL_ENSURE(false, "IOException");
	}
	
	return bRet;
}

} // namespace configmgr

