/*************************************************************************
 *
 *  $RCSfile: binarywriter.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:18:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_BINARYWRITER_HXX
#define CONFIGMGR_BINARYWRITER_HXX

#ifndef CONFIGMGR_CONFIGURATION_ATTRIBUTES_HXX_
#include "attributes.hxx"
#endif

#ifndef CONFIGMGR_BINARYTYPE_HXX
#include "binarytype.hxx"
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_IOEXCEPTION_HPP_
#include <com/sun/star/io/IOException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XDataOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XMARKABLESTREAM_HPP_
#include <com/sun/star/io/XMarkableStream.hpp>
#endif

namespace configmgr
{
	namespace css = com::sun::star;
	
	namespace io   = css::io;
	namespace uno  = css::uno;
	namespace lang = css::lang;

	// -----------------------------------------------------------------------------


	class OBinaryBaseWriter
	{
		rtl::OUString      m_aFileURL;
		osl::File*         m_pFileOut;
		::com::sun::star::uno::Sequence< sal_Int8 >	m_aBuffer;

		void ensure_File() SAL_THROW( (io::IOException, uno::RuntimeException) );
		uno::Reference<lang::XMultiServiceFactory> m_xServiceProvider;
		uno::Reference< io::XDataOutputStream > m_xDataOutputStream;
		uno::Reference< io::XMarkableStream > m_xMarkableStream;

		OBinaryBaseWriter(OBinaryBaseWriter const&);
		OBinaryBaseWriter& operator=(OBinaryBaseWriter const&);
	protected:

	public:
		// OBinaryBaseWriter(osl::File& _aFileOut)
		//		:m_aFileOut(_aFileOut)
		// 	{}
		
		explicit OBinaryBaseWriter(rtl::OUString const& m_aFilename, uno::Reference<lang::XMultiServiceFactory> const& _rxServiceProvider);
		~OBinaryBaseWriter();
        void open()  SAL_THROW( (io::IOException, uno::RuntimeException) );
        void close() SAL_THROW( (io::IOException, uno::RuntimeException) );		

		// Type writer
		void write(sal_Bool _bValue)    SAL_THROW( (io::IOException, uno::RuntimeException) );
		void write(sal_Int8 _nValue)    SAL_THROW( (io::IOException, uno::RuntimeException) );
		void write(sal_Int16 _nValue)   SAL_THROW( (io::IOException, uno::RuntimeException) );
		void write(sal_Int32 _nValue)   SAL_THROW( (io::IOException, uno::RuntimeException) );
		void write(sal_Int64 _nValue)   SAL_THROW( (io::IOException, uno::RuntimeException) );
		void write(double _nValue)      SAL_THROW( (io::IOException, uno::RuntimeException) );
		void write(sal_Unicode _nValue) SAL_THROW( (io::IOException, uno::RuntimeException) );
//!		void write(sal_Unicode *_pValue, sal_Int32 _nLength);
		void write(rtl::OUString const& _aStr) SAL_THROW( (io::IOException, uno::RuntimeException) );

		uno::Reference<io::XMarkableStream> getMarkableStream() {return m_xMarkableStream;}
	};

// -----------------------------------------------------------------------------
	class OMark
	{
		OBinaryBaseWriter* m_pWriter;			 // hold as pointer, do not delete
		uno::Reference< io::XMarkableStream > m_xMarkableStream;
		sal_Int32          m_nPosition;
		
		// is copyable
	public:
		OMark();
		void create(OBinaryBaseWriter* _pWriter);
		void store();
		bool is() {return m_pWriter != NULL;}
		
		~OMark();
	};

	// -----------------------------------------------------------------------------

	void writeNodeType(OBinaryBaseWriter& _aWriter, NodeType::Enum _eType)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

	void writeNullValue(OBinaryBaseWriter& _aWriter, rtl::OUString const& _aName, 
                        configuration::Attributes const& _aAttributes,uno::Type const& _aType)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

	void writeValue(OBinaryBaseWriter& _aWriter, rtl::OUString const& _aName, 
                    configuration::Attributes const& _aAttributes, uno::Type const& _aType, 
                    uno::Any const& _aValue, uno::Any const& _aDefaultValue)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

	void writeGroup(OBinaryBaseWriter& _aWriter, rtl::OUString const& _aName, 
                    configuration::Attributes const& _aAttributes)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

	void writeSet(OBinaryBaseWriter& _aWriter, rtl::OUString const& _aName, 
                    configuration::Attributes const& _aAttributes,
                    rtl::OUString const& _aTemplateName, rtl::OUString const& _aModuleName)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

	void writeStop(OBinaryBaseWriter& _aWriter)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

    void writeFileHeader(OBinaryBaseWriter& _aWriter, sal_Int32 nMagic)
        SAL_THROW( (io::IOException, uno::RuntimeException) );

} // namespace configmgr

#endif
