/*************************************************************************
 *
 *  $RCSfile: generatecache.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "generatecache.hxx"

#ifndef INCLUDED_VECTOR
#include <vector>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HPP_
#include <com/sun/star/script/XTypeConverter.hpp>
#endif

#ifndef CONFIGMGR_LOOKUPCONTEXT_HXX_
#include <lookupcontext.hxx>
#endif

#ifndef _CONFIGMGR_LOCALSESSION_HXX_
#include "localsession.hxx"
#endif

#ifndef CONFIGMGR_PARSERCONTEXT_HXX
#include <parsercontext.hxx>
#endif

#ifndef _CONFIGMGR_FILEHELPER_HXX_
#include "filehelper.hxx"
#endif

namespace configmgr
{
	namespace css    = com::sun::star;
	namespace uno    = css::uno;
	namespace script = css::script;
	namespace sax    = css::xml::sax;

#define ASCII(x) rtl::OUString::createFromAscii(x)

// -----------------------------------------------------------------------------
static
void scanDirectory(rtl::OUString const& _sPath, rtl::OUString const& _aName, std::vector<OUString>& _aFiles)
{
	// _sPath MUST be a Directory, not a file, this wont be checkt.

	osl::Directory aDirectory(_sPath);	
	bool bDirectoryExist = aDirectory.open() == osl_File_E_None;	
	osl::DirectoryItem aItem;

	while (aDirectory.getNextItem(aItem) != osl_File_E_NOENT)
	{
		// aItem is mass of all things ,-)
		osl::FileStatus aStatus(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Type);
		osl::FileBase::RC eError = aItem.getFileStatus(aStatus);
		if (eError != osl::FileBase::E_None)
		{
			return; // Hae?
		}
		
		if (aStatus.isValid(osl_FileStatus_Mask_FileName) && aStatus.isValid(osl_FileStatus_Mask_Type))
		{
			rtl::OUString aName = aStatus.getFileName();
			osl::FileStatus::Type aType = aStatus.getFileType();

			rtl::OUString aNewName;
			if (_aName.getLength() > 0)
				aNewName = _aName + FileHelper::delimiterAsString() + aName;
			else
				aNewName = aName;

			if (aType == osl::FileStatus::Directory)
			{
				rtl::OUString aNewDirectory = _sPath + FileHelper::delimiterAsString() + aName;
				scanDirectory(aNewDirectory, aNewName, _aFiles);
			}
			else if (aType == osl::FileStatus::Regular)
			{
				// aFile
				rtl::OUString aNewName = _aName + FileHelper::delimiterAsString() + aName;
				sal_Int32 nIdx = aNewName.lastIndexOf(OLookupContext::xmlExt(), aNewName.getLength());
				if (nIdx > 0)
				{
					aNewName = aNewName.copy(0,nIdx);
				}
				_aFiles.push_back(aNewName);
			}
			else
			{
				// Hae?
			}
		}
	}
	
	aDirectory.close();
}
// -----------------------------------------------------------------------------
static
bool directoryScan(rtl::OUString const& _aPath, std::vector<rtl::OUString> &_aFilenameList)
{
	// rtl::OUString sSourcePath = ASCII("//./f|/office60_632/share/config/registry/instance");

	scanDirectory(_aPath, ASCII(""), _aFilenameList);

	// return true, if vector isn't empty
	return _aFilenameList.empty() ? false : true;
}
// -----------------------------------------------------------------------------

class OEmptyHandler : public CmDocumentHandler_BASE
{
public:
	OEmptyHandler::OEmptyHandler() {}
	

	// XDocumentHandler
	virtual void SAL_CALL startDocument(void) throw (sax::SAXException, uno::RuntimeException); 
	virtual void SAL_CALL endDocument(void) throw(sax::SAXException, uno::RuntimeException);
	virtual void SAL_CALL startElement(const rtl::OUString& aName, const uno::Reference< sax::XAttributeList > &xAttribs) throw(sax::SAXException, uno::RuntimeException);
	virtual void SAL_CALL endElement(const rtl::OUString& aName) throw(sax::SAXException, uno::RuntimeException);
	virtual void SAL_CALL characters(const rtl::OUString& aChars) throw(sax::SAXException, uno::RuntimeException);
	virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces) throw(sax::SAXException, uno::RuntimeException);
	virtual void SAL_CALL processingInstruction(const rtl::OUString& aTarget, const rtl::OUString& aData) throw(sax::SAXException, uno::RuntimeException);
	virtual void SAL_CALL setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator) throw(sax::SAXException, uno::RuntimeException);
};
	// XDocumentHandler
	void OEmptyHandler::startDocument(void)
		throw (sax::SAXException, uno::RuntimeException) 
		{}
	
	void OEmptyHandler::endDocument(void)
		throw(sax::SAXException, uno::RuntimeException)
		{}
	
	void OEmptyHandler::startElement(const rtl::OUString& aName,
									   const uno::Reference< sax::XAttributeList > &xAttribs)
		throw(sax::SAXException, uno::RuntimeException)
		{}
	
	void OEmptyHandler::endElement(const rtl::OUString& aName)
		throw(sax::SAXException, uno::RuntimeException)
		{}
	
	void OEmptyHandler::characters(const rtl::OUString& aChars)
		throw(sax::SAXException, uno::RuntimeException)
		{}
	
	
	void OEmptyHandler::ignorableWhitespace(const rtl::OUString& aWhitespaces)
		throw(sax::SAXException, uno::RuntimeException)
		{}
	
	
	void OEmptyHandler::processingInstruction(const rtl::OUString& aTarget,
												const rtl::OUString& aData)
		throw(sax::SAXException, uno::RuntimeException)
		{}
	
	void OEmptyHandler::setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
		throw(sax::SAXException, uno::RuntimeException)
		{}

// -----------------------------------------------------------------------------
	OGenerateCache::OGenerateCache(rtl::OUString const& _aShareDirectoryURL, rtl::OUString const& _aBinaryDirectoryURL, LocalSession* _pSession, node::Attributes const& _aBaseAttributes)
	{
		std::vector<rtl::OUString > aFileList;
		if (directoryScan(_aShareDirectoryURL, aFileList))
		{
			// Create a TypeConverter
			uno::Reference<script::XTypeConverter> aConverter;
			aConverter = aConverter.query(_pSession->getServiceFactory()->createInstance(ASCII( "com.sun.star.script.Converter" )) );

			vector<OUString> aEmptyFilter;
			uno::Reference<sax::XDocumentHandler> xHandler(new OEmptyHandler());
			for (vector<OUString>::iterator it = aFileList.begin();it != aFileList.end();it++)
			{
				ParserContext aContext(ASCII(""), _aBaseAttributes, aConverter);

                OUString sXMLFilename = _aShareDirectoryURL;
				sXMLFilename += FileHelper::delimiterAsString();
				sXMLFilename += *it;
				sXMLFilename += OLookupContext::xmlExt();

				OUString sBinaryFilename = _aBinaryDirectoryURL;
				sBinaryFilename += FileHelper::delimiterAsString();
				sBinaryFilename += *it;

                sBinaryFilename += OLookupContext::cacheExt();
				_pSession->readSubtreeFromXML(sXMLFilename, sBinaryFilename, xHandler, aContext, aEmptyFilter);
			}
		}
	}
 
} // namespace
