/*************************************************************************
 *
 *  $RCSfile: valuenodebuilder.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/* PLEASE DON'T DELETE ANY COMMENT LINES, ALSO IT'S UNNECESSARY. */

#ifndef CONFIGMGR_VALUENODEBUILDER_HXX
#define CONFIGMGR_VALUENODEBUILDER_HXX

#include "nodebuilder.hxx"

#include "valueconverter.hxx"
#include "saxadapter.hxx"

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;

// -----------------------------------------------------------------------------
	class OAttributeParser;
	class OTreeNodeFactory;
	struct ParserContext;

	class AbstractValueNodeBuilder : public ISaxNodeBuilder, public InternalDocumentHandler
	{
	public:
		AbstractValueNodeBuilder(ParserContext& rContext);
		
	public:
		/// is this currently work in progress ?
		bool isInContent() const;

		/// get the logical name of the node
		OUString getNodeName() const 
		{ 
			return m_sNodeName; 
		}

		ValueInfo const& getValueInfo() const 
		{ 
			return m_aValueConverter.getInfo(); 
		}

		uno::Type getUnoType() const 
		{ 
			return m_aValueConverter.getType(); 
		}

		OAttributeParser& getAttributeHandler() const;
		OTreeNodeFactory& getNodeFactory() const; 

        void setBaseAttributes(node::Attributes const& _aAttributes)
        { m_aBaseAttributes = _aAttributes; }
	public:
		void startNode(OUString const& aNodeName, ValueInfo const& aValueDesc);
		void endNode();

	protected:
		// XDocumentHandler implementations
		virtual void SAL_CALL startElement(const rtl::OUString& aName,
										   const uno::Reference< sax::XAttributeList > &xAttribs)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endElement(const rtl::OUString& aName)
			throw(sax::SAXException, uno::RuntimeException);

	public:// primarily for implementing classes - 

		// get the context with helper objects
		ParserContext& getParserContext() const
		{ return m_rContext; }

		//  get the value information and conversion
		OValueConverter& getValueConverter() 
		{ return m_aValueConverter; }
		OValueConverter const& getValueConverter() const 
		{ return m_aValueConverter; }
		
	private:
		/// prepare for a new node. discard old node data - will enter inContent state
		virtual void startedNode() = 0;
		/// left inContent state - finalize the node
		virtual void finishNode() = 0;

	protected:	
		// ISaxNodeBuilder implementations
		virtual uno::Reference< sax::XDocumentHandler > doGetSaxHandler();
		virtual void doPrepare();

	private:
		ParserContext&	m_rContext;

		OValueConverter m_aValueConverter;
        node::Attributes m_aBaseAttributes;
		OUString		m_sNodeName;

		OUString		m_sXMLName;
	};
	
// -----------------------------------------------------------------------------
	class SimpleValueNodeBuilder : public AbstractValueNodeBuilder
	{
	public:
		SimpleValueNodeBuilder(ParserContext& rContext);
		
	protected:
		// XDocumentHandler
		virtual void SAL_CALL characters(const rtl::OUString& aChars)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces)
			throw(sax::SAXException, uno::RuntimeException);

	private: // AbstractValueNodeBuilder
		virtual void startedNode();
		virtual void finishNode();

	protected:
		// ISaxNodeBuilder
		virtual std::auto_ptr<INode> doGetNode();
		virtual void doPrepare();


	private:
		std::auto_ptr<INode> implMakeValueNode(uno::Any const& m_aValue);
		std::auto_ptr<INode> implMakeNullNode();

		OUString				m_sContentCharacters;
		std::auto_ptr<INode>	m_pValueNode;
	};
	
// -----------------------------------------------------------------------------
	
} // namespace

#endif

