/*************************************************************************
 *
 *  $RCSfile: MABDatabaseMetaData.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: oj $ $Date: 2001/08/29 12:21:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Willem van Dorp, Darren Kenny
 *
 *
 ************************************************************************/

//  Mozilla includes.
#include <mozaddressbook/MABDatabaseMetaDataHelper.hxx>

#ifndef _CONNECTIVITY_MAB_OCALCDATABASEMETADATA_HXX_
#include "mozaddressbook/MABDatabaseMetaData.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_COLUMNVALUE_HPP_
#include <com/sun/star/sdbc/ColumnValue.hpp>
#endif

#include <MABDebug.hxx>

using namespace connectivity::mozaddressbook;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;

namespace connectivity
{
	namespace mozaddressbook
	{
            static sal_Int32    const s_nCOLUMN_SIZE = 256;
            static sal_Int32    const s_nDECIMAL_DIGITS = 0;
            static sal_Int32    const s_nNULLABLE = 1;
            static sal_Int32    const s_nCHAR_OCTET_LENGTH = 65535;
    }
}

static Sequence< ::rtl::OUString> mabColumnNames(37);

OMozabDatabaseMetaData::OMozabDatabaseMetaData(OMozabConnection* _pCon) 	:ODatabaseMetaData(_pCon)
{

OSL_TRACE( "IN OMozabDatabaseMetaData::OMozabDatabaseMetaData()\n" );

    
    m_pMozConnection    =   _pCon;

    // Column names (in total 37) in mozilla addressbooks are constant. 
    // Refer to ~/mozilla/mailnews/addrbook/src/nsAddrDatabase.cpp.
    // Use mozilla method nsIAbCard::getCardValue("FirstName"); etc. to
    // access the right field in the addressbook.

    for (sal_Int32 i(FIRSTNAME); i < END; ++i) {
        mabColumnNames[i]  =  (_pCon->getColumnAlias().getAlias())[i];
    }

    // Initialize Mozilla side (XPCOM, etc.)
    // Use a ref counter so OK to call multiple times

    // nsresult rv = NS_InitEmbedding( nsnull, nsnull );

//OSL_TRACE( "MAB_NS_Init return value = %d\n", rv );
    

OSL_TRACE( "\tOUT OMozabDatabaseMetaData::OMozabDatabaseMetaData()\n" );

}
// -------------------------------------------------------------------------
OMozabDatabaseMetaData::~OMozabDatabaseMetaData()
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::~OMozabDatabaseMetaData()\n" );


    // Terminate Mozilla side (XPCOM, etc.)
    // Use a ref counter so OK to call multiple times
    // MAB_NS_Term();
    // NS_TermEmbedding();

}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL OMozabDatabaseMetaData::getTypeInfo() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getTypeInfo()\n" );

    ::osl::MutexGuard aGuard( m_aMutex );

	ODatabaseMetaDataResultSet* pResult = new ODatabaseMetaDataResultSet();
    Reference< XResultSet > xRef = pResult;
	pResult->setTypeInfoMap();
	static ODatabaseMetaDataResultSet::ORows aRows;
	
	if(aRows.empty())
	{
		ODatabaseMetaDataResultSet::ORow aRow;
		aRow.reserve(18);
		aRow.push_back(ODatabaseMetaDataResultSet::getEmptyValue());
		aRow.push_back(new ORowSetValueDecorator(::rtl::OUString::createFromAscii("VARCHAR")));
		aRow.push_back(new ORowSetValueDecorator(DataType::VARCHAR));
		aRow.push_back(new ORowSetValueDecorator((sal_Int32)s_nCHAR_OCTET_LENGTH));
		aRow.push_back(ODatabaseMetaDataResultSet::getQuoteValue());
		aRow.push_back(ODatabaseMetaDataResultSet::getQuoteValue());
		aRow.push_back(ODatabaseMetaDataResultSet::getEmptyValue());
		aRow.push_back(new ORowSetValueDecorator((sal_Int32)ColumnValue::NULLABLE));
		aRow.push_back(ODatabaseMetaDataResultSet::get1Value());
		aRow.push_back(new ORowSetValueDecorator((sal_Int32)ColumnSearch::CHAR));
		aRow.push_back(ODatabaseMetaDataResultSet::get1Value());
		aRow.push_back(ODatabaseMetaDataResultSet::get0Value());
		aRow.push_back(ODatabaseMetaDataResultSet::get0Value());
		aRow.push_back(ODatabaseMetaDataResultSet::getEmptyValue());
		aRow.push_back(ODatabaseMetaDataResultSet::get0Value());
		aRow.push_back(ODatabaseMetaDataResultSet::get0Value());
		aRow.push_back(ODatabaseMetaDataResultSet::getEmptyValue());
		aRow.push_back(ODatabaseMetaDataResultSet::getEmptyValue());
		aRow.push_back(new ORowSetValueDecorator((sal_Int32)10));

		aRows.push_back(aRow);

		aRow[1] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("VARCHAR"));
		aRow[2] = new ORowSetValueDecorator(DataType::VARCHAR);
		aRow[3] = new ORowSetValueDecorator((sal_Int32)65535);
		aRows.push_back(aRow);
	}
	pResult->setRows(aRows);
	return xRef;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getCatalogSeparator() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL OMozabDatabaseMetaData::getColumns( 
	const Any& catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& tableNamePattern, 
	const ::rtl::OUString& columnNamePattern ) throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN OMozabDatabaseMetaData::getColumns()\n" );

    // This is a very lean implementation for now. It is assumed that all columns
    // have identical properties except for their name, which comes from the array
    // mabColumnNames.
	::osl::MutexGuard aGuard( m_aMutex );

    Reference< XTablesSupplier > xTables = m_pConnection->createCatalog();
	if(!xTables.is())
        throw SQLException();

	Reference< XNameAccess> xNames = xTables->getTables();
	if(!xNames.is())
        throw SQLException();

    ODatabaseMetaDataResultSet::ORows aRows; // temp added.
    ODatabaseMetaDataResultSet::ORow aRow(19); // temp added.
    // NUM_PREC_RADIX
	aRow[10] = new ORowSetValueDecorator((sal_Int32)10);
    // Sequence of table names.
	Sequence< ::rtl::OUString> aTabNames(xNames->getElementNames());
	const ::rtl::OUString* pTabBegin = aTabNames.getConstArray();
	const ::rtl::OUString* pTabEnd   = pTabBegin + aTabNames.getLength();
    // Iterate over all tables in the catalog.
	for(;pTabBegin != pTabEnd;++pTabBegin)
	{
		if(match(tableNamePattern,*pTabBegin,'\0'))
		{
			aRow[1] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii(""));
			aRow[2] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii(""));
            // TABLE_NAME 
			aRow[3] = new ORowSetValueDecorator(*pTabBegin); 
OSL_TRACE( "\t\tTableName = %s;\n",OUtoCStr(*pTabBegin));
			//	Sequence< ::rtl::OUString> aColNames = mabColumnNames; // Column names are constant.
			const ::rtl::OUString* pBegin = mabColumnNames.getConstArray();
			const ::rtl::OUString* pEnd   = pBegin + mabColumnNames.getLength();
			Reference< XPropertySet> xColumn;
            // Iterate over all collumns in the table.
			for(sal_Int32 i=1;pBegin != pEnd;++pBegin,++i)
			{
				if(match(columnNamePattern,*pBegin,'\0'))
				{
OSL_TRACE( "\t\t\tColumnName = %s;\n",OUtoCStr(*pBegin));
                    // COLUMN_NAME 
					aRow[4] = new ORowSetValueDecorator(*pBegin);               
                    // DATA_TYPE 
					aRow[5] = new ORowSetValueDecorator(static_cast<sal_Int16>(DataType::VARCHAR)); 
                    // TYPE_NAME, not used
					aRow[6] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("VARCHAR"));
                    // COLUMN_SIZE 
					aRow[7] = new ORowSetValueDecorator(s_nCOLUMN_SIZE); 
                    // BUFFER_LENGTH, not used 
					aRow[8] = ODatabaseMetaDataResultSet::getEmptyValue();                   
                    // DECIMAL_DIGITS.
					aRow[9] = new ORowSetValueDecorator(s_nDECIMAL_DIGITS);
                    // NULLABLE
					aRow[11] = new ORowSetValueDecorator(s_nNULLABLE); 
                    // REMARKS 
					aRow[12] = ODatabaseMetaDataResultSet::getEmptyValue();                  
                    // COULUMN_DEF, not used 
					aRow[13] = ODatabaseMetaDataResultSet::getEmptyValue();                  
                    // SQL_DATA_TYPE, not used
					aRow[14] = ODatabaseMetaDataResultSet::getEmptyValue();                  
                    // SQL_DATETIME_SUB, not used 
					aRow[15] = ODatabaseMetaDataResultSet::getEmptyValue();                  
                    // CHAR_OCTET_LENGTH, refer to [5]
					aRow[16] = new ORowSetValueDecorator(s_nCHAR_OCTET_LENGTH);
                    // ORDINAL_POSITION
					aRow[17] = new ORowSetValueDecorator(i);                    
                    // IS_NULLABLE
					aRow[18] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("YES"));

					aRows.push_back(aRow);
				}
			}
		}
	}

	ODatabaseMetaDataResultSet* pResult = new ODatabaseMetaDataResultSet();
    Reference< XResultSet > xRef = pResult;
	pResult->setColumnsMap();
	pResult->setRows(aRows);


OSL_TRACE( "\tOUT OMozabDatabaseMetaData::getColumns()\n" );

	return xRef;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL OMozabDatabaseMetaData::getTables( 
	const Any& catalog, const ::rtl::OUString& schemaPattern, 
	const ::rtl::OUString& tableNamePattern, const Sequence< ::rtl::OUString >& types ) throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN OMozabDatabaseMetaData::getTables()\n" );

    ::osl::MutexGuard aGuard( m_aMutex );

	ODatabaseMetaDataResultSet* pResult = new ODatabaseMetaDataResultSet();
    Reference< XResultSet > xRef = pResult;
	pResult->setTablesMap();

	// Check if any type is given
	// when no types are given then we have to return all tables e.g. TABLE

	::rtl::OUString aTable(::rtl::OUString::createFromAscii("TABLE"));

    // (Only) Checking the table types. For now not supporting catalog and
    // tableNamePattern. We might ignore it???
	sal_Bool bTableFound = sal_True;
	sal_Int32 nLength = types.getLength();
	if(nLength)
	{
		bTableFound = sal_False;
		
		const ::rtl::OUString* pBegin = types.getConstArray();
		const ::rtl::OUString* pEnd	= pBegin + nLength;
		for(;pBegin != pEnd;++pBegin)
		{
			if(*pBegin == aTable)
			{
				bTableFound = sal_True;
				break;
			}
		}
	}
	if(!bTableFound)
		return xRef;

    OMozabDatabaseMetaDataHelper    mdbHelper;
	pResult->setRows(mdbHelper.getTables( m_pMozConnection ));


OSL_TRACE( "\tOUT OMozabDatabaseMetaData::getTables()\n" );

	return xRef;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxBinaryLiteralLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxBinaryLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxRowSize() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxRowSize()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxCatalogNameLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxCatalogNameLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxCharLiteralLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxCharLiteralLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxColumnNameLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxColumnNameLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxColumnsInIndex() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxColumnsInIndex()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxCursorNameLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxCursorNameLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxConnections() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxConnections()\n" );

	return 1;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxColumnsInTable() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxColumnsInTable()\n" );

	return mabColumnNames.getLength(); // the length of the static member never change
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxStatementLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxStatementLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxTableNameLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxTableNameLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxTablesInSelect() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxTablesInSelect()\n" );

	return 1;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::doesMaxRowSizeIncludeBlobs() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::doesMaxRowSizeIncludeBlobs()\n" );

	return sal_True; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::storesLowerCaseQuotedIdentifiers() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesLowerCaseQuotedIdentifiers()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::storesLowerCaseIdentifiers() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesLowerCaseIdentifiers()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::storesMixedCaseQuotedIdentifiers() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesMixedCaseQuotedIdentifiers()\n" );

	return sal_True; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::storesMixedCaseIdentifiers() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesMixedCaseIdentifiers()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::storesUpperCaseQuotedIdentifiers() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesUpperCaseQuotedIdentifiers()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::storesUpperCaseIdentifiers() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesUpperCaseIdentifiers()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsAlterTableWithAddColumn() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesAlterTableWithAddColumn()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsAlterTableWithDropColumn() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::storesAlterTableWithDropColumn()\n" );

	return sal_False; 
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxIndexLength() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getMaxIndexLength()\n" );

	return 0;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsNonNullableColumns() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::supportsNonNullableColumns()\n" );

	return sal_False;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getCatalogTerm() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getCatalogTerm()\n" );

	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getIdentifierQuoteString() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getIdentifierQuoteString()\n" );

	return ::rtl::OUString::createFromAscii("\"");
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getExtraNameCharacters() throw(SQLException, RuntimeException)
{
OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::getExtraNameCharacters()\n" );

	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsDifferentTableCorrelationNames() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::supportsDifferentTableCorrelationNames()\n" );

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::isCatalogAtStart() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::isCatalogAtStart()\n" );

	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::dataDefinitionIgnoredInTransactions() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::dataDefinitionIgnoredInTransactions()\n" );

	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::dataDefinitionCausesTransactionCommit() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::dataDefinitionCausesTransactionCommit()\n" );

	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsDataManipulationTransactionsOnly() throw(SQLException, RuntimeException)
{

OSL_TRACE( "IN/OUT OMozabDatabaseMetaData::dataDefinitionCausesTransactionsOnly()\n" );

	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsDataDefinitionAndDataManipulationTransactions() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsPositionedDelete() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsPositionedUpdate() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsOpenStatementsAcrossRollback() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsOpenStatementsAcrossCommit() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsOpenCursorsAcrossCommit() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsOpenCursorsAcrossRollback() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsTransactionIsolationLevel( sal_Int32 level ) throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSchemasInDataManipulation() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsANSI92FullSQL() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsANSI92EntryLevelSQL() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsIntegrityEnhancementFacility() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSchemasInIndexDefinitions() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSchemasInTableDefinitions() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCatalogsInTableDefinitions() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCatalogsInIndexDefinitions() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCatalogsInDataManipulation() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsOuterJoins() throw(SQLException, RuntimeException)
{
	return sal_False ;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxStatements() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxProcedureNameLength() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxSchemaNameLength() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsTransactions() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::allProceduresAreCallable() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsStoredProcedures() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSelectForUpdate() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::allTablesAreSelectable() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::isReadOnly() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::usesLocalFiles() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::usesLocalFilePerTable() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsTypeConversion() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::nullPlusNonNullIsNull() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsColumnAliasing() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsTableCorrelationNames() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsConvert( sal_Int32 fromType, sal_Int32 toType ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsExpressionsInOrderBy() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsGroupBy() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsGroupByBeyondSelect() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsGroupByUnrelated() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsMultipleTransactions() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsMultipleResultSets() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsLikeEscapeClause() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsOrderByUnrelated() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsUnion() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsUnionAll() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsMixedCaseIdentifiers() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsMixedCaseQuotedIdentifiers() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::nullsAreSortedAtEnd() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::nullsAreSortedAtStart() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::nullsAreSortedHigh() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::nullsAreSortedLow() throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSchemasInProcedureCalls() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSchemasInPrivilegeDefinitions() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCatalogsInProcedureCalls() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCatalogsInPrivilegeDefinitions() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCorrelatedSubqueries() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSubqueriesInComparisons() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSubqueriesInExists() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSubqueriesInIns() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsSubqueriesInQuantifieds() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsANSI92IntermediateSQL() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getURL() throw(SQLException, RuntimeException)
{
    ::osl::MutexGuard aGuard( m_aMutex );

	return m_pMozConnection->getConnectionURL();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getUserName() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getDriverName() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getDriverVersion() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString::valueOf((sal_Int32)1);
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getDatabaseProductVersion() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString::valueOf((sal_Int32)0);
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getDatabaseProductName() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getProcedureTerm() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getSchemaTerm() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getDriverMajorVersion() throw(RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getDefaultTransactionIsolation() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getDriverMinorVersion() throw(RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getSQLKeywords() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getSearchStringEscape() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getStringFunctions() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getTimeDateFunctions() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getSystemFunctions() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabDatabaseMetaData::getNumericFunctions() throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsExtendedSQLGrammar() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsCoreSQLGrammar() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsMinimumSQLGrammar() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsFullOuterJoins() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsLimitedOuterJoins() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxColumnsInGroupBy() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxColumnsInOrderBy() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxColumnsInSelect() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabDatabaseMetaData::getMaxUserNameLength() throw(SQLException, RuntimeException)
{
	return 0;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsResultSetType( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsResultSetConcurrency( sal_Int32 setType, sal_Int32 concurrency ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::ownUpdatesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::ownDeletesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::ownInsertsAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::othersUpdatesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::othersDeletesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::othersInsertsAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::updatesAreDetected( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::deletesAreDetected( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::insertsAreDetected( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDatabaseMetaData::supportsBatchUpdates() throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
Reference< XConnection > SAL_CALL OMozabDatabaseMetaData::getConnection() throw(SQLException, RuntimeException)
{
	return (Reference< XConnection >)m_pConnection;
}
// -------------------------------------------------------------------------
