/*************************************************************************
 *
 *  $RCSfile: CKey.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: oj $ $Date: 2001/10/12 11:58:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef DBACCESS_CORE_API_KEY_HXX
#include "CKey.hxx"
#endif
#ifndef DBACCESS_CORE_API_KEYCOLUMNS_HXX
#include "CKeyColumns.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _DBA_CORE_TABLE_HXX_
#include "table.hxx"
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif

using namespace dbaccess;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
// -------------------------------------------------------------------------
OTableKey::OTableKey(	ODBTable* _pTable) : connectivity::sdbcx::OKey(sal_True),m_pTable(_pTable)
{
	construct();
}
// -------------------------------------------------------------------------
OTableKey::OTableKey(	ODBTable* _pTable,
			const ::rtl::OUString& _Name,
			const ::rtl::OUString& _ReferencedTable,
			sal_Int32		_Type,
			sal_Int32		_UpdateRule,
			sal_Int32		_DeleteRule,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbcx::XColumnsSupplier >& _rxKey
			) : connectivity::sdbcx::OKey(_Name,
						  _ReferencedTable,
						  _Type,
						  _UpdateRule,
						  _DeleteRule,sal_True)
				,m_pTable(_pTable)
				,m_xKey(_rxKey)
{
	construct();
	refreshColumns();
}
// -------------------------------------------------------------------------
void OTableKey::refreshColumns()
{
	if(!m_pTable)
		return;

	Reference<XNameAccess> xNames;
	::std::vector< ::rtl::OUString> aVector;
	if(m_xKey.is())
	{
		xNames = m_xKey->getColumns();
		if(xNames.is())
		{
			Sequence< ::rtl::OUString> aNames = xNames->getElementNames();
			const ::rtl::OUString* pBegin	= aNames.getConstArray();
			const ::rtl::OUString* pEnd		= pBegin + aNames.getLength();
			for(;pBegin != pEnd;++pBegin)
				aVector.push_back(*pBegin);
		}
	}
	else if(!isNew())
	{
		::rtl::OUString aSchema,aTable;
		m_pTable->getPropertyValue(PROPERTY_SCHEMANAME)	>>= aSchema;
		m_pTable->getPropertyValue(PROPERTY_NAME)		>>= aTable;

		if(m_Name.getLength()) // foreign key
		{

			//	m_pTable->getPropertyValue(PROPERTY_CATALOGNAME)	>>= aCatalog;
			Reference< XResultSet > xResult = m_pTable->getConnection()->getMetaData()->getImportedKeys(m_pTable->getPropertyValue(PROPERTY_CATALOGNAME),
				aSchema,aTable);


			if(xResult.is())
			{
				Reference< XRow > xRow(xResult,UNO_QUERY);
				while(xResult->next())
				{
					::rtl::OUString aForeignKeyColumn = xRow->getString(8);
					if(xRow->getString(12) == m_Name)
						aVector.push_back(aForeignKeyColumn);
				}
			}
		}
		if(!aVector.size())
		{
			Reference< XResultSet > xResult = m_pTable->getConnection()->getMetaData()->getPrimaryKeys(m_pTable->getPropertyValue(PROPERTY_CATALOGNAME),
				aSchema,aTable);

			if(xResult.is())
			{
				Reference< XRow > xRow(xResult,UNO_QUERY);
				while(xResult->next())
					aVector.push_back(xRow->getString(4));
			}
		}
	}


	if(m_pColumns)
		m_pColumns ->reFill(aVector);
	else
		m_pColumns	= new OKeyColumns(this,m_aMutex,aVector,xNames);
}
// -----------------------------------------------------------------------------
