/*************************************************************************
 *
 *  $RCSfile: CKeys.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: oj $ $Date: 2001/11/08 15:24:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBACCESS_CORE_API_KEYS_HXX
#include "CKeys.hxx"
#endif
#ifndef DBACCESS_CORE_API_KEY_HXX
#include "CKey.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_KEYTYPE_HPP_
#include <com/sun/star/sdbcx/KeyType.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_KEYRULE_HPP_
#include <com/sun/star/sdbc/KeyRule.hpp>
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif

using namespace dbaccess;
using namespace comphelper;
using namespace connectivity::sdbcx;
using namespace connectivity;
using namespace dbtools;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;

typedef connectivity::sdbcx::OCollection OCollection_TYPE;

Any SAL_CALL OKeys::queryInterface( const Type & rType ) throw(RuntimeException)
{
	if(rType == ::getCppuType(static_cast< Reference<XNameAccess> *>(NULL)))
		return Any();
//	if(rType == ::getCppuType(static_cast< Reference<XAppend> *>(NULL)))
//		return Any();
//	if(rType == ::getCppuType(static_cast< Reference<XDrop> *>(NULL)))
//		return Any();
//	if(rType == ::getCppuType(static_cast< Reference<XDataDescriptorFactory> *>(NULL)))
//		return Any();

	return OCollection_TYPE::queryInterface(rType);
}
// -------------------------------------------------------------------------
Sequence< Type > SAL_CALL OKeys::getTypes(  ) throw(RuntimeException)
{
	Sequence< Type > aTypes(OCollection_TYPE::getTypes());
	Type* pBegin	= aTypes.getArray();
	Type* pEnd		= pBegin + aTypes.getLength();

	::std::vector<Type> aOwnTypes;
	aOwnTypes.reserve(aTypes.getLength());	
	for(;pBegin != pEnd; ++pBegin)
	{
		if( *pBegin != ::getCppuType(static_cast< Reference<XNameAccess> *>(NULL)))
			aOwnTypes.push_back(*pBegin);		
	}

	return Sequence< Type >(aOwnTypes.begin(),aOwnTypes.size());
}
// -------------------------------------------------------------------------
Reference< XNamed > OKeys::createObject(const ::rtl::OUString& _rName)
{
	Reference< XNamed > xRet = NULL;

	Reference<XPropertySet> xKey;
	if(m_xMasterKeys.is())
	{
		sal_Int32 nCount = m_xMasterKeys->getCount();
		for(sal_Int32 i=0;i< nCount;++i)
		{
			::cppu::extractInterface(xKey,m_xMasterKeys->getByIndex(i));
			if(xKey.is() && ::comphelper::getString(xKey->getPropertyValue(PROPERTY_NAME)) == _rName)
				break;
			xKey = NULL;
		}
	}
	
	if(xKey.is())
	{
		Reference<XColumnsSupplier > xSup(xKey,UNO_QUERY);
		OSL_ENSURE(xSup.is(),"A Key must be a columns supplier!");

		OTableKey* pRet = new OTableKey(m_pTable,
										_rName,
										::comphelper::getString(xKey->getPropertyValue(PROPERTY_REFERENCEDTABLE)),
										::comphelper::getINT32(xKey->getPropertyValue(PROPERTY_TYPE)),
										::comphelper::getINT32(xKey->getPropertyValue(PROPERTY_UPDATERULE)),
										::comphelper::getINT32(xKey->getPropertyValue(PROPERTY_DELETERULE)),
										xSup);
		xRet = pRet;
	}
	else
	{
		if(_rName.getLength())
		{
			::rtl::OUString aSchema,aTable;
			m_pTable->getPropertyValue(PROPERTY_SCHEMANAME)	>>= aSchema;
			m_pTable->getPropertyValue(PROPERTY_NAME)		>>= aTable;

			Reference< XResultSet > xResult = m_pTable->getConnection()->getMetaData()->getImportedKeys(m_pTable->getPropertyValue(PROPERTY_CATALOGNAME),
				aSchema,aTable);

			if(xResult.is())
			{
				Reference< XRow > xRow(xResult,UNO_QUERY);
				::rtl::OUString aName,aCatalog;
				while(xResult->next())
				{
					// this must be outsid the "if" because we have to call in a right order
					aCatalog	= xRow->getString(1);
					aSchema		= xRow->getString(2);
					aName		= xRow->getString(3);

					sal_Int32 nUpdateRule = xRow->getInt(10);
					sal_Int32 nDeleteRule = xRow->getInt(11);
					if(xRow->getString(12) == _rName)
					{
						::rtl::OUString aComposedName;
						::dbtools::composeTableName(m_pTable->getConnection()->getMetaData(),aCatalog,aSchema,aName,aComposedName,sal_False);
						OTableKey* pRet = new OTableKey(m_pTable,_rName,aComposedName,KeyType::FOREIGN,nUpdateRule,nDeleteRule);
						xRet = pRet;
						break;
					}
				}
			}
		}

		if(!xRet.is()) // we have a primary key with a system name
		{
			OTableKey* pRet = new OTableKey(m_pTable,_rName,::rtl::OUString(),KeyType::PRIMARY,KeyRule::NO_ACTION,KeyRule::NO_ACTION);
			xRet = pRet;
		}
	}

	return xRet;
}
// -------------------------------------------------------------------------
void OKeys::impl_refresh() throw(RuntimeException)
{
	m_pTable->refreshKeys();
}
// -------------------------------------------------------------------------
Reference< XPropertySet > OKeys::createEmptyObject()
{
	Reference<XDataDescriptorFactory> xDataFac(m_xMasterKeys,UNO_QUERY);
	if(xDataFac.is())
		return 	xDataFac->createDataDescriptor();

	return new OTableKey(m_pTable);
}
// -------------------------------------------------------------------------
// XAppend
void OKeys::appendObject( const Reference< XPropertySet >& descriptor )
{
	::rtl::OUString aName = getString(descriptor->getPropertyValue(PROPERTY_NAME));
	Reference<XAppend> xAppend(m_xMasterKeys,UNO_QUERY);
	if(xAppend.is())
	{
		xAppend->appendByDescriptor(descriptor);
	}
	else if(!m_pTable->isNew() )
	{
//		if(m_pTable->getConnection()->getMetaData()->supportsAlterTableWithAddColumn())
//			dbtools::throwGenericSQLException(::rtl::OUString::createFromAscii("Driver does not support AlterTableWithAddColumn!") ,*m_pTable);

		sal_Int32 nKeyType		= getINT32(descriptor->getPropertyValue(PROPERTY_TYPE));

		::rtl::OUString aSql	= ::rtl::OUString::createFromAscii("ALTER TABLE ");
		::rtl::OUString aQuote	= m_pTable->getConnection()->getMetaData()->getIdentifierQuoteString(  );
		::rtl::OUString aDot	= ::rtl::OUString::createFromAscii(".");

		::rtl::OUString aCatalog;
		::rtl::OUString aSchema;
		::rtl::OUString aTable;
		m_pTable->getPropertyValue(PROPERTY_CATALOGNAME)	>>= aCatalog;
		m_pTable->getPropertyValue(PROPERTY_SCHEMANAME)		>>= aSchema;
		m_pTable->getPropertyValue(PROPERTY_NAME)			>>= aTable;

		::rtl::OUString aComposedName;
		composeTableName(m_pTable->getConnection()->getMetaData(),aCatalog,aSchema,aTable,aComposedName,sal_True);

		aSql += aComposedName + ::rtl::OUString::createFromAscii(" ADD ");

		if(nKeyType == KeyType::PRIMARY)
		{
			aSql += ::rtl::OUString::createFromAscii(" PRIMARY KEY (");
		}
		else if(nKeyType == KeyType::FOREIGN)
		{
			aSql += ::rtl::OUString::createFromAscii(" FOREIGN KEY (");
		}
		else
			throw SQLException();

		Reference<XColumnsSupplier> xColumnSup(descriptor,UNO_QUERY);
		Reference<XIndexAccess> xColumns(xColumnSup->getColumns(),UNO_QUERY);
		Reference< XPropertySet > xColProp;
		for(sal_Int32 i=0;i<xColumns->getCount();++i)
		{
			::cppu::extractInterface(xColProp,xColumns->getByIndex(i));
			aSql += ::dbtools::quoteName( aQuote,getString(xColProp->getPropertyValue(PROPERTY_NAME)))
							+ 	::rtl::OUString::createFromAscii(",");
		}
		aSql = aSql.replaceAt(aSql.getLength()-1,1,::rtl::OUString::createFromAscii(")"));

		if(nKeyType == KeyType::FOREIGN)
		{
			::rtl::OUString aRefTable;

			descriptor->getPropertyValue(PROPERTY_REFERENCEDTABLE) >>= aRefTable;
			
			aSql += ::rtl::OUString::createFromAscii(" REFERENCES ")
				 +  ::dbtools::quoteTableName(m_pTable->getConnection()->getMetaData(),aRefTable);
			aSql += ::rtl::OUString::createFromAscii(" (");

			for(sal_Int32 i=0;i<xColumns->getCount();++i)
			{
				::cppu::extractInterface(xColProp,xColumns->getByIndex(i));
				aSql += ::dbtools::quoteName( aQuote,getString(xColProp->getPropertyValue(PROPERTY_RELATEDCOLUMN)))
								+ 	::rtl::OUString::createFromAscii(",");
			}
			aSql = aSql.replaceAt(aSql.getLength()-1,1,::rtl::OUString::createFromAscii(")"));

			sal_Int32 nUpdateRule	= getINT32(descriptor->getPropertyValue(PROPERTY_UPDATERULE));
			switch(nUpdateRule)
			{
				case KeyRule::CASCADE:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON UPDATE CASCADE ");
					break;
				case KeyRule::RESTRICT:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON UPDATE RESTRICT ");
					break;
				case KeyRule::SET_NULL:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON UPDATE SET NULL ");
					break;
				case KeyRule::SET_DEFAULT:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON UPDATE SET DEFAULT ");
					break;
				default:
					;
			}

			sal_Int32 nDeleteRule	= getINT32(descriptor->getPropertyValue(PROPERTY_DELETERULE));
			switch(nDeleteRule)
			{
				case KeyRule::CASCADE:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON DELETE CASCADE ");
					break;
				case KeyRule::RESTRICT:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON DELETE RESTRICT ");
					break;
				case KeyRule::SET_NULL:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON DELETE SET NULL ");
					break;
				case KeyRule::SET_DEFAULT:
					aSql = aSql + ::rtl::OUString::createFromAscii(" ON DELETE SET DEFAULT ");
					break;
				default:
					;
			}
		}

		Reference< XStatement > xStmt = m_pTable->getConnection()->createStatement(  );
		xStmt->execute(aSql);
		// we need a name for the insertion
		if(nKeyType == KeyType::FOREIGN)
		{
			Reference< XResultSet > xResult = m_pTable->getConnection()->getMetaData()->getImportedKeys(Any(),aSchema,aTable);
			if(xResult.is())
			{
				Reference< XRow > xRow(xResult,UNO_QUERY);
				while(xResult->next())
				{
					::rtl::OUString sName = xRow->getString(12);
					ObjectMap::iterator aIter = m_aNameMap.find(sName);
					if( aIter == m_aNameMap.end()) // this name wasn't inserted yet so it must be te new one
					{
						descriptor->setPropertyValue(PROPERTY_NAME,makeAny(sName));
						break;
					}
				}
			}
		}
	}
}
// -------------------------------------------------------------------------
// XDrop
void OKeys::dropObject(sal_Int32 _nPos,const ::rtl::OUString _sElementName)
{
	Reference<XDrop> xDrop(m_xMasterKeys,UNO_QUERY);
	if(xDrop.is())
	{
		xDrop->dropByName(_sElementName);
	}
	else if(!m_pTable->isNew())
	{
		::rtl::OUString aSql	= ::rtl::OUString::createFromAscii("ALTER TABLE ");

		::rtl::OUString aCatalog;
		::rtl::OUString aSchema;
		::rtl::OUString aTable;
		m_pTable->getPropertyValue(PROPERTY_CATALOGNAME)	>>= aCatalog;
		m_pTable->getPropertyValue(PROPERTY_SCHEMANAME)		>>= aSchema;
		m_pTable->getPropertyValue(PROPERTY_NAME)			>>= aTable;

		::rtl::OUString aComposedName;
		composeTableName(m_pTable->getConnection()->getMetaData(),aCatalog,aSchema,aTable,aComposedName,sal_True);
		aSql += aComposedName;

		ObjectIter aIter = m_aElements[_nPos];
		if(!aIter->second.is()) // we want to drop a object which isn't loaded yet so we must load it
			aIter->second = createObject(_sElementName);
		Reference<XPropertySet> xKey(aIter->second,UNO_QUERY);
		sal_Int32 nKeyType = 0;
		xKey->getPropertyValue(PROPERTY_TYPE) >>= nKeyType;

		aSql += ::rtl::OUString::createFromAscii(" DROP CONSTRAINT ");
		::rtl::OUString aQuote	= m_pTable->getConnection()->getMetaData()->getIdentifierQuoteString();
		aSql += aQuote + _sElementName + aQuote;

		Reference< XStatement > xStmt = m_pTable->getConnection()->createStatement(  );
		xStmt->execute(aSql);
		::comphelper::disposeComponent(xStmt);
	}
}
// -----------------------------------------------------------------------------
Reference< XNamed > OKeys::cloneObject(const Reference< XPropertySet >& _xDescriptor)
{
	Reference< XNamed > xName;
	if(!m_pTable->isNew())
	{
		xName = Reference< XNamed >(_xDescriptor,UNO_QUERY);		
		OSL_ENSURE(xName.is(),"Must be a XName interface here !");
		xName = xName.is() ? createObject(xName->getName()) : Reference< XNamed >();
	}
	else
	{
		Reference<XPropertySet> xProp = createEmptyObject();
		::comphelper::copyProperties(_xDescriptor,xProp);
		Reference<XColumnsSupplier> xSup(_xDescriptor,UNO_QUERY);
		Reference<XIndexAccess> xIndex(xSup->getColumns(),UNO_QUERY);
		Reference<XColumnsSupplier> xDestSup(xProp,UNO_QUERY);
		Reference<XAppend> xAppend(xDestSup->getColumns(),UNO_QUERY);
		sal_Int32 nCount = xIndex->getCount();
		for(sal_Int32 i=0;i< nCount;++i)
		{
			Reference<XPropertySet> xColProp;
			xIndex->getByIndex(i) >>= xColProp;
			xAppend->appendByDescriptor(xColProp);
		}
		xName = Reference< XNamed >(xProp,UNO_QUERY);		
	}
	return xName;
}
// -----------------------------------------------------------------------------

