/*************************************************************************
 *
 *  $RCSfile: definitioncontainer.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/01 16:29:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_DEFINITIONCONTAINER_HXX_
#define _DBA_CORE_DEFINITIONCONTAINER_HXX_

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE9_HXX_
#include <cppuhelper/implbase9.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _UNOTOOLS_CONFIGNODE_HXX_
#include <unotools/confignode.hxx>
#endif
#ifndef _DBA_CORE_CONFIGURATIONFLUSHABLE_HXX_
#include "configurationflushable.hxx"
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XEnumerationAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HPP_
#include <com/sun/star/beans/XVetoableChangeListener.hpp>
#endif

//........................................................................
namespace dbaccess
{
//........................................................................

//==========================================================================
//= ODefinitionContainer -	base class of collections of database definition
//=							documents
//==========================================================================
typedef ::cppu::WeakImplHelper9<	::com::sun::star::container::XIndexAccess
								,	::com::sun::star::container::XNameContainer
								,	::com::sun::star::container::XEnumerationAccess
								,	::com::sun::star::container::XContainer
								,	::com::sun::star::lang::XServiceInfo
								,	::com::sun::star::lang::XSingleServiceFactory
								,	::com::sun::star::beans::XPropertyChangeListener
								,	::com::sun::star::beans::XVetoableChangeListener
								,	::com::sun::star::container::XChild
								>	ODefinitionContainer_Base;

class ODefinitionContainer
			:public ODefinitionContainer_Base
			,public OConfigurationFlushable
{
public:
	typedef ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
									PropertySetRef;
	DECLARE_STL_USTRINGACCESS_MAP(::utl::OConfigurationNode, ConfigNodeMap);
	DECLARE_STL_USTRINGACCESS_MAP(PropertySetRef, PropertySetMap);

	struct Document
	{
		::rtl::OUString		sName;
		PropertySetRef		xObject;
		Document(const ::rtl::OUString& _rName, const PropertySetRef& _rxObject)
			:sName(_rName), xObject(_rxObject) { }
	};
	DECLARE_STL_VECTOR(Document, Documents);
private:
		// we can't just hold a vector of PropertySetRefs, as after initialization they're all empty
		// cause we load them only on access

	Documents				m_aDocuments;				// for a efficient index access
	PropertySetMap			m_aDocumentMap;				// for a efficient name access
	ConfigNodeMap			m_aDocumentObjectKeys;		// the top level keys for the object persistence

protected:
	::cppu::OWeakObject&	m_rParent;		// for the ref counting

	::cppu::OInterfaceContainerHelper
							m_aContainerListeners;

	sal_Bool	m_bInitialized : 1;		// the late ctor (initialize) was called ?

public:
	/** constructs the container.<BR>
		after the construction of the object the creator has to call <code>initialize</code>.
		@param		_rParent				the parent object which is used for ref counting
		@param		_rMutex					the parent's mutex object for access safety
	*/
	ODefinitionContainer(
		::cppu::OWeakObject& _rParent,
		::osl::Mutex& _rMutex
		);
	/** looks like the dtor ...
	*/
	virtual ~ODefinitionContainer();

// ::com::sun::star::uno::XInterface
    virtual void SAL_CALL acquire(  ) throw() { m_rParent.acquire(); }
    virtual void SAL_CALL release(  ) throw() { m_rParent.release(); }

// ::com::sun::star::lang::XServiceInfo
	virtual ::rtl::OUString SAL_CALL getImplementationName(  ) throw(::com::sun::star::uno::RuntimeException);
	virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(  ) throw(::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XElementAccess
	virtual ::com::sun::star::uno::Type SAL_CALL getElementType(  ) throw(::com::sun::star::uno::RuntimeException);
	virtual sal_Bool SAL_CALL hasElements(  ) throw(::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XEnumerationAccess
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumeration > SAL_CALL createEnumeration(  ) throw(::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XIndexAccess
	virtual sal_Int32 SAL_CALL getCount(  ) throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Any SAL_CALL getByIndex( sal_Int32 _nIndex ) throw(::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XNameContainer
    virtual void SAL_CALL insertByName( const ::rtl::OUString& _rName, const ::com::sun::star::uno::Any& aElement ) throw(::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::container::ElementExistException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeByName( const ::rtl::OUString& _rName ) throw(::com::sun::star::container::NoSuchElementException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XNameReplace
    virtual void SAL_CALL replaceByName( const ::rtl::OUString& _rName, const ::com::sun::star::uno::Any& aElement ) throw(::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::container::NoSuchElementException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XNameAccess
	virtual ::com::sun::star::uno::Any SAL_CALL getByName( const ::rtl::OUString& aName ) throw(::com::sun::star::container::NoSuchElementException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames(  ) throw(::com::sun::star::uno::RuntimeException);
	virtual sal_Bool SAL_CALL hasByName( const ::rtl::OUString& aName ) throw(::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XContainer
    virtual void SAL_CALL addContainerListener( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XContainerListener >& xListener ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeContainerListener( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XContainerListener >& xListener ) throw(::com::sun::star::uno::RuntimeException);

// ::com::sun::star::lang::XEventListener
	virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) throw(::com::sun::star::uno::RuntimeException);

// ::com::sun::star::lang::XSingleServiceFactory
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > SAL_CALL createInstance(  ) throw(::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > SAL_CALL createInstanceWithArguments( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArguments ) throw(::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

// ::com::sun::star::container::XChild
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > SAL_CALL getParent(  ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setParent( const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& Parent ) throw (::com::sun::star::lang::NoSupportException, ::com::sun::star::uno::RuntimeException);
	// XPropertyChangeListener
	virtual void SAL_CALL propertyChange( const ::com::sun::star::beans::PropertyChangeEvent& evt ) throw (::com::sun::star::uno::RuntimeException);
	// XVetoableChangeListener
	virtual void SAL_CALL vetoableChange( const ::com::sun::star::beans::PropertyChangeEvent& aEvent ) throw (::com::sun::star::beans::PropertyVetoException, ::com::sun::star::uno::RuntimeException);

// helper
	/**	late construction, to be called after the construction of the object
		@see dispose
		@param		_rConfigurationRoot		the configuration node which is the root for all document informations
		@param		_bRead					if sal_True, the objects data is initialized with the data stored under
											the given config node, else only the config node is saved (and propagated
											to all descendants which need to know it).
	*/
	virtual void	initialize(const ::utl::OConfigurationTreeRoot& _rConfigurationRoot, sal_Bool _bRead = sal_True);

	/** tell the container to free all resources. After that it's in a state like after the construction, i.e.
		you may call <code>initialize</code> again (maybe with another configuration node).
	*/
	virtual void	dispose();

	/// flush all persistent information (into the configuration)
	virtual void	flush_NoBroadcast_NoCommit();

	::utl::OConfigurationNode getConfigLocation() const { return m_aConfigurationNode; }

protected:
	/** approve that the object given may be inserted into the container. Should be overloaded by derived classes,
		the default implementation just checks the object to be non-void.
	*/
	virtual sal_Bool approveNewObject(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxObject) const;

	/** create a object from it's persistent data within the configuration. To be overwritten by derived classes.
		@param		_rName			the name the object has within the container
		@param		_rObjectNode	the configuration node under which the object is stored
		@return						the newly created object or an empty reference if somthing went wrong
	*/
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > createObject(
		const ::rtl::OUString& _rName,
		const ::utl::OConfigurationNode& _rObjectNode) = 0;

	/** create a clean object without initial configuration location.
	*/
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > createObject() = 0;

	/**	checks whether the object is basically alive, i.e. it has been fully initialized (@see initialize) and
		not disposed (@see dispose)
		@param		_bIntendWriteAccess		determines whether or not the caller intends to modify the configuration.
											if sal_True and the configuration is readonly, a runtime exception with
											a description string is thrown.
	*/
	void		checkValid(sal_Bool _bIntendWriteAccess) const throw (::com::sun::star::uno::RuntimeException, ::com::sun::star::lang::DisposedException);

	/** checks whether or not the configuration data the object is based on is readonly
	*/
	sal_Bool	isReadOnly() const;

	/** get the object specified by the given name. If desired, the object will be read if not already done so.<BR>
		@param		_rName				the object name
		@param		_bReadIfNeccessary	if sal_True, the object will be read from the configuration if not already done so
		@return							the property set interface of the object. Usually the return value is not NULL, but
										if so, then the object could not be read from the configuration
		@throws							NoSuchElementException if there is no object with the given name.
		@see	createObject
	*/
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
				implGetByName(const ::rtl::OUString& _rName, sal_Bool _bReadIfNeccessary = sal_True) throw (::com::sun::star::container::NoSuchElementException);

	/** quickly checks if there already is an element with a given name. No access to the configuration occures, i.e.
		if there is such an object which is not already loaded, it won't be loaded now.
		@param		_rName		the object name to check
		@return					sal_True if there already exists such an object
	*/
	inline	sal_Bool	checkExistence(const ::rtl::OUString& _rName);

	/** get
	*/

	/** append a new object to the container. No plausibility checks are done, e.g. if the object is non-NULL or
		if the name is already used by another object or anything like this. This method is for derived classes
		which may support different methods to create and/or append objects, and don't want to deal with the
		internal structures of this class.<BR>
		The old component will not be disposed, this is the callers responsibility, too.
		@param		_rName			the name of the new object
		@param		_rxNewObject	the new object (not surprising, is it ?)
		@param		_rObjectNode	the object key of the new object
		@see		createConfigKey
		@see		implReplace
		@see		implRemove
	*/
	void	implAppend(
		const ::rtl::OUString& _rName,
		const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxNewObject,
		const ::utl::OConfigurationNode& _rObjectNode
		);

	/** remove all references to an object from the container. No plausibility checks are done, e.g. whether
		or not there exists an object with the given name. This is the responsibility of the caller.<BR>
		Additionally the node for the given object will be removed from the registry (including all sub nodes).<BR>
		The old component will not be disposed, this is the callers responsibility, too.
		@param			_rName		the objects name
		@see			implReplace
		@see			implAppend
	*/
	void implRemove(const ::rtl::OUString& _rName);

	/** remove a object in the container. No plausibility checks are done, e.g. whether
		or not there exists an object with the given name or the object is non-NULL. This is the responsibility of the caller.<BR>
		Additionally all object-related informations within the registry will be deleted. The new object config node,
		where the caller may want to store the new objects information, is returned.<BR>
		The old component will not be disposed, this is the callers responsibility, too.
		@param			_rName				the objects name
		@param			_rxNewObject		the new object
		@param			_rNewObjectNode		the configuration node where the new object may be stored
		@see			implAppend
		@see			implRemove
	*/
	void implReplace(
		const ::rtl::OUString& _rName,
		const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxNewObject,
		::utl::OConfigurationNode& _rNewObjectNode
		);

	
private:
	void	initializeFromConfiguration();
	void	implInsert(const ::rtl::OUString& _rName, const ::com::sun::star::uno::Any& aElement);
	void	addObjectListener(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _xNewObject);
	void	removeObjectListener(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _xNewObject);
};

//--------------------------------------------------------------------------
inline	sal_Bool ODefinitionContainer::checkExistence(const ::rtl::OUString& _rName)
{
	return m_aDocumentMap.find(_rName) != m_aDocumentMap.end();
}

//........................................................................
}	// namespace dbaccess
//........................................................................

#endif // _DBA_CORE_DEFINITIONCONTAINER_HXX_

