/*************************************************************************
 *
 *	$RCSfile: commonpages.hxx,v $
 *
 *	$Revision: 1.18 $
 *
 *	last change: $Author: oj $ $Date: 2001/09/25 13:24:37 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_COMMONPAGES_HXX_
#define _DBAUI_COMMONPAGES_HXX_

#ifndef _DBAUI_ADMINPAGES_HXX_
#include "adminpages.hxx"
#endif
#ifndef _DBAUI_CONTAINERMULTIPLEXER_HXX_
#include "containermultiplexer.hxx"
#endif
#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _SVTREEBOX_HXX 
#include <svtools/svtreebx.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX 
#include <vcl/toolbox.hxx>
#endif
#ifndef _DBAUI_COMMON_TYPES_HXX_
#include "commontypes.hxx"
#endif
#ifndef _SVTABBX_HXX 
#include <svtools/svtabbx.hxx>
#endif
#ifndef _VOS_REF_HXX_ 
#include <vos/ref.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................
	class OComponentClientMonitor;

	//=========================================================================
	void lcl_removeToolboxItemShortcuts(ToolBox& _rTB);

	//========================================================================
	//= OCollectionPage
	//========================================================================
	class OCollectionPage
			:public OGenericAdministrationPage
			,public OContainerListener
	{
		friend class ODbAdminDialog;

	private:
		SvTabListBox		m_aObjects;

	protected:
		FixedLine			m_aFrame;
		ToolBox 			m_aActions;


		::osl::Mutex	m_aMutex;
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
						m_xORB;
		::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >
						m_xObjects;

		OContainerListenerAdapter*
						m_pListenerAdapter;
		ODbAdminDialog* m_pAdminDialog;

		::rtl::OUString m_sDSName;

		sal_uInt16		m_nObjectNameResId;
		sal_uInt16		m_nPageResId;

	public:
		void setServiceFactory(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > _rxORB)
			{ m_xORB = _rxORB; }

	protected:
		OCollectionPage( Window* pParent, const ResId& _rId, const SfxItemSet& _rCoreAttrs,
			sal_uInt16 _nObjectNameResId );
		~OCollectionPage();

		// OContainerListener
		virtual void _elementInserted( const ::com::sun::star::container::ContainerEvent& _rEvent ) throw(::com::sun::star::uno::RuntimeException);
		virtual void _elementRemoved( const ::com::sun::star::container::ContainerEvent& _Event ) throw(::com::sun::star::uno::RuntimeException);
		virtual void _elementReplaced( const ::com::sun::star::container::ContainerEvent& _rEvent ) throw(::com::sun::star::uno::RuntimeException);

	protected:
		void		implDeleteSelection(sal_uInt16 _nQueryResourceId);
		String		getSelectedObjectName( ) const;

		SvLBoxEntry*	FirstSelected() const { return m_aObjects.FirstSelected(); }
		SvLBoxEntry*	NextSelected( SvLBoxEntry* _pEntry ) const { return m_aObjects.NextSelected( _pEntry ); }
		String 			getEntryText( SvLBoxEntry* _pEntry ) const { return m_aObjects.GetEntryText( _pEntry, 0 ); }
		void			setEntryText( sal_uInt32 _nEntryPos, sal_uInt16 _nCol , const String& _rText) { m_aObjects.SetEntryText( _rText, _nEntryPos, _nCol ); }
		void			setEntryText( SvLBoxEntry* _pEntry, sal_uInt16 _nCol , const String& _rText) { m_aObjects.SetEntryText( _rText, _pEntry, _nCol ); }

	protected:
		void SetAdminDialog(ODbAdminDialog* _pDialog) { m_pAdminDialog = _pDialog; }

		virtual void		ActivatePage(const SfxItemSet& _rSet);
		virtual int 		DeactivatePage(SfxItemSet* _pSet);
		virtual BOOL		FillItemSet(SfxItemSet& _rCoreAttrs);
		virtual void		implInitControls(const SfxItemSet& _rSet, sal_Bool _bSaveValue);

		virtual void			updateButtons();
		virtual void			enableControls(sal_Bool _bEnable = sal_True);
		virtual Image			getEntryImage() const;
		virtual void			insertEntry( const ::rtl::OUString& _rName );
		virtual SvLBoxEntry*	findEntry( const ::rtl::OUString& _rName );

		virtual void			fillViewSettings(OPageSettings* _pSettings);
		virtual void			restoreViewSettings(const OPageSettings* _pSettings);

		virtual void			onEntryDoubleClicked( );
		virtual void			onToolBoxAction( sal_uInt16 _nClickedItemId );

		virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >
						getObjectCollection( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxDatasource ) const = 0;

		DECL_LINK( OnObjectDoubleClicked, void* );
		DECL_LINK( OnToolboxClicked, void* );
		DECL_LINK( OnSelectObject, SvTreeListBox*);
	};

	//========================================================================
	//= OQueryAdministrationPage
	//========================================================================
	class OQueryAdministrationPage : public OCollectionPage
	{
	protected:
		::vos::ORef< OComponentClientMonitor >		m_xConnectionClientMonitor;

	public:
		static	SfxTabPage* Create( Window* _pParent, const SfxItemSet& _rAttrSet);

	protected:
		OQueryAdministrationPage( Window* pParent, const SfxItemSet& _rCoreAttrs );
		~OQueryAdministrationPage();

		virtual int 		DeactivatePage( SfxItemSet* _pSet );

	protected:
		virtual void updateButtons();
		virtual void onToolBoxAction( sal_uInt16 _nClickedItemId );

		virtual OPageSettings*	createViewSettings();

		virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >
						getObjectCollection( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxDatasource ) const;
		virtual Image getEntryImage() const;

	private:
		sal_Bool	createClientMonitor();
		void		deleteClientMonitor();
		const ::vos::ORef< OComponentClientMonitor >&
			getClientMonitor( ) const { return m_xConnectionClientMonitor; }
		void		implRenameSelection();
	};

	//========================================================================
	//= ODocumentLinksPage
	//========================================================================
	class ODocumentLinksPage : public OCollectionPage
	{
	public:
		static	SfxTabPage* Create( Window* _pParent, const SfxItemSet& _rAttrSet);

	protected:
		ODocumentLinksPage( Window* pParent, const SfxItemSet& _rCoreAttrs );

		virtual void		ActivatePage(const SfxItemSet& _rSet);

	protected:
		virtual void	updateButtons();
		virtual void	insertEntry( const ::rtl::OUString& _rName );
		virtual void	onEntryDoubleClicked( );
		virtual void	onToolBoxAction( sal_uInt16 _nClickedItemId );

		virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >
						getObjectCollection( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _rxDatasource ) const;

		void OnOpenDocument();
		void OnEditDocument();
		void OnNewLink();
		void OnEditLink();
		void OnDropLink();

		::rtl::OUString getLocation( const ::rtl::OUString& _rName ) const;

	protected:
		DECL_LINK( OnDropDownToolboxButton, void* );
	};

//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // _DBAUI_COMMONPAGES_HXX_

/*************************************************************************
 * history:
 *	$Log: commonpages.hxx,v $
 *	Revision 1.18  2001/09/25 13:24:37  oj
 *	#91719# implementing the XRename handling
 *	
 *	Revision 1.17  2001/09/07 10:05:12  fs
 *	changes so that different design tasks opened from the query page share the same connection
 *	
 *	Revision 1.16  2001/09/04 11:35:03  vg
 *	#65293# corrected for solaris compiler
 *	
 *	Revision 1.15  2001/08/31 13:35:57  fs
 *	#84000# use the SvTabListBox instead of OTwoColumnTreeList
 *	
 *	Revision 1.14  2001/08/16 14:09:16	fs
 *	#88813# enable calling the form auto pilot from the bookmarks page
 *	
 *	Revision 1.13  2001/05/29 10:00:52	fs
 *	#86082# outsourced the general and the tables page
 *	
 *	Revision 1.12  2001/05/23 13:47:58	fs
 *	#86444# QueryPage: save the data sources before creating/editing a query
 *	
 *	Revision 1.11  2001/05/10 13:35:29	fs
 *	#86223# table create invoked from table administration page / toolbox in query administration page
 *	
 *	Revision 1.10  2001/05/08 12:08:22	fs
 *	createDirectoryDeep now using the UCB
 *	
 *	Revision 1.9  2001/05/08 10:08:46  fs
 *	#86224# interpret dBase and file URLs as paths and create if necessary
 *	
 *	Revision 1.8  2001/04/26 11:40:21  fs
 *	file is alive, again - added support for data source associated bookmarks
 *	
 *	Revision 1.7  2001/04/09 07:30:29  oj
 *	#85663# disable some controlls which aren't used for remote connections
 *	
 *	Revision 1.6  2001/03/29 07:12:18  oj
 *	show views the correct way
 *	
 *	Revision 1.5  2001/03/27 07:34:29  oj
 *	impl new page for adabas
 *	
 *	Revision 1.4  2001/02/05 15:42:07  fs
 *	enlargen the tab pages -> some redesigns
 *	
 *	Revision 1.3  2001/02/05 13:55:19  fs
 *	#83430# apply the dialog's changes before administrating the queries for a new data source
 *	
 *	Revision 1.2  2001/01/30 08:34:41  fs
 *	redesigned the table subscription page
 *	
 *	Revision 1.1  2001/01/26 16:13:58  fs
 *	initial checkin - administration tab pages used for all DSN types
 *	
 *
 *	Revision 1.0 26.01.01 10:36:59	fs
 ************************************************************************/

