/*************************************************************************
 *
 *  $RCSfile: unoorder.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:43:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_UNOORDER_HXX
#include "unoorder.hxx"
#endif
#ifndef _DBU_REGHELPER_HXX_
#include "dbu_reghelper.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBCX_XCOLUMNSSUPPLIER_HPP_ 
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_ 
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_ 
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_ 
#include <com/sun/star/container/XNamed.hpp>
#endif
#ifndef DBAUI_QUERYORDER_HXX
#include "queryorder.hxx"
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif

extern "C" void SAL_CALL createRegistryInfo_ORowsetOrderDialog()
{
	static ::dbaui::OMultiInstanceAutoRegistration< ::dbaui::ORowsetOrderDialog > aAutoRegistration;
}

//.........................................................................
namespace dbaui
{
//.........................................................................

#define PROPERTY_ID_QUERYCOMPOSER		100
#define PROPERTY_ID_ROWSET				101
#define PROPERTY_ID_DEFAULTFIELD		102

	IMPLEMENT_CONSTASCII_USTRING( PROPERTY_QUERYCOMPOSER,	"QueryComposer" );
	IMPLEMENT_CONSTASCII_USTRING( PROPERTY_ROWSET,			"RowSet" );
	IMPLEMENT_CONSTASCII_USTRING( PROPERTY_DEFAULTFIELD,	"DefaultOrderColumn" );

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::sdbcx;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::sdb;

	//=====================================================================
	//= ORowsetOrderDialog
	//=====================================================================
	//---------------------------------------------------------------------
	ORowsetOrderDialog::ORowsetOrderDialog(const Reference< XMultiServiceFactory >& _rxORB)
		:ORowsetOrderDialog_BASE( _rxORB )
	{
		registerProperty( PROPERTY_QUERYCOMPOSER, PROPERTY_ID_QUERYCOMPOSER, PropertyAttribute::TRANSIENT,
			&m_xComposer, ::getCppuType( &m_xComposer ) );
		registerProperty( PROPERTY_ROWSET, PROPERTY_ID_ROWSET, PropertyAttribute::TRANSIENT,
			&m_xRowSet, ::getCppuType( &m_xRowSet ) );
		registerProperty( PROPERTY_DEFAULTFIELD, PROPERTY_ID_DEFAULTFIELD, PropertyAttribute::TRANSIENT,
			&m_xField, ::getCppuType( &m_xField ) );
	}

	//---------------------------------------------------------------------
	ORowsetOrderDialog::~ORowsetOrderDialog()
	{
	}

	//---------------------------------------------------------------------
	IMPLEMENT_IMPLEMENTATION_ID( ORowsetOrderDialog )

	//---------------------------------------------------------------------
	IMPLEMENT_SERVICE_INFO1_STATIC( ORowsetOrderDialog, "com.sun.star.uno.comp.sdb.RowsetOrderDialog", "com.sun.star.sdb.OrderDialog" )

	//---------------------------------------------------------------------
	IMPLEMENT_PROPERTYCONTAINER_DEFAULTS( ORowsetOrderDialog )

	//---------------------------------------------------------------------
	Dialog*	ORowsetOrderDialog::createDialog(Window* _pParent)
	{
		// obtain all the objects needed for the dialog
		Reference< XConnection > xConnection;
		Reference< XNameAccess > xColumns;
		::rtl::OUString sFieldName;
		try
		{
			// the connection the row set is working with
			Reference< XPropertySet > xRowsetProps( m_xRowSet, UNO_QUERY );
			if ( xRowsetProps.is() )
				xRowsetProps->getPropertyValue( PROPERTY_ACTIVECONNECTION ) >>= xConnection;

			// the columns of the row set
			Reference< XColumnsSupplier > xSuppColumns( m_xRowSet, UNO_QUERY );
			if ( xSuppColumns.is() )
				xColumns = xSuppColumns->getColumns();

		}
		catch( const Exception& )
		{
			OSL_ENSURE( sal_False, "ORowsetOrderDialog::createDialog: caught an exception!" );
		}

		if	(	!xConnection.is()
			||	!m_xComposer.is()
			||	!xColumns.is()
			)
			// can't create the dialog if I have improper settings
			return NULL;

		return new DlgOrderCrit( _pParent, xConnection, m_xComposer, xColumns,m_xField);
	}

	//---------------------------------------------------------------------
	void ORowsetOrderDialog::executedDialog( sal_Int16 _nExecutionResult )
	{
		ORowsetOrderDialog_BASE::executedDialog( _nExecutionResult );

		if ( _nExecutionResult && m_pDialog )
			static_cast< DlgOrderCrit* >( m_pDialog )->BuildOrderPart();
		else if ( m_xComposer.is() )
			m_xComposer->setOrder( static_cast< DlgOrderCrit* >( m_pDialog )->GetOrignalOrder() );
	}

//.........................................................................
}	// namespace dbaui
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: unoorder.cxx,v $
 *	Revision 1.1.2.1  2002/05/31 14:43:10  mh
 *	join: from SRC641
 *	
 *	Revision 1.1  2002/03/04 13:09:49  oj
 *	#97043# enable service for order dialog
 *	
 *	Revision 1.1  2001/08/17 09:20:24  fs
 *	initial checkin - UNO wrapper for the filter dialog
 *	
 *
 *	Revision 1.0 17.08.01 08:55:46  fs
 ************************************************************************/


