/*************************************************************************
 *
 *  $RCSfile: wrapper.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: as $ $Date: 2001/08/22 13:05:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "wrapper.hxx"

#include <offmgr/app.hxx>
#include <sw/swdll.hxx>
#include <sc/scdll.hxx>
#include <sd/sddll.hxx>
#include <sch/schdll.hxx>
#include <starmath/smdll.hxx>
#include <svx/svdetc.hxx>
#include <osl/mutex.hxx>
#include <cppuhelper/factory.hxx>
#include <sfx2/docfac.hxx>
#include <sfx2/docfilt.hxx>
#include <sfx2/fcontnr.hxx>
#include <sfx2/app.hxx>
#include <sfx2/imagemgr.hxx>
#include <framework/imageproducer.hxx>
#include <unotools/processfactory.hxx>

#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_HELPOPT_HXX
#include <svtools/helpopt.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

#define DEFINE_CONST_UNICODE(CONSTASCII)        UniString(RTL_CONSTASCII_USTRINGPARAM(CONSTASCII##))

static SwDLL*			pSwDLL=0;
static SdDLL*			pSdDLL=0;
static ScDLL*			pScDLL=0;
static SchDLL*			pSchDLL=0;
static SimDLL*			pSimDLL=0;
static SmDLL*			pSmDLL=0;
static OfficeWrapper*	pOfficeWrapper=0;

SFX_IMPL_XSERVICEINFO( OfficeWrapper, "com.sun.star.office.OfficeWrapper", "com.sun.star.comp.desktop.OfficeWrapper" )

Reference< XInterface >  SAL_CALL OfficeWrapper_CreateInstance( const Reference< XMultiServiceFactory >  & rSMgr )
{
	static osl::Mutex	aMutex;

	if ( pOfficeWrapper == 0 )
	{
		osl::MutexGuard guard( aMutex );
		if ( pOfficeWrapper == 0 )
			return (XComponent*) ( new OfficeWrapper( rSMgr ) );
	}

	return (XComponent*)0;
}


OfficeWrapper::OfficeWrapper( const Reference < XMultiServiceFactory >& xFactory )
    : aListeners( aMutex )
    , pApp( new OfficeApplication )
	, pSfxHelp( 0 )
{
	SvtModuleOptions aMOpt;
//    if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SWRITER ) )
    {
        pSwDLL  = new SwDLL;
		SwDLL::LibInit();
    }
    if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SDRAW ) || aMOpt.IsModuleInstalled( SvtModuleOptions::E_SIMPRESS ) )
    {
        pSdDLL  = new SdDLL;
		SdDLL::LibInit();
    }
    if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCALC ) )
    {
        pScDLL  = new ScDLL;
		ScDLL::LibInit();
    }
    if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCHART ) )
	{
        pSchDLL = new SchDLL;
		SchDLL::LibInit();
	}
    if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SMATH ) )
	{
        pSmDLL = new SmDLL;
		SmDLL::LibInit();
	}
}

void SAL_CALL OfficeWrapper::initialize( const Sequence< Any >& aArguments ) throw( Exception )
{
	// Help instance it must be destroyed before Deinit (sends AppEvent in DTOR)
	pSfxHelp = new SfxHelp;

	rtl::OUString aDescription;
	if ( aArguments.getLength() > 0 )
		aArguments[0] >>= aDescription;

	if ( aDescription.getLength())
	{
		sal_Int32   index;
		sal_Int32   lastIndex = 0;
		do
		{
			index = aDescription.indexOf((sal_Unicode) ',', lastIndex);
			::rtl::OUString token = (index == -1) ? aDescription.copy(lastIndex) : aDescription.copy(lastIndex, index - lastIndex);
			lastIndex = index + 1;
			sal_Int32 eindex = token.indexOf((sal_Unicode)'=');
			::rtl::OUString left = token.copy(0, eindex).toAsciiLowerCase().trim();
			::rtl::OUString right = token.copy(eindex + 1).trim();
			if( left.equals( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "ticket" ))))
			{
				pSfxHelp->SetTicket( right );
			}
			if(left.equals( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "user" ))))
			{
				pSfxHelp->SetUser( right );
			}
		}
		while( index != -1 );
	}

	::framework::SetImageProducer( GetImage );

	Application::SetHelp( pSfxHelp );
	if ( SvtHelpOptions().IsExtendedHelp() )
		Help::EnableBalloonHelp();
	else
		Help::DisableBalloonHelp();
	if ( SvtHelpOptions().IsHelpTips() )
		Help::EnableQuickHelp();
	else
		Help::DisableQuickHelp();

}

OfficeWrapper::~OfficeWrapper()
{
    {
		// all ConfigItems must be destroyed before destroying the SfxApp
		delete pSfxHelp;
		pSfxHelp = NULL;

		SvtModuleOptions aMOpt;

        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCHART ) )
		{
			SchDLL::LibExit();
			DELETEZ( pSchDLL );
		}
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SMATH ) )
		{
			SmDLL::LibExit();
			DELETEZ( pSmDLL );
		}
      //  if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SWRITER ) )
		{
			SwDLL::LibExit();
			DELETEZ( pSwDLL );
		}
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SDRAW ) || aMOpt.IsModuleInstalled( SvtModuleOptions::E_SIMPRESS ) )
		{
			SdDLL::LibExit();
			DELETEZ( pSdDLL );
		}
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCALC ) )
		{
			ScDLL::PreExit();           // der Teil vom Exit der noch Svx etc. braucht
			ScDLL::LibExit();
			DELETEZ( pScDLL );
		}
    }

    delete pApp;
    delete &GetSdrGlobalData(); // ??????????
}

void SAL_CALL OfficeWrapper::dispose() throw ( RuntimeException )
{
    EventObject aObject;
    aObject.Source = (XComponent*)this;
    aListeners.disposeAndClear( aObject );
}

void SAL_CALL OfficeWrapper::addEventListener( const Reference< XEventListener > & aListener) throw ( RuntimeException )
{
    aListeners.addInterface( aListener );
}

void SAL_CALL OfficeWrapper::removeEventListener( const Reference< XEventListener > & aListener ) throw ( RuntimeException )
{
    aListeners.removeInterface( aListener );
}

extern "C"
{

void SAL_CALL component_getImplementationEnvironment(	const	sal_Char**			ppEnvironmentTypeName	,
																uno_Environment**	ppEnvironment			)
{
	*ppEnvironmentTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME ;
}

sal_Bool SAL_CALL component_writeInfo(  void*   pServiceManager , void*   pRegistryKey    )
{
    Reference< XMultiServiceFactory >  xMan( reinterpret_cast< XMultiServiceFactory* >( pServiceManager ) ) ;
//    ::utl::setProcessServiceFactory( xMan );
    Reference< XRegistryKey > xKey( reinterpret_cast< XRegistryKey* >( pRegistryKey ) ) ;

    // Eigentliche Implementierung und ihre Services registrieren
    ::rtl::OUString aTempStr;

    ::rtl::OUString aImpl( RTL_CONSTASCII_USTRINGPARAM("/") );
    aImpl += OfficeWrapper::impl_getStaticImplementationName();
    aImpl += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/UNO/SERVICES"));
    Reference< XRegistryKey > xNewKey = xKey->createKey( aImpl );
    xNewKey->createKey( ::rtl::OUString::createFromAscii("com.sun.star.office.OfficeWrapper") );

	return sal_True;
}

void* SAL_CALL component_getFactory(	const	sal_Char*	pImplementationName	,
												void*		pServiceManager		,
												void*		pRegistryKey		)
{
	// Set default return value for this operation - if it failed.
	void* pReturn = NULL ;
    if  ( pImplementationName && pServiceManager )
	{
		// Define variables which are used in following macros.
        Reference< XSingleServiceFactory >   xFactory                                             ;
        Reference< XMultiServiceFactory >    xServiceManager( reinterpret_cast< XMultiServiceFactory* >( pServiceManager ) ) ;

        if ( OfficeWrapper::impl_getStaticImplementationName().compareToAscii( pImplementationName ) == COMPARE_EQUAL )
        {
			xFactory = Reference< XSingleServiceFactory >( cppu::createSingleFactory( xServiceManager, OfficeWrapper::impl_getStaticImplementationName(),
																OfficeWrapper_CreateInstance, OfficeWrapper::impl_getStaticSupportedServiceNames() ) );
        }

		// Factory is valid - service was found.
		if ( xFactory.is() )
		{
			xFactory->acquire();
			pReturn = xFactory.get();
		}
	}

	// Return with result of this operation.
	return pReturn ;
}

} // extern "C"
