/*************************************************************************
 *
 *  $RCSfile: pkgchk_basic.cxx,v $
 *
 *  $Revision: 1.3.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 14:39:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"

#include <com/sun/star/io/XActiveDataSource.hpp>
#include <com/sun/star/xml/sax/XParser.hpp>
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>


using namespace ::std;
using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;

namespace pkgchk
{

//__________________________________________________________________________________________________
void pkgchk_env::basic_flush( basic_libs * libs ) const
    SAL_THROW( (RuntimeException) )
{
    if (!libs->m_inited || !libs->m_modified)
        return;
    
    ::xmlscript::LibDescriptorArray export_array( libs->m_map.size() );
    t_libs_map::iterator iPos( libs->m_map.begin() );
    t_libs_map::iterator iEnd( libs->m_map.end() );
    size_t nPos = 0;
    while (iPos != iEnd)
    {
        export_array.mpLibs[ nPos ] = iPos->second;
        ++nPos;
        ++iPos;
    }
    
    try
    {
        // raise sax writer
        Reference< XComponentContext > const & xContext = get_component_context();
        Reference< xml::sax::XExtendedDocumentHandler > xHandler(
            xContext->getServiceManager()->createInstanceWithContext(
                OUSTR("com.sun.star.xml.sax.Writer"), xContext ), UNO_QUERY );
        if (! xHandler.is())
        {
            throw RuntimeException(
                OUSTR("no sax writer available!"), Reference< XInterface >() );
        }
        
        Reference< io::XActiveDataSource > xSource( xHandler, UNO_QUERY );
        get_ucb_cmdproc(); // ensure initialized ucb
        // try to erase xlc file
        File::remove( libs->m_container_path );
        // create new one
        xSource->setOutputStream(
            get_simple_file_access()->openFileWrite( libs->m_container_path ) );
        
        ::xmlscript::exportLibraryContainer( xHandler, &export_array );
    }
    catch (RuntimeException &)
    {
        throw;
    }
    catch (Exception & exc)
    {
        throw RuntimeException(
            exc.Message, Reference< XInterface >() );
    }
    
    libs->m_modified = false;
    
    OUStringBuffer buf( 64 );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("updated basic library container file ") );
    buf.append( libs->m_container_path );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
    log( buf.makeStringAndClear() );
}
//__________________________________________________________________________________________________
void pkgchk_env::basic_verify_init( basic_libs * libs )
    SAL_THROW( () )
{
    if (! libs->m_inited)
    {
        if (path_exists( libs->m_container_path ))
        {
            OUStringBuffer buf( 128 );
            buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("reading basic library container file ") );
            buf.append( libs->m_container_path );
            try
            {
                // raise sax parser
                Reference< XComponentContext > const & xContext = get_component_context();
                Reference< xml::sax::XParser > xParser(
                    xContext->getServiceManager()->createInstanceWithContext(
                        OUSTR("com.sun.star.xml.sax.Parser"), xContext ), UNO_QUERY );
                if (! xParser.is())
                {
                    throw RuntimeException(
                        OUSTR("no sax parser available!"), Reference< XInterface >() );
                }
                
                // error handler, entity resolver omitted
                ::xmlscript::LibDescriptorArray import_array;
                xParser->setDocumentHandler( ::xmlscript::importLibraryContainer( &import_array ) );
                
                xml::sax::InputSource source;
                get_ucb_cmdproc(); // ensure initialized ucb
                source.aInputStream = get_simple_file_access()->openFileRead(
                    libs->m_container_path );
                source.sSystemId = libs->m_container_path;
                xParser->parseStream( source );
                
                for ( sal_Int32 nPos = import_array.mnLibCount; nPos--; )
                {
                    ::xmlscript::LibDescriptor const & descr = import_array.mpLibs[ nPos ];
                    pair< t_libs_map::iterator, bool > insertion(
                        libs->m_map.insert( t_libs_map::value_type( descr.aName, descr ) ) );
                    OSL_ASSERT( insertion.second );
                }
                
                buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
            }
            catch (Exception & exc)
            {
                buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": failed!  exception occured: ") );
                buf.append( exc.Message );
            }
            log( buf.makeStringAndClear() );
        }
        libs->m_modified = false;
        libs->m_inited = true;
    }
}
//==================================================================================================
static inline OUString basic_path_get_libname( OUString const & path ) SAL_THROW( () )
{
    sal_Int32 slash_end = path.lastIndexOf( '/' );
    sal_Int32 slash_start = path.lastIndexOf( '/', slash_end -1 );
    OSL_ASSERT( slash_end >= 0 && slash_end >= 0 );
    if (slash_end > slash_start)
    {
        return path.copy( slash_start +1, slash_end - slash_start -1 );
    }
    return OUString();
}
//__________________________________________________________________________________________________
bool pkgchk_env::basic_insert( basic_libs * libs, ::rtl::OUString const & path )
    SAL_THROW( () )
{
    ::xmlscript::LibDescriptor descr;
    descr.aName = basic_path_get_libname( path );
    if (descr.aName.getLength())
    {
        descr.aStorageURL = path;
        descr.bLink = sal_False;
        // all other fields are ignored by xmlscript lib export        
        basic_verify_init( libs );
        if (m_supersede_basic_libs)
        {
            t_libs_map::const_iterator iFind( libs->m_map.find( descr.aName ) );
            if (libs->m_map.end() != iFind) // found one
            {
                if (! path_equals( path_make_absolute( iFind->second.aStorageURL ),
                                   path_make_absolute( descr.aStorageURL ) )) // different lib?
                {
                    libs->m_map[ descr.aName ] = descr;
                    libs->m_modified = true;
                }
                return true;
            }
        }
        pair< t_libs_map::iterator, bool > insertion(
            libs->m_map.insert( t_libs_map::value_type( descr.aName, descr ) ) );
        if (insertion.second)
        {
            libs->m_modified = true;
            return true;
        }
    }
    return false;
}
//__________________________________________________________________________________________________
bool pkgchk_env::basic_remove( basic_libs * libs, ::rtl::OUString const & path, bool exact )
    SAL_THROW( () )
{
    bool ret = false;
    basic_verify_init( libs );
    if (exact)
    {
        OUString libname( basic_path_get_libname( path ) );
        if (libname.getLength())
        {
            size_t erased = libs->m_map.erase( libname );
            OSL_ASSERT( 1 == erased );
            if (0 < erased)
            {
                libs->m_modified = true;
                ret = true;
            }
        }
    }
    else // erase some matching url
    {
        t_libs_map::iterator iPos( libs->m_map.begin() );
        t_libs_map::iterator iEnd( libs->m_map.end() );
        while (iPos != iEnd)
        {
            OUString const & url = iPos->second.aStorageURL;
            if (url.matchIgnoreAsciiCase( path ))
            {
                t_libs_map::iterator iErase( iPos );
                ++iPos;
                libs->m_map.erase( iErase );
                libs->m_modified = true;
                ret = true;
            }
            else
            {
                ++iPos;
            }
        }
    }
    return ret;
}

}
