/*************************************************************************
 *
 *  $RCSfile: test_unxcb.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2001/09/12 09:55:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <unistd.h>

#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_XTRANSFERABLE_HPP_
#include <com/sun/star/datatransfer/XTransferable.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARDOWNER_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboardOwner.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARDNOTIFIER_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboardNotifier.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARDEX_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboardEx.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_XDROPTARGETLISTENER_HPP_
#include <com/sun/star/datatransfer/dnd/XDropTargetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_XDROPTARGET_HPP_
#include <com/sun/star/datatransfer/dnd/XDropTarget.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_XDRAGSOURCELISTENER_HPP_
#include <com/sun/star/datatransfer/dnd/XDragSourceListener.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_XDISPLAYCONNECTION_HPP_
#include <com/sun/star/awt/XDisplayConnection.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_DNDCONSTANTS_HPP_
#include <com/sun/star/datatransfer/dnd/DNDConstants.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#include <stdio.h>

#include <memory>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

//-------------------------------------------------------------
// my defines
//-------------------------------------------------------------

#define TEST_CLIPBOARD
#define UNXCLIPBOARD_SERVICE_NAME "com.sun.star.datatransfer.clipboard.SystemClipboard"
#define UNXDND_SERVICE_NAME "com.sun.star.datatransfer.dnd.X11DragSource"
#define UNXDND_DROPTARGET_SERVICE_NAME "com.sun.star.datatransfer.dnd.X11DropTarget"

//------------------------------------------------------------
//	namesapces
//------------------------------------------------------------

using namespace	::rtl;
using namespace ::std;
using namespace ::cppu;
using namespace ::com::sun::star::datatransfer;
using namespace ::com::sun::star::datatransfer::clipboard;
using namespace ::com::sun::star::datatransfer::dnd;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::awt;
using namespace	::com::sun::star::lang;

class SimpleDragSourceListener : public WeakImplHelper1< XDragSourceListener >
{
public:
	SimpleDragSourceListener() {}
	virtual ~SimpleDragSourceListener() {}

	// XEventListener
	virtual void SAL_CALL disposing ( const EventObject& ) throw() {}

	// XDragSourceListener
	virtual void SAL_CALL dragDropEnd ( const DragSourceDropEvent& dsde ) throw ()  ;
	virtual void SAL_CALL dragEnter( const DragSourceDragEvent& dsde ) throw();
	virtual void SAL_CALL dragExit( const DragSourceEvent& dse ) throw();
	virtual void SAL_CALL dragOver( const DragSourceDragEvent& dsde ) throw();
	virtual void SAL_CALL dropActionChanged( const DragSourceDragEvent& dsde ) throw();
};

void SimpleDragSourceListener::dragDropEnd( const DragSourceDropEvent& dsde ) throw()
{
	fprintf( stderr, "drag ended %s with dropaction ( %s %s %s)\n",
			 dsde.DropSuccess ? "successful" : "unsuccessfull",
			 dsde.DropAction & DNDConstants::ACTION_MOVE ? "MOVE" : "",
			 dsde.DropAction & DNDConstants::ACTION_COPY ? "COPY" : "",
			 dsde.DropAction & DNDConstants::ACTION_LINK ? "LINK" : ""
			 );
}

void SimpleDragSourceListener::dragEnter( const DragSourceDragEvent& dsde ) throw()
{
//	dsde.DragSourceContext->setCursor( dsde.DragSource->getDefaultCursor( dsde.DropAction ) );
	fprintf( stderr, "dragEnter\n" );
}

void SimpleDragSourceListener::dragExit( const DragSourceEvent& dsde ) throw()
{
	fprintf( stderr, "dragExit\n" );
}

void SimpleDragSourceListener::dragOver( const DragSourceDragEvent& dsde ) throw()
{
//	dsde.DragSourceContext->setCursor( dsde.DragSource->getDefaultCursor( dsde.DropAction ) );
	fprintf( stderr, "dragOver\n" );
}

void SimpleDragSourceListener::dropActionChanged( const DragSourceDragEvent& dsde ) throw()
{
//	dsde.DragSourceContext->setCursor( dsde.DragSource->getDefaultCursor( dsde.DropAction ) );
	fprintf( stderr, "dragActionChanged to ( %s %s %s)\n",
			 dsde.DropAction & DNDConstants::ACTION_MOVE ? "MOVE" : "",
			 dsde.DropAction & DNDConstants::ACTION_COPY ? "COPY" : "",
			 dsde.DropAction & DNDConstants::ACTION_LINK ? "LINK" : ""
			 );
}

//------------------------------------------------------------
//	
//------------------------------------------------------------


class SimpleTransferable : public WeakImplHelper2< XClipboardOwner, XTransferable >
{
public:	
	SimpleTransferable();
	~SimpleTransferable();
	
	//-------------------------------------------------
	// XTransferable
	//-------------------------------------------------

	virtual Any SAL_CALL getTransferData( const DataFlavor& aFlavor ) throw(UnsupportedFlavorException, IOException, RuntimeException);
    virtual Sequence< DataFlavor > SAL_CALL getTransferDataFlavors(  ) throw(RuntimeException);
	virtual sal_Bool SAL_CALL isDataFlavorSupported( const DataFlavor& aFlavor ) throw(RuntimeException);
	
	//-------------------------------------------------
	// XClipboardOwner
	//-------------------------------------------------

	virtual void SAL_CALL lostOwnership( const Reference< XClipboard >& xClipboard, const Reference< XTransferable >& xTrans ) throw(RuntimeException);
	
private:
	Sequence< DataFlavor > m_seqDFlv;
	OUString               m_Data;
};


//----------------------------------------------------------------
//	ctor
//----------------------------------------------------------------

SimpleTransferable::SimpleTransferable() :
	m_seqDFlv( 2 ),
	m_Data( OUString::createFromAscii( "Ich habe mir ein neues Fahrrad gekauft!" ) )
{
	DataFlavor df;
	
	df.MimeType = OUString::createFromAscii( "text/plain;charset=iso8859-1" );
	df.DataType = getCppuType( ( Sequence< sal_Int8 >* )0 );
	m_seqDFlv[0] = df;	

	df.MimeType = OUString::createFromAscii( "text/plain;charset=utf-16" );
	df.DataType = getCppuType( ( OUString* )0 );
	m_seqDFlv[1] = df;	
}

//----------------------------------------------------------------
//	dtor
//----------------------------------------------------------------

SimpleTransferable::~SimpleTransferable()
{
}

//----------------------------------------------------------------
//	getTransferData
//----------------------------------------------------------------

Any SAL_CALL SimpleTransferable::getTransferData( const DataFlavor& aFlavor ) 
	throw(UnsupportedFlavorException, IOException, RuntimeException)
{	
	Any anyData;

	if( aFlavor.MimeType == m_seqDFlv[0].MimeType )
	{
		OString aStr( m_Data.getStr( ), m_Data.getLength( ), RTL_TEXTENCODING_ISO_8859_1 );
		Sequence< sal_Int8 > sOfChars( aStr.getLength( ) );
		sal_Int32 lenStr = aStr.getLength( );

		for ( sal_Int32 i = 0; i < lenStr; ++i )
			sOfChars[i] = aStr[i];

		anyData = makeAny( sOfChars );
	}
	else if( aFlavor.MimeType == m_seqDFlv[1].MimeType )
	{
		anyData <<= m_Data;
	}

	return anyData;
}

//----------------------------------------------------------------
//	getTransferDataFlavors
//----------------------------------------------------------------

Sequence< DataFlavor > SAL_CALL SimpleTransferable::getTransferDataFlavors(  ) 
	throw(RuntimeException)
{
	return m_seqDFlv;
}

//----------------------------------------------------------------
//	isDataFlavorSupported
//----------------------------------------------------------------

sal_Bool SAL_CALL SimpleTransferable::isDataFlavorSupported( const DataFlavor& aFlavor ) 
	throw(RuntimeException)
{
	sal_Int32 nLength = m_seqDFlv.getLength( );
	sal_Bool bRet     = sal_False;

	for ( sal_Int32 i = 0; i < nLength; ++i )
	{
		OUString aMimeType = m_seqDFlv[i].MimeType ;
		if ( aMimeType == aFlavor.MimeType )
		{
			bRet = sal_True;
			break;
		}
	}

	return bRet;
}

//----------------------------------------------------------------
//	lostOwnership
//----------------------------------------------------------------

void SAL_CALL SimpleTransferable::lostOwnership( const Reference< XClipboard >& xClipboard, const Reference< XTransferable >& xTrans ) 
	throw(RuntimeException)
{
	fprintf( stderr, "clipboard ownership lost\n" );
}


//------------------------------------------------------------
//	
//------------------------------------------------------------

class SimpleDropTargetListener : public WeakImplHelper1< XDropTargetListener >
{

	void printDataTypes( const Sequence< DataFlavor >& rTypes );
public:
	SimpleDropTargetListener() {}
	virtual ~SimpleDropTargetListener() {}

	// XEventListener
	virtual void disposing( const EventObject& ) throw();

	// XDropTargetListener
	virtual void drop( const DropTargetDropEvent& dtde ) throw();
	virtual void dragEnter( const DropTargetDragEnterEvent& dtde ) throw();
	virtual void dragExit( const DropTargetEvent& dte ) throw();
	virtual void dragOver( const DropTargetDragEvent& dtde ) throw();
	virtual void dropActionChanged( const DropTargetDragEvent& dtde ) throw();
};

void SimpleDropTargetListener::printDataTypes( const Sequence< DataFlavor >& rTypes )
{
	printf( "DataTypes:\n" );
	for( int i = 0; i < rTypes.getLength(); i++ )
		printf( "\t%s\n", OUStringToOString( rTypes.getConstArray()[i].MimeType, RTL_TEXTENCODING_ISO_8859_1 ).getStr() );
}

void SimpleDropTargetListener::disposing( const EventObject& rEvent ) throw()
{
}

void SimpleDropTargetListener::drop( const DropTargetDropEvent& dtde ) throw()
{
	printf( "drop\n" );
	Sequence< DataFlavor > types( dtde.Transferable->getTransferDataFlavors() );
	printDataTypes( types );
//	dtde.Context->acceptDrop( DNDConstants::ACTION_COPY );
	for( int i = 0; i < types.getLength(); i++ )
	{
		if( types[i].MimeType == OUString::createFromAscii( "text/plain;charset=utf-16" ) )
		{
			Any aValue = dtde.Transferable->getTransferData( types[i] );
			OUString aString;
			aValue >>= aString;
			fprintf( stderr, "got string of length %d: \"%s\"\n",
					 aString.getLength(),
					 OUStringToOString( aString, RTL_TEXTENCODING_ISO_8859_1 ).getStr() );
		}
	}
	
	dtde.Context->dropComplete( sal_True );
}

void SimpleDropTargetListener::dragEnter( const DropTargetDragEnterEvent& dtde ) throw()
{
	printf( "dragEnter\n" );
	printDataTypes( dtde.SupportedDataFlavors );
	dtde.Context->acceptDrag( DNDConstants::ACTION_COPY );
}

void SimpleDropTargetListener::dragExit( const DropTargetEvent& dte ) throw()
{
	printf( "dragExit\n" );
}

void SimpleDropTargetListener::dragOver( const DropTargetDragEvent& dtde ) throw()
{
	printf( "dragOver\n" );
	dtde.Context->acceptDrag( DNDConstants::ACTION_COPY );
}

void SimpleDropTargetListener::dropActionChanged( const DropTargetDragEvent& dtde ) throw()
{
	printf( "dropActionChanged\n" );
	dtde.Context->acceptDrag( DNDConstants::ACTION_COPY );
}

//------------------------------------------------------------
//	
//------------------------------------------------------------

class SimpleDisplayConnection : public WeakImplHelper1< XDisplayConnection >
{
	Reference< XEventHandler >			m_xHandler;
	Display*							m_pDisplay;
	Window								m_aWindow;
	Reference< XMultiServiceFactory > 	m_xFactory;
public:
	SimpleDisplayConnection( const OUString& rRdb );
	virtual ~SimpleDisplayConnection();

	void dispatch();

	// XDisplayConnection
	virtual void addEventHandler( const Any& window, const Reference< XEventHandler >& handler, sal_Int32 flags ) throw()
		{ m_xHandler = handler; }
	virtual void removeEventHandler( const Any& window, const Reference< XEventHandler >& handler ) throw()
		{ m_xHandler.clear(); }

	virtual void addErrorHandler( const Reference< XEventHandler >& handler ) throw()
		{}
	virtual void removeErrorHandler( const Reference< XEventHandler >& handler ) throw()
		{}
	virtual Any getIdentifier() throw();
};

SimpleDisplayConnection::SimpleDisplayConnection( const OUString& rRdb )
{
	m_xFactory = createRegistryServiceFactory( rRdb );

	printf(  !m_xFactory.is() ?
			 "Can't create RegistryServiceFactory\n" :
			 "Creating RegistryServiceFactory successful\n" );

	m_pDisplay = XOpenDisplay( NULL );
	if( m_pDisplay )
	{
		m_aWindow = XCreateSimpleWindow(
			m_pDisplay,
			DefaultRootWindow( m_pDisplay ),
			100, 100, 200, 200, 0,
			BlackPixel( m_pDisplay, DefaultScreen( m_pDisplay ) ),
			BlackPixel( m_pDisplay, DefaultScreen( m_pDisplay ) )
			);
		XSizeHints aSizeHints;
		aSizeHints.flags = PMinSize | PMaxSize;
		aSizeHints.min_width = 200;
		aSizeHints.min_height = 200;
		aSizeHints.max_width = 400;
		aSizeHints.max_height = 400;
		XSetWMNormalHints( m_pDisplay, m_aWindow, &aSizeHints );
		XWMHints aHints;
		aHints.flags = InputHint;
		aHints.input = True;
		XSetWMHints( m_pDisplay, m_aWindow, &aHints );
		XMapWindow( m_pDisplay, m_aWindow );
		XSelectInput( m_pDisplay, m_aWindow,
					  ButtonPressMask		|
					  ExposureMask			|
					  StructureNotifyMask	|
					  PropertyChangeMask );
		XFlush( m_pDisplay );
	}
	else
		printf( "Error opening display\n" );
}

SimpleDisplayConnection::~SimpleDisplayConnection()
{
	if( m_pDisplay )
		XCloseDisplay( m_pDisplay );
}

Any SimpleDisplayConnection::getIdentifier() throw()
{
	Any aRet;
	if( m_pDisplay )
	{
		OString aDisplay( DisplayString( m_pDisplay ) );
		aRet <<= OStringToOUString( aDisplay, RTL_TEXTENCODING_ISO_8859_1 );
	}
	return aRet;
}

void SimpleDisplayConnection::dispatch()
{
	if( m_pDisplay && m_aWindow && m_xFactory.is() )
	{
		Sequence< Any > serviceArgs( 2 );
		serviceArgs.getArray()[0] <<= Reference< XDisplayConnection >(this);
		serviceArgs.getArray()[1] <<= (sal_Int32)m_aWindow;

		Reference< XClipboard > xClipboard( m_xFactory->createInstance( OUString::createFromAscii( UNXCLIPBOARD_SERVICE_NAME ) ), UNO_QUERY );
		if ( !xClipboard.is() )
		{
			OSL_ENSURE( sal_False, "Error creating clipboard Service" );
			return;
		}

		Reference< XDragSource > xDragSource( m_xFactory->createInstanceWithArguments( OUString::createFromAscii( UNXDND_SERVICE_NAME ), serviceArgs ), UNO_QUERY );
		if ( !xDragSource.is() )
		{
			printf( "Error creating DnD Service\n" );
			return;
		}

		Reference< XDropTarget > xDropTarget( m_xFactory->createInstanceWithArguments( OUString::createFromAscii( UNXDND_DROPTARGET_SERVICE_NAME ), serviceArgs ), UNO_QUERY );
		if( ! xDropTarget.is() )
			printf( "failed to create DropTarget\n" );
		else
		{
			Reference< XDropTargetListener > xListener( new SimpleDropTargetListener() );
			xDropTarget->addDropTargetListener( xListener );
			// dispatch loop
			Sequence< sal_Int8 > aEvent( sizeof( XEvent ) );
			XEvent* pEvent = (XEvent*)aEvent.getArray();
			GC aGC = DefaultGC( m_pDisplay, 0 );
			do
			{
				osl_yieldThread();
				XNextEvent( m_pDisplay, pEvent );
				switch( pEvent->type )
				{
					case Expose:
						XSetForeground( m_pDisplay, aGC, WhitePixel( m_pDisplay, 0 ) );
						XSetBackground( m_pDisplay, aGC, 0x00ff0000 );
						XFillRectangle( m_pDisplay, m_aWindow, aGC, 50, 50, 40, 40 );
						XFlush( m_pDisplay );
						break;
					case ButtonPress:
						if( pEvent->xbutton.button == Button1 )
						{
							XUngrabPointer( m_pDisplay, CurrentTime );
							XSync( m_pDisplay, False );
							fprintf( stderr, "beginning drag\n" );
							xDragSource->startDrag( DragGestureEvent(),
													DNDConstants::ACTION_MOVE| DNDConstants::ACTION_COPY | DNDConstants::ACTION_LINK,
													0, 0,
													new SimpleTransferable(),
													new SimpleDragSourceListener()
													);
						}
						else if( pEvent->xbutton.button == Button2 )
						{
							Reference< XTransferable > rXTransfRead = xClipboard->getContents( );
							
							Sequence< DataFlavor > flavorList = rXTransfRead->getTransferDataFlavors( );
							sal_Int32 nFlavors = flavorList.getLength();
							OUString mimeType;
							for ( sal_Int32 i = 0; i < nFlavors; ++i )
							{
								if( flavorList[i].MimeType == OUString::createFromAscii( "text/plain;charset=utf-16" ) )
								{
									Any aValue = rXTransfRead->getTransferData( flavorList[i] );
									OUString aString;
									aValue >>= aString;
									fprintf( stderr, "clipboard: got string of length %d: \"%s\"\n",
											 aString.getLength(),
											 OUStringToOString( aString, RTL_TEXTENCODING_ISO_8859_1 ).getStr() );
								}
							}
						}
						else if( pEvent->xbutton.button == Button3 )
						{
							Reference< XTransferable > xTrans( new SimpleTransferable );
							xClipboard->setContents( xTrans, Reference< XClipboardOwner >( xTrans, UNO_QUERY )  );
						}
						break;
				}
				if( m_xHandler.is() )
				{
					Any aEv;
					aEv <<= aEvent;
					m_xHandler->handleEvent( aEv );
				}
				else
					printf( "Xevent but no handler\n" );
			} while( pEvent->type != DestroyNotify || pEvent->xdestroywindow.window != m_aWindow );
		}
	}
}

//----------------------------------------------------------------
//	main
//----------------------------------------------------------------

int SAL_CALL main( int nArgc, char* Argv[] )
{
	//-------------------------------------------------
	// create the global service-manager
	//-------------------------------------------------
	OUString rdbName( Argv[0], strlen( Argv[0] ), RTL_TEXTENCODING_ISO_8859_1 );
	int nLastSlash = rdbName.lastIndexOf( '/' );
	if( nLastSlash >= 0 )
		rdbName = rdbName.copy( 0, nLastSlash+1 );
	else
		rdbName = OUString();
	rdbName += OUString::createFromAscii( "applicat.rdb" );
	printf( "using registry %s\n", OUStringToOString( rdbName, RTL_TEXTENCODING_ISO_8859_1 ).getStr() );

	SimpleDisplayConnection aConnection( rdbName );
	aConnection.dispatch();

	return 0;	
}
