/*************************************************************************
 *
 *  $RCSfile: filenotation.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: fs $ $Date: 2001/07/27 05:55:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	//=====================================================================
	//= OFileNotation
	//=====================================================================
	//---------------------------------------------------------------------
	OFileNotation::OFileNotation(const ::rtl::OUString& _rFileOrPath, NOTATION _eInputNotation)
	{
		switch (_eInputNotation)
		{
			case N_SYSTEM:
				m_sSystem = _rFileOrPath;
				osl_getFileURLFromSystemPath(m_sSystem.pData, &m_sFileURL.pData);
				break;
			case N_URL:
				m_sFileURL = _rFileOrPath;
				osl_getSystemPathFromFileURL(m_sFileURL.pData, &m_sSystem.pData);
				break;
			default:
				OSL_ENSURE(sal_False, "OFileNotation::OFileNotation: inavlid enum value!");
		}
	}

	//---------------------------------------------------------------------
	::rtl::OUString OFileNotation::get(NOTATION _eOutputNotation)
	{
		switch (_eOutputNotation)
		{
			case N_SYSTEM: return m_sSystem;
			case N_URL: return m_sFileURL;
		}

		OSL_ENSURE(sal_False, "OFileNotation::get: inavlid enum value!");
		return ::rtl::OUString();
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: filenotation.cxx,v $
 *	Revision 1.4  2001/07/27 05:55:31  fs
 *	#90267# remove TF_FILEURL
 *	
 *	Revision 1.3  2001/05/16 11:48:15  fs
 *	#65293# osl changes are TF_FILEURL-, not SUPD-dependent
 *	
 *	Revision 1.2  2001/05/11 10:51:56  fs
 *	osl removed the support for normalized file names
 *	
 *	Revision 1.1  2001/02/12 07:12:05  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 07.02.01 16:31:47  fs
 ************************************************************************/

