/*************************************************************************
 *
 *  $RCSfile: sdbfileaccess.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 12:03:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_SDBFILEACCESS_HXX_
#include "sdbfileaccess.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif
#ifndef _SVTOOLS_LOCALRESACCESS_HXX_
#include <svtools/localresaccess.hxx>
#endif
#ifndef _EXTENSIONS_DBIRESID_HRC_
#include "dbiresid.hrc"
#endif
#ifndef _EXTENSIONS_DBI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif
#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::svt;

	//==============================================================================
	//= OSdbFileAccess
	//==============================================================================
	//------------------------------------------------------------------------------
	OSdbFileAccess::OSdbFileAccess()
		:m_nError(ERRCODE_NONE)
	{
	}

	//------------------------------------------------------------------------------
	sal_uInt32 OSdbFileAccess::getQueryCount() const
	{
		StringArray aObjects;
		getQueryNames(aObjects);
		return aObjects.size();
	}

	//------------------------------------------------------------------------------
	sal_uInt32 OSdbFileAccess::getFormCount() const
	{
		StringArray aObjects;
		getFormNames(aObjects);
		return aObjects.size();
	}

	//------------------------------------------------------------------------------
	void OSdbFileAccess::getQueryNames(StringArray& _rNames) const
	{
		if (m_aQueries.isValid())
			m_aQueries->GetStorageNameList(_rNames);
	}

	//------------------------------------------------------------------------------
	void OSdbFileAccess::getFormNames(StringArray& _rNames) const
	{
		if (m_aForms.isValid())
			m_aForms->GetStreamNameList(_rNames);
	}

	//------------------------------------------------------------------------------
	void OSdbFileAccess::getTableNames(StringArray& _rNames) const
	{
		if (m_aTables.isValid())
			m_aTables->GetStorageNameList(_rNames);
	}

	//------------------------------------------------------------------------------
	sal_Bool OSdbFileAccess::open(const String& _rFile)
	{
		if (isOpen())
			close();

		OFileNotation aTransformer(_rFile, OFileNotation::N_SYSTEM);
		m_sFileURL = aTransformer.get(OFileNotation::N_URL);

		m_aFile = new SdbStorage(m_sFileURL);
		if (!m_aFile->isError())
		{
			// open the queries container
			m_aQueries = new SdbStorage(*m_aFile, String::CreateFromAscii("Query"));
			if (m_aQueries->isError())
			{
				DBG_ERROR("OSdbFileAccess::open: did not find the query container in the file!");
				m_aQueries = NULL;
			}

			// open the queries container
			m_aForms = new SdbStorage(*m_aFile, String::CreateFromAscii("Form"));
			if (m_aForms->isError())
			{
				DBG_ERROR("OSdbFileAccess::open: did not find the forms container in the file!");
				m_aForms = NULL;
			}

			// open the tables container
			m_aTables = new SdbStorage(*m_aFile, String::CreateFromAscii("Table"));
			if (m_aTables->isError())
			{
				DBG_ERROR("OSdbFileAccess::open: did not find the table container in the file!");
				m_aTables = NULL;
			}

			// the connection string
			if (!readDSN())
				return sal_False;

			// the title
			readTitle();
		}
		else
		{
			sal_uInt32 nPreserveError = m_aFile->getError();
			close();
			m_nError = nPreserveError;
			return sal_False;
		}

		m_sFileName = _rFile;
		return sal_True;
	}

	//------------------------------------------------------------------------------
	void OSdbFileAccess::readTitle()
	{
		resetError();

		// open the title stream
		SvStorageStreamRef aSignature = m_aFile->OpenStream(String::CreateFromAscii(SIGNATURE_STREAM));
		if (aSignature.Is())
		{
			ByteString sSignature;
			aSignature->ReadLine(sSignature);
			sSignature.Convert(RTL_TEXTENCODING_MS_1252, gsl_getSystemTextEncoding());

			if (sSignature.GetTokenCount(';') == 2)				// Lesen des Titels
			{
				m_sTitle.AssignAscii(sSignature.GetToken(1, ';').GetBuffer());
				return;
			}
		}

		// no title in the signature stream ... take the file name base

		INetURLObject aURL(m_sFileURL);
		m_sTitle = aURL.getBase();
	}

	//------------------------------------------------------------------------------
	sal_Bool OSdbFileAccess::readDSN()
	{
		resetError();

		// get the DSN string
		SvStorageStreamRef aDSNStream = m_aFile->OpenStream(String::CreateFromAscii("Connection"));
		if (!aDSNStream.Is())
			return sal_False;

		String sDSN;
		if (!readString(*aDSNStream, sDSN, 5 == m_aFile->GetVersion()))
			return sal_False;

		static String s_sPassword = String::CreateFromAscii("PWD");
		// some additional translations
		if (2 == m_aFile->GetVersion())
		{
			// initialize the parse
			CommandParser aTemporaryParser(sDSN, ';', '=', sal_True);

			// if a password is present, decrypt it
			if (aTemporaryParser.Exists(s_sPassword))
			{
				aTemporaryParser.SetOption(s_sPassword, decryptSdbString(aTemporaryParser.OptionString(s_sPassword)));

				// rebuild the connection string with the new value
				sDSN.Erase();
				aTemporaryParser.Compose(sDSN, String());
			}
		}
		else if (3 == m_aFile->GetVersion())
		{	// the whole DSN string was encrypted
			sDSN = decryptSdbString(sDSN);
		}

		// now we have a completely decrypted DSN string
		m_aDSNParser = CommandParser(sDSN, ';', '=', sal_True);
		return sal_True;
	}

	//------------------------------------------------------------------------------
	void OSdbFileAccess::overwriteStringToken( const String& _rTokenName, const String& _rNewTokenValue)
	{
		m_aDSNParser.SetOption(_rTokenName, _rNewTokenValue);
	}

	//------------------------------------------------------------------------------
	SvStorageStreamRef OSdbFileAccess::getFormStream(const String& _rName)
	{
		SvStorageStreamRef aEmptyReturn;
		resetError();
		if (!m_aForms.isValid())
			return aEmptyReturn;

		SvStorageStreamRef aObjectStream = m_aForms->OpenStream(_rName);
		if (m_aForms->isError() || !aObjectStream.Is())
		{
			m_nError = m_aForms->getError();
			return aEmptyReturn;
		}

		return aObjectStream;
	}

	//------------------------------------------------------------------------------
	sal_Bool OSdbFileAccess::getQuery(const String& _rName, OQueryDescriptor& _rDescr)
	{
		resetError();
		if (!m_aQueries.isValid())
			return sal_False;

		::vos::ORef< SdbStorage > aObjectStoage = m_aQueries->OpenStorage(_rName);
		if (m_aQueries->isError() || !aObjectStoage.isValid())
		{
			m_nError = m_aQueries->getError();
			return sal_False;
		}

		SvStorageStreamRef aObjectDescription = aObjectStoage->OpenStream(String::CreateFromAscii("SQL"));
		if (aObjectStoage->isError() || !aObjectDescription.Is())
		{
			m_nError = aObjectStoage->getError();
			return sal_False;
		}


		// the native flag
		BYTE bNative = 1;
		(*aObjectDescription) >> bNative;
		_rDescr.bEscapeProcessing = (0 == bNative);

		// the statement
		if (!readString(*aObjectDescription, _rDescr.sStatement, sal_False))
			return sal_False;

		return sal_True;
	}

	//------------------------------------------------------------------------------
	String OSdbFileAccess::decryptSdbString(const String& _rEncrypted)
	{
		// need to go via an ByteString for compatibility reasons
		ByteString sEncrypted(_rEncrypted, gsl_getSystemTextEncoding());

		// the real 'decryption' using a memory stream
		SvMemoryStream aMemoryStream(sEncrypted.GetBufferAccess(), sEncrypted.Len(), STREAM_READ);
		aMemoryStream.SetKey(ByteString("a$*'FF|~@dsf"));
		ByteString sDecrypted;
		aMemoryStream.ReadByteString(sDecrypted);

		// convert back to a string
		return String(sDecrypted, gsl_getSystemTextEncoding());
	}

	//------------------------------------------------------------------------------
	void OSdbFileAccess::close()
	{
		m_aForms = NULL;
		m_aQueries = NULL;
		m_aFile = NULL;
		m_sFileURL = m_sFileName = m_sTitle = String();

		m_aDSNParser = CommandParser();
		resetError();
	}

	//------------------------------------------------------------------------------
	sal_uInt16 OSdbFileAccess::getTypeLogical() const
	{
		return ODSNTypeInfo(m_aDSNParser.OptionString(String::CreateFromAscii("TYP"))).getId();
	}

	//------------------------------------------------------------------------------
	sal_Bool OSdbFileAccess::readString(SvStorageStream& _rStream, String& _rValue, BOOL _bDecrypt)
	{
		resetError();

		// decrypt BEFORE converting
		ByteString aTemp;
		if (_bDecrypt)
		{
			// load the encrypted part into a memory stream
			sal_uInt16 nSize;
			_rStream >> nSize;
			SvMemoryStream aMemoryStream(nSize);
			char cBuffer[1024];
			sal_uInt16 nDone = 0;
			while (nDone < nSize)
			{
				sal_uInt16 nThisRound = (nSize - nDone < sizeof(cBuffer)) ? (nSize - nDone) : sizeof(cBuffer);
				_rStream.Read(cBuffer, nThisRound);
				aMemoryStream.Write(cBuffer, nThisRound);
				nDone += nThisRound;
			}
			aMemoryStream.Flush();

			// 'decrypt'
			aMemoryStream.SetKey(ByteString("a$*'FF|~@dsf"));
			aMemoryStream.Seek(STREAM_SEEK_TO_BEGIN);
			aMemoryStream .ReadByteString(aTemp);
		}
		else
			_rStream.ReadByteString(aTemp);

		// the strings were stored as ANSI, so convert this
		aTemp.Convert(RTL_TEXTENCODING_MS_1252, gsl_getSystemTextEncoding());
		_rValue.AssignAscii(aTemp.GetBuffer());

		m_nError = _rStream.GetErrorCode();
		return m_nError == _rStream.GetErrorCode();
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: sdbfileaccess.cxx,v $
 *	Revision 1.3  2001/11/02 12:03:49  hr
 *	#92924#: cast
 *	
 *	Revision 1.2  2001/04/09 14:16:38  fs
 *	#85206# extra page for handling $(USER) etc
 *	
 *	Revision 1.1  2001/02/12 07:15:10  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 01.02.01 16:37:40  fs
 ************************************************************************/

