/*************************************************************************
 *
 *  $RCSfile: sdbstorage.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: fs $ $Date: 2001/02/12 07:16:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_SDBSTORAGE_HXX_
#define _EXTENSIONS_DBI_SDBSTORAGE_HXX_

/** this is the outsourcing of an old 5.2 SDB storage implementation, stripped down to readonly functionality,
	and adjusted in some aspects (e.g. now using STL in some more places)
*/

#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_
#include <vos/refernce.hxx>
#endif
#ifndef _EXTENSIONS_DBI_DBITYPES_HXX_
#include "dbitypes.hxx"
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

#define SIGNATURE_STREAM	"StarBaseDocument"

	/*---------------------------------------------------------------------------
		Internes Verzeichnis fuer Datenbankstorage, ein einzelner Eintrage besteht
		aus Key und Name
	/---------------------------------------------------------------------------*/
	class SdbStorageDir
	{
		friend class SdbStorage;

		friend  SvStream& operator >> (SvStream &rStream, SdbStorageDir&);

		SdbStorage& rStorage;
		SvStorageStream* pStream;

		MapInt2String				m_aNames;
		ConstMapInt2StringIterator	m_aPos;		// for simulating the old first/next

	public:
		SdbStorageDir(SdbStorage&);
		~SdbStorageDir();

		void Insert(sal_uInt32 nKey, const String& rValue);
		void Remove(sal_uInt32 nKey);

		sal_uInt32 GetKey(const String& _rName) const;

		String		first();
		String		next();
		sal_Bool	done() const { return (m_aNames.end() == m_aPos); }

		sal_Bool	knows(sal_uInt32 _nKey) const { return m_aNames.end() != m_aNames.find(_nKey); }

		sal_uInt32	size() const { return m_aNames.size(); }

	protected:
		void Init(SvStorageStream* pStream);
	};

	class SdbStorInfo
	{
		SvStorage*		pImpl;

	public:
		SdbStorInfo(SvStorage* pStor);
		~SdbStorInfo();

		SvStorage* Storage() const { return pImpl; }
	};

	/*---------------------------------------------------------------------------
		SdbStorage ist im Prinzip eine Wrapperklasse fuer den SvStorage, da der SvStorage
		nicht in der Lage ist Verzeichnisnamen > 31 zu verwalten, was aber innerhalb
		der Datenbank durchaus vorkommen kann
	/---------------------------------------------------------------------------*/
	class SdbStorage : public ::vos::OReference
	{
		friend class SdbStorageDir;

		SdbStorInfo*	pImpl;
		SdbStorageDir	aDir;			// Verzeichniseintraege
		sal_uInt32		m_nStreamError;

	protected:
		virtual ~SdbStorage();

	public:
		SdbStorage(const String& rName);
		SdbStorage(SdbStorage& _rParent, const String& rName);

		void GetStorageNameList(StringArray& rList);
		void GetStreamNameList(StringArray& rList);

		long GetVersion() const { return pImpl->Storage()->GetVersion(); }

		// da bei Storages eine Namensuebersetzung erfolgt, ein paar Funktionen, die die Arbeit mit den unuebersetzen Namen erlauben
		sal_Bool HasStorage(const String& strName,sal_Bool _bTable) const;
		// ausser dem Dir-Stream noch irgendwelche anderen ?
		sal_Bool HasStreams() const;
		sal_Bool HasStorages() const;

		sal_uInt32	getError() const { return m_nStreamError; }
		sal_Bool	isError() const { return ERRCODE_NONE != m_nStreamError; }

		SvStorageStream* OpenStream(const String& _rEleName);
		SdbStorage*	OpenStorage(const String& _rEleName);

	private:
		SvStorage* Impl() const { return pImpl->Storage(); }

		sal_Bool GetStorageName(String& rName, sal_Bool bFirst);

		sal_Bool IsStorage(const String& _rName) const { return Impl()->IsStorage(_rName); }
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_SDBSTORAGE_HXX_

/*************************************************************************
 * history:
 *	$Log: sdbstorage.hxx,v $
 *	Revision 1.1  2001/02/12 07:16:00  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 01.02.01 14:17:50  fs
 ************************************************************************/

