/*************************************************************************
 *
 *  $RCSfile: contenttaskclient.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef HIERARCHY_CONTENTTASKCLIENT_HXX
#define HIERARCHY_CONTENTTASKCLIENT_HXX

#ifndef _HIERARCHY_HELPER_HXXH_
#include <hierarchy_helper.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTTASKCLIENT_HPP_
#include <com/sun/star/ucb/XContentTaskClient.hpp>
#endif

#if defined(TF_TYPE) || (SUPD >= 564)
using namespace cppu;
#endif

using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::ucb;


class OClientContentTask :
public XContentTaskClient,
public OContentTaskHelper
{
public:

	OClientContentTask( const Reference< XContentTaskClient > &xClient, const Reference< XContentTaskEnvironment > &xEnvironment);

    // add a created task to list
    virtual void addContentTask( const Reference< XContentTask > &xTask);

    /*
     * XInterface
     */

    // query interface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc ) throw(RuntimeException);
#endif

    // increase refcount
	virtual void SAL_CALL acquire() throw(RuntimeException) { OWeakObject::acquire(); };

    // decrease refcount
    virtual void SAL_CALL release() throw(RuntimeException) { OWeakObject::release(); };

    /*
     * XEventListener
     */

    virtual void SAL_CALL disposing( const EventObject& rEvent ) throw(RuntimeException);

    /*
     * XContentTaskClient
     */

    virtual void SAL_CALL contentTaskEvent( const ContentTaskEvent& rEvent ) throw(RuntimeException);

protected:
	~OClientContentTask();

    // send status notifications
	virtual ContentTaskStatus setStatus( const ContentTaskStatus &eStatus );

    // execute all tasks
	virtual void doExecute();

    // original client
	Reference< XContentTaskClient > m_xClient;

    // list of tasks created.
	safe_list< Reference< XInterface > > m_aTaskList;

    // flag to indicate that one or more tasks have aborted
    sal_Bool m_bAborted;
};


class OClientCommandTask : 
public OClientContentTask,
public OCommandTaskHelper
{
public:
	OClientCommandTask( const Command &TheCommand, const Reference< XContentTaskClient> &xClient, const Reference< XContentTaskEnvironment > &xEnvironment) :
	OClientContentTask( xClient, xEnvironment ),
	OCommandTaskHelper( xEnvironment, TheCommand )
	{
	}

	virtual void doExecute()
	{
		OClientContentTask::doExecute();
	}
};


#endif /* HIERARCHY_CONTENTTASKCLIENT_HXX */

