/*************************************************************************
 *
 *  $RCSfile: profilecache.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: pl $ $Date: 2001/05/14 09:47:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________________________________________________________________________________
//	my own include
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_PROFILECACHE_HXX_
#include "profilecache.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	namespaces
//_______________________________________________________________________________________________________________________

using namespace ::rtl						;
using namespace ::osl						;
using namespace ::cppu						;
using namespace ::vos						;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::util		;
using namespace ::com::sun::star::lang		;
using namespace ::com::sun::star::beans		;
using namespace ::com::sun::star::registry	;

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

//_______________________________________________________________________________________________________________________
//	defines
//_______________________________________________________________________________________________________________________

#define	KEYSEPERATOR												sal_Unicode(0x002F)						// seperator of ini-keys as unicode [ '/' => 2Fh ]
#define	MAX_LINELENGTH												10000
#define	STRINGFOUND													0										// OUstring::compare..() returns 0, if string was found
#define	INITEXTENCODING												RTL_TEXTENCODING_MS_1252				// Global textencoding for all convertions in THIS class! (We use ANSI!)

// Follow four keynames must have values in lower case! We will compare it so ...
#define	KEYNAME_BOOKMARKDIRECTORY									"directories/bookmark-dir"				// keyname of bookmark directory	[soffice.ini]
#define	KEYNAME_WORKDIRECTORY										"directories/work-path"					// keyname of work directory    	[soffice.ini]
#define	KEYNAME_EXPLORERDIRECTORY									"directories/explorer"					// keyname of explorer directory	[soffice.ini]
#define	KEYNAME_LANGUAGETYPE										"user/language"							// keyname of language type     	[soffice.ini]

#ifdef WNT
	#define	SOFFICE_INI												OUString(RTL_CONSTASCII_USTRINGPARAM("soffice.ini"	))
	#define	UCB_INI													OUString(RTL_CONSTASCII_USTRINGPARAM("ucb.ini"		))
#elif defined UNIX
	#define	SOFFICE_INI												OUString(RTL_CONSTASCII_USTRINGPARAM("sofficerc"	))
	#define	UCB_INI													OUString(RTL_CONSTASCII_USTRINGPARAM("ucbrc"		))
#else
	#error "name of soffice or ucb profile unknown"
#endif
#define	SERVICENAME_CONFIGURATION									OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.configuration.ConfigurationRegistry"	))
#if SUPD>604
#define STARTPOINT_SETUP                                            OUString(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Setup"          ))
#define STARTPOINT_COMMON                                           OUString(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Office.Common"      ))
#define STARTPOINT_USERPROFILE                                      OUString(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.UserProfile"       ))
#define STARTPOINT_INET                                             OUString(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Inet"           ))
#else
#define	STARTPOINT_SETUP											OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.Setup"								))
#define	STARTPOINT_COMMON           								OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.Office.Common"						))
#define	STARTPOINT_USERPROFILE      								OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.UserProfile"							))
#define	STARTPOINT_INET      										OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.Inet"								))
#endif
#define	DISABLE_CONFIGURATIONMAP_SECTION							OUString(RTL_CONSTASCII_USTRINGPARAM("ConfigurationManagement"							))
#define	DISABLE_CONFIGURATIONMAP_KEY								OUString(RTL_CONSTASCII_USTRINGPARAM("Disabled"											))

// Old keys for STARTPOINT_COMMON
#define	OLDKEY_DIRECTORIES_ADDINS_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/AddIns-Path"			))
#define	OLDKEY_DIRECTORIES_AUTOCORRECT_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/AutoCorrect-Dir"		))
#define	OLDKEY_DIRECTORIES_AUTOPILOT_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Autopilot-Dir"		))
#define	OLDKEY_DIRECTORIES_BACKUP_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Backup-Path"			))
#define	OLDKEY_DIRECTORIES_BASIC_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Basic-Path"			))
#define	OLDKEY_DIRECTORIES_BITMAP_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Bitmap-Path"			))
#define	OLDKEY_DIRECTORIES_CONFIG_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Config-Dir"			))
#define	OLDKEY_DIRECTORIES_DATABASE_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Database-Path"		))
#define	OLDKEY_DIRECTORIES_DICTIONARY_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Dictionary-Path"		))
#define	OLDKEY_DIRECTORIES_FAVORITES_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Favorites-Dir"		))
#define	OLDKEY_DIRECTORIES_FILTER_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Filter-Path"			))
#define	OLDKEY_DIRECTORIES_GALLERY_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Gallery-Dir"			))
#define	OLDKEY_DIRECTORIES_GLOSSARY_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Glossary-Path"		))
#define	OLDKEY_DIRECTORIES_GRAPHICS_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Graphics-Path"		))
#define	OLDKEY_DIRECTORIES_HELP_DIR									OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Help-Dir"				))
#define	OLDKEY_DIRECTORIES_LINGUISTIC_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Linguistic-Dir"		))
#define	OLDKEY_DIRECTORIES_MODULES_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Modules-Path"			))
#define	OLDKEY_DIRECTORIES_NEW_DIR									OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/New-Dir"				))
#define	OLDKEY_DIRECTORIES_PALETTE_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Palette-Path"			))
#define	OLDKEY_DIRECTORIES_PLUGINS_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Plugins-Dir"			))
#define	OLDKEY_DIRECTORIES_STORAGE_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Storage-Dir"			))
#define	OLDKEY_DIRECTORIES_SUB_INI									OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Sub-Ini"				))
#define	OLDKEY_DIRECTORIES_TEMP_DIR									OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Temp-Dir"				))
#define	OLDKEY_DIRECTORIES_TEMPLATE_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Template-Path"		))
#define	OLDKEY_DIRECTORIES_TRASH_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Trash-Dir"			))
#define	OLDKEY_DIRECTORIES_USERCONFIG_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/UserConfig-Path"		))
#define	OLDKEY_DIRECTORIES_USERDICTIONARY_DIR						OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/UserDictionary-Dir"	))
#define	OLDKEY_DIRECTORIES_WORK_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Directories/Work-Path"			))
// Old keys for STARTPOINT_SETUP
#define	OLDKEY_SOFFICE_APPS_SCALC									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/scalc"				))
#define	OLDKEY_SOFFICE_APPS_SCHART									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/schart"				))
#define	OLDKEY_SOFFICE_APPS_SDRAW									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/sdraw"				))
#define	OLDKEY_SOFFICE_APPS_SIMAGE									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/simage"				))
#define	OLDKEY_SOFFICE_APPS_SIMPRESS								OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/simpress"			))
#define	OLDKEY_SOFFICE_APPS_SMATH									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/smath"				))
#define	OLDKEY_SOFFICE_APPS_SSCHEDULE								OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/sschedule"			))
#define	OLDKEY_SOFFICE_APPS_SWRITER									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps/swriter"				))
// Old and new keys for STARTPOINT_USERPROFILE
#define	OLDKEY_USER_USER_ADRESS										OUString(RTL_CONSTASCII_USTRINGPARAM("User/User-Adress"					))
#define	OLDKEY_USER_USER_FIRSTNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("User/User-FirstName"				))
#define	OLDKEY_USER_USER_ID											OUString(RTL_CONSTASCII_USTRINGPARAM("User/User-Id"						))
#define	OLDKEY_USER_USER_NAME										OUString(RTL_CONSTASCII_USTRINGPARAM("User/User-Name"					))
#define	OLDKEY_USER_USERNUMBER										OUString(RTL_CONSTASCII_USTRINGPARAM("User/UserNumber"					))
#define	OLDKEY_USER_LANGUAGE										OUString(RTL_CONSTASCII_USTRINGPARAM("User/Language"					))
// Old and new keys for STARTPOINT_INET
#define	OLDKEY_INET_DNSSERVER										OUString(RTL_CONSTASCII_USTRINGPARAM("INet/DNSServer"					))
#define	OLDKEY_INET_FTPPROXYNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("INet/FTPProxyName"				))
#define	OLDKEY_INET_FTPPROXYPORT									OUString(RTL_CONSTASCII_USTRINGPARAM("INet/FTPProxyPort"				))
#define	OLDKEY_INET_HTTPPROXYNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("INet/HTTPProxyName"				))
#define	OLDKEY_INET_HTTPPROXYPORT									OUString(RTL_CONSTASCII_USTRINGPARAM("INet/HTTPProxyPort"				))
#define	OLDKEY_INET_SOCKSPROXYNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("INet/SocksProxyName"				))
#define	OLDKEY_INET_SOCKSPROXYPORT									OUString(RTL_CONSTASCII_USTRINGPARAM("INet/SocksProxyPort"				))
#define	OLDKEY_INET_REVEALMAILADDRESS								OUString(RTL_CONSTASCII_USTRINGPARAM("INet/RevealMailAddress"			))
#define	OLDKEY_INET_SMTPSERVER										OUString(RTL_CONSTASCII_USTRINGPARAM("INet/SMTPServer"					))
#define	OLDKEY_INET_NOPROXY											OUString(RTL_CONSTASCII_USTRINGPARAM("INet/NoProxy"						))
#define	OLDKEY_INET_PROXYTYPE										OUString(RTL_CONSTASCII_USTRINGPARAM("INet/ProxyType"					))
#define	OLDKEY_INET_USERAGENT										OUString(RTL_CONSTASCII_USTRINGPARAM("INet/UserAgent"					))

// New keys for STARTPOINT_COMMON
#define	NEWKEY_DIRECTORIES_ADDINS_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Addin"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_AUTOCORRECT_DIR							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/AutoCorrect"			)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_AUTOPILOT_DIR							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/AutoPilot"			)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_BACKUP_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Backup"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_BASIC_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Basic"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_BITMAP_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Bitmap"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_CONFIG_DIR								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Config"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_DATABASE_PATH							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Database"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_DICTIONARY_PATH							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Dictionary"			)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_FAVORITES_DIR							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Favorite"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_FILTER_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Filter"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_GALLERY_DIR								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Gallery"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_GLOSSARY_PATH							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/AutoText"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_GRAPHICS_PATH							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Graphic"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_HELP_DIR									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Help"					)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_LINGUISTIC_DIR							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Linguistic"			)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_MODULES_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Module"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_NEW_DIR									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/New"					)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_PALETTE_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Palette"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_PLUGINS_DIR								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Plugin"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_STORAGE_DIR								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Storage"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_SUB_INI									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/SubIni"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_TEMP_DIR									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Temp"					)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_TEMPLATE_PATH							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Template"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_TRASH_DIR								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Trash"				)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_USERCONFIG_PATH							tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/UserConfig"			)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_USERDICTIONARY_DIR						tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/UserDictionary"		)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
#define	NEWKEY_DIRECTORIES_WORK_PATH								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Path/Work"					)), m_aCfgPoint_Common.xTree, m_aCfgPoint_Common.xBaseNode				)
// New keys for STARTPOINT_SETUP
#if SUPD>604
#define NEWKEY_SOFFICE_APPS_SCALC tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Calc/Install"  )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#define NEWKEY_SOFFICE_APPS_SCHART tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Chart/Install"  )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#define NEWKEY_SOFFICE_APPS_SDRAW tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Draw/Install"  )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#define NEWKEY_SOFFICE_APPS_SIMAGE tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Impress/Install"  )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#define NEWKEY_SOFFICE_APPS_SIMPRESS tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Impress/Install" )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#define NEWKEY_SOFFICE_APPS_SMATH tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Math/Install"  )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#define NEWKEY_SOFFICE_APPS_SSCHEDULE tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/sschedule/Install" )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode                                )
#define NEWKEY_SOFFICE_APPS_SWRITER tIMPL_KeyInfo(OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/Writer/Install" )), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode    )
#else
#define	NEWKEY_SOFFICE_APPS_SCALC									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/scalc"		)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SCHART									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/schart"		)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SDRAW									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/sdraw"		)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SIMAGE									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/simage"		)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SIMPRESS								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/simpress"	)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SMATH									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/smath"		)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SSCHEDULE								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/sschedule"	)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#define	NEWKEY_SOFFICE_APPS_SWRITER									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Office/Modules/swriter"	)), m_aCfgPoint_Setup.xTree, m_aCfgPoint_Setup.xBaseNode				)
#endif
// New keys for STARTPOINT_USERPROFILE
#define	NEWKEY_USER_USER_ADRESS										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Data"						)), m_aCfgPoint_UserProfile.xTree, m_aCfgPoint_UserProfile.xBaseNode	)
#define	NEWKEY_USER_USER_FIRSTNAME									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Data/FirstName"			)), m_aCfgPoint_UserProfile.xTree, m_aCfgPoint_UserProfile.xBaseNode	)
#define	NEWKEY_USER_USER_ID											tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Data/UserID"				)), m_aCfgPoint_UserProfile.xTree, m_aCfgPoint_UserProfile.xBaseNode	)
#define	NEWKEY_USER_USER_NAME										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Data/LastName"				)), m_aCfgPoint_UserProfile.xTree, m_aCfgPoint_UserProfile.xBaseNode	)
#define	NEWKEY_USER_USERNUMBER										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Data/CustomerNumber"		)), m_aCfgPoint_UserProfile.xTree, m_aCfgPoint_UserProfile.xBaseNode	)
#define	NEWKEY_USER_LANGUAGE										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("International/Locale"		)), m_aCfgPoint_UserProfile.xTree, m_aCfgPoint_UserProfile.xBaseNode	)
// New keys for STARTPOINT_INET
#define	NEWKEY_INET_DNSSERVER										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("DNS/IP_Address"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_FTPPROXYNAME									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/FTP/Name"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_FTPPROXYPORT									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/FTP/Port"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_HTTPPROXYNAME									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/HTTP/Name"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_HTTPPROXYPORT									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/HTTP/Port"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_SOCKSPROXYNAME									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/SOCKS/Name"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_SOCKSPROXYPORT									tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/SOCKS/Port"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_REVEALMAILADDRESS								tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Protocol/RevealMailAddress"	)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_SMTPSERVER										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("SMTP/ServerName"				)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_NOPROXY											tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/NoProxy"					)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_PROXYTYPE										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Proxy/Type"					)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)
#define	NEWKEY_INET_USERAGENT										tIMPL_KeyInfo( OUString(RTL_CONSTASCII_USTRINGPARAM("Protocol/UserAgent"			)), m_aCfgPoint_Inet.xTree, m_aCfgPoint_Inet.xBaseNode	)

// Special sections of our new configuration management
#define	SPECIALSECTION_DIRECTORIES									OUString(RTL_CONSTASCII_USTRINGPARAM("Directories"				))
#define	SPECIALSECTION_SOFFICE_APPS									OUString(RTL_CONSTASCII_USTRINGPARAM("soffice-Apps"				))
#define	SPECIALSECTION_USER											OUString(RTL_CONSTASCII_USTRINGPARAM("User"						))
#define	SPECIALSECTION_INET											OUString(RTL_CONSTASCII_USTRINGPARAM("INet"						))

// Subkeys of old ini section "Directories"
#define	SUBKEY_DIRECTORIES_ADDINS_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Addins-Path"				))
#define	SUBKEY_DIRECTORIES_AUTOCORRECT_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("AutoCorrect-Dir"			))
#define	SUBKEY_DIRECTORIES_AUTOPILOT_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Autopilot-Dir"			))
#define	SUBKEY_DIRECTORIES_BACKUP_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Backup-Path"				))
#define	SUBKEY_DIRECTORIES_BASIC_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Basic-Path"				))
#define	SUBKEY_DIRECTORIES_BITMAP_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Bitmap-Path"				))
#define	SUBKEY_DIRECTORIES_CONFIG_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Config-Dir"				))
#define	SUBKEY_DIRECTORIES_DATABASE_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Database-Path"			))
#define	SUBKEY_DIRECTORIES_DICTIONARY_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Dictionary-Path"			))
#define	SUBKEY_DIRECTORIES_FAVORITES_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Favorites-Dir"			))
#define	SUBKEY_DIRECTORIES_FILTER_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Filter-Path"				))
#define	SUBKEY_DIRECTORIES_GALLERY_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Gallery-Dir"				))
#define	SUBKEY_DIRECTORIES_GLOSSARY_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Glossary-Path"			))
#define	SUBKEY_DIRECTORIES_GRAPHICS_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Graphics-Path"			))
#define	SUBKEY_DIRECTORIES_HELP_DIR									OUString(RTL_CONSTASCII_USTRINGPARAM("Help-Dir"					))
#define	SUBKEY_DIRECTORIES_LINGUISTIC_DIR							OUString(RTL_CONSTASCII_USTRINGPARAM("Linguistic-Dir"			))
#define	SUBKEY_DIRECTORIES_MODULES_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Modules-Path"				))
#define	SUBKEY_DIRECTORIES_NEW_DIR									OUString(RTL_CONSTASCII_USTRINGPARAM("New-Dir"					))
#define	SUBKEY_DIRECTORIES_PALETTE_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Palette-Path"				))
#define	SUBKEY_DIRECTORIES_PLUGINS_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Plugins-Dir"				))
#define	SUBKEY_DIRECTORIES_STORAGE_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Storage-Dir"				))
#define	SUBKEY_DIRECTORIES_SUB_INI									OUString(RTL_CONSTASCII_USTRINGPARAM("Sub-Ini"					))
#define	SUBKEY_DIRECTORIES_TEMP_DIR									OUString(RTL_CONSTASCII_USTRINGPARAM("Temp-Dir"					))
#define	SUBKEY_DIRECTORIES_TEMPLATE_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("Template-Path"			))
#define	SUBKEY_DIRECTORIES_TRASH_DIR								OUString(RTL_CONSTASCII_USTRINGPARAM("Trash-Dir"				))
#define	SUBKEY_DIRECTORIES_USERCONFIG_PATH							OUString(RTL_CONSTASCII_USTRINGPARAM("UserConfig-Path"			))
#define	SUBKEY_DIRECTORIES_USERDICTIONARY_DIR						OUString(RTL_CONSTASCII_USTRINGPARAM("UserDictionary-Dir"		))
#define	SUBKEY_DIRECTORIES_WORK_PATH								OUString(RTL_CONSTASCII_USTRINGPARAM("Work-Path"				))
// Subkeys of old ini section "soffice-Apps"
#define	SUBKEY_SOFFICE_APPS_SCALC									OUString(RTL_CONSTASCII_USTRINGPARAM("scalc"					))
#define	SUBKEY_SOFFICE_APPS_SCHART									OUString(RTL_CONSTASCII_USTRINGPARAM("schart"					))
#define	SUBKEY_SOFFICE_APPS_SDRAW									OUString(RTL_CONSTASCII_USTRINGPARAM("sdraw"					))
#define	SUBKEY_SOFFICE_APPS_SIMAGE									OUString(RTL_CONSTASCII_USTRINGPARAM("simage"					))
#define	SUBKEY_SOFFICE_APPS_SIMPRESS								OUString(RTL_CONSTASCII_USTRINGPARAM("simpress"					))
#define	SUBKEY_SOFFICE_APPS_SMATH									OUString(RTL_CONSTASCII_USTRINGPARAM("smath"					))
#define	SUBKEY_SOFFICE_APPS_SSCHEDULE								OUString(RTL_CONSTASCII_USTRINGPARAM("sschedule"				))
#define	SUBKEY_SOFFICE_APPS_SWRITER									OUString(RTL_CONSTASCII_USTRINGPARAM("swriter"					))
// Subkeys of old ini section "User"
#define	SUBKEY_USER_USER_ADRESS										OUString(RTL_CONSTASCII_USTRINGPARAM("User-Adress"				))
#define	SUBKEY_USER_USER_FIRSTNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("User-FirstName"			))
#define	SUBKEY_USER_USER_ID											OUString(RTL_CONSTASCII_USTRINGPARAM("User-Id"					))
#define	SUBKEY_USER_USER_NAME										OUString(RTL_CONSTASCII_USTRINGPARAM("User-Name"				))
#define	SUBKEY_USER_USERNUMBER										OUString(RTL_CONSTASCII_USTRINGPARAM("UserNumber"				))
#define	SUBKEY_USER_LANGUAGE										OUString(RTL_CONSTASCII_USTRINGPARAM("Language"					))
// Subkeys of old ini section "INet"
#define	SUBKEY_INET_DNSSERVER										OUString(RTL_CONSTASCII_USTRINGPARAM("DNSServer"				))
#define	SUBKEY_INET_FTPPROXYNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("FTPProxyName"				))
#define	SUBKEY_INET_FTPPROXYPORT									OUString(RTL_CONSTASCII_USTRINGPARAM("FTPProxyPort"				))
#define	SUBKEY_INET_HTTPPROXYNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("HTTPProxyName"			))
#define	SUBKEY_INET_HTTPPROXYPORT									OUString(RTL_CONSTASCII_USTRINGPARAM("HTTPProxyPort"			))
#define	SUBKEY_INET_SOCKSPROXYNAME									OUString(RTL_CONSTASCII_USTRINGPARAM("SocksProxyName"			))
#define	SUBKEY_INET_SOCKSPROXYPORT									OUString(RTL_CONSTASCII_USTRINGPARAM("SocksProxyPort"			))
#define	SUBKEY_INET_REVEALMAILADDRESS								OUString(RTL_CONSTASCII_USTRINGPARAM("RevealMailAddress"		))
#define	SUBKEY_INET_SMTPSERVER										OUString(RTL_CONSTASCII_USTRINGPARAM("SMTPServer"				))
#define	SUBKEY_INET_NOPROXY											OUString(RTL_CONSTASCII_USTRINGPARAM("NoProxy"					))
#define	SUBKEY_INET_PROXYTYPE										OUString(RTL_CONSTASCII_USTRINGPARAM("ProxyType"				))
#define	SUBKEY_INET_USERAGENT										OUString(RTL_CONSTASCII_USTRINGPARAM("UserAgent"				))

// Subkeys for special configuration key "com.sun.star.UserProfile.Data"
// Attention: User-Adress is splitted to multiple new keys!
// We handle this by an impl method.
#define	SUBKEY_USERADRESS_TITLE										OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Title"				))
#define	SUBKEY_USERADRESS_EMAIL										OUString(RTL_CONSTASCII_USTRINGPARAM("Data/EMail"				))
#define	SUBKEY_USERADRESS_POSITION									OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Position"			))
#define	SUBKEY_USERADRESS_CITY										OUString(RTL_CONSTASCII_USTRINGPARAM("Data/City"				))
#define	SUBKEY_USERADRESS_FAX										OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Fax"					))
#define	SUBKEY_USERADRESS_TELEPHONWORK								OUString(RTL_CONSTASCII_USTRINGPARAM("Data/TelephoneWork"		))
#define	SUBKEY_USERADRESS_TELEPHONHOME								OUString(RTL_CONSTASCII_USTRINGPARAM("Data/TelephoneHome"		))
#define	SUBKEY_USERADRESS_STREET									OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Street"				))
#define	SUBKEY_USERADRESS_COMPANY									OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Company"				))
#define	SUBKEY_USERADRESS_COUNTRY									OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Country"				))
#define	SUBKEY_USERADRESS_STATE										OUString(RTL_CONSTASCII_USTRINGPARAM("Data/State"				))
#define	SUBKEY_USERADRESS_ZIP										OUString(RTL_CONSTASCII_USTRINGPARAM("Data/Zip"					))

//_______________________________________________________________________________________________________________________
//	macros
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	constructor
//_______________________________________________________________________________________________________________________

ProfileCache::ProfileCache(	const	Reference< XMultiServiceFactory >&	xFactory	,
									Mutex&								aMutex		)
	: m_aPropertyChangeListener	( aMutex	)
	, m_aModifyListener			( aMutex	)
	, m_aProfile				(			)
	, m_aConfigurationMap		(			)
	, m_xFactory				( xFactory	)
	, m_bCfgEnabled				( sal_False )
{
}

//_______________________________________________________________________________________________________________________
//	destructor
//_______________________________________________________________________________________________________________________

ProfileCache::~ProfileCache ()
{
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::open(	const	OUString&	sProfileName	,
								const	sal_uInt8	aFlag			)
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_open( sProfileName, aFlag ), "ProfileCache::open()\nInvalid parameter detected.\n" );

	// Set default return value, if method failed!
	sal_Bool bState = sal_False ;
	switch( aFlag )
	{
		// Open ini-file readonly and save state.
		case OPENFLAG_READONLY	:	bState = m_aProfile.open( sProfileName, OProfile::TOption_ReadLock );
									break;
		// Open ini-file writeable and save state.
		case OPENFLAG_WRITEABLE	:	bState = m_aProfile.open( sProfileName, OProfile::TOption_FlushWrite );
									break;
	}

	// If soffice.ini/ucb.ini opened successfuly - we must initialize ouer configuration map!
	// (sProfileName must be a full qualified path in UNC-notation. We can search for last '/" and get rest as filename of profile!)
	sal_Int32	nFilenameStart	=	sProfileName.lastIndexOf( KEYSEPERATOR );
	++nFilenameStart;
	OUString	sININame		=	sProfileName.copy( nFilenameStart, sProfileName.getLength()-nFilenameStart );
	if	(
			( bState	==	sal_True	)	&&
			(
				( sININame	==	SOFFICE_INI	)	||
				( sININame	==	UCB_INI		)
			)
		)
	{
#if SUPD<613//MUSTINI

		// Then we initialize our hash map. If this map filled, some special keys are forwarded to new configuration
		// management. All other keys are written to soffice.ini/ucb.ini!

		// Attention: For local installation we must disable this feature!
		// Our configuration server can't distinguish between client and server informations.
		// In this case we must work with a normal profile.
		// We can detect this case with an existing key "[ConfigurationManagement]/Disabled=1".
		// The default is a non existing key and a enabled configuration map!

		OUString	sValue;
		sal_Bool	bCfgDisabled = readString( DISABLE_CONFIGURATIONMAP_SECTION, DISABLE_CONFIGURATIONMAP_KEY, sValue );
		if( bCfgDisabled == sal_False )
		{
			// (Use flags to support READONLY, WRITABLE, FLUSHABLE modes too for this keys.)
			m_bCfgEnabled	= impl_initConfigurationMap( aFlag );
			bState			= m_bCfgEnabled;
		}
#else
		OSL_ENSURE( sal_False, "ProfileCache::open()\nsoffice.ini & ucb.ini is obsolete! Don't open it with these service!\n" );
#endif
	}

	// Return state of operation.
	return bState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

void ProfileCache::close()
{
	m_aProfile.close();
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::flush()
{
	if( m_aCfgPoint_Setup.xFlush.is() == sal_True )
	{
		m_aCfgPoint_Setup.xFlush->flush();
	}
	if( m_aCfgPoint_Common.xFlush.is() == sal_True )
	{
		m_aCfgPoint_Common.xFlush->flush();
	}
	if( m_aCfgPoint_UserProfile.xFlush.is() == sal_True )
	{
		m_aCfgPoint_UserProfile.xFlush->flush();
	}
	if( m_aCfgPoint_Inet.xFlush.is() == sal_True )
	{
		m_aCfgPoint_Inet.xFlush->flush();
	}
	return m_aProfile.flush();
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::readString(	const	OUString&	sSection	,
									const	OUString&	sEntry		,
											OUString&	sValue		)
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_readString( sSection, sEntry, sValue ), "ProfileCache::readString()\nInvalid parameter detected.\n" );

	// Set default return value.
	sal_Bool bState = sal_False;

	tIMPL_ConfigurationMapHelper::iterator aItem = impl_searchSpecialKey( sSection, sEntry );
	if( aItem != m_aConfigurationMap.end() )
	{
		// Forward operation to new configuration management.
		try
		{
			if( aItem->first == OLDKEY_USER_USER_ADRESS )
			{
				// Special mode for "User/User-Adress"!
				sValue = impl_readUserAdress( aItem->second.xRootKey );
			}
			else
			{
				// Normal mode for all other keys.
				sValue = impl_readCfgKey( aItem->second.xRootKey, aItem->second.sConfigKeyName );
			}
			bState = sal_True;
		}
		catch( ... )
		{
			#ifdef _DEBUG
			OUString sOut = OUString(RTL_CONSTASCII_USTRINGPARAM("ProfileCache::readString()\nException detected!\nKeyname = "));
			sOut += aItem->second.sConfigKeyName;
			sOut += OUString(RTL_CONSTASCII_USTRINGPARAM(" \n"));
			OSL_ENSURE( sal_False, OUStringToOString( sOut, RTL_TEXTENCODING_UTF8 ) );
			#endif
			bState = sal_False;
		}
	}
	else
	{
		// Use normal ini file.
		// Convert section- and entry-name to OString to get sal_Char!
    	OString sEncodedSection = OUStringToOString( sSection, INITEXTENCODING );
    	OString sEncodedEntry   = OUStringToOString( sEntry  , INITEXTENCODING );
		// Create buffer to get value.
		sal_Char cBuffer[MAX_LINELENGTH];
		memset( cBuffer, 0, MAX_LINELENGTH );
		// Try to get value.
		bState = m_aProfile.readString( sEncodedSection.getStr(), sEncodedEntry.getStr(), cBuffer, MAX_LINELENGTH, NULL );
		// Convert value from sal_Char to OUString.
		sValue = OStringToOUString( OString( cBuffer ), INITEXTENCODING );
	}

	// Return state of operation.
	return bState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::writeString(	const	OUString&	sSection	,
									const	OUString&	sEntry		,
									const	OUString&	sValue		)
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_writeString( sSection, sEntry, sValue ), "ProfileCache::writeString()\nCall without valid parameters!\n" ) ;

	// Read old value from file to compare it with new value
	// and send message to all listener, if value has change.
	OUString sOldValue ;
	sal_Bool bReadState = readString( sSection, sEntry, sOldValue );

	// Convert section-, entry- and value-name to OString to get sal_Char!
    OString sEncodedSection = OUStringToOString( sSection, INITEXTENCODING );
    OString sEncodedEntry   = OUStringToOString( sEntry  , INITEXTENCODING );
    OString sEncodedValue   = OUStringToOString( sValue  , INITEXTENCODING );

	// Set default return state.
	sal_Bool bWriteState = sal_False;

	// Write new value to file.
	// Compare comes later!
	tIMPL_ConfigurationMapHelper::iterator aItem = impl_searchSpecialKey( sSection, sEntry );
	if( aItem != m_aConfigurationMap.end() )
	{
		// Forward operation to new configuration management.
		try
		{
			if( aItem->first == OLDKEY_USER_USER_ADRESS )
			{
				// Special mode for "User/User-Adress"!
				impl_writeUserAdress( aItem->second.xRootKey, sValue );
			}
			else
			{
				// Normal mode for all other keys.
				impl_writeCfgKey( aItem->second.xRootKey, aItem->second.sConfigKeyName, sValue );
			}
			bWriteState = sal_True;
		}
		catch( ... )
		{
			#ifdef _DEBUG
			OUString sOut = OUString(RTL_CONSTASCII_USTRINGPARAM("ProfileCache::writeString()\nException detected!\nKeyname = "));
			sOut += aItem->second.sConfigKeyName;
			sOut += OUString(RTL_CONSTASCII_USTRINGPARAM(" \nValue   = "));
			sOut += sValue;
			sOut += OUString(RTL_CONSTASCII_USTRINGPARAM(" \n"));
			OSL_ENSURE( sal_False, OUStringToOString( sOut, RTL_TEXTENCODING_UTF8 ) );
			#endif
			bWriteState = sal_False;
		}
	}
	else
	{
		// Use normal ini file.
		bWriteState = m_aProfile.writeString( sEncodedSection.getStr(), sEncodedEntry.getStr(), sEncodedValue.getStr() );
	}

	OUString sNewValue = sValue ;
	if	(
			( bReadState	==	sal_True	)	&&
			( bWriteState	==	sal_True	)	&&
			( sOldValue		!=	sNewValue	)
		)
	{
		// Value of existing key hase changed.
		// Send message to all listener on this key.
		impl_sendChangeEvent( sSection, sEntry, sOldValue, sNewValue );

		// Is state of "substitutionVariables()" modified in future ?
		// (Is variable necessary for method "substituteVariables()"?)
		if ( impl_isModified( sSection, sEntry ) == sal_True )
		{
			// Yes ... send notfication to all listener.
			impl_sendModifyEvent();
		}
	}

	// Return state of write operation!
	// ReadState is necessary only for compare and listener notification.
	return bWriteState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::createSection( const OUString& sSection )
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_createSection( sSection ), "ProfileCache::createSection()\nInvalid parameter detected.\n" );

	// Set default return value.
	sal_Bool bState = sal_True;

	// In our new configuration management we could not create an entry or section!
	// We must handle this case.
	// We must return TRUE, because section already exist!
	OSL_ENSURE( !(sSection==SPECIALSECTION_DIRECTORIES || sSection==SPECIALSECTION_SOFFICE_APPS || sSection==SPECIALSECTION_USER), "ProfileCache::createSection()\nCreation of configuration section not allowed! It already exist.\n" );

	// OProfile can't create empty section!
	// And we can't write any entry at this point!
	// This method support only listener mechanism to send an "CREATE_SECTION"-event!
	impl_sendCreateEvent( sSection );

	return bState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::createEntry(	const	OUString&	sSection	,
									const	OUString&	sEntry		)
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_createEntry( sSection, sEntry ), "ProfileCache::createEntry()\nInvalid parameter detected.\n" );

	// Set default return state.
	sal_Bool bState = sal_True;

	// In our new configuration management we could not create a new entry!
	// We must handle this case.
	// Creation of configuration key not allowed but this key MUST exist!
	// Wen can return with true!
	tIMPL_ConfigurationMapHelper::iterator aItem = impl_searchSpecialKey( sSection, sEntry );
	OSL_ENSURE( !(aItem!=m_aConfigurationMap.end()), "ProfileCache::createEntry()\nCreation of configuration key not allowed!\n" );
	if( aItem == m_aConfigurationMap.end() )
	{
		// Create entry without value.
		bState = writeString( sSection, sEntry, OUString() );
	}

	// Send message to all listener on this key.
	if ( bState == sal_True )
	{
		impl_sendCreateEvent( sSection, sEntry );
	}

	return bState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::removeSection( const OUString& sSection )
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_removeSection( sSection ), "ProfileCache::removeSection()\nInvalid parameter detected.\n" );

	// Set default return value.
	sal_Bool bState = sal_False;

	// In our new configuration management we could not remove an entry or section!
	// We must handle this case.
	// We must return FALSE, because removing is not allowed!
	OSL_ENSURE( !(sSection==SPECIALSECTION_DIRECTORIES || sSection==SPECIALSECTION_SOFFICE_APPS || sSection==SPECIALSECTION_USER), "ProfileCache::removeSection()\nRemoving of configuration section not allowed!\n" );
	if	(
			( sSection!=SPECIALSECTION_DIRECTORIES	)	&&
			( sSection!=SPECIALSECTION_SOFFICE_APPS	)	&&
			( sSection!=SPECIALSECTION_USER			)
		)
	{
		// Any other section we can remove!
		Sequence< OUString >	seqEntries	= getSectionEntries( sSection );	// Get all entries of section.
		sal_uInt32				nEntryCount	= seqEntries.getLength();			// Get count of entries.
		const OUString*			pEntry		= seqEntries.getConstArray();
		sal_Bool				bState		= sal_True;							// Set default return state.
		sal_uInt32				nPosition	= 0;

		// Remove all entries.
		// If an error occured - break loop!
		while	(
					( nPosition	<	nEntryCount	)	&&
					( bState	==	sal_True	)
				)
		{
			// Attention: All listener on an entry becomes a message.
			// Listener on this section only, don't become this message now!
			bState = removeEntry( sSection, pEntry[nPosition] );
			++nPosition;
		}
	}

	if ( bState == sal_True )
	{
		// Now send message to listener on this section.
		impl_sendRemoveEvent( sSection );
	}

	// Return state of operation.
	return bState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::removeEntry(	const	OUString&	sSection	,
									const	OUString&	sEntry		)
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_removeEntry( sSection, sEntry ), "ProfileCache::removeEntry()\nInvalid parameter detected.\n" );

	// Set default return state.
	sal_Bool bRemoveState = sal_False;

	// In our new configuration management we could not remove any entries!
	// We must handle this case.
	tIMPL_ConfigurationMapHelper::iterator aItem = impl_searchSpecialKey( sSection, sEntry );
	OSL_ENSURE( !(aItem!=m_aConfigurationMap.end()), "ProfileCache::removeEntry()\nRemoving of configuration key not allowed!\n" );
	if( aItem == m_aConfigurationMap.end() )
	{
		// Read old value from file to send it to all listener!
		// (If someone exist!)
		OUString sOldValue ;
		sal_Bool bReadState = readString( sSection, sEntry, sOldValue );

		// Convert section- and entry-name to OString to get sal_Char!
    	OString sEncodedSection = OUStringToOString( sSection, INITEXTENCODING );
    	OString sEncodedEntry   = OUStringToOString( sEntry  , INITEXTENCODING );

		// Remove key from file.
		bRemoveState = m_aProfile.removeEntry( sEncodedSection.getStr(), sEncodedEntry.getStr() );

		// Send message to all listener on this key.
		// (If we have a valid values!)
		if	(
				( bReadState	==	sal_True	) &&
				( bRemoveState	==	sal_True	)
			)
		{
			impl_sendRemoveEvent( sSection, sEntry, sOldValue );

			// Is state of "substitutionVariables()" modified in future ?
			// (Is variable necessary for method "substituteVariables()"?)
			if ( impl_isModified( sSection, sEntry ) == sal_True )
			{
				// Yes ... send notfication to all listener.
				impl_sendModifyEvent();
			}
		}
	}

	// Return state of operation.
	return bRemoveState ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

Sequence< OUString > ProfileCache::getSectionEntries( const OUString& sSection )
{
	// Safe impossible cases
	// Check parameters
	OSL_ENSURE( impl_debug_checkParameter_getSectionEntries( sSection ), "ProfileCache::getSectionEntries()\nInvalid parameter detected.\n" );

	// Convert section-name to OString to get sal_Char!
    OString sEncodedSection= OUStringToOString( sSection, INITEXTENCODING );

	// Set default return value, if operation failed
    Sequence< OUString > seqEntries = Sequence< OUString >();

	// First look for special section names of our new configuration management.
	if( m_bCfgEnabled == sal_True )
	{
		if( sSection == SPECIALSECTION_DIRECTORIES )
		{
			seqEntries.realloc( 28 );
			seqEntries[0 ]	=	SUBKEY_DIRECTORIES_ADDINS_PATH				;
			seqEntries[1 ]	=	SUBKEY_DIRECTORIES_AUTOCORRECT_DIR          ;
			seqEntries[2 ]	=	SUBKEY_DIRECTORIES_AUTOPILOT_DIR            ;
			seqEntries[3 ]	=	SUBKEY_DIRECTORIES_BACKUP_PATH              ;
			seqEntries[4 ]	=	SUBKEY_DIRECTORIES_BASIC_PATH               ;
			seqEntries[5 ]	=	SUBKEY_DIRECTORIES_BITMAP_PATH              ;
			seqEntries[6 ]	=	SUBKEY_DIRECTORIES_CONFIG_DIR               ;
			seqEntries[7 ]	=	SUBKEY_DIRECTORIES_DATABASE_PATH            ;
			seqEntries[8 ]	=	SUBKEY_DIRECTORIES_DICTIONARY_PATH          ;
			seqEntries[9 ]	=	SUBKEY_DIRECTORIES_FAVORITES_DIR            ;
			seqEntries[10]	=	SUBKEY_DIRECTORIES_FILTER_PATH              ;
			seqEntries[11]	=	SUBKEY_DIRECTORIES_GALLERY_DIR              ;
			seqEntries[12]	=	SUBKEY_DIRECTORIES_GLOSSARY_PATH            ;
			seqEntries[13]	=	SUBKEY_DIRECTORIES_GRAPHICS_PATH            ;
			seqEntries[14]	=	SUBKEY_DIRECTORIES_HELP_DIR                 ;
			seqEntries[15]	=	SUBKEY_DIRECTORIES_LINGUISTIC_DIR           ;
			seqEntries[16]	=	SUBKEY_DIRECTORIES_MODULES_PATH             ;
			seqEntries[17]	=	SUBKEY_DIRECTORIES_NEW_DIR                  ;
			seqEntries[18]	=	SUBKEY_DIRECTORIES_PALETTE_PATH             ;
			seqEntries[19]	=	SUBKEY_DIRECTORIES_PLUGINS_DIR              ;
			seqEntries[20]	=	SUBKEY_DIRECTORIES_STORAGE_DIR              ;
			seqEntries[21]	=	SUBKEY_DIRECTORIES_SUB_INI                  ;
			seqEntries[22]	=	SUBKEY_DIRECTORIES_TEMP_DIR                 ;
			seqEntries[23]	=	SUBKEY_DIRECTORIES_TEMPLATE_PATH            ;
			seqEntries[24]	=	SUBKEY_DIRECTORIES_TRASH_DIR                ;
			seqEntries[25]	=	SUBKEY_DIRECTORIES_USERCONFIG_PATH          ;
			seqEntries[26]	=	SUBKEY_DIRECTORIES_USERDICTIONARY_DIR       ;
			seqEntries[27]	=	SUBKEY_DIRECTORIES_WORK_PATH                ;
		}
		if( sSection == SPECIALSECTION_SOFFICE_APPS )
		{
			seqEntries.realloc( 7 );
			seqEntries[0]	=	SUBKEY_SOFFICE_APPS_SCALC					;
			seqEntries[1]	=	SUBKEY_SOFFICE_APPS_SCHART					;
			seqEntries[2]	=	SUBKEY_SOFFICE_APPS_SDRAW					;
			seqEntries[3]	=	SUBKEY_SOFFICE_APPS_SIMAGE					;
			seqEntries[4]	=	SUBKEY_SOFFICE_APPS_SIMPRESS				;
			seqEntries[5]	=	SUBKEY_SOFFICE_APPS_SMATH					;
			seqEntries[6]	=	SUBKEY_SOFFICE_APPS_SWRITER					;
		}
		if( sSection == SPECIALSECTION_USER )
		{
			seqEntries.realloc( 6 );
			seqEntries[0]	=	SUBKEY_USER_USER_ADRESS						;
			seqEntries[1]	=	SUBKEY_USER_USER_FIRSTNAME					;
			seqEntries[2]	=	SUBKEY_USER_USER_ID							;
			seqEntries[3]	=	SUBKEY_USER_USER_NAME						;
			seqEntries[4]	=	SUBKEY_USER_USERNUMBER						;
			seqEntries[5]	=	SUBKEY_USER_LANGUAGE						;
		}
		if( sSection == SPECIALSECTION_INET )
		{
			seqEntries.realloc( 12 );
			seqEntries[0]	=	SUBKEY_INET_DNSSERVER						;
			seqEntries[1]	=	SUBKEY_INET_FTPPROXYNAME					;
			seqEntries[2]	=	SUBKEY_INET_FTPPROXYPORT					;
			seqEntries[3]	=	SUBKEY_INET_HTTPPROXYNAME					;
			seqEntries[4]	=	SUBKEY_INET_HTTPPROXYPORT					;
			seqEntries[5]	=	SUBKEY_INET_SOCKSPROXYNAME					;
			seqEntries[6]	=	SUBKEY_INET_SOCKSPROXYPORT					;
			seqEntries[7]	=	SUBKEY_INET_REVEALMAILADDRESS				;
			seqEntries[8]	=	SUBKEY_INET_SMTPSERVER						;
			seqEntries[9]	=	SUBKEY_INET_NOPROXY							;
			seqEntries[10]	=	SUBKEY_INET_PROXYTYPE						;
			seqEntries[11]	=	SUBKEY_INET_USERAGENT						;
		}
	}

	// If no special section was handled - sequence must be empty at this point!
	// If sequence not empty we must handle normal ini section.
	if( seqEntries.getLength() < 1 )
	{
		// Get neccessary size of buffer to get all entries.
    	sal_uInt32	nBufferSize	= m_aProfile.getSectionEntries( sEncodedSection.getStr(), NULL, 0 );
		if ( nBufferSize > 0 )
		{
			// Create buffer o get entries.
    		sal_Char* pBuffer = new sal_Char[nBufferSize];
			memset( pBuffer, 0, nBufferSize );
    		// Get names of all entries and count it.
    		sal_uInt32 nSectionLength = m_aProfile.getSectionEntries( sEncodedSection.getStr(), pBuffer, nBufferSize );
			// Safe impossible cases
			// "getSectionEntries()" return always values greater then 0!
			// The last element in array is everytime "\0". But if this changed ???? .... we have a problem !!!!
			OSL_ENSURE ( !( nSectionLength < 1 ), "ProfileCache::getSectionEntries()\nHas implementation of OProfile::getSectionEntries() changed? nSectionLength <= 0\n" ) ;
			// Don't look for last element in buffer!!!!
			--nSectionLength ;
			// nSectionLength must be >= 0 now!
			// nSectionLength is the size of pBuffer but not the number of entries!
			// Now, we count the entries.
			sal_uInt32 nEntryCount = 0 ;
			for ( sal_uInt32 nPosition=0; nPosition<nSectionLength; )
			{
				// Get name of entry ...
				OString sEntryName = ( pBuffer + nPosition ) ;
				// ... and count this.
				++nEntryCount ;
				// Step to new position in pBuffer
        		nPosition += sEntryName.getLength();
				++nPosition ;
			}

			// Create sequence for all entries.
			seqEntries.realloc( nEntryCount );
			OUString* pArray = seqEntries.getArray();

			// Copy names from buffer to sequence.
			nPosition = 0;
    		for ( sal_uInt32 nEntryNumber=0; nEntryNumber<nEntryCount; ++nEntryNumber )
    		{
				// Read an entry from buffer ...
        		OUString sINIEntry = OStringToOUString( OString( pBuffer+nPosition ), INITEXTENCODING );
				// ... set it into sequence ...
				if ( sINIEntry.getLength() > 0 )
				{
					pArray[nEntryNumber] = sINIEntry ;
				}
				#ifdef _DEBUG
				else
				{
					OSL_ENSURE( sal_False, "ProfileCache::getSections()\nI have read an empty sectionname! Whats wrong ...\n");
				}
				#endif
				// Calculate new position in entry list and sequence.
        		nPosition += sINIEntry.getLength()+1;
    		}
			// Clear memory!
			delete[] pBuffer ;
		}
	}

	// Return entries.
	return seqEntries ;
}

//_______________________________________________________________________________________________________________________
//	OProfile
//_______________________________________________________________________________________________________________________

Sequence< OUString > ProfileCache::getSections()
{
	// Set default return value, if operation failed
    Sequence< OUString > seqSections = Sequence< OUString >();

	// Get neccessary size of buffer to get all entries.
    sal_uInt32	nBufferSize	= m_aProfile.getSections( NULL, NULL, 0 );
	if ( nBufferSize > 0 )
	{
		// Create buffer to get sections.
    	sal_Char* pBuffer = new sal_Char[nBufferSize];
		memset( pBuffer, 0, nBufferSize );
    	// Get names of all sections and count it.
    	sal_uInt32 nLength = m_aProfile.getSections( NULL, pBuffer, nBufferSize );
		// Safe impossible cases
		// "getSections()" return always values greater then 0!
		// The last element in array is everytime "\0". But if this changed ???? .... we have a problem !!!!
		OSL_ENSURE ( !( nLength < 1 ), "ProfileCache::getSections()\nHas implementation of OProfile::getSections() changed? nSectionLength <= 0\n" ) ;
		// Don't look for last element in buffer!!!!
		--nLength ;
		// nLength must be >= 0 now!
		// nLength is the size of pBuffer but not the number of sections!
		// Now, we count the sections.
		sal_uInt32 nSectionCount = 0 ;
		for ( sal_uInt32 nPosition=0; nPosition<nLength; )
		{
			// Get name of section ...
			OString sSectionName = ( pBuffer + nPosition ) ;
			// ... and count this.
			++nSectionCount ;
			// Step to new position in pBuffer
        	nPosition += sSectionName.getLength();
			++nPosition ;
		}

		// Create sequence for all sections.
		seqSections.realloc( nSectionCount );
		OUString* pArray = seqSections.getArray();

		// Copy names from buffer to sequence.
		nPosition = 0 ;
    	for ( sal_uInt32 nSectionNumber=0; nSectionNumber<nSectionCount; ++nSectionNumber )
    	{
			// Read a sectionname from buffer ...
        	OUString sINISection = OStringToOUString( OString( pBuffer+nPosition ), INITEXTENCODING );
			// ... set it into sequence ...
			if ( sINISection.getLength() > 0 )
			{
				pArray[nSectionNumber] = sINISection ;
			}
			// Calculate new position in section list and sequence.
        	nPosition += sINISection.getLength()+1;
    	}
		// Clear memory!
		delete[] pBuffer ;
	}

	// Add special sections to return list now!
	// These sections could not exist in normal ini .. or something is worng with setup!
	if( m_bCfgEnabled == sal_True )
	{
		sal_Int32 nLength = seqSections.getLength();
		seqSections.realloc( nLength+4 );
		seqSections[nLength  ] = SPECIALSECTION_DIRECTORIES	;
		seqSections[nLength+1] = SPECIALSECTION_SOFFICE_APPS;
		seqSections[nLength+2] = SPECIALSECTION_USER		;
		seqSections[nLength+3] = SPECIALSECTION_INET		;
	}

	// Return sections.
	return seqSections ;
}

//_______________________________________________________________________________________________________________________
//	public but not exported method (impl!)
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_addPropertyChangeListener(	const	OUString&								sKeyName	,
													const	Reference< XPropertyChangeListener >&	xListener	) throw( RuntimeException )
{
	// Convert keyname to lower case!
	// It's necessary to find this key case insensitive.
	// Sections and entries of an INI-file are case insensitive ...
	// but helperclass for "PropertyChangeListener" is it!
	m_aPropertyChangeListener.addInterface( sKeyName.toAsciiLowerCase(), xListener );
}

//_______________________________________________________________________________________________________________________
//	public but not exported method (impl!)
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_removePropertyChangeListener(	const	OUString&								sKeyName	,
														const	Reference< XPropertyChangeListener >&	xListener	) throw( RuntimeException )
{
	// Convert keyname to lower case!
	// See also "impl_addPropertyChangeListener()" !
	m_aPropertyChangeListener.removeInterface( sKeyName.toAsciiLowerCase(), xListener );
}

//_______________________________________________________________________________________________________________________
//	public but not exported method (impl!)
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_addModifyListener( const Reference< XModifyListener >& xListener ) throw( RuntimeException )
{
	m_aModifyListener.addInterface( ::getCppuType((const Reference< XModifyListener >*)0), xListener );
}

//_______________________________________________________________________________________________________________________
//	public but not exported method (impl!)
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_removeModifyListener( const Reference< XModifyListener >& xListener ) throw( RuntimeException )
{
	m_aModifyListener.removeInterface( ::getCppuType((const Reference< XModifyListener >*)0), xListener );
}

//_______________________________________________________________________________________________________________________
//	public but not exported method (impl!)
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_setConfigManagerReference( XInterface* pConfigManager )
{
	m_pConfigManager = pConfigManager ;
}

//_______________________________________________________________________________________________________________________
//	public but not exported method (impl!)
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_disposing( const EventObject& aSource ) throw( RuntimeException )
{
	// Dispose ALL listener ...
	m_aPropertyChangeListener.disposeAndClear( aSource );
	m_aModifyListener.disposeAndClear( aSource );
	// Clear configuration map
	m_aConfigurationMap.clear();
	// Close(!) and forget all configuration keys and access points.
	if( m_aCfgPoint_Setup.xBaseNode.is()==sal_True )
	{
		m_aCfgPoint_Setup.xBaseNode->closeKey();
		m_aCfgPoint_Setup.xBaseNode = Reference< XRegistryKey >();
	}
	if( m_aCfgPoint_Common.xBaseNode.is()==sal_True )
	{
		m_aCfgPoint_Common.xBaseNode->closeKey();
		m_aCfgPoint_Common.xBaseNode = Reference< XRegistryKey >();
	}
	if( m_aCfgPoint_UserProfile.xBaseNode.is()==sal_True )
	{
		m_aCfgPoint_UserProfile.xBaseNode->closeKey();
		m_aCfgPoint_UserProfile.xBaseNode = Reference< XRegistryKey >();
	}
	if( m_aCfgPoint_Inet.xBaseNode.is()==sal_True )
	{
		m_aCfgPoint_Inet.xBaseNode->closeKey();
		m_aCfgPoint_Inet.xBaseNode = Reference< XRegistryKey >();
	}
	if( m_aCfgPoint_Setup.xTree.is()==sal_True )
	{
		m_aCfgPoint_Setup.xTree->close();
		m_aCfgPoint_Setup.xTree = Reference< XSimpleRegistry >();
	}
	if( m_aCfgPoint_Common.xTree.is()==sal_True )
	{
		m_aCfgPoint_Common.xTree->close();
		m_aCfgPoint_Common.xTree = Reference< XSimpleRegistry >();
	}
	if( m_aCfgPoint_UserProfile.xTree.is()==sal_True )
	{
		m_aCfgPoint_UserProfile.xTree->close();
		m_aCfgPoint_UserProfile.xTree = Reference< XSimpleRegistry >();
	}
	if( m_aCfgPoint_Inet.xTree.is()==sal_True )
	{
		m_aCfgPoint_Inet.xTree->close();
		m_aCfgPoint_Inet.xTree = Reference< XSimpleRegistry >();
	}
	// Release some other references.
	m_aCfgPoint_Setup.xFlush		= Reference< XFlushable >();
	m_aCfgPoint_Common.xFlush		= Reference< XFlushable >();
	m_aCfgPoint_UserProfile.xFlush	= Reference< XFlushable >();
	m_aCfgPoint_Inet.xFlush			= Reference< XFlushable >();
	m_xFactory						= Reference< XMultiServiceFactory >();
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendCreateEvent( const OUString& sSection )
{
	// Get listener for sections!
	// But search names case insensitive.
	// See also "impl_addPropertyChangeListener()" !
	OInterfaceContainerHelper* pListener_Section = m_aPropertyChangeListener.getContainer( sSection.toAsciiLowerCase() );

	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if ( pListener_Section != NULL )
	{
		// Build event for send to listener.
		PropertyChangeEvent	aEvent ;

		aEvent.PropertyName		=	sSection	;	// Name of key, which is changed.
		aEvent.Further			=	sal_False	;	// Thats all !
		aEvent.PropertyHandle	=	-1		 	;	// Handle is not needed.
		aEvent.OldValue			=	Any()	 	;	// Old value of key. ( set "void" while key is created. )
		aEvent.NewValue			<<= OUString() 	;	// New value of key. ( set empty string, to say "key is created"!)

		// Send message to all listener on this section.
		impl_sendPropertyChangeEvent( pListener_Section, aEvent );
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendCreateEvent(	const	OUString&	sSection	,
											const	OUString&	sEntry		)
{
	// Build keyname for this entry.
	OUStringBuffer sKeyNameBuffer( MAX_LINELENGTH );
	sKeyNameBuffer.append( sSection		);
	sKeyNameBuffer.append( KEYSEPERATOR	);
	sKeyNameBuffer.append( sEntry		);
	OUString sKeyName = sKeyNameBuffer.makeStringAndClear();

	// Get listener for entry.
	// But search names case insensitive.
	// See also "impl_addPropertyChangeListener()" !
	OInterfaceContainerHelper* pListener_Entry = m_aPropertyChangeListener.getContainer( sKeyName.toAsciiLowerCase() );

	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if ( pListener_Entry != NULL )
	{
		// Build event for send to listener.
		PropertyChangeEvent	aEvent ;

		aEvent.PropertyName		=	sKeyName	;	// Name of key, which is changed.
		aEvent.Further			=	sal_False	;	// Thats all !
		aEvent.PropertyHandle	=	-1		 	;	// Handle is not needed.
		aEvent.OldValue			=	Any()	 	;	// Old value of key. ( set "void" while key is created. )
		aEvent.NewValue			<<= OUString() 	;	// New value of key. ( set empty string, to say "key is created"!)

		// Send message to all listener on this entry.
		impl_sendPropertyChangeEvent( pListener_Entry, aEvent );
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendChangeEvent(	const	OUString&	sSection		,
											const	OUString&	sChangedEntry	)
{
	// Get listener for sections!
	// But search names case insensitive.
	// See also "impl_addPropertyChangeListener()" !
	OInterfaceContainerHelper* pListener_Section = m_aPropertyChangeListener.getContainer( sSection.toAsciiLowerCase() );

	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if ( pListener_Section != NULL )
	{
		// Build event for send to listener.
		PropertyChangeEvent	aEvent ;

		aEvent.PropertyName		=	sSection		;	// Name of key, which is changed.
		aEvent.Further			=	sal_False		;	// Thats all !
		aEvent.PropertyHandle	=	-1		 		;	// Handle is not needed.
		aEvent.OldValue			<<=	OUString() 		;	// Old value of key. ( set empty string while key is created. )
		aEvent.NewValue			<<= sChangedEntry 	;	// New value of key. ( set keyname himself, to say "key is created"!)

		// Send message to all listener on this section.
		impl_sendPropertyChangeEvent( pListener_Section, aEvent );
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendChangeEvent(	const	OUString&	sSection	,
											const	OUString&	sEntry		,
											const	OUString&	sOldValue	,
											const	OUString&	sNewValue	)
{
	// Build keyname for this entry.
	OUStringBuffer sKeyNameBuffer( MAX_LINELENGTH );
	sKeyNameBuffer.append( sSection		);
	sKeyNameBuffer.append( KEYSEPERATOR	);
	sKeyNameBuffer.append( sEntry		);
	OUString sKeyName = sKeyNameBuffer.makeStringAndClear();

	// Get listener for entry.
	// But search names case insensitive.
	// See also "impl_addPropertyChangeListener()" !
	OInterfaceContainerHelper* pListener_Entry = m_aPropertyChangeListener.getContainer( sKeyName.toAsciiLowerCase() );

	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if ( pListener_Entry != NULL )
	{
		// Build event for send to listener.
		PropertyChangeEvent	aEvent ;

		aEvent.PropertyName		=	sKeyName	;	// Name of key, which is changed.
		aEvent.Further			=	sal_False	;	// Thats all !
		aEvent.PropertyHandle	=	-1		 	;	// Handle is not needed.
		aEvent.OldValue			<<=	sOldValue 	;	// Old value of key.
		aEvent.NewValue			<<= sNewValue 	;	// New value of key.

		// Send message to all listener on this entry.
		impl_sendPropertyChangeEvent( pListener_Entry, aEvent );
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendRemoveEvent( const OUString& sSection )
{
	// Get listener for sections!
	// But search names case insensitive.
	// See also "impl_addPropertyChangeListener()" !
	OInterfaceContainerHelper* pListener_Section = m_aPropertyChangeListener.getContainer( sSection.toAsciiLowerCase() );

	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if ( pListener_Section != NULL )
	{
		// Build event for send to listener.
		PropertyChangeEvent	aEvent ;

		aEvent.PropertyName		=	sSection		;	// Name of key, which is changed.
		aEvent.Further			=	sal_False		;	// Thats all !
		aEvent.PropertyHandle	=	-1		 		;	// Handle is not needed.
		aEvent.OldValue			<<=	OUString() 		;	// Old value of key.
		aEvent.NewValue			=	Any()			;	// New value of key. ( set "void", to say "key is removed"!)

		// Send message to all listener on this section.
		impl_sendPropertyChangeEvent( pListener_Section, aEvent );
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendRemoveEvent(	const	OUString&	sSection	,
											const	OUString&	sEntry		,
											const	OUString&	sOldValue	)
{
	// Build keyname for this entry.
	OUStringBuffer sKeyNameBuffer( MAX_LINELENGTH );
	sKeyNameBuffer.append( sSection		);
	sKeyNameBuffer.append( KEYSEPERATOR	);
	sKeyNameBuffer.append( sEntry		);
	OUString sKeyName = sKeyNameBuffer.makeStringAndClear();

	// Get listener for entry.
	// But search names case insensitive.
	// See also "impl_addPropertyChangeListener()" !
	OInterfaceContainerHelper* pListener_Entry = m_aPropertyChangeListener.getContainer( sKeyName.toAsciiLowerCase() );

	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if ( pListener_Entry != NULL )
	{
		// Build event for send to listener.
		PropertyChangeEvent	aEvent ;

		aEvent.PropertyName		=	sKeyName	;	// Name of key, which is changed.
		aEvent.Further			=	sal_False	;	// Thats all !
		aEvent.PropertyHandle	=	-1		 	;	// Handle is not needed.
		aEvent.OldValue			<<=	sOldValue	;	// Old value of key.
		aEvent.NewValue			=	Any() 		;	// New value of key. ( set "void" while key is removed. )

		// Send message to all listener on this entry.
		impl_sendPropertyChangeEvent( pListener_Entry, aEvent );
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendPropertyChangeEvent(		OInterfaceContainerHelper*	pListener	,
												const	PropertyChangeEvent&		aEvent		)
{
	// Send "PropertyChange"-message to all listener.
	OInterfaceIteratorHelper aIterator(*pListener);
	while ( aIterator.hasMoreElements() )
	{
		(( XPropertyChangeListener*)aIterator.next())->propertyChange(aEvent);
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

void ProfileCache::impl_sendModifyEvent()
{
	// Get Listener
	OInterfaceContainerHelper* pListener = m_aModifyListener.getContainer( ::getCppuType((const Reference< XModifyListener >*)0) );

	if ( pListener != NULL )
	{
		// Build message.
		EventObject aEvent( m_pConfigManager );
		// Send message to all listener.
		OInterfaceIteratorHelper aIterator(*pListener);
		while ( aIterator.hasMoreElements() )
		{
			(( XModifyListener*)aIterator.next())->modified(aEvent);
		}
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________

sal_Bool ProfileCache::impl_isModified(	const	OUString&	sSection	,
										const	OUString&	sEntry		)
{
	// At this point, we know "value of key was changed" !
	// Question: Modify this key the results of "substituteVariables()" ? Must we send  notification to all listener ?

	// Build complete keyname.
	OUStringBuffer sBuffer(MAX_LINELENGTH);
	sBuffer.append( sSection	);
	sBuffer.append( KEYSEPERATOR);
	sBuffer.append( sEntry		);
	OUString sKeyName = sBuffer.makeStringAndClear();
	// Convert it to lower case to compare it with const ascii defines!
	sKeyName = sKeyName.toAsciiLowerCase();

	// Test, if key one of modifiable keys.
	if (
		( sKeyName.compareToAscii( KEYNAME_BOOKMARKDIRECTORY	) == STRINGFOUND )	||
		( sKeyName.compareToAscii( KEYNAME_WORKDIRECTORY		) == STRINGFOUND )	||
		( sKeyName.compareToAscii( KEYNAME_EXPLORERDIRECTORY	) == STRINGFOUND )	//||
//		( sKeyName.compareToAscii( KEYNAME_LANGUAGETYPE			) == STRINGFOUND )		Not used at the moment! We don't switch language at runtime.
	   )
	{
		// YES ...
		return sal_True ;
	}

	// There was nothing changed!
	return sal_False ;
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________
sal_Bool ProfileCache::impl_initConfigurationMap( const sal_uInt8 nFlag )
{
	// Don't call this method again!
	OSL_ENSURE( !(m_aCfgPoint_Setup.xBaseNode.is()==sal_True && m_aCfgPoint_Common.xBaseNode.is()==sal_True && m_aCfgPoint_UserProfile.xBaseNode.is()==sal_True && m_aCfgPoint_Inet.xBaseNode.is()==sal_True), "ProfileCache::impl_initConfigurationMap()\nDon't call this method again!\n" );

	sal_Bool bState = sal_False;

	try
	{
		// First open 4 different subtrees of configuration tree.
		// (All needed variables are collected in these.)
		m_aCfgPoint_Setup.xTree			= Reference< XSimpleRegistry >( m_xFactory->createInstance( SERVICENAME_CONFIGURATION ), UNO_QUERY );
		m_aCfgPoint_Common.xTree		= Reference< XSimpleRegistry >( m_xFactory->createInstance( SERVICENAME_CONFIGURATION ), UNO_QUERY );
		m_aCfgPoint_UserProfile.xTree	= Reference< XSimpleRegistry >( m_xFactory->createInstance( SERVICENAME_CONFIGURATION ), UNO_QUERY );
		m_aCfgPoint_Inet.xTree			= Reference< XSimpleRegistry >( m_xFactory->createInstance( SERVICENAME_CONFIGURATION ), UNO_QUERY );
		// Initialize services for flushing keys from configuration map.
		m_aCfgPoint_Setup.xFlush		= Reference< XFlushable >( m_aCfgPoint_Setup.xTree		, UNO_QUERY );
		m_aCfgPoint_Common.xFlush		= Reference< XFlushable >( m_aCfgPoint_Common.xTree		, UNO_QUERY );
		m_aCfgPoint_UserProfile.xFlush	= Reference< XFlushable >( m_aCfgPoint_UserProfile.xTree, UNO_QUERY );
		m_aCfgPoint_Inet.xFlush			= Reference< XFlushable >( m_aCfgPoint_Inet.xTree		, UNO_QUERY );

		// Safe impossible cases
		// We need this services for working!
		OSL_ENSURE( !(m_aCfgPoint_Setup.xTree.is()==sal_False || m_aCfgPoint_Common.xTree.is()==sal_False || m_aCfgPoint_UserProfile.xTree.is()==sal_False || m_aCfgPoint_Inet.xTree.is()==sal_False ), "ProfileCache::impl_initConfigurationMap()\nUnknown service \"com.sun.star.configuration.ConfigurationRegistry\"!\n"	);
		OSL_ENSURE( !(m_aCfgPoint_Setup.xFlush.is()==sal_False || m_aCfgPoint_Common.xFlush.is()==sal_False || m_aCfgPoint_UserProfile.xFlush.is()==sal_False || m_aCfgPoint_Inet.xFlush.is()==sal_False), "ProfileCache::impl_initConfigurationMap()\nConfiguration wrapper don't support XFlushable ...!?\n" );

		// Open start points in configuration tree.
		// Open all keys depended from open state of soffice.ini!
		sal_Bool bReadOnly = sal_False;
		if( nFlag == OPENFLAG_READONLY )
		{
			bReadOnly = sal_True;
		}
		m_aCfgPoint_Setup.xTree->open		( STARTPOINT_SETUP		, bReadOnly, sal_False );
		m_aCfgPoint_Common.xTree->open		( STARTPOINT_COMMON		, bReadOnly, sal_False );
		m_aCfgPoint_UserProfile.xTree->open	( STARTPOINT_USERPROFILE, bReadOnly, sal_False );
		m_aCfgPoint_Inet.xTree->open		( STARTPOINT_INET		, bReadOnly, sal_False );
		// Get access point to needed subtrees.
		m_aCfgPoint_Setup.xBaseNode			= m_aCfgPoint_Setup.xTree->getRootKey();
		m_aCfgPoint_Common.xBaseNode		= m_aCfgPoint_Common.xTree->getRootKey();
		m_aCfgPoint_UserProfile.xBaseNode	= m_aCfgPoint_UserProfile.xTree->getRootKey();
		m_aCfgPoint_Inet.xBaseNode			= m_aCfgPoint_Inet.xTree->getRootKey();

		// Safe impossible cases
		// We need access points for working!
		OSL_ENSURE( !(m_aCfgPoint_Setup.xTree->isValid()==sal_False|| m_aCfgPoint_Common.xTree->isValid()==sal_False || m_aCfgPoint_UserProfile.xTree->isValid()==sal_False  || m_aCfgPoint_Inet.xTree->isValid()==sal_False ), "ProfileCache::impl_initConfigurationMap()\nConfiguration services not valid!\n" );
		OSL_ENSURE( !(m_aCfgPoint_Setup.xBaseNode.is()==sal_False	|| m_aCfgPoint_Common.xBaseNode.is()==sal_False || m_aCfgPoint_UserProfile.xBaseNode.is()==sal_False  || m_aCfgPoint_Inet.xBaseNode.is()==sal_False ), "ProfileCache::impl_initConfigurationMap()\nAccess start points of configuration server not available!\n" );

		// Now we can fill our configuration map.
		// Initialize configuration map for "com.sun.star.Office.Common"
		m_aConfigurationMap[OLDKEY_DIRECTORIES_ADDINS_PATH			] = NEWKEY_DIRECTORIES_ADDINS_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_AUTOCORRECT_DIR		] = NEWKEY_DIRECTORIES_AUTOCORRECT_DIR			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_AUTOPILOT_DIR		] = NEWKEY_DIRECTORIES_AUTOPILOT_DIR			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_BACKUP_PATH			] = NEWKEY_DIRECTORIES_BACKUP_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_BASIC_PATH			] = NEWKEY_DIRECTORIES_BASIC_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_BITMAP_PATH			] = NEWKEY_DIRECTORIES_BITMAP_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_CONFIG_DIR			] = NEWKEY_DIRECTORIES_CONFIG_DIR				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_DATABASE_PATH		] = NEWKEY_DIRECTORIES_DATABASE_PATH			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_DICTIONARY_PATH		] = NEWKEY_DIRECTORIES_DICTIONARY_PATH			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_FAVORITES_DIR		] = NEWKEY_DIRECTORIES_FAVORITES_DIR			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_FILTER_PATH			] = NEWKEY_DIRECTORIES_FILTER_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_GALLERY_DIR			] = NEWKEY_DIRECTORIES_GALLERY_DIR				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_GLOSSARY_PATH		] = NEWKEY_DIRECTORIES_GLOSSARY_PATH			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_GRAPHICS_PATH		] = NEWKEY_DIRECTORIES_GRAPHICS_PATH			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_HELP_DIR				] = NEWKEY_DIRECTORIES_HELP_DIR					;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_LINGUISTIC_DIR		] = NEWKEY_DIRECTORIES_LINGUISTIC_DIR			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_MODULES_PATH			] = NEWKEY_DIRECTORIES_MODULES_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_NEW_DIR				] = NEWKEY_DIRECTORIES_NEW_DIR					;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_PALETTE_PATH			] = NEWKEY_DIRECTORIES_PALETTE_PATH				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_PLUGINS_DIR			] = NEWKEY_DIRECTORIES_PLUGINS_DIR				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_STORAGE_DIR			] = NEWKEY_DIRECTORIES_STORAGE_DIR				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_SUB_INI				] = NEWKEY_DIRECTORIES_SUB_INI					;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_TEMP_DIR				] = NEWKEY_DIRECTORIES_TEMP_DIR					;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_TEMPLATE_PATH		] = NEWKEY_DIRECTORIES_TEMPLATE_PATH			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_TRASH_DIR			] = NEWKEY_DIRECTORIES_TRASH_DIR				;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_USERCONFIG_PATH		] = NEWKEY_DIRECTORIES_USERCONFIG_PATH			;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_USERDICTIONARY_DIR	] = NEWKEY_DIRECTORIES_USERDICTIONARY_DIR		;
		m_aConfigurationMap[OLDKEY_DIRECTORIES_WORK_PATH			] = NEWKEY_DIRECTORIES_WORK_PATH				;
		// Initialize configuration map for "com.sun.star.Setup"
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SCALC				] = NEWKEY_SOFFICE_APPS_SCALC					;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SCHART				] = NEWKEY_SOFFICE_APPS_SCHART					;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SDRAW				] = NEWKEY_SOFFICE_APPS_SDRAW					;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SIMAGE				] = NEWKEY_SOFFICE_APPS_SIMAGE					;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SIMPRESS			] = NEWKEY_SOFFICE_APPS_SIMPRESS				;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SMATH				] = NEWKEY_SOFFICE_APPS_SMATH					;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SSCHEDULE			] = NEWKEY_SOFFICE_APPS_SSCHEDULE				;
		m_aConfigurationMap[OLDKEY_SOFFICE_APPS_SWRITER				] = NEWKEY_SOFFICE_APPS_SWRITER					;
		// Initialize configuration map for "com.sun.star.UserProfile"
		m_aConfigurationMap[OLDKEY_USER_USER_ADRESS					] = NEWKEY_USER_USER_ADRESS						;
		m_aConfigurationMap[OLDKEY_USER_USER_FIRSTNAME				] = NEWKEY_USER_USER_FIRSTNAME					;
		m_aConfigurationMap[OLDKEY_USER_USER_ID						] = NEWKEY_USER_USER_ID							;
		m_aConfigurationMap[OLDKEY_USER_USER_NAME					] = NEWKEY_USER_USER_NAME						;
		m_aConfigurationMap[OLDKEY_USER_USERNUMBER					] = NEWKEY_USER_USERNUMBER						;
		m_aConfigurationMap[OLDKEY_USER_LANGUAGE					] = NEWKEY_USER_LANGUAGE						;
		// Initialize configuration map for "com.sun.star.Office.Inet"
		m_aConfigurationMap[OLDKEY_INET_DNSSERVER					] = NEWKEY_INET_DNSSERVER						;
		m_aConfigurationMap[OLDKEY_INET_FTPPROXYNAME				] = NEWKEY_INET_FTPPROXYNAME					;
		m_aConfigurationMap[OLDKEY_INET_FTPPROXYPORT				] = NEWKEY_INET_FTPPROXYPORT					;
		m_aConfigurationMap[OLDKEY_INET_HTTPPROXYNAME				] = NEWKEY_INET_HTTPPROXYNAME					;
		m_aConfigurationMap[OLDKEY_INET_HTTPPROXYPORT				] = NEWKEY_INET_HTTPPROXYPORT					;
		m_aConfigurationMap[OLDKEY_INET_SOCKSPROXYNAME				] = NEWKEY_INET_SOCKSPROXYNAME					;
		m_aConfigurationMap[OLDKEY_INET_SOCKSPROXYPORT				] = NEWKEY_INET_SOCKSPROXYPORT					;
		m_aConfigurationMap[OLDKEY_INET_REVEALMAILADDRESS			] = NEWKEY_INET_REVEALMAILADDRESS				;
		m_aConfigurationMap[OLDKEY_INET_SMTPSERVER					] = NEWKEY_INET_SMTPSERVER						;
		m_aConfigurationMap[OLDKEY_INET_NOPROXY						] = NEWKEY_INET_NOPROXY							;
		m_aConfigurationMap[OLDKEY_INET_PROXYTYPE					] = NEWKEY_INET_PROXYTYPE						;
		m_aConfigurationMap[OLDKEY_INET_USERAGENT					] = NEWKEY_INET_USERAGENT						;

		bState = sal_True;
	}
	catch( ... )
	{
		OSL_ENSURE( sal_False, "ProfileCache::impl_initConfigurationMap()\nMap for configuration management could not be initialized!\n" );
		bState = sal_False;
	}

	return bState;
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________
tIMPL_ConfigurationMapHelper::iterator ProfileCache::impl_searchSpecialKey(	const	OUString&	sSection	,
																			const	OUString&	sEntry		)
{
	// Build key for hash map.
	OUStringBuffer sKeyBuffer( MAX_LINELENGTH );
	sKeyBuffer.append( sSection		);
	sKeyBuffer.append( KEYSEPERATOR	);
	sKeyBuffer.append( sEntry		);
	// Look for key in map and return found state.
	// Key exist     = True
	// Key not exist = False
	return m_aConfigurationMap.find( sKeyBuffer.makeStringAndClear() );
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________
OUString ProfileCache::impl_readUserAdress( const Reference< XRegistryKey >& xBaseNode )
{
	OUStringBuffer sBuffer( MAX_LINELENGTH );
	Reference< XRegistryKey > xEntry;
	OUString sEntryValue;

	// Read all subkeys and append it to return value.
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_COMPANY );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_STREET );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_COUNTRY );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_ZIP );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_CITY );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_TITLE );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_POSITION );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_TELEPHONHOME );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_TELEPHONWORK );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_FAX );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_EMAIL );
	sBuffer.append( sEntryValue		);
	sBuffer.append( sal_Unicode('#'));
	sEntryValue = impl_readCfgKey( xBaseNode, SUBKEY_USERADRESS_STATE );
	sBuffer.append( sEntryValue		);

	// Return state of operation.
	return sBuffer.makeStringAndClear();
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________
void ProfileCache::impl_writeUserAdress(	const	Reference< XRegistryKey >&	xBaseNode	,
											const	OUString&					sValue		)
{
	sal_Int32	nTokenStart	= 0;
	sal_Int32	nTokenEnd	= 0;
	sal_Int32	nToken		= 0;
	OUString	sToken;

	nTokenEnd = sValue.indexOf( sal_Unicode('#') );
	while( nTokenEnd != -1 )
	{
		sToken = sValue.copy( nTokenStart, nTokenEnd-nTokenStart );
		++nToken;
		switch( nToken )
		{
			case 1	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_COMPANY, sToken );
						break;
			case 2	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_STREET, sToken );
						break;
			case 3	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_COUNTRY, sToken );
						break;
			case 4	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_ZIP, sToken );
						break;
			case 5	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_CITY, sToken );
						break;
			case 6	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_TITLE, sToken );
						break;
			case 7	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_POSITION, sToken );
						break;
			case 8	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_TELEPHONHOME, sToken );
						break;
			case 9	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_TELEPHONWORK, sToken );
						break;
			case 10	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_FAX, sToken );
						break;
			case 11	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_EMAIL, sToken );
						break;
			case 12	:	impl_writeCfgKey( xBaseNode, SUBKEY_USERADRESS_STATE, sToken );
						break;
		}
		++nTokenEnd;
		nTokenStart	=	nTokenEnd;
		nTokenEnd	=	sValue.indexOf( sal_Unicode('#'), nTokenStart );
		// Handle pending letters from last '#' to end of incoming value!
		if	(
				( nTokenEnd		==	-1					)	&&
				( nTokenStart	<	sValue.getLength()	)
			)
		{
			nTokenEnd = sValue.getLength();
		}
	}
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________
OUString ProfileCache::impl_readCfgKey(	const	Reference< XRegistryKey >&	xBaseNode	,
										const	OUString&					sName		)
{
	// Set default value if method failed.
	OUString sValue;

	// Open subkey, get his type, read his value with right interface method
	// and set it for return.
	Reference< XRegistryKey > xEntry = xBaseNode->openKey( sName );
	if( xEntry.is() == sal_True )
	{
		RegistryValueType aType = xEntry->getValueType();
		switch( aType )
		{
			case RegistryValueType_STRING		:	sValue = xEntry->getStringValue();
													break;
			case RegistryValueType_LONG			:	sValue = OUString::valueOf( (sal_Int32)xEntry->getLongValue() );
													break;
			case RegistryValueType_STRINGLIST	:	{
														Sequence< OUString >	seqEntries	= xEntry->getStringListValue();
														sal_Int32				nCount		= seqEntries.getLength();
														for( sal_Int32 nPosition=0; nPosition<nCount; ++nPosition )
														{
															sValue += seqEntries[nPosition];
															if( nPosition < nCount-1 )
															{
																sValue += OUString(RTL_CONSTASCII_USTRINGPARAM(";"));
															}
														}
													}
													break;
			default								:	throw RuntimeException( OUString(RTL_CONSTASCII_USTRINGPARAM("ProfileCache::impl_readCfgKey()\nUnsupported config key type detected!\n")), Reference< XInterface>( m_pConfigManager, UNO_QUERY ) );
													break;
		}
		xEntry->closeKey();
	}
	else
	{
		throw RuntimeException();
	}

	return sValue;
}

//_______________________________________________________________________________________________________________________
//	private method
//_______________________________________________________________________________________________________________________
void ProfileCache::impl_writeCfgKey(	const	Reference< XRegistryKey >&	xBaseNode	,
										const	OUString&					sName		,
										const	OUString&					sValue		)
{
	// Open subkey, get his type and write his value with right interface method.
	Reference< XRegistryKey > xEntry = xBaseNode->openKey( sName );
	if( xEntry.is() == sal_True )
	{
		RegistryValueType aType = xEntry->getValueType();
		switch( aType )
		{
			case RegistryValueType_STRING		:	xEntry->setStringValue( sValue );
													break;
			case RegistryValueType_LONG			:	xEntry->setLongValue( sValue.toInt32() );
													break;
			case RegistryValueType_STRINGLIST	:	{
														sal_Int32	nSize	= sValue.getLength();
														sal_Int32	nToken	= 0					;
														sal_Int32	nStart	= 0					;
														sal_Int32	nEnd	= 0					;
														Sequence< OUString > seqToken			;

														while( nStart < nSize )
														{
															nEnd = sValue.indexOf( ';', nStart );
															if( nEnd != -1 )
															{
																++nToken;
																seqToken.realloc( nToken );
																seqToken[nToken-1] = sValue.copy( nStart, nEnd-nStart );
																nStart = nEnd+1;
															}
															else
															{
																if( nStart < nSize )
																{
																	++nToken;
																	seqToken.realloc( nToken );
																	seqToken[nToken-1] = sValue.copy( nStart, nSize-nStart );
																	nStart = nSize+1;
																}
															}
														}
														xEntry->setStringListValue( seqToken );
													}
													break;
			default								:	throw RuntimeException( OUString(RTL_CONSTASCII_USTRINGPARAM("ProfileCache::impl_writeCfgKey()\nUnsupported config key type detected!\n")), Reference< XInterface>( m_pConfigManager, UNO_QUERY ) );
													break;
		}
		xEntry->closeKey();
	}
	else
	{
		throw RuntimeException();
	}
}

//_______________________________________________________________________________________________________________________
//	debug methods to check incoming parameter
//_______________________________________________________________________________________________________________________

#ifdef _DEBUG

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_open(	const	OUSTRING&	sProfileName	,
														const	sal_uInt8	aFlag			)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sProfileName				==	NULL	)	||
			( sProfileName.getLength()	<	1		)	||
			(
				( aFlag	!= OPENFLAG_READONLY )	&&
				( aFlag != OPENFLAG_WRITEABLE)
			)
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_readString(	const	OUSTRING&	sSection	,
																const	OUSTRING&	sEntry		,
																const	OUSTRING&	sValue		)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( &sEntry				==	NULL	)	||
			( &sValue				==	NULL	)	||
			( sSection.getLength()	<	1		)	||
			( sEntry.getLength()	<	1		)	||
			( sValue.getLength()	>	0		)	// Value should be read!
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_writeString(	const	OUSTRING&	sSection	,
																const	OUSTRING&	sEntry		,
																const	OUSTRING&	sValue		)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( &sEntry				==	NULL	)	||
            ( &sValue               ==  NULL    )   ||
			( sSection.getLength()	<	1		)	||
            ( sEntry.getLength()    <   1       )
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_createSection( const OUSTRING& sSection )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( sSection.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_createEntry(	const	OUSTRING&	sSection	,
																const	OUSTRING&	sEntry		)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( sSection.getLength()	<	1		)	||
			( &sEntry				==	NULL	)	||
			( sEntry.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_removeSection( const OUSTRING& sSection )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( sSection.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_removeEntry(	const	OUSTRING&	sSection	,
																const	OUSTRING&	sEntry		)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( &sEntry				==	NULL	)	||
			( sSection.getLength()	<	1		)	||
			( sEntry.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool ProfileCache::impl_debug_checkParameter_getSectionEntries( const OUSTRING& sSection )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sSection				==	NULL	)	||
			( sSection.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate OSL_ENSURE in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

#endif	// #ifdef _DEBUG

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com
