/*************************************************************************
 *
 *  $RCSfile: rootkey.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________________________________________________________________________________
//	my own include
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_ROOTKEY_HXX_
#include "rootkey.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_SECTIONKEY_HXX_
#include "sectionkey.hxx"
#endif

#ifndef _EXTENSIONS_ENTRYKEY_HXX_
#include "entrykey.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	namespaces
//_______________________________________________________________________________________________________________________

using namespace ::osl						;
using namespace ::rtl						;
using namespace ::cppu						;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::registry	;
using namespace ::com::sun::star::lang		;

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

//_______________________________________________________________________________________________________________________
//	defines
//_______________________________________________________________________________________________________________________

#define	DEFAULT_INIMANAGER	   				Reference< XSimpleRegistry >()				// Dfault values to initialize AND reset member
#define	DEFAULT_INIFILE		   				NULL

#define	KEYSEPERATOR						'/'											// Delimiter for section, entry and value of a key
#define	MAX_LINELENGTH						1024

#define	KEYTYPE_UNKNOWN						0											// Types of keys
#define	KEYTYPE_SECTION						1
#define	KEYTYPE_ENTRY						2
#define	KEYTYPE_VALUE						3

//_______________________________________________________________________________________________________________________
//	macros
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	constructor
//_______________________________________________________________________________________________________________________

RootKey::RootKey( Mutex& aMutex )
	: m_aMutex			( aMutex				)
	, m_xINIManager		( DEFAULT_INIMANAGER	)
	, m_pINIFile		( DEFAULT_INIFILE		)
{
}

//_______________________________________________________________________________________________________________________
//	destructor
//_______________________________________________________________________________________________________________________

RootKey::~RootKey()
{
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL RootKey::createKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_createKey( sKeyName ), "RootKey::createKey()\nInvalid parameter detected!\n" );

	// Don't work at corrupt instance.
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Set default return value, if creation failed.
	Reference< XRegistryKey > xKey = Reference< XRegistryKey >();

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Split keyname
	OUString	sNewSection	;
	OUString	sNewEntry	;
	OUString	sNewValue	;

	switch( impl_getKeyInformation( sKeyName, sNewSection, sNewEntry, sNewValue ) )
	{
		// New key is a sub-section.
		// If section already exist -> impl-method will OPEN it!
		case	KEYTYPE_SECTION	:	xKey = impl_createSection( sNewSection );
									break ;

		// New key is a sub-entry with section. A value is optional and can be "".
		// If entry already exist -> impl-method will OPEN it!
		case	KEYTYPE_ENTRY	:
		case	KEYTYPE_VALUE	:	xKey = impl_createEntry( sNewSection, sNewEntry, sNewValue );
				 					break ;
	}

	// Return result of this operation
	return xKey ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::deleteKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																	RuntimeException			)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_deleteKey( sKeyName ), "RootKey::deleteKey()\nInvalid parameter detected!\n" );

	// Don't work at corrupt instance.
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
	MutexGuard aGuard( m_aMutex );

	// Split keyname
	OUString	sOldSection	;
	OUString	sOldEntry	;
	OUString	sOldValue	;

	switch( impl_getKeyInformation( sKeyName, sOldSection, sOldEntry, sOldValue ) )
	{
		// Searched key is a sub-section.
		case	KEYTYPE_SECTION	:	m_pINIFile->removeSection( sOldSection );
				 					break ;

		// Searched key is a sub-entry. (Value is ignored)
		case	KEYTYPE_ENTRY	:
		case	KEYTYPE_VALUE	:	m_pINIFile->removeEntry( sOldSection, sOldEntry );
						   			break ;
	}
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL RootKey::openKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_openKey( sKeyName ), "RootKey::openKey()\nInvalid parameter detected!\n" );

	// Don't work at corrupt instance.
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Set default return value, if method failed
	Reference< XRegistryKey > xKey = Reference< XRegistryKey >();

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Split keyname
	OUString	sNewSection	;
	OUString	sNewEntry	;
	OUString	sNewValue	;

	switch( impl_getKeyInformation( sKeyName, sNewSection, sNewEntry, sNewValue ) )
	{
		// Searched key is a sub-section.
		case	KEYTYPE_SECTION	:	xKey = impl_openSection( sNewSection );
									break ;

		// Searched key is a sub-entry. (Value is ignored)
		case	KEYTYPE_ENTRY	:
		case	KEYTYPE_VALUE	:	xKey = impl_openEntry( sNewSection, sNewEntry );
						   			break ;
	}

	// Return result of this operation
	return xKey ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< Reference< XRegistryKey > > SAL_CALL RootKey::openKeys() throw(	InvalidRegistryException	,
																			RuntimeException			)
{
	// Don't work at corrupt instance.
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Set default return value, if method failed.
	Sequence< Reference< XRegistryKey > > seqKeys = Sequence< Reference< XRegistryKey > >();

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

    // Get name of all sections and count it.
	Sequence< OUString >	seqSections		= m_pINIFile->getSections();
	sal_uInt32				nSectionCount	= seqSections.getLength();

	// If we have found sections ...
    if ( nSectionCount > 0 )
    {
		// ... create key-objects, build sequence and return it.
		// Get memory for right sequence.
		seqKeys.realloc( nSectionCount );
		// Get pointer to fields of sections and keys to copy elements from one section to another.
		const OUString*					pSection=	seqSections.getConstArray();
		Reference< XRegistryKey >*		pKey	=	seqKeys.getArray();

		// Create for all sections a key object and set it into return sequence.
    	for ( sal_uInt32 nSectionNumber=0; nSectionNumber<nSectionCount; ++nSectionNumber )
    	{
			// Create key object to given sectionname...
			Reference< XRegistryKey > xNewKey = impl_openSection( pSection[nSectionNumber] );
			// Safe impossible cases.
			DBG_ASSERT( !(xNewKey.is() == sal_False ), "RootKey::openKeys()\nCan't open section!\n" );
			// ... and copy it into return sequence.
			pKey[nSectionNumber] = xNewKey ;
    	}
    }

	// Return sections
	return seqKeys ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::closeKey () throw( InvalidRegistryException, RuntimeException  )
{
	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	impl_resetObject();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL RootKey::createLink(	const	OUString&	sLinkName	,
										const	OUString&	sLinkTarget	) throw(	InvalidRegistryException	,
																					RuntimeException			)
{
	// Warn programmers
	// A RootKey has no link!
	DBG_ASSERT( sal_False, "RootKey::createLink()\nRootKey has no link. You can't create one!\n" );

	return sal_False ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::deleteLink( const OUString& sLinkName ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Warn programmers
	// A RootKey has no link!
	DBG_ASSERT( sal_False, "RootKey::deleteLink()\nRootKey has no link. You can't delete one!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL RootKey::isReadOnly() throw(	InvalidRegistryException	,
												RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// In the memoment, this state depends only from open-state of INI-file!
	// Forwarded to INIManager.
	return m_xINIManager->isReadOnly();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL RootKey::isValid() throw( RuntimeException )
{
	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Set default return
	sal_Bool bIsValid = sal_True ;

	// Check state of current keyobject.
	if (
		( m_xINIManager.is()		==	sal_False	)	||	//is INIManager reference invalid?
		( m_xINIManager->isValid()	==	sal_False	)	||	//is INIManager reference invalid?
		( m_pINIFile				==	NULL		)		//is INI-file not open ?
	   )
	{
		// Object is not valid - reset member to default
		impl_resetObject();
		bIsValid = sal_False ;
	}

	return bIsValid ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL RootKey::getKeyName() throw( RuntimeException )
{
	// Rootkey has NO name.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SAL_CALL RootKey::getKeyName()\nRootKey has no name!\n" ) ;

	return OUString() ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL RootKey::getKeyNames() throw(	InvalidRegistryException	,
															RuntimeException			)
{
	// Don't work at corrupt instance
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

    // Ready for multithreading
    MutexGuard aGuard ( m_aMutex ) ;
	return m_pINIFile->getSections();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

RegistryKeyType SAL_CALL RootKey::getKeyType( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																				RuntimeException			)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_getKeyType( sKeyName ), "RootKey::getKeyType()\nInvalid parameter detected!\n" );

	// Don't work at corrupt instance.
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// This object is a ROOTKEY, but  RegistryKeyType" known only KEY and LINK!
	return RegistryKeyType_KEY ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL RootKey::getResolvedName( const OUString& sKeyName ) throw( InvalidRegistryException, RuntimeException  )
{
	// This method is not implemented!
	DBG_ASSERT( sal_False, "RootKey::getResolvedName()\nNot implemented yet!\n" );
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

RegistryValueType SAL_CALL RootKey::getValueType() throw(	InvalidRegistryException	,
															RuntimeException			)
{
	// Rootkey has NO value.
	return RegistryValueType_NOT_DEFINED ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Int32 SAL_CALL RootKey::getLongValue() throw(	InvalidRegistryException	,
													InvalidValueException		,
													RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();

	return 0 ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< sal_Int32 > SAL_CALL RootKey::getLongListValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();
	return Sequence< sal_Int32 >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL RootKey::getAsciiValue() throw(	InvalidRegistryException	,
													InvalidValueException		,
													RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL RootKey::getAsciiListValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL RootKey::getStringValue() throw(	InvalidRegistryException	,
													InvalidValueException		,
													RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL RootKey::getStringListValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL RootKey::getBinaryValue() throw(	InvalidRegistryException	,
																InvalidValueException		,
																RuntimeException			)
{
	// Rootkey has NO value.
	throw InvalidValueException();
	return Sequence< sal_Int8 >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL RootKey::getLinkTarget( const OUString& sLinkName ) throw(	InvalidRegistryException	,
																				RuntimeException			)
{
	// RootKey has NO link.
	// Warn programmers!
	DBG_ASSERT( sal_False, "RootKey::getLinkTarget()\nRootKey has no link!\n" );
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setLongValue( sal_Int32 nValue ) throw(	InvalidRegistryException	,
																RuntimeException			)
{
	// RootKey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "RootKey::setLongValue()\nRootKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setLongListValue( const Sequence< sal_Int32 >& seqValue ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// RootKey has NO value.
	// Warn programmers!
	DBG_ASSERT ( sal_False, "RootKey::setLongListValue()\nRootKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setAsciiValue( const OUString& sValue ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Rootkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "RootKey::setAsciiValue()\nRootKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setAsciiListValue( const Sequence< OUString >& seqValue ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Rootkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "RootKey::setAsciiListValue()\nRootKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setStringValue( const OUString& sValue ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Rootkey has NO value.
	// Warn programmers!
	DBG_ASSERTWARNING( sal_False, "RootKey::setStringValue()\nRootKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setStringListValue( const Sequence< OUString >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Rootkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "RootKey::setStringListValue()\nRootKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL RootKey::setBinaryValue( const Sequence< sal_Int8 >& seqValue ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Rootkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "RootKey::setBinaryValue()\nRootKey has no value! Nothing to set.\n" );
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

Any SAL_CALL RootKey::queryInterface( const Type& aType ) throw( RuntimeException )
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Ask for my own supported interfaces ...
	Any aReturn	( ::cppu::queryInterface	(	aType								  ,
									   			static_cast< XTypeProvider*	> ( this ),
									   			static_cast< XRegistryKey*	> ( this )
											)
				);

	// If searched interface not supported by this class ...
	if ( aReturn.hasValue() == sal_False )
	{
		// Else; ... ask baseclass for interfaces!
		aReturn = OWeakObject::queryInterface( aType );
	}

	return aReturn ;
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL RootKey::acquire() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::acquire();
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL RootKey::release() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::release();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< Type > SAL_CALL RootKey::getTypes() throw( RuntimeException )
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pTypeCollection is NULL - for the second call pTypeCollection is different from NULL!
	static OTypeCollection* pTypeCollection = NULL ;

	if ( pTypeCollection == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pTypeCollection == NULL )
		{
			// Create a static typecollection ...
			static OTypeCollection aTypeCollection	(	::getCppuType(( const Reference< XTypeProvider	>*)NULL ),
												  		::getCppuType(( const Reference< XRegistryKey	>*)NULL )
													);

			// ... and set his address to static pointer!
			pTypeCollection = &aTypeCollection ;
		}
	}

	return pTypeCollection->getTypes();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL RootKey::getImplementationId() throw( RuntimeException )
{
	// Create one Id for all instances of this class.
	// Use ethernet address to do this! (sal_True)

	// Optimize this method
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pID is NULL - for the second call pID is different from NULL!
	static OImplementationId* pID = NULL ;

	if ( pID == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pID == NULL )
		{
			// Create a new static ID ...
			static OImplementationId aID( sal_False );
			// ... and set his address to static pointer!
			pID = &aID ;
		}
	}

	return pID->getImplementationId();
}

//________________________________________________________________________________________________________
//	public but not exported methods (impl!)
//________________________________________________________________________________________________________

void RootKey::impl_initializeKey(	const	Reference< XSimpleRegistry >&	xINIManager	,
											ProfileCache*					pINIFile	)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implinitializeKey( xINIManager, pINIFile ), "RootKey::impl_initializeKey()\nInvalid parameter detected!\n" );

	// This method overwrite ALL member of this object ...
	// You must call this at first after construct.
	m_xINIManager	=	xINIManager	;
	m_pINIFile		=	pINIFile	;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

void RootKey::impl_resetObject()
{
	// Set default values for the member of this object.
	// Needs for initialisation or reset.

	m_xINIManager	=	DEFAULT_INIMANAGER	;
	m_pINIFile		=	DEFAULT_INIFILE		;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

sal_uInt16 RootKey::impl_getKeyInformation(	const	OUString&	sKey	,
													OUString&	sSection,
													OUString&	sEntry	,
													OUString&	sValue	)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implgetKeyInformation( sKey, sSection, sEntry, sValue ), "RootKey::impl_getKeyInformation()\nInvalid parameter detected!\n" );

	sSection	=	sKey		;	// If no "/" exist, key is a section. But it can be an empty string!
	sEntry		=	OUString()	;
	sValue		=	OUString()	;

	// Special mode! If incoming key quoted - we don't parse for section, entry and value!
	// The whole key is handled as section only.
	// We accept FULL quoted names only!
	// zB ["aaa/bbb/ccc"] but not [aaa"/bbb/ccc"]
	if	(
			( sKey.indexOf( '"', 0 ) == 0					)	&&
			( sKey.indexOf( '"', 1 ) == sKey.getLength()-1	)
		)
	{
		// We must decode keyname.
		sSection = sKey.copy( 1, sKey.getLength()-2 );
	}
	else
	{
		// Else
		// Initialize some Variables for follow loop.
		sal_Int32	nPosition		=	0			;
		sal_uInt8	nTokenCount		=	0			;
		OUString	sLeftToken		=	OUString()	;
		OUString	sRightToken		=	sKey		;

		while ( nPosition != -1 )
		{
			// Search for entry
			nPosition = sRightToken.indexOf( KEYSEPERATOR );
			if ( nPosition != -1 )
			{
				// Split string in left and right site.
				sLeftToken	= sRightToken.copy( 0, nPosition );
				++nPosition ;	// Don't use delimiter!
				sRightToken	= sRightToken.copy( nPosition, sRightToken.getLength()-nPosition );
				// Count token.
				nTokenCount++ ;
				// Set section and use rest for entry!
				if ( nTokenCount == 1 )
				{
					sSection		= sLeftToken		;	// Change valud of section.
					sEntry			= sRightToken		;	// Set rest as entry.
				}
				// Set entry and use rest as value!
				if ( nTokenCount == 2 )
				{
					sEntry			= sLeftToken		;	// Change value of entry.
					sValue			= sRightToken		;	// Rest must be value.
				}
			}
		}
	}

	// Set type of key.
	sal_uInt16 nReturnKeyType = KEYTYPE_UNKNOWN ;
	if ( sSection.getLength() > 0 )
	{
		nReturnKeyType = KEYTYPE_SECTION ;
	}
	if ( sEntry.getLength() > 0 )
	{
		nReturnKeyType = KEYTYPE_ENTRY ;
	}
	if ( sValue.getLength() > 0 )
	{
		nReturnKeyType = KEYTYPE_VALUE ;
	}

	// Return default (UNKNOWN) or well known keytype and values.
	return nReturnKeyType ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

sal_Bool RootKey::impl_existKey(	const	OUString&	sSection	,
									const	OUString&	sEntry		)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implexistKey( sSection, sEntry ), "RootKey::impl_existKey()\nInvalid parameter detected!\n" );

	// Search in INI-file for given section AND entry.
	// sSection and sEntry must be absolute!
	// sEntry can be "".

	// Set default return value, if method failed
	sal_Bool bExist = sal_False ;

	// If no entry searched ...
	if ( sEntry.getLength() < 1 )
	{
		// ... search for section only!
		// If a section exist, it must have entries!
		Sequence< OUString > seqEntries = m_pINIFile->getSectionEntries( sSection );
		if ( seqEntries.getLength() > 0 )
		{
			bExist = sal_True ;
		}
	}
	// If an entry well known to ...
	else
	{
		// ... search for entry in a section.
		// Read his value!
		OUString sValue ;
		bExist = m_pINIFile->readString( sSection, sEntry, sValue );
	}

	// 1)
	//		No section or entry was found.
	// 2)
	//		Entry not searched. But this is OK.
	//		This key is only a valid section without a entry.
	// 3)
	//		Section AND entry are valid and exist.

	return bExist ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

Reference< XRegistryKey > RootKey::impl_createSection( const OUString& sSection )
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implcreateSection( sSection ), "RootKey::impl_createSection()\nInvalid parameter detected!\n" );

	// Set default return value, if method failed.
	Reference< XRegistryKey > xSectionKey = Reference< XRegistryKey >();

	// Look for existing key width the same name.
	if ( impl_existKey( sSection, OUString() ) == sal_True )
	{
		// The key already exist. Open it ...
		xSectionKey = impl_openSection( sSection );
	}
	else
	{
		// Key not exist ... we must create it.
		// OProfile can't write a section only!
		// We create a SectionKey-object ... set information on it ... but don't write key to INI-file!
		// If user create a entry at this new key ... the information are written to file.
		// Now, we must build a new instance of a keyReference.
		// DON'T delete this dynamical key!!! This is the return value of this method.
		SectionKey* pNewKey = new SectionKey( m_aMutex );

		// Safe impossible cases
		// Never been reached, but its better to control!
		DBG_ASSERT( !(pNewKey == NULL), "RootKey::impl_createSection()\nIts not necessary to create a new key! Memorymanager works not fine.\n" );

		if ( pNewKey != NULL )
		{
			// Create the new keyReference and set right information on it.
			pNewKey->impl_initializeKey( m_xINIManager, m_pINIFile, sSection );
			Reference< XRegistryKey > xNewKey = static_cast< XRegistryKey* >( pNewKey );
			xSectionKey = xNewKey ;
			// !!! Send message to all listener on this section!
			if ( xSectionKey.is() == sal_True )
			{
				m_pINIFile->createSection( sSection );
			}
		}
	}

	return xSectionKey ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

Reference< XRegistryKey > RootKey::impl_createEntry(	const	OUString&	sSection	,
														const	OUString&	sEntry		,
														const	OUString&	sValue		)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implcreateEntry( sSection, sEntry, sValue ), "RootKey::impl_createEntry()\nInvalid parameter detected!\n" );

	// Set default value, if method failed.
	Reference< XRegistryKey > xEntryKey = Reference< XRegistryKey >();

	// Look for existing key width the same name.
	if ( impl_existKey( sSection, sEntry ) == sal_True )
	{
		// The key already exist. Open it ...
		xEntryKey = impl_openEntry( sSection, sEntry );
	}
	else
	{
		// Key not exist ... we must create it.
		if ( m_pINIFile->createEntry( sSection, sEntry ) == sal_True )
		{
			// OK ... we have create the new key.
			// Now, we must build a new instance of a keyReference.
			// DON'T delete this dynamical key!!! This is the return value of this method.
			EntryKey* pNewKey = new EntryKey( m_aMutex );

			// Safe impossible cases
			// Never been reached, but its better to control!
			DBG_ASSERT( !(pNewKey == NULL), "RootKey::impl_createEntry()\nIts not necessary to create a new key! Memorymanager works not fine.\n" );

			if ( pNewKey != NULL )
			{
				// Create the new keyReference and set right information on it.
				pNewKey->impl_initializeKey( m_xINIManager, m_pINIFile, sSection, sEntry );
				xEntryKey = static_cast< XRegistryKey* >( pNewKey );
			}
		}
	}

	// ... and write NEW value (if it exist).
	if	(
			( xEntryKey.is()		==	sal_True	) &&
			( sValue.getLength()	>	0			)
		)
	{
		xEntryKey->setStringValue( sValue );
	}

	return xEntryKey ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

Reference< XRegistryKey > RootKey::impl_openSection( const OUString& sSection )
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implopenSection( sSection ), "RootKey::impl_openSection()\nInvalid parameter detected!\n" );

	// Set default return value, if method failed.
	Reference< XRegistryKey > xSectionKey = Reference< XRegistryKey >();

	if ( impl_existKey( sSection, OUString() ) == sal_True )
	{
		// We have a valid and existing section.
		// Open it ...
		// Now, we must build a new instance of a keyReference.
		// DON'T delete this dynamical key!!! This is the return value of this method.
		SectionKey* pNewKey = new SectionKey( m_aMutex );

		// Safe impossible cases
		// Never been reached, but its better to control!
		DBG_ASSERT( !(pNewKey == NULL), "RootKey::impl_openSection()\nIts not necessary to create a new key! Memorymanager works not fine.\n" );

		if ( pNewKey != NULL )
		{
			// Create the new keyReference and set right information on it.
			pNewKey->impl_initializeKey( m_xINIManager, m_pINIFile, sSection );
			xSectionKey = static_cast< XRegistryKey* >( pNewKey );
		}
	}

	return xSectionKey ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

Reference< XRegistryKey > RootKey::impl_openEntry(	const	OUString&	sSection	,
													const	OUString&	sEntry		)
{
	// Safe impossible cases
	// It's not allowed to call this method without a valid parameter.
	DBG_ASSERT( impl_checkParameter_implopenEntry( sSection, sEntry ), "RootKey::impl_openEntry()\nInvalid parameter detected!\n" );

	// Set default return value, if method failed.
	Reference< XRegistryKey > xEntryKey = Reference< XRegistryKey >();

	if ( impl_existKey( sSection, sEntry ) == sal_True )
	{
		// We have a valid and existing section with entry.
		// Now, we must build a new instance of a keyReference.
		// DON'T delete this dynamical key!!! This is the return value of this method.
		EntryKey* pNewKey = new EntryKey( m_aMutex );

		// Safe impossible cases
		// Never been reached, but its better to control!
		DBG_ASSERT( !(pNewKey == NULL), "RootKey::impl_openEntry()\nIts not necessary to create a new key! Memorymanager works not fine.\n" );

		if ( pNewKey != NULL )
		{
			// Create the new keyReference and set right information on it.
			pNewKey->impl_initializeKey( m_xINIManager, m_pINIFile, sSection, sEntry );
			xEntryKey = static_cast< XRegistryKey* >( pNewKey );
		}
	}

	return xEntryKey ;
}

//_______________________________________________________________________________________________________________________
//	debug and check methods
//_______________________________________________________________________________________________________________________

#ifdef _DEBUG

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_createKey( const OUString& sKeyName )
{
	if ( &sKeyName				==	NULL	) return sal_False ;
	if ( sKeyName.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_deleteKey( const OUString& sKeyName )
{
	if ( &sKeyName				==	NULL	) return sal_False ;
	if ( sKeyName.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_openKey( const OUString& sKeyName )
{
	if ( &sKeyName				==	NULL	) return sal_False ;
	if ( sKeyName.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_getKeyType( const OUString& sKeyName )
{
	if ( &sKeyName				==	NULL	) return sal_False ;
	if ( sKeyName.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implinitializeKey(	const	Reference< XSimpleRegistry >&	xINIManager	,
															const	ProfileCache*					pINIFile	)
{
	if ( &xINIManager		==	NULL		) return sal_False ;
	if ( xINIManager.is()	==	sal_False	) return sal_False ;
	if ( pINIFile			==	NULL		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implgetKeyInformation(	const	OUString&	sKey	,
																const	OUString&	sSection,
																const	OUString&	sEntry	,
																const	OUString&	sValue	)
{
	if ( &sKey					==	NULL	) return sal_False ;
	if ( sKey.getLength()		<	1		) return sal_False ;
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	>	0		) return sal_False ;
	if ( &sEntry				==	NULL	) return sal_False ;
	if ( sEntry.getLength()		>	0		) return sal_False ;
	if ( &sValue				==	NULL	) return sal_False ;
	if ( sValue.getLength()		>	0		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implexistKey(	const	OUString&	sSection,
													const	OUString&	sEntry	)
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	1		) return sal_False ;
//    if ( &sEntry                ==  NULL    ) return sal_False ;
//    if ( sEntry.getLength()     <   1       ) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implcreateSection( const OUString& sSection )
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implcreateEntry(	const	OUString&	sSection,
														const	OUString&	sEntry	,
														const	OUString&	sValue	)
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	0		) return sal_False ;
	if ( &sEntry				==	NULL	) return sal_False ;
	if ( sEntry.getLength()		<	0		) return sal_False ;
	if ( &sValue				==	NULL	) return sal_False ;
	// sValue can be empty!

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_impldeleteSection( const OUString& sSection )
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_impldeleteEntry(	const	OUString&	sSection,
														const	OUString&	sEntry	)
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	1		) return sal_False ;
	if ( &sEntry				==	NULL	) return sal_False ;
	if ( sEntry.getLength()		<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implopenSection( const OUString& sSection )
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	1		) return sal_False ;

	return sal_True ;
}

//_______________________________________________________________________________________________________________________
sal_Bool RootKey::impl_checkParameter_implopenEntry(const	OUString&	sSection,
													const	OUString&	sEntry	)
{
	if ( &sSection				==	NULL	) return sal_False ;
	if ( sSection.getLength()	<	1		) return sal_False ;
	if ( &sEntry				==	NULL	) return sal_False ;
	if ( sEntry.getLength()		<	1		) return sal_False ;

	return sal_True ;
}

#endif // _DEBUG

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com
