/*************************************************************************
 *
 *  $RCSfile: instchk.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:57:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define INSTCHK_SERVICE_NAME        \
    "com.sun.star.installation.InstallationCheck"
#define INSTCHK_IMPLEMENTATION_NAME \
    "com.sun.star.installation.InstallationCheck.V10"

#ifdef WIN32
#include <tools/prewin.h>
#include <windows.h>                        /* win32 api */
#include <tools/postwin.h>
#endif

#include <vcl/svapp.hxx>
#include <vcl/wrkwin.hxx>
#include <tools/fsys.hxx>
#include <tools/resmgr.hxx>
#include <tools/string.hxx>

#include <osl/mutex.hxx>

#ifndef _COM_SUN_STAR_INSTALLATION_XINSTALLATIONCHECK_HPP_
#include <com/sun/star/installation/XInstallationCheck.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#include "instdlg.hxx"

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef _UNO_MAPPING_HXX_
#include <uno/mapping.hxx>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#include <com/sun/star/reflection/XIdlClass.hpp>

#ifndef _CPPU_WEAK_HXX_
#include<cppuhelper/weak.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::installation;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::reflection;
using namespace ::com::sun::star::registry;
using namespace ::rtl;
using namespace ::cppu;

const char *__flagName = "suppressed";
const char *__fonts[] = {"StarMath", "StarBats"};
#define FONT_COUNT (sizeof(__fonts) / sizeof(__fonts[0]))

class InstallationCheck_Impl : public XInstallationCheck, public OWeakObject
{
private:
    sal_Bool mbSuppressed, inReg;
    int missingFonts; /* bitMask */
    String *fontNames;
    OUString flagName;
    Reference<XMultiServiceFactory> xSMgr;
    Reference<XRegistryKey> getImplementationKey();
public:
/* --- Methoden von XInterface -------------------------------------------- */
    virtual Any SAL_CALL queryInterface(const Type& aType)
        throw(RuntimeException);
	virtual void SAL_CALL acquire() throw();
	virtual void SAL_CALL release() throw();
// --- XInstallationCheck ----------------------------------------------------
	InstallationCheck_Impl(const Reference<XMultiServiceFactory> &xServiceMgr);
    virtual ~InstallationCheck_Impl();
    virtual sal_Bool SAL_CALL check(sal_Bool bForce)
        throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL checkWithDialog(sal_Bool bForce)
        throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL executeDialog(void)
        throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL getSuppressed(void)
        throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setSuppressed(sal_Bool bSuppress)
        throw(::com::sun::star::uno::RuntimeException);
};

// ###########################################################################
// ### implementation ########################################################
// ###########################################################################
// --- XInterface ------------------------------------------------------------
Any SAL_CALL InstallationCheck_Impl::queryInterface(const Type& aType)
  throw(RuntimeException)
{
    Any aRet = ::cppu::queryInterface(aType,
      static_cast<XInstallationCheck *> (this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(aType);
}

void SAL_CALL InstallationCheck_Impl::acquire() throw()
{
    OWeakObject::acquire();
}

void SAL_CALL InstallationCheck_Impl::release() throw()
{
    OWeakObject::release();
}

// --- XInstallationCheck ----------------------------------------------------
Reference<XRegistryKey> InstallationCheck_Impl::getImplementationKey()
{
    Reference<XRegistryKey> xRet;
    if (xSMgr.is())
    {
        Reference<XSimpleRegistry> xReg( xSMgr->createInstance( OUString::createFromAscii("com.sun.star.registry.DefaultRegistry")), UNO_QUERY );

        if ( xReg.is() )
        {
            try
            {
                OUString aName = OUString::createFromAscii("/IMPLEMENTATIONS/");
                aName += OUString::createFromAscii(INSTCHK_SERVICE_NAME);
                xRet = xReg->getRootKey()->openKey(aName);
            }
            catch (InvalidRegistryException e)
            {
            }
        }
    }
    return xRet;
}

InstallationCheck_Impl::InstallationCheck_Impl(
  const Reference<XMultiServiceFactory>  &rServiceMgr)
: xSMgr(rServiceMgr), flagName(OUString::createFromAscii(__flagName))
{
    inReg = sal_False;
    mbSuppressed = sal_False;
    Reference<XRegistryKey> keyRef(getImplementationKey());
    if (keyRef.is())
    {
        Reference<XRegistryKey> tmpKey(keyRef->openKey(flagName));
        inReg = tmpKey.is();
        mbSuppressed = inReg;
    }
    fontNames = new String[FONT_COUNT];
    WorkWindow* pWindow = Application::GetAppWindow();
    missingFonts = 0;
    for (int i = FONT_COUNT - 1; i >= 0; i--)
    {
        fontNames[i] = String::CreateFromAscii(__fonts[i]);
        sal_Bool b = pWindow->IsFontAvailable(fontNames[i]);
        if (!b) missingFonts |= (1 << i);
    }
}

InstallationCheck_Impl::~InstallationCheck_Impl()
{
    if (mbSuppressed && !inReg)
    {
        Reference<XRegistryKey> keyRef(getImplementationKey());
        if (keyRef.is()) keyRef->createKey(flagName);
    }
    delete [] fontNames;
}

/* tool functions */
sal_Bool FixRegistry(OString const& rFontFile, OString const& rFontName)
{
#ifdef WIN32
    char s[MAX_PATH];
    GetWindowsDirectory(s, MAX_PATH);

    DirEntry aTTF_File(OUString::createFromAscii(s));
    aTTF_File += DirEntry(OUString::createFromAscii("Fonts"));
    aTTF_File += DirEntry(OUString::createFromAscii(rFontFile));

    if(!aTTF_File.Exists()) return sal_False; /* file is missing */
    OString aPath = OUStringToOString(aTTF_File.GetFull(), osl_getThreadTextEncoding());
    if(!AddFontResource(aPath.getStr())) return sal_False;
    /* unable to add  */

    OString aFontRegistryName("Software\\Microsoft\\Windows");
    WORD nGUIVersion = (WORD) GetVersion();
    sal_uInt16 nVer = ((((sal_uInt16)LOBYTE(nGUIVersion))*100) +
                       HIBYTE(nGUIVersion));
    /* 351 = WNT351; 395 = W95 16Bit; 400 = W95; 410 = W98 */
    if ((nVer == 395) || (nVer == 400) || (nVer == 410))
    { /* WinNT 3.51 / Win 95/98 */
        aFontRegistryName += "\\CurrentVersion\\Fonts\\";
    }
    else
    { /* Win NT */
        aFontRegistryName += " NT\\CurrentVersion\\Fonts\\";
    }

    aFontRegistryName += rFontName;
    aFontRegistryName += OString(" (TrueType)");

    OString aFontFileName = OUStringToOString(aTTF_File.GetName(), osl_getThreadTextEncoding());
    aFontFileName = aFontFileName.toAsciiUpperCase();

    RegSetValue(HKEY_LOCAL_MACHINE, aFontRegistryName.getStr(), REG_SZ, aFontFileName,
                aFontFileName.getLength());
    SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    return sal_True;
#else /* kein win32 --> keine unterstuetzung fuer windowsregistryreparatur */
    return sal_False;
#endif
}

sal_Bool InstallationCheck_Impl::check(sal_Bool bForce) throw(::com::sun::star::uno::RuntimeException)
{
#ifdef UNX
    return sal_True;
#else
    if (mbSuppressed && !bForce) return sal_True;
    if (missingFonts > 0)
    {
        for (int i = FONT_COUNT - 1; i >= 0; i--)
        {
            if (missingFonts & (1 << i))
            { // versuchen die windowsregistry zu repariren
                OString fName(__fonts[i]);
                fName += OString(".ttf");
                if (FixRegistry(fName, __fonts[i]))
                    missingFonts &= ~(1 << i);
            }
        }
    }
    return (missingFonts == 0);
#endif
}

sal_Bool InstallationCheck_Impl::checkWithDialog(sal_Bool bForce) throw(::com::sun::star::uno::RuntimeException)
{
    sal_Bool b = check(bForce);
    if (b) return sal_True;
    return executeDialog();
}

sal_Bool InstallationCheck_Impl::executeDialog(void) throw(::com::sun::star::uno::RuntimeException)
{
    if (missingFonts == 0) return sal_True;

    OString aResFileName("oic");
    aResFileName += MAKE_NUMSTR(SUPD);
    ResMgr* pResMgr = ResMgr::CreateResMgr(aResFileName.getStr());
    FonTestDialog* dlg = new FonTestDialog(NULL, pResMgr);
    dlg->setSuppress(mbSuppressed);
    for (int i = FONT_COUNT - 1; i >= 0; i--)
        if (missingFonts & (1 << i)) dlg->insertFontLine(i);
    if (dlg->Execute()) mbSuppressed = dlg->getSuppress();
      /* get status of checkbox, if dialog was exit through ok-button */
    delete dlg;
    return sal_False;
}

sal_Bool InstallationCheck_Impl::getSuppressed(void) throw(::com::sun::star::uno::RuntimeException)
{
    return mbSuppressed;
}

void InstallationCheck_Impl::setSuppressed(sal_Bool bSuppress) throw(::com::sun::star::uno::RuntimeException)
{
    if (mbSuppressed == bSuppress) return;
    Reference<XRegistryKey> keyRef(getImplementationKey());
    if (keyRef.is())
    {
        if (bSuppress)
        {
            if (!inReg)
            {
                keyRef->createKey(flagName);
                mbSuppressed = sal_True;
                inReg = sal_True;
            }
        }
        else
        {
            keyRef->deleteKey(flagName);
            mbSuppressed = sal_False;
            inReg = sal_False;
        }
    }
}

// --- statics ---------------------------------------------------------------
static OUString Instchk_getImplementationName()
{
	return OUString::createFromAscii(INSTCHK_IMPLEMENTATION_NAME);
}

static Sequence<OUString> Instchk_getSupportedServiceNames()
{
	OUString aName(OUString::createFromAscii(INSTCHK_SERVICE_NAME));
	Sequence<OUString> aSeq(&aName, 1);
	return aSeq;
}

static Reference<XInterface> SAL_CALL Instchk_createInstance(
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XInterface> xInst(
      SAL_STATIC_CAST(::cppu::OWeakObject *,
      new InstallationCheck_Impl(rxManager)));
	return xInst;
}

static Reference<XSingleServiceFactory> Instchk_createServiceFactory(
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XSingleServiceFactory> xFactory (
		cppu::createSingleFactory (
			rxManager,
			Instchk_getImplementationName(),
			Instchk_createInstance,
			Instchk_getSupportedServiceNames()));
	return xFactory;
}

//-----------------------------------------------------------------------
// registration
//-----------------------------------------------------------------------


extern "C"
{
	//-------------------------------------------------------------------
	// component_getImplementationEnvironment
	//-------------------------------------------------------------------

	void SAL_CALL component_getImplementationEnvironment( 
		const sal_Char** ppEnvTypeName, uno_Environment** ppEnv )
	{
		*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
	}

	//-------------------------------------------------------------------
	// component_writeInfo
	//-------------------------------------------------------------------

	sal_Bool SAL_CALL component_writeInfo( void* pServiceManager, void* pRegistryKey )
	{
		sal_Bool bRet = sal_False;

		if ( pRegistryKey )
		{
			try
			{
				Reference< XRegistryKey > xNewRegKey( 
					reinterpret_cast< XRegistryKey* >( pRegistryKey )->createKey( 
					OUString::createFromAscii( "/" INSTCHK_IMPLEMENTATION_NAME "/UNO/SERVICES" ) ) );

				Sequence< OUString >& rSNL = Instchk_getSupportedServiceNames( );
				const OUString* pArray = rSNL.getConstArray( );
				for ( sal_Int32 i = rSNL.getLength( ); i--; /* empty */ )
					xNewRegKey->createKey( pArray[i] );

				bRet = sal_True;

			}
			catch( InvalidRegistryException& )
			{
				OSL_ENSURE( sal_False, "### InvalidRegistryException!" ); 
			}
		}

		return bRet;
	}	

	//-------------------------------------------------------------------
	// component_getFactory
	//-------------------------------------------------------------------

	void* SAL_CALL component_getFactory( 
		const sal_Char* pImplName, void* pServiceManager, void* pRegistryKey )
	{
		void* pRet = 0;

		if ( 0 == rtl_str_compare( pImplName, INSTCHK_IMPLEMENTATION_NAME ) )
		{
			Reference< XSingleServiceFactory > xFactory( createOneInstanceFactory(
				reinterpret_cast< XMultiServiceFactory* >( pServiceManager ), 
				OUString::createFromAscii( pImplName ),
				Instchk_createInstance, 
				Instchk_getSupportedServiceNames( ) ) );

			if ( xFactory.is( ) )
			{
				xFactory->acquire( );
				pRet = xFactory.get( );
			}
		}

		return pRet;
	}
	
} // extern "C"


// --- LogEntries ------------------------------------------------------------
