/*************************************************************************
 *
 *  $RCSfile: pgpui.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PGP_PGPUI_HXX
#define _EXTENSIONS_PGP_PGPUI_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _EXTENSIONS_PGP_PGPTYPES_HXX
#include "pgptypes.hxx"
#endif

typedef com::sun::star::uno::Sequence<rtl::OUString> string_sequence_type;

/*========================================================================
 *
 * PGPUI interface.
 *
 *======================================================================*/
/** PGPUIPreferences_Impl.
 */
struct PGPUIPreferences_Impl
{
	PGPBoolean    m_bEncryptToSelf;
	PGPBoolean    m_bEncryptByDefault;
	PGPBoolean    m_bSignByDefault;
	PGPBoolean    m_bAutoDecrypt;

	PGPUIPreferences_Impl (void)
		: m_bEncryptToSelf    (sal_False),
		  m_bEncryptByDefault (sal_False),
		  m_bSignByDefault    (sal_False),
		  m_bAutoDecrypt      (sal_False)
	{}
};

/** PGPUIGetPreferences_Impl.
 */
PGPError PGPUIGetPreferences_Impl (PGPUIPreferences_Impl &rPref);

/** PGPUIGetRecipientKeySet_Impl.
 */
void PGPUIGetRecipientKeySet_Impl (
	PGPContextRef               Context,
	const string_sequence_type &rRecipients,
	PGPKeySetRef               *OriginalKeySet,
	PGPKeySetRef               *pSelectedKeySet);

/** PGPUIGetSigningPhrase_Impl.
 */
PGPError PGPUIGetSigningPhrase_Impl (
	PGPContextRef  Context,
	PGPKeySetRef   KeyRing,
	PGPKeyRef     *pKey,
	sal_Char     **pszPhrase);

/** PGPUIGetDecryptPhrase_Impl.
 */
PGPError PGPUIGetDecryptPhrase_Impl (
	PGPContextRef  Context,
	PGPKeySetRef   KeyRing,
	PGPKeySetRef   KeySet,
	const PGPKeyID KeyIDList[],
	PGPUInt32      KeyIDCount,
	sal_Char     **pszPhrase);

/** PGPUIFreePhrase_Impl.
 */
void PGPUIFreePhrase_Impl (sal_Char *pszPhrase);

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

#endif /* _EXTENSIONS_PGP_PGPUI_HXX */

